SET search_path TO confdb;

DELETE FROM eventpolicycontent WHERE eventpolicy IN (3,4);
DELETE FROM eventpolicy WHERE eventpolicy IN (3,4);

DROP TRIGGER trg_eventpolicy_realm_not_null ON eventpolicy;

CREATE OR REPLACE FUNCTION fn_trg_realm_not_null() RETURNS TRIGGER AS
$BODY$
BEGIN
  IF (TG_OP IN ('INSERT', 'UPDATE')) THEN
    IF (NEW.eventpolicy >= 100 AND NEW.realm IS NULL) THEN
      RAISE not_null_violation;
    END IF;
  END IF;
  RETURN NULL;
END;
$BODY$
LANGUAGE plpgsql;

CREATE CONSTRAINT TRIGGER trg_eventpolicy_realm_not_null
 AFTER INSERT OR UPDATE
    ON eventpolicy
   FOR EACH ROW EXECUTE PROCEDURE fn_trg_realm_not_null();

INSERT INTO eventpolicy (eventpolicy, name, "protected") VALUES
    (3,'Alert',true),(4,'Informational',true);
INSERT INTO eventpolicycontent (eventpolicy, eventsource,workflow,infworkflow,parameters) VALUES
    (3,5,4,2,'priority=3|eventtype=1|preevent=5|postevent=15'),
    (3,6,7,7,'priority=3|eventtype=1|preevent=5|postevent=15'),
    (3,2,1,1,'priority=3|eventtype=1|preevent=5|postevent=15'),
    (3,7,1,6,'priority=3|eventtype=1|preevent=5|postevent=15'),
    (3,1,1,1,'priority=3|eventtype=1|preevent=5|postevent=15'),
    (3,3,1,1,'priority=3|eventtype=1|preevent=5|postevent=15'),
    (3,4,2,2,'priority=3|eventtype=0|preevent=5|postevent=15'),
    (4,5,4,2,'priority=2|eventtype=0|preevent=5|postevent=15'),
    (4,6,7,7,'priority=2|eventtype=0|preevent=5|postevent=15'),
    (4,2,1,1,'priority=2|eventtype=0|preevent=5|postevent=15'),
    (4,7,1,6,'priority=2|eventtype=0|preevent=5|postevent=15'),
    (4,1,1,1,'priority=2|eventtype=0|preevent=5|postevent=15'),
    (4,3,5,6,'priority=2|eventtype=0|preevent=5|postevent=15'),
    (4,4,2,2,'priority=2|eventtype=0|preevent=5|postevent=15');
