SET search_path = confdb, pg_catalog;


--
-- Name: attr_archstate_on_of(); Type: FUNCTION; Schema: confdb; Owner: postgres
--

CREATE OR REPLACE FUNCTION attr_archstate_on_of() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    if NEW.attr = 'ARCHSTATE' then
        if NEW.val = 'off' AND OLD.val = 'on' then
            UPDATE _obj_attr SET val = 'stopping' WHERE obj = NEW.obj AND attr = 'STATUS';
        end if;
        if NEW.val = 'on' and OLD.val = 'off' then
            UPDATE _obj_attr SET val = 'starting' WHERE obj = NEW.obj AND attr = 'STATUS';
        end if;
    end if;
    return NEW;
END;
$$;

--
-- Name: insert_link_type(); Type: FUNCTION; Schema: confdb; Owner: postgres
--

CREATE OR REPLACE FUNCTION insert_link_type() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    NEW.link_type := (SELECT type FROM _objs WHERE obj = NEW.obj_res) || '2' || (SELECT type FROM _objs WHERE obj = NEW.obj_cons);
    return NEW;
END;
$$;

--
-- Name: insertattributes(); Type: FUNCTION; Schema: confdb; Owner: postgres
--

CREATE OR REPLACE FUNCTION insertattributes() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    if NEW.attr = 'OBJID' then
        NEW.val = NEW.obj;
    end if;
    if NEW.attr = 'NAME' then
        UPDATE _objs
            SET name = NEW.val
            WHERE obj = NEW.obj;
    end if;
    if NEW.attr = 'DESCRIPTION' then
        UPDATE _objs
            SET description = NEW.val
            WHERE obj = NEW.obj;
    end if;
    if NEW.attr = 'UDID' then
        if NEW.val = '' then
            SELECT udid INTO NEW.val FROM _objs WHERE obj = NEW.obj;
        else
            UPDATE _objs
                SET udid = NEW.val
                WHERE obj = NEW.obj;
        end if;
    end if;
    NEW.val = COALESCE(NEW.val,'');
    return NEW;
END;
$$;

--
-- Name: set_cmd_stime(); Type: FUNCTION; Schema: confdb; Owner: postgres
--

CREATE OR REPLACE FUNCTION set_cmd_stime() RETURNS trigger
    LANGUAGE plpgsql
    AS $$begin
  if NEW.CMD!=OLD.CMD and length(NEW.CMD)!=0 then
   NEW.stime=now();
  end if;
  return NEW;
end;$$;


-- Name: set_stime(); Type: FUNCTION; Schema: confdb; Owner: postgres
--

CREATE OR REPLACE FUNCTION set_stime() RETURNS trigger
    LANGUAGE plpgsql
    AS $$begin  NEW.stime=now(); return NEW; end;$$;


-- Name: set_udid_on_delete_update(); Type: FUNCTION; Schema: confdb; Owner: postgres
--

CREATE OR REPLACE FUNCTION set_udid_on_delete_update() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    NEW.udid = upper(NEW.udid);
    if NEW.deleted = 1 then
        NEW.udid := null;
    end if;
    if NEW.udid = '' then
        NEW.udid := null;
    end if;
    return NEW;
END;
$$;

--
-- Name: upd_timestamp(); Type: FUNCTION; Schema: confdb; Owner: postgres
--

CREATE OR REPLACE FUNCTION upd_timestamp() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    if OLD.updated_at = NEW.updated_at then
        NEW.updated_at := now() at time zone 'UTC';
    end if;
    return NEW;
END;
$$;

--
-- Name: updateattributes(); Type: FUNCTION; Schema: confdb; Owner: postgres
--

CREATE OR REPLACE FUNCTION updateattributes() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    if NEW.attr = 'NAME' then
        UPDATE _objs
            SET name = NEW.val
            WHERE obj = NEW.obj;
    end if;
    if NEW.attr = 'DESCRIPTION' then
        UPDATE _objs
            SET description = NEW.val
            WHERE obj = NEW.obj;
    end if;
    if NEW.attr = 'UDID' then
        NEW.val = upper(NEW.val);
        if NEW.val = '' then
            NEW.val = null;
        end if;
        UPDATE _objs
            SET udid = NEW.val
            WHERE obj = NEW.obj;
    end if;
    NEW.val = COALESCE(NEW.val, '');
    return NEW;
END;
$$;

--
-- Name: insert_otype_subtype(); Type: FUNCTION; Schema: confdb; Owner: postgres
--

CREATE OR REPLACE FUNCTION insert_otype_subtype() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
    NEW.otype := (SELECT otype FROM objtype WHERE type = NEW.type);
    NEW.subtype := (SELECT subtype FROM objtype WHERE type = NEW.type);
    return NEW;
END;
$$;
