package Overcast::DB;

use 5.008008;
use strict;
use warnings;
use DBI;

require Exporter;

our @ISA = qw(Exporter);

our %EXPORT_TAGS = ( 'all' => [ qw(
    DBConnect getDBConf
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
    DBConnect getDBConf
);

our $VERSION = '0.01';

# Constants ----------------------------------------------------------
my %DEFAULT_ATTR   = (PrintError => 0, RaiseError => 0, FetchHashKeyName => 'NAME_lc');

# Vars ---------------------------------------------------------------
my %DBConf   = ();

# Preloaded methods go here.

sub getDBConf {
    $DBConf{name} = $ENV{OVERCAST_DB_SERVICE_DATABASE} || 'apl';
    $DBConf{host} = $ENV{OVERCAST_DB_SERVICE_HOST} || 'overcast-db';
    $DBConf{port} = $ENV{OVERCAST_DB_SERVICE_PORT} || '5432';
    $DBConf{user} = $ENV{OVERCAST_DB_SERVICE_USER} || 'apl';
    $DBConf{pass} = $ENV{OVERCAST_DB_SERVICE_PASS} || '';
    $DBConf{connstr} = "dbi:Pg:dbname=$DBConf{name};host=$DBConf{host}";
    $DBConf{connuri} = "postgresql://$DBConf{user}:$DBConf{pass}\@$DBConf{host}:$DBConf{port}/$DBConf{name}";
    return \%DBConf;
}

sub DBConnect {
    my $arg = shift;
    my %attr = (%DEFAULT_ATTR, ref($arg) eq 'HASH' ? %$arg : ());
    
    getDBConf;
    
    return DBI->connect($DBConf{connstr}, $DBConf{user}, $DBConf{pass}, \%attr);
}


1;
