SET search_path TO apl;
CREATE OR REPLACE VIEW event AS SELECT * FROM transdb.event;
REVOKE ALL ON TABLE event FROM PUBLIC;
GRANT SELECT,INSERT,DELETE,UPDATE ON TABLE event TO apl;
--
-- Name: el_get_event(integer); Type: FUNCTION; Schema: apl; Owner: postgres
--

CREATE OR REPLACE FUNCTION el_get_event(integer) RETURNS SETOF el_event
    LANGUAGE plpgsql
    AS $_$
DECLARE
   result EL_Event;
BEGIN

FOR result in
    SELECT
               event.objid,
               eventsource,
               extract('epoch' from utc_when),
               extract('epoch' from utc_from),
               extract('epoch' from utc_to),
               priority,
               state,
               message,
               note,
               eventtype,
               externalid,
               eventproperty.name,
               eventproperty.value,
               -- fields bellow used in next SELECT
               NULL as witness_objid,
               NULL as witness_name,
               NULL as witness_otype,
               NULL as witness_subtype,
               NULL as witness_timedst,
               NULL as witness_tz
    FROM event
    LEFT JOIN eventproperty ON eventproperty.eventid=event.eventid
    WHERE event.eventid=$1
    UNION
    SELECT NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
              eventwitness.objid,
              _objs.name,
              otype,
              subtype,
              _obj_attr.val,
              0
    FROM event, _objs, (SELECT eventid, unnest(witness) objid from event) as eventwitness, _obj_attr
    WHERE event.eventid=$1 AND eventwitness.eventid=event.eventid AND _objs.obj = eventwitness.objid
      AND _obj_attr.obj=eventwitness.objid AND _obj_attr.attr='TIME_ZONE'
    ORDER BY objid ASC
LOOP
RETURN NEXT result;
END LOOP;

RETURN;

END
$_$;

--
-- Name: el_merge_witnesses(integer, uuid, uuid[]); Type: FUNCTION; Schema: apl; Owner: postgres
--

CREATE OR REPLACE FUNCTION el_merge_witnesses(integer, uuid, uuid[]) RETURNS SETOF el_object_info
    LANGUAGE plpgsql
    AS $_$
DECLARE
   event_id         ALIAS FOR $1;
   obj_id           ALIAS FOR $2;
   witnesses_       ALIAS FOR $3;
   witnesses        uuid[];
   merged_witnesses text[];
   result           EL_Object_Info;
BEGIN

-- postgres 8.1.x requires this
IF witnesses_ IS NULL THEN
   witnesses = ARRAY[obj_id];
ELSE
   witnesses = witnesses_;
END IF;

merged_witnesses := (SELECT COALESCE(
                              string_to_array(replace(val, ' ', ''), ','), -- just for case removing spaces between comas
                              CAST(ARRAY[obj_id] as text[]) -- if previous expression is NULL keep array of original obj_id.
                            ) || CAST(witnesses AS text[]) || CAST(ARRAY[obj_id] as text[]) -- adding objid of event to witnesses too
                    FROM _obj_attr
                    WHERE obj=obj_id AND attr='ASSOCIATE');

UPDATE event set witness = (SELECT array_agg(DISTINCT witness) FROM (
   (SELECT unnest(merged_witnesses::uuid[]) witness) UNION (SELECT unnest(witness) witness FROM event where eventid = event_id)
) as wit_array) where eventid = event_id;

IF FOUND THEN

  FOR result in
      SELECT o.obj, o.name, o.type, o.otype, o.subtype, COALESCE(a1.val, 'UTC') as tz, 0, COALESCE(a2.val, '0') as vl_rate
        FROM (SELECT eventid, unnest(witness) objid FROM event) w
       INNER JOIN _objs o ON o.obj = w.objid
        LEFT OUTER JOIN _obj_attr a1 ON a1.obj=o.obj AND a1.attr='TIME_ZONE'
        LEFT OUTER JOIN _obj_attr a2 ON a2.obj=o.obj AND a2.attr='STAT_VL_RATE_LAST'
       WHERE w.eventid = event_id
  LOOP
     RETURN NEXT result;
  END LOOP;
END IF;

RETURN;

END
$_$;

