SET search_path TO transdb;

--
-- Name: audit; Type: TABLE; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE TABLE audit (
    date timestamp without time zone DEFAULT timezone('UTC'::text, now()) NOT NULL,
    category integer NOT NULL,
    userid uuid,
    objid uuid,
    level integer DEFAULT 2,
    parameters character varying
);


--
-- Name: auditcategory; Type: TABLE; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE TABLE auditcategory (
    category integer NOT NULL,
    parent integer,
    name character varying(200) NOT NULL,
    digest character varying
);


--
-- Name: auditlevel; Type: TABLE; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE TABLE auditlevel (
    level integer NOT NULL,
    name character varying(200) NOT NULL
);


--
-- Name: av_seq_requestid; Type: SEQUENCE; Schema: transdb; Owner: postgres
--

CREATE SEQUENCE av_seq_requestid
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;



CREATE SEQUENCE eventrepllog_seq
    START WITH 0
    INCREMENT BY 1
    MINVALUE 0
    NO MAXVALUE
    CACHE 1;


--
-- Name: avatar_archive_requests; Type: TABLE; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE TABLE avatar_archive_requests (
    requestid integer DEFAULT nextval('av_seq_requestid'::regclass) NOT NULL,
    avatarid uuid NOT NULL,
    nodeid uuid,
    objid uuid NOT NULL,
    start_time timestamp without time zone NOT NULL,
    end_time timestamp without time zone NOT NULL,
    created_time timestamp without time zone DEFAULT ('now'::text)::timestamp(6) without time zone NOT NULL,
    userid uuid,
    priority integer,
    status character varying NOT NULL,
    message character varying,
    size integer,
    downloaded integer,
    completed_time timestamp without time zone,
    is_private boolean DEFAULT false,
    stream_num integer DEFAULT 1 NOT NULL
);


--
-- Name: avatar_geo_history; Type: TABLE; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE TABLE avatar_geo_history (
    avatarid uuid NOT NULL,
    gtime timestamp without time zone NOT NULL,
    gdata text
);


--
-- Name: camera_downtime; Type: TABLE; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE TABLE camera_downtime (
    objid uuid NOT NULL,
    utc_from timestamp without time zone NOT NULL,
    utc_to timestamp without time zone,
    status integer,
    CONSTRAINT c_interval CHECK ((utc_from < utc_to))
);


--
-- Name: camera_status; Type: TABLE; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE TABLE camera_status (
    status integer NOT NULL,
    description character varying
);



--
-- Name: content_delivery_history; Type: TABLE; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE TABLE content_delivery_history (
    deliverytypeid integer NOT NULL,
    objid uuid NOT NULL,
    tstamp timestamp without time zone DEFAULT timezone('UTC'::text, now()) NOT NULL,
    seconds integer NOT NULL,
    isqueued boolean,
    megabytes double precision
);


--
-- Name: content_delivery_type; Type: TABLE; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE TABLE content_delivery_type (
    deliverytypeid integer NOT NULL,
    name character varying
);


--
-- Name: seqeventid; Type: SEQUENCE; Schema: transdb; Owner: postgres
--

CREATE SEQUENCE seqeventid
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: event; Type: TABLE; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE TABLE event (
    eventid integer DEFAULT nextval('seqeventid'::regclass) NOT NULL,
    objid uuid NOT NULL,
    eventsource integer NOT NULL,
    utc_when timestamp without time zone NOT NULL,
    utc_from timestamp without time zone NOT NULL,
    utc_to timestamp without time zone NOT NULL,
    eventtype integer NOT NULL,
    priority integer NOT NULL,
    workflow integer NOT NULL,
    state integer NOT NULL,
    message varchar,
    note varchar,
    history varchar,
    updated_at timestamp without time zone DEFAULT ('now'::text)::timestamp(6) without time zone,
    externalid character varying,
    CONSTRAINT c_event_dates1 CHECK ((utc_from < utc_to)),
    CONSTRAINT c_event_dates2 CHECK ((utc_from <= utc_when)),
    CONSTRAINT c_event_dates3 CHECK ((utc_when <= utc_to))
);


--
-- Name: eventbookmark; Type: TABLE; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE TABLE eventbookmark (
    eventid integer NOT NULL,
    utc_when timestamp without time zone NOT NULL,
    bookmark character varying
);


--
-- Name: eventproperty; Type: TABLE; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE TABLE eventproperty (
    eventid integer NOT NULL,
    name character varying NOT NULL,
    value character varying
);


--
-- Name: eventrepllog; Type: TABLE; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE TABLE eventrepllog (
    eventid integer NOT NULL,
    oper character(1),
    obj uuid,
    updated_at timestamp without time zone NOT NULL,
    CONSTRAINT c_eventrepllog_operation CHECK ((oper = ANY (ARRAY['I'::bpchar, 'U'::bpchar, 'D'::bpchar])))
);


--
-- Name: eventwitness; Type: TABLE; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE TABLE eventwitness (
    eventid integer NOT NULL,
    objid uuid NOT NULL
);


--
-- Name: seq_gismo_data; Type: SEQUENCE; Schema: transdb; Owner: postgres
--

CREATE SEQUENCE seq_gismo_data
    START WITH 100
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: gismo_data; Type: TABLE; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE TABLE gismo_data (
    id integer DEFAULT nextval('seq_gismo_data'::regclass) NOT NULL,
    stime timestamp without time zone DEFAULT timezone('UTC'::text, now()),
    deleted integer DEFAULT 0,
    "time" bigint,
    userid text,
    username text,
    objid text,
    sessionid text,
    camerafovx text,
    camerafovy text,
    cameratiltangel text,
    cameraazimuthangle text,
    camerazoom text,
    camerafocus text,
    camerarangefindervalue text,
    cameralatitude text,
    cameralongitude text,
    cameraheight text,
    cameraresolutionwidth text,
    cameraresolutionheight text,
    imagex text,
    imagey text,
    targetid text,
    targetsymbolid text,
    targetsymboldescr text,
    targetlatitude text,
    targetlongitude text,
    targetaltitude text,
    targetdistance text,
    targettype text,
    targetspeed text,
    targetcourse text,
    targetsource text,
    targeteleventid integer NOT NULL
);


--
-- Name: wipe_tasks; Type: TABLE; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE TABLE wipe_tasks (
    objids integer[] NOT NULL,
    dt_hour timestamp without time zone NOT NULL
);


--
-- Name: auditcategory_pkey; Type: CONSTRAINT; Schema: transdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY auditcategory
    ADD CONSTRAINT auditcategory_pkey PRIMARY KEY (category);


--
-- Name: auditlevel_pkey; Type: CONSTRAINT; Schema: transdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY auditlevel
    ADD CONSTRAINT auditlevel_pkey PRIMARY KEY (level);


--
-- Name: camera_downtime_pkey; Type: CONSTRAINT; Schema: transdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY camera_downtime
    ADD CONSTRAINT camera_downtime_pkey PRIMARY KEY (objid, utc_from);


--
-- Name: camera_status_pkey; Type: CONSTRAINT; Schema: transdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY camera_status
    ADD CONSTRAINT camera_status_pkey PRIMARY KEY (status);


--
-- Name: content_delivery_type_pkey; Type: CONSTRAINT; Schema: transdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY content_delivery_type
    ADD CONSTRAINT content_delivery_type_pkey PRIMARY KEY (deliverytypeid);


--
-- Name: pk_av_requestid; Type: CONSTRAINT; Schema: transdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY avatar_archive_requests
    ADD CONSTRAINT pk_av_requestid PRIMARY KEY (requestid);


--
-- Name: pk_eventbookmark; Type: CONSTRAINT; Schema: transdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY eventbookmark
    ADD CONSTRAINT pk_eventbookmark PRIMARY KEY (eventid, utc_when);


--
-- Name: pk_gismo_data; Type: CONSTRAINT; Schema: transdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY gismo_data
    ADD CONSTRAINT pk_gismo_data PRIMARY KEY (id);


--
-- Name: idx_auditlog_objid; Type: INDEX; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE INDEX idx_auditlog_objid ON audit USING btree (objid);


--
-- Name: idx_avatar_geo_history_avatarid; Type: INDEX; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE INDEX idx_avatar_geo_history_avatarid ON avatar_geo_history USING btree (avatarid);


--
-- Name: idx_avatar_geo_history_gtime; Type: INDEX; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE INDEX idx_avatar_geo_history_gtime ON avatar_geo_history USING btree (gtime);


--
-- Name: idx_camera_downtime_objid; Type: INDEX; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE INDEX idx_camera_downtime_objid ON camera_downtime USING btree (objid);


--
-- Name: idx_event_fts_message; Type: INDEX; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE INDEX idx_event_fts_message ON event USING gist (to_tsvector('english'::regconfig, (message)::text));


--
-- Name: idx_event_fts_note; Type: INDEX; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE INDEX idx_event_fts_note ON event USING gist (to_tsvector('english'::regconfig, (note)::text));


--
-- Name: idx_event_objid_ls; Type: INDEX; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE INDEX idx_event_objid_ls ON event USING btree (objid, priority);


--
-- Name: idx_event_utc_from; Type: INDEX; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE INDEX idx_event_utc_from ON event USING btree (utc_from);


--
-- Name: idx_event_utc_to; Type: INDEX; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE INDEX idx_event_utc_to ON event USING btree (utc_to);


--
-- Name: idx_eventbookmark_fts_bookmark; Type: INDEX; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE INDEX idx_eventbookmark_fts_bookmark ON eventbookmark USING gist (to_tsvector('english'::regconfig, (bookmark)::text));


--
-- Name: idx_eventproperty_fts_value; Type: INDEX; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE INDEX idx_eventproperty_fts_value ON eventproperty USING gist (to_tsvector('english'::regconfig, (value)::text));


--
-- Name: idx_eventrepllog_obj_upd_ts; Type: INDEX; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE INDEX idx_eventrepllog_obj_upd_ts ON eventrepllog USING btree (updated_at, obj);


--
-- Name: idx_gismo_data_eventid; Type: INDEX; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE INDEX idx_gismo_data_eventid ON gismo_data USING btree (targeteleventid);


--
-- Name: idx_gismo_data_targetid; Type: INDEX; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE INDEX idx_gismo_data_targetid ON gismo_data USING btree (targetid);


--
-- Name: idx_gismo_data_time; Type: INDEX; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE INDEX idx_gismo_data_time ON gismo_data USING btree ("time");


--
-- Name: idx_pk_event; Type: INDEX; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE UNIQUE INDEX idx_pk_event ON event USING btree (eventid);


--
-- Name: idx_pk_eventproperty; Type: INDEX; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE UNIQUE INDEX idx_pk_eventproperty ON eventproperty USING btree (eventid, name);


--
-- Name: idx_pk_eventwitness; Type: INDEX; Schema: transdb; Owner: postgres; Tablespace:
--

CREATE UNIQUE INDEX idx_pk_eventwitness ON eventwitness USING btree (eventid, objid);


--
-- Name: trg_event_repl; Type: TRIGGER; Schema: transdb; Owner: postgres
--

CREATE TRIGGER trg_event_repl AFTER INSERT OR DELETE OR UPDATE ON event FOR EACH ROW EXECUTE PROCEDURE event_repl_log();


--
-- Name: trg_event_upd_time; Type: TRIGGER; Schema: transdb; Owner: postgres
--

CREATE TRIGGER trg_event_upd_time BEFORE UPDATE ON event FOR EACH ROW EXECUTE PROCEDURE upd_timestamp();


--
-- Name: trg_event_upd_ts_eventbookmark; Type: TRIGGER; Schema: transdb; Owner: postgres
--

CREATE TRIGGER trg_event_upd_ts_eventbookmark BEFORE UPDATE ON eventbookmark FOR EACH ROW EXECUTE PROCEDURE upd_timestamp_cascading_event();


--
-- Name: trg_event_upd_ts_eventproperty; Type: TRIGGER; Schema: transdb; Owner: postgres
--

CREATE TRIGGER trg_event_upd_ts_eventproperty BEFORE UPDATE ON eventproperty FOR EACH ROW EXECUTE PROCEDURE upd_timestamp_cascading_event();


--
-- Name: trg_event_upd_ts_eventwitness; Type: TRIGGER; Schema: transdb; Owner: postgres
--

CREATE TRIGGER trg_event_upd_ts_eventwitness BEFORE UPDATE ON eventwitness FOR EACH ROW EXECUTE PROCEDURE upd_timestamp_cascading_event();


--
-- Name: trg_gismo_data_upd_time; Type: TRIGGER; Schema: transdb; Owner: postgres
--

CREATE TRIGGER trg_gismo_data_upd_time BEFORE UPDATE ON gismo_data FOR EACH ROW EXECUTE PROCEDURE gismo_upd_timestamp();
