SET search_path TO apl;

-- select sets for user, role and object (role and object can be null)
CREATE OR REPLACE FUNCTION getSets(realm uuid, userobj uuid, roleobj uuid, objectobj uuid) RETURNS SETOF object_list AS $$
DECLARE
   result object_list;
BEGIN
    IF objectobj IS NULL THEN
        FOR result in
            SELECT DISTINCT _objs.realm, _objs.obj, _objs.udid, _objs.name, _objs.description, _objs.type, _objs.protected
                FROM _objs, _links as user2role, _links as set2role
                WHERE
                    _objs.deleted = 0
                    AND ($1 IS NULL OR _objs.realm = $1)
                    AND user2role.link_type = 'user2role'
                    AND set2role.link_type = 'set2role'
                    AND _objs.obj = set2role.obj_res
                    AND _objs.type = 'set'
                    AND user2role.obj_res = userobj
                    AND (roleobj IS NULL OR user2role.obj_cons = roleobj)
                    AND set2role.obj_cons = user2role.obj_cons
                ORDER BY _objs.name
        LOOP
            RETURN NEXT result;
        END LOOP;
    ELSE
        FOR result in
            SELECT DISTINCT _objs.realm, _objs.obj, _objs.udid, _objs.name, _objs.description, _objs.type, _objs.protected
                FROM _objs, _links as user2role, _links as set2role, _links as object2set
                WHERE
                    _objs.deleted = 0
                    AND ($1 IS NULL OR _objs.realm = $1)
                    AND user2role.link_type = 'user2role'
                    AND set2role.link_type = 'set2role'
                    AND _objs.obj = set2role.obj_res
                    AND _objs.type = 'set'
                    AND user2role.obj_res = userobj
                    AND (roleobj IS NULL OR user2role.obj_cons = roleobj)
                    AND set2role.obj_cons = user2role.obj_cons
                    AND (
                        object2set.obj_res = objectobj
                        AND object2set.obj_cons = set2role.obj_res
                        AND object2set.link_type LIKE '%2set'
                    )
                ORDER BY _objs.name
        LOOP
            RETURN NEXT result;
        END LOOP;
    END IF;

    RETURN;
END
$$ LANGUAGE 'plpgsql';

