SET search_path TO apl;

--
-- Name: el_get_object_info(uuid)
--

CREATE OR REPLACE FUNCTION el_get_object_info(uuid) RETURNS SETOF el_object_info
    LANGUAGE plpgsql
    AS $_$
DECLARE
   obj_id   ALIAS FOR $1;
   result   EL_Object_Info;
BEGIN
  FOR result in
      SELECT o.obj, o.name, o.type, o.otype, o.subtype, COALESCE(a1.val, 'UTC'), 0, '0'
        FROM _objs o
        LEFT OUTER JOIN _obj_attr a1 ON a1.obj=o.obj AND a1.attr='TIME_ZONE'
       WHERE o.obj = obj_id
  LOOP
     RETURN NEXT result;
  END LOOP;

RETURN;

END;
$_$;
