SET search_path TO confdb;

-- _OBJS: add index access for "realm"

CREATE INDEX _objs_realm ON _objs USING btree(realm);

-- PASSWORD_HISTORY: add index on "userid"

CREATE INDEX password_history_userid ON password_history USING btree(userid);


-- trigger function to be used when "realm" column can not get propor NOT NULL constraint since NULLs are used for system-defined values

CREATE OR REPLACE FUNCTION fn_trg_realm_not_null() RETURNS TRIGGER AS
$BODY$
BEGIN
  IF (TG_OP IN ('INSERT', 'UPDATE')) THEN
    IF (NEW.realm IS NULL) THEN
      RAISE not_null_violation;
    END IF;
  END IF;
  RETURN NULL;
END;
$BODY$
LANGUAGE plpgsql;


-- EVENTPOLICY: forbid inserts for new NULLs (there are standard values shared by realms!), add index access for "realm"

CREATE CONSTRAINT TRIGGER trg_eventpolicy_realm_not_null
 AFTER INSERT OR UPDATE
    ON eventpolicy
   FOR EACH ROW EXECUTE PROCEDURE fn_trg_realm_not_null();

CREATE INDEX eventpolicy_realm ON eventpolicy USING btree(realm);

