SET search_path TO apl;
--
-- Name: getobjectsfromset(uuid, uuid, character, character); Type: FUNCTION; Schema: apl; Owner: postgres
--
DROP FUNCTION getobjectsfromset(realm uuid, setobj uuid, otype character, subtype character);

CREATE OR REPLACE FUNCTION getobjectsfromset(realm uuid, setobj uuid, otype character, subtype character) RETURNS SETOF object_list_without_credentials
    LANGUAGE plpgsql
    AS $_$
BEGIN
    RETURN QUERY
        SELECT _objs.realm, object2set.obj_cons, _objs.obj, _objs.udid, _objs.name, _objs.description, _objs.type, _objs.otype, _objs.subtype, _objs.protected
            FROM _objs, _links as object2set
            WHERE
                ($1 IS NULL OR _objs.realm = $1)
                AND ($3 IS NULL OR _objs.otype = $3)
                AND ($4 IS NULL OR _objs.subtype = $4)
                AND _objs.deleted = 0
                AND object2set.link_type LIKE '%2set'
                AND object2set.obj_res = _objs.obj
                AND object2set.obj_cons = $2
            ORDER BY _objs.name;
END
$_$; 

