SET search_path TO apl;

-- Name: node_list; Type: TYPE; Schema: apl; Owner: postgres
--

CREATE TYPE node_list AS (
	obj uuid,
	uni character varying,
	number_of_cameras integer
);


-- Name: el_workflow; Type: TYPE; Schema: apl; Owner: postgres
--

CREATE TYPE el_workflow AS (
	id integer,
	eventpolicy_parameters character varying
);


--
-- Name: el_workflow_context; Type: TYPE; Schema: apl; Owner: postgres
--

CREATE TYPE el_workflow_context AS (
	context character varying
);


-- Name: el_object_info; Type: TYPE; Schema: apl; Owner: postgres
--

CREATE TYPE el_object_info AS (
	objid uuid,
	name character varying(255),
	type varchar(255),
	otype character(1),
	subtype character(1),
	timedst character varying,
	tz character varying,
	stat_vl_rate character varying
);


--
-- Name: object_list; Type: TYPE; Schema: apl; Owner: postgres
--

CREATE TYPE object_list AS (
  realm uuid,
  obj uuid,
	udid character varying,
	name character varying,
	description character varying,
  type varchar(255),
	protected integer
);


--
-- Name: object_list_with_credentials; Type: TYPE; Schema: apl; Owner: postgres
--

CREATE TYPE object_list_with_credentials AS (
	realm uuid,
	obj uuid,
	udid character varying,
	name character varying,
	description character varying,
	type varchar(255),
	otype character(1),
	subtype character(1),
	protected integer,
	permission character varying,
	credentials character varying
);


--
-- Name: object_list_without_credentials; Type: TYPE; Schema: apl; Owner: postgres
--

CREATE TYPE object_list_without_credentials AS (
	realm uuid,
	setobj uuid,
	obj uuid,
	udid character varying,
	name character varying,
	description character varying,
	type varchar(255),
	otype character(1),
	subtype character(1),
	protected integer
);


