set search_path to confdb;

-- Name: _links_pkey; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY _links
    ADD CONSTRAINT _links_pkey PRIMARY KEY (obj_res, obj_cons, link_type);


--
-- Name: _obj_attr_pkey; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY _obj_attr
    ADD CONSTRAINT _obj_attr_pkey PRIMARY KEY (obj, attr);


--
-- Name: _objs_udid_key; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY _objs
    ADD CONSTRAINT _objs_udid_key UNIQUE (udid);


--
-- Name: eventannounce_pkey; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY eventannounce
    ADD CONSTRAINT eventannounce_pkey PRIMARY KEY (announce_to_userid, eventid);


--
-- Name: obj_block_pkey; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY obj_block
    ADD CONSTRAINT obj_block_pkey PRIMARY KEY (obj, blockid);


--
-- Name: permission_type_permission_credentials_key; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY permission_type
    ADD CONSTRAINT permission_type_permission_credentials_key UNIQUE (permission, credentials);


--
-- Name: permission_type_pkey; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY permission_type
    ADD CONSTRAINT permission_type_pkey PRIMARY KEY (permission);


--
-- Name: pk__link_types; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY _link_types
    ADD CONSTRAINT pk__link_types PRIMARY KEY (link_type);


--
-- Name: pk__obj_otypes; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY objtype
    ADD CONSTRAINT objtype_type_key PRIMARY KEY (type);

ALTER TABLE ONLY objtype
    ADD CONSTRAINT pk__obj_otypes UNIQUE (type, otype, subtype);


--
-- Name: pk__objs; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY _objs
    ADD CONSTRAINT pk__objs PRIMARY KEY (obj);


--
-- Name: pk_cred_types; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY _cred_types
    ADD CONSTRAINT pk_cred_types PRIMARY KEY (cred, type);


--
-- Name: pk_event_emailer_tag; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY event_emailer_tag
    ADD CONSTRAINT pk_event_emailer_tag PRIMARY KEY (userid);


--
-- Name: pk_eventlifespan; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY eventlifespan
    ADD CONSTRAINT pk_eventlifespan PRIMARY KEY (eventlifespan);


--
-- Name: pk_eventpolicy; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY eventpolicy
    ADD CONSTRAINT pk_eventpolicy PRIMARY KEY (eventpolicy);


--
-- Name: pk_eventpolicycontent; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY eventpolicycontent
    ADD CONSTRAINT pk_eventpolicycontent PRIMARY KEY (eventpolicy, eventsource);


--
-- Name: pk_eventpriority; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY eventpriority
    ADD CONSTRAINT pk_eventpriority PRIMARY KEY (eventpriority);


--
-- Name: pk_eventpropertydef; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY eventpropertydef
    ADD CONSTRAINT pk_eventpropertydef PRIMARY KEY (name);


--
-- Name: pk_eventsource; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY eventsource
    ADD CONSTRAINT pk_eventsource PRIMARY KEY (eventsource);


--
-- Name: pk_eventsourceworkflow; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY eventsourceworkflow
    ADD CONSTRAINT pk_eventsourceworkflow PRIMARY KEY (eventsource, workflow);


--
-- Name: pk_eventstate; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY eventstate
    ADD CONSTRAINT pk_eventstate PRIMARY KEY (eventstate);


--
-- Name: pk_eventstatetag; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY eventstatetag
    ADD CONSTRAINT pk_eventstatetag PRIMARY KEY (eventstate, eventtag);


--
-- Name: pk_eventtag; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY eventtag
    ADD CONSTRAINT pk_eventtag PRIMARY KEY (eventtag);


--
-- Name: pk_eventtype; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY eventtype
    ADD CONSTRAINT pk_eventtype PRIMARY KEY (eventtype);


--
-- Name: pk_storagepolicy; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY storagepolicy
    ADD CONSTRAINT pk_storagepolicy PRIMARY KEY (storagepolicy);


--
-- Name: pk_storagertntype; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY storagertntype
    ADD CONSTRAINT pk_storagertntype PRIMARY KEY (storagertntype);


--
-- Name: pk_workflow; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY workflow
    ADD CONSTRAINT pk_workflow PRIMARY KEY (workflow);


--
-- Name: realmtype_realm_otype_subtype_type_key; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY realmtype
    ADD CONSTRAINT realmtype_realm_otype_subtype_type_key UNIQUE (realm, otype, subtype, type);


--
-- Name: schedulehist_pkey; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY schedulehist
    ADD CONSTRAINT schedulehist_pkey PRIMARY KEY (scheduleid, subjectid, propname);


--
-- Name: schedulelink_pkey; Type: CONSTRAINT; Schema: confdb; Owner: postgres; Tablespace:
--

ALTER TABLE ONLY schedulelink
    ADD CONSTRAINT schedulelink_pkey PRIMARY KEY (scheduleid, postureid, timecardid);


--
-- Name: event_emailer_snapshot_snapshot; Type: INDEX; Schema: confdb; Owner: postgres; Tablespace:
--

CREATE INDEX event_emailer_snapshot_snapshot ON event_emailer_snapshot USING btree (snapshotid);

--
-- Name: obj_attr_tbu; Type: TRIGGER; Schema: confdb; Owner: postgres       
--
CREATE TRIGGER obj_attr_tbu BEFORE UPDATE ON _obj_attr FOR EACH ROW EXECUTE PROCEDURE attr_archstate_on_of();

--
-- Name: objs_tbu; Type: TRIGGER; Schema: confdb; Owner: postgres
--
CREATE TRIGGER objs_tbu BEFORE UPDATE ON _objs FOR EACH ROW EXECUTE PROCEDURE set_udid_on_delete_update();


--
-- Name: trg_links_upd_time; Type: TRIGGER; Schema: confdb; Owner: postgres
--

CREATE TRIGGER trg_links_upd_time BEFORE UPDATE ON _links FOR EACH ROW EXECUTE PROCEDURE upd_timestamp();


--
-- Name: trg_objs_upd_time; Type: TRIGGER; Schema: confdb; Owner: postgres
--

CREATE TRIGGER trg_objs_upd_time BEFORE UPDATE ON _objs FOR EACH ROW EXECUTE PROCEDURE upd_timestamp();


--
-- Name: trigger_links_update_link_type; Type: TRIGGER; Schema: confdb; Owner: postgres
--

CREATE TRIGGER trigger_links_update_link_type BEFORE INSERT OR UPDATE ON _links FOR EACH ROW EXECUTE PROCEDURE insert_link_type();


--
-- Name: trigger_obj_attr_insert; Type: TRIGGER; Schema: confdb; Owner: postgres
--
CREATE TRIGGER trigger_obj_attr_insert BEFORE INSERT ON _obj_attr FOR EACH ROW EXECUTE PROCEDURE insertattributes();

--
-- Name: trigger_obj_attr_update; Type: TRIGGER; Schema: confdb; Owner: postgres
--
CREATE TRIGGER trigger_obj_attr_update BEFORE UPDATE ON _obj_attr FOR EACH ROW EXECUTE PROCEDURE updateattributes();


--
-- Name: trigger_objs_insert; Type: TRIGGER; Schema: confdb; Owner: postgres
--

CREATE TRIGGER trigger_objs_type_insert BEFORE INSERT ON _objs FOR EACH ROW EXECUTE PROCEDURE insert_otype_subtype();


--
-- Name: _cred_types_otype_fkey; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY _cred_types
    ADD CONSTRAINT _cred_types_type_fkey FOREIGN KEY (type) REFERENCES objtype(type) ON DELETE CASCADE;


--
-- Name: _link_types_otype_cons_fkey; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY _link_types
    ADD CONSTRAINT _link_types_otype_cons_fkey FOREIGN KEY (type_cons) REFERENCES objtype(type) ON DELETE CASCADE;


--
-- Name: _link_types_otype_res_fkey; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY _link_types
    ADD CONSTRAINT _link_types_otype_res_fkey FOREIGN KEY (type_res) REFERENCES objtype(type) ON DELETE CASCADE;


--
-- Name: _links_link_type_fkey; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY _links
    ADD CONSTRAINT _links_link_type_fkey FOREIGN KEY (link_type) REFERENCES _link_types(link_type) ON DELETE CASCADE;


--
-- Name: _links_obj_cons_fkey; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY _links
    ADD CONSTRAINT _links_obj_cons_fkey FOREIGN KEY (obj_cons) REFERENCES _objs(obj) ON DELETE CASCADE;


--
-- Name: _links_obj_res_fkey; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY _links
    ADD CONSTRAINT _links_obj_res_fkey FOREIGN KEY (obj_res) REFERENCES _objs(obj) ON DELETE CASCADE;


--
-- Name: _links_permission_fkey; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY _links
    ADD CONSTRAINT _links_permission_fkey FOREIGN KEY (permission) REFERENCES permission_type(permission) ON DELETE CASCADE;


--
-- Name: _obj_attr_obj_fkey; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY _obj_attr
    ADD CONSTRAINT _obj_attr_obj_fkey FOREIGN KEY (obj) REFERENCES _objs(obj);


--
-- Name: _objs_otype_fkey; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY _objs
    ADD CONSTRAINT _objs_otype_fkey FOREIGN KEY (type) REFERENCES objtype(type) ON DELETE CASCADE;


--
-- Name: fk__obj_0types_otype; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY objtype
    ADD CONSTRAINT fk__obj_0types_otype FOREIGN KEY (type) REFERENCES objtype(type) ON DELETE CASCADE;


--
-- Name: fk__objs_type; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY _objs
    ADD CONSTRAINT fk__objs_type FOREIGN KEY (type, otype, subtype) REFERENCES objtype(type, otype, subtype);


--
-- Name: obj_block_obj_fkey; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY obj_block
    ADD CONSTRAINT obj_block_obj_fkey FOREIGN KEY (obj) REFERENCES _objs(obj);


--
-- Name: password_history_userid_fkey; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY password_history
    ADD CONSTRAINT password_history_userid_fkey FOREIGN KEY (userid) REFERENCES _objs(obj);


--
-- Name: realmtype_otype_fkey; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY realmtype
    ADD CONSTRAINT realmtype_otype_fkey FOREIGN KEY (type, otype, subtype) REFERENCES objtype(type, otype, subtype) ON DELETE CASCADE;


--
-- Name: realmtype_realm_fkey; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY realmtype
    ADD CONSTRAINT realmtype_realm_fkey FOREIGN KEY (realm) REFERENCES _objs(obj) ON DELETE CASCADE;


--
-- Name: realmtype_set_fkey; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY realmtype
    ADD CONSTRAINT realmtype_set_fkey FOREIGN KEY (set) REFERENCES _objs(obj) ON DELETE CASCADE;


--
-- Name: ref_eventpolicycontent_policy; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY eventpolicycontent
    ADD CONSTRAINT ref_eventpolicycontent_policy FOREIGN KEY (eventpolicy) REFERENCES eventpolicy(eventpolicy);


--
-- Name: ref_eventpolicycontent_src_infwlf; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY eventpolicycontent
    ADD CONSTRAINT ref_eventpolicycontent_src_infwlf FOREIGN KEY (eventsource, infworkflow) REFERENCES eventsourceworkflow(eventsource, workflow) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: ref_eventpolicycontent_src_wlf; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY eventpolicycontent
    ADD CONSTRAINT ref_eventpolicycontent_src_wlf FOREIGN KEY (eventsource, workflow) REFERENCES eventsourceworkflow(eventsource, workflow) ON UPDATE CASCADE;


--
-- Name: ref_eventsourceworkflow_src; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY eventsourceworkflow
    ADD CONSTRAINT ref_eventsourceworkflow_src FOREIGN KEY (eventsource) REFERENCES eventsource(eventsource);


--
-- Name: ref_eventsourceworkflow_wfl; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY eventsourceworkflow
    ADD CONSTRAINT ref_eventsourceworkflow_wfl FOREIGN KEY (workflow) REFERENCES workflow(workflow) ON DELETE CASCADE;


--
-- Name: ref_eventstate_workflow; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY eventstate
    ADD CONSTRAINT ref_eventstate_workflow FOREIGN KEY (workflow) REFERENCES workflow(workflow) ON DELETE CASCADE;


--
-- Name: ref_eventstatetag_eventstate; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY eventstatetag
    ADD CONSTRAINT ref_eventstatetag_eventstate FOREIGN KEY (eventstate) REFERENCES eventstate(eventstate);


--
-- Name: ref_eventstatetag_eventtag; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY eventstatetag
    ADD CONSTRAINT ref_eventstatetag_eventtag FOREIGN KEY (eventtag) REFERENCES eventtag(eventtag);


--
-- Name: ref_storagepolicy_storagertntype; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY storagepolicy
    ADD CONSTRAINT ref_storagepolicy_storagertntype FOREIGN KEY (storagertntype) REFERENCES storagertntype(storagertntype);


--
-- Name: schedulehist_scheduleid_fkey; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY schedulehist
    ADD CONSTRAINT schedulehist_scheduleid_fkey FOREIGN KEY (scheduleid) REFERENCES _objs(obj) ON DELETE CASCADE;


--
-- Name: schedulehist_subjectid_fkey; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY schedulehist
    ADD CONSTRAINT schedulehist_subjectid_fkey FOREIGN KEY (subjectid) REFERENCES _objs(obj) ON DELETE CASCADE;


--
-- Name: schedulelink_postureid_fkey; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY schedulelink
    ADD CONSTRAINT schedulelink_postureid_fkey FOREIGN KEY (postureid) REFERENCES _objs(obj) ON DELETE CASCADE;


--
-- Name: schedulelink_scheduleid_fkey; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY schedulelink
    ADD CONSTRAINT schedulelink_scheduleid_fkey FOREIGN KEY (scheduleid) REFERENCES _objs(obj) ON DELETE CASCADE;


--
-- Name: schedulelink_timecardid_fkey; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY schedulelink
    ADD CONSTRAINT schedulelink_timecardid_fkey FOREIGN KEY (timecardid) REFERENCES _objs(obj) ON DELETE CASCADE;

--
-- Name: avatar_key; Type: FK CONSTRAINT; Schema: confdb; Owner: postgres
--

ALTER TABLE ONLY avatar_key ADD PRIMARY KEY(avatarid);
CREATE INDEX ON avatar_key(isactive);
