import os,socket,threading,time, sys
import base64
from select import select
TCP_IP = '127.0.0.1'
MODE = sys.argv[1]
TCP_PORT = int(sys.argv[2])

class SocketManagerAct:
	def __init__(self, lg):
		self.lg = lg
		self.closed = False
		self.sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
		self.sock.connect((TCP_IP, TCP_PORT))
	def rec(self) :
		while True:
			readers, _, _= select([self.sock], [], [], 0.1)
			if len(readers) == 0:
				break
			for s in readers:
				msg = s.recv(1024)
				if not msg: break
				self.lg.write("raw snd:" + msg + '\n')
				lg.flush()
				msg = base64.b64encode(msg)
				self.lg.write("b64 snd:" + msg + '\n')
				lg.flush()
				sys.stdout.write(msg+'\n');
				sys.stdout.flush()
	def send(self):
		while True:
			readers, _, _= select([sys.stdin], [], [], 0.1)
			if len(readers) == 0:
				break
			for r in readers:
				msg = r.readline()
				if msg == "QUIT":
					self.close()
					break
				_msg = base64.b64decode(msg)
				self.sock.send(_msg)
	def close(self):
		self.closed = True

class SocketManagerPass:
	def __init__(self, lg):
		self.lg = lg
		self.closed = False
		self.sck = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
		self.sck.bind((TCP_IP, TCP_PORT))
		self.sck.listen(5)
		self.sock, _ = self.sck.accept()
		sys.stdout.write("CONNECT\n")
		sys.stdout.flush()
	def rec(self) :
		while True:
			readers, _, _= select([self.sock], [], [], 0.1)
			if len(readers) == 0:
				break
			for s in readers:
				msg = s.recv(1024)
				if not msg: break
				self.lg.write("raw snd:" + msg + '\n')
				lg.flush()
				msg = base64.b64encode(msg)
				self.lg.write("b64 snd:" + msg + '\n')
				lg.flush()
				sys.stdout.write("MSG\n" + msg+'\n');
				sys.stdout.flush()
	def send(self):
		while True:
			readers, _, _= select([sys.stdin], [], [], 0.1)
			if len(readers) == 0:
				break
			for r in readers:
				msg = r.readline()
				if msg == "QUIT":
					self.close()
					break
				_msg = base64.b64decode(msg)
				self.sock.send(_msg)
	def close(self):
		self.closed = True

if __name__=='__main__':
	lg = open("/tmp/logs.log", 'w');
	lg.write("starting")
	lg.flush()
	man = None
	if MODE == "act":
		man = SocketManagerAct(lg)
	else:
		man = SocketManagerPass(lg)
	lg.write("socker started")
	lg.flush()
	while not man.closed:
		man.rec()
		man.send()
