/**
 * @version $Id: validate.js 30471 2014-04-11 16:04:11Z astarostin $
 * ------------------------------------------------------------------------------
 * Validation functions
 * Used for validate VAE attributes. Function names defined in the template.
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2012
 * ------------------------------------------------------------------------------
 */

(function(window){
	"use strict";

	window.Validate = window.Validate || {};
	Validate.VAE = Validate.VAE || {};
	Validate.VAE.edva = Validate.VAE.vca || {};

	Validate.VAE.edva.VAE_EDVA_ACTIVE = function()
	{
		var value = $(Validate.getObj("VAE_EDVA_ACTIVE", this)).val();

        if (Validate.isAttributeVisible("VAE_EDVA_ACTIVE", this))
        {
            Validate.showAttribute("VAE_EDVA_SEPARATOR", this);
        }

		var attributeList = [
			"VAE_EDVA_MIN_FPS",
			"VAE_EDVA_MAX_FPS",
			"VAE_EDVA_VISUALIZATION",
			"VAE_EDVA_CONFIGURATOR",
			"VAE_EDVA_CONFIG",
			"VAE_EDVA_SKIPFRAMES",
			"VAE_EDVA_SCHEDULER",
			"VAE_EDVA_LICENSE_TYPE"
		];

		if (value == 'no') {
			Validate.hideAttribute(attributeList, this);
		} else {
			Validate.showAttribute(attributeList, this);
		}
	};

	Validate.VAE.edva.VAE_EDVA_CONFIGURATOR = function()
	{
		var camera_id = $(this).data("obj");
		var url = $(this).data("url");
		var error_msg = $(this).data("error");
		var self = this;

		var api = new API();
		api.getAttributes({
			obj: camera_id
		})
		.fail(function(code, message){
			Log.error("[" + code + "] " + message);
		})
		.done(function(result){
			var attributes = result.list;

			if (attributes.VAE_ACTIVE != "yes" || attributes.VAE_EDVA_ACTIVE != "yes")
			{
				Log.error(error_msg);
			} else {
				var iAdmin = require("iadmin");

				iAdmin.destroyEditor();
				iAdmin.setFrameContent('/sdi/vae/edva/index.php?objid=' + camera_id + '&VCA=' + attributes.VAE_EDVA_ACTIVE, true);
				iAdmin.setContentHeight();
			}
		});
	};

})(window);
