#!/bin/sh
# $Id: mkvnrepo.sh 752 2011-03-14 22:36:15Z vchepkov $

umask 002
mkdir -p repodata
repomanage --old . | xargs -r rm 
cat > repodata/comps.xml <<REPO
<comps>
  <group>
    <id>videonext-edva</id>
    <name>va-edva</name>
    <description>Packages for videoNEXT edva</description>
    <default>true</default>
    <uservisible>true</uservisible>
    <packagelist>
REPO

for i in *.rpm
do
cat >> repodata/comps.xml <<REPO
       <packagereq type="default">$(rpm -qp --queryformat "%{NAME}" $i)</packagereq>
REPO
done

cat >> repodata/comps.xml <<REPO
    </packagelist>
  </group>
</comps>
REPO

createrepo -g repodata/comps.xml -s sha .
chmod -R g+w repodata
