<?php
	require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
	SessionManager::isUserLoggedIn() or SessionManager::redirect();

	$objid = intval($_GET['objid']);
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<title>OV Analytics configuration page</title>
	<link rel="stylesheet" href="/sdi/global/global.css" type="text/css"/>
	<link rel="stylesheet" href="/sdi/lib/css/jaoselect/style.css" type="text/css"/>
	<link rel="stylesheet" href="style.css" type="text/css"/>

	<script src="/sdi/lib/js/jquery.js"></script>
	<script src="/sdi/lib/js/jquery.databind.js"></script>
	<script src="/sdi/lib/js/jquery.tools.js"></script>
	<script src="/sdi/lib/js/jquery.jaoselect.js"></script>
	<script src="/sdi/lib/js/jquery.mask.js"></script>

	<script src="/sdi/vae/ov/js/analytics.js"></script>
	<script src="/sdi/analytics/js/analytics.formBuilder.js"></script>
	<script src="/sdi/vae/ov/js/classificator.js"></script>
	<script src="/sdi/vae/ov/js/calibrator_ov.js"></script>
	<script src="/sdi/analytics/js/scheduler.js"></script>
	<script src="/sdi/lib/js/log.js"></script>

	<script>
		$(document).ready(function() {
			$('#button_close').click(function() {
				if (confirm("Do you want to close analytics configurator?")) {
					parent.window.location.reload();
				}
			});

			window.analytics.init({
				objid: '<?=$_GET['objid'];?>',
				ov: '<?=$_GET['OV']?>',
				ovc: '<?=$_GET['OVC']?>'
			});
		});
	</script>
</head>
<body>

	<div id="tabs" class="tabs">
		<div class="tabs_menu_header">
			Analytics configuration for camera
			<span id="camera_name"></span>
		</div>
		<div id="tabs_menu" class="tabs_menu">
			<span id="tab_tamper" href="tamper">Tamper detection</span>
			<span id="tab_calibration_ov" href="calibration_ov">OV calibration</span>
			<span id="tab_classification" href="classification">Classification</span>
			<span id="tab_channel" href="channel">Channel settings</span>
			<span id="tab_zones" href="zones">Zones</span>
		</div>
		<div class="tabs_content">

			<div id="player" style="width: 700px; height: 500px">
				<iframe width="700" height="500" scrolling="no" id="analyticsPlayer" src="/TibcoGI/JSXAPPS/mx/cell_player.php?name=livePlayer&camera=<?=$objid;?>&width=700&height=500"></iframe><br />
			</div>

			<div id="tabs_content" class="tabs_form">
				<div id="pane_tamper" class="tab_content">
					<fieldset id="form_tamper">
						<legend>Tamper detection settings</legend>
					</fieldset>
				</div>

				<div id="pane_calibration_ov" class="tab_content">
					<fieldset id="form_calibration_ov">
						<legend>Calibration sample</legend>
						<button id="button_addSample">Add</button>
						<button id="button_removeSample">Remove</button>
					</fieldset>
				</div>

				<div id="pane_classification" class="tab_content">
					<fieldset>
						<legend>Object classes</legend>
						<select size="8" id="classification_object" style="width: 200px;"></select>
						<br>
						<button id="add_classification" style="margin-top: 5px;">Add</button>
						<button id="remove_classification" style="margin-top: 5px;">Remove</button>
					</fieldset>

					<form id="form_classification">
					<fieldset>
						<legend>Object editor</legend>
						<ul>
							<li>
								<div class="clear">
									Name
									<div class="input_wrapper"><input type="text" name="name" /></div>
								</div>
							</li>
							<li>
								<div class="clear">
									Minimum area (m&sup2;)
									<div class="input_wrapper"><input type="text" name="area_min" /></div>
								</div>
							</li>
							<li>
								<div class="clear">
									Maximum area (m&sup2;)
									<div class="input_wrapper"><input type="text" name="area_max" /></div>
								</div>
							</li>
							<li>
								<div class="clear">
									Minimum speed (km/h)
									<div class="input_wrapper"><input type="text" name="speed_min" /></div>
								</div>
							</li>
							<li>
								Maximum speed (km/h)
								<div class="input_wrapper"><input type="text" name="speed_max" /></div>
							</li>
						</ul>
					</fieldset>
					</form>
				</div>

				<div id="pane_channel" class="tab_content">
					<fieldset id="form_channel_settings">
						<legend>Channel settings</legend>
					</fieldset>
					<fieldset id="form_ov_channel">
						<legend>OV view settings</legend>
					</fieldset>
				</div>

				<div id="pane_zones" class="tab_content">
					<fieldset>
						<legend id="zones_list_legend">Zones</legend>
						<select id="zones_list"style="width: 200px; margin: 0 0 5px 15px;"></select><br />
						<button id="add_zone">Add zone</button>
						<button id="add_line">Add line</button>
						<button id="add_multiline">Add multiline</button>
						<button id="remove_object">Remove</button>
					</fieldset>

					<form id="zone_editor" onsubmit="return false;" style="display: none;">
					<fieldset>
						<legend id="zone_editor_legend">Zone editor</legend>
						<ul>
							<li>Activity:
								<select name="state">
									<option value="active">Active</option>
									<option value="nonactive">Non-active</option>
									<option value="when">When:</option>
								</select>

								<select multiple name="postures" class="postures"></select>
								<button id="schedule_preview">Review Schedule</button>
							</li>
							<li>Name <input type="text" name="name" /></li>
							<li>Color
								<select name="color">
									<option value="16711680">Blue</option>
									<option value="65280">Green</option>
									<option value="255">Red</option>
									<option value="16777215">White</option>
									<option	value="65535">Yellow</option>
									<option	value="16711935">Magenta</option>
									<option	value="16776960">Cyan</option>
								</select>
							</li>
							<li id="detection_type">
								Detect/non-detect
								<select name="type">
									<option value="alarm">Detection zone</option>
									<option value="nondetection">Non-detection zone</option>
								</select>
							</li>

							<li id="zone_object_filter" class="separator">
								Include/exclude object classes
								<select id="trk_objs" name="trk_objs" multiple></select>
								<select name="include">
									<option value="include">Include</option>
									<option value="exclude">Exclude</option>
								</select>
							</li>
						</ul>
						<ul id="zone_rules" class="separator">
						</ul>
					</fieldset>
					</form>
				</div>
			</div>

			<div class="tabs_manage_buttons_wrapper">
				<button id="button_apply">Apply changes</button>
				<button id="button_close" title="Close tracker configuration page">Close</button>
			</div>

			<div class="tabs_footer"></div>
		</div>
	</div>

	<div id="boxes">
		<div id="schedule_preview_box" class="window" style="z-index: 920;">
			<div class="tabs">
				<div class="tabs_menu">
					<div class="single_tab">
						<div class="tab_text">
							<?=__("Schedule Info");?>
						</div>
					</div>
				</div>
				<div class="tabs_dialog">
					<div class="d-blank" style="margin-left:15px;">
						<div id="schedule_info">
						</div>
					</div>
					<div class="tabs_manage_buttons_wrapper">
						<div class="tabs_manage_buttons" style="width: 20%; float:right;">
							<div style="margin:2px; width: 90%;">
								<input type="button" id="schedule_info_close" value="<?=__("Close");?>" class="close1"/>
							</div>
						</div>
					</div>
				</div>
				<div class="tabs_footer"></div>
			</div>
		</div>
	</div>
	<!-- Mask for hiding screen -->
	<div id="mask"></div>
</body>
</html>
