/**
 * @version $Id: validate.js 30471 2014-04-11 16:04:11Z astarostin $
 * ------------------------------------------------------------------------------
 * Validation functions
 * Used for validate VAE attributes. Function names defined in the template.
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2012
 * ------------------------------------------------------------------------------
 */

(function (window)
{
	"use strict";

	window.Validate = window.Validate || {};
	Validate.VAE = Validate.VAE || {};
	Validate.VAE.ov = Validate.VAE.ov || {};

	Validate.VAE.ov.VAE_OV_ACTIVE = function ()
	{
		var VAE_OV_ACTIVE = $(Validate.getObj("VAE_OV_ACTIVE", this)).val();
		var VAE_OV_COUNTING_ACTIVE = $(Validate.getObj("VAE_OV_COUNTING_ACTIVE", this)).val();

        if (Validate.isAttributeVisible("VAE_OV_ACTIVE", this) || Validate.isAttributeVisible("VAE_OV_COUNTING_ACTIVE", this))
        {
            Validate.showAttribute("VAE_OV_SEPARATOR", this);
        }

		var attributeList = [
			"VAE_OV_MIN_FPS",
			"VAE_OV_MAX_FPS",
			"VAE_OV_VISUALIZATION",
			"VAE_OV_CONFIGURATOR",
			"VAE_OV_CONFIG",
			"VAE_OV_SCHEDULER"
		];

		if (VAE_OV_ACTIVE == "no" && VAE_OV_COUNTING_ACTIVE == "no")
		{
			Validate.hideAttribute(attributeList, this);
		} else {
			Validate.showAttribute(attributeList, this);
		}
	};

	Validate.VAE.ov.VAE_OV_CONFIGURATOR = function ()
	{
		var camera_id = $(this).data("obj");
		var url = $(this).data("url");
		var error_msg = $(this).data("error");
		var self = this;

		var api = new API();
		api.getAttributes({
			obj: camera_id
		})
		.fail(function(code, message){
			Log.error("[" + code + "] " + message);
		})
		.done(function(result){
			var attributes = result.list;

			if (attributes.VAE_ACTIVE != "yes" || (attributes.VAE_OV_ACTIVE != "yes" && attributes.VAE_OV_COUNTING_ACTIVE != 'yes'))
			{
				Log.error(error_msg);
			} else {
				var iAdmin = require("iadmin");

				iAdmin.destroyEditor();
				iAdmin.setFrameContent('/sdi/vae/ov/index.php?objid=' + camera_id + '&OV=' + attributes.VAE_OV_ACTIVE + '&OVC=' + attributes.VAE_OV_COUNTING_ACTIVE, true);
				iAdmin.setContentHeight();
			}
		});
	};

})(window);
