<?php
	require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
	SessionManager::isUserLoggedIn() or SessionManager::redirect();

	$objid = intval($_GET['objid']);
?>

<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8"/>
	<meta http-equiv="X-UA-Compatible" content="IE=10"/>

	<title>Motion test page</title>
	<link rel="stylesheet" href="/sdi/global/global.css" type="text/css"/>
	<link rel="stylesheet" href="/sdi/lib/css/jaoselect/style.css" type="text/css"/>
	<link rel="stylesheet" href="style.css" type="text/css"/>

	<!--link rel="stylesheet" href="http://trentrichardson.com/examples/timepicker/css/ui-lightness/jquery-ui-1.8.16.custom.css" type="text/css" /-->
	<link rel="stylesheet" href="/sdi/lib/css/uidatepicker/jquery-ui.custom.css" type="text/css" />

	<script src="/sdi/lib/js/require.js"></script>

	<script>
		require.config({
			paths: {
				motion: "js/motion"
			}
		});
		require(["motion", "amq.api"], function(motion){
			$(document).ready(function() {
				$("#player").append('<iframe width="700" height="500" scrolling="no" id="motionPlayer" src="/TibcoGI/JSXAPPS/mx/cell_player.php?name=livePlayer&camera=<?=$objid;?>&width=700&height=500"></iframe>');

				$('.buttons button.back').click(function() {
					if (confirm("Do you want to close motion configurator?")) {
						parent.window.location.reload();
					}
				});
				motion.init({objid: '<?=$objid;?>'});
			});
		});
	</script>
</head>
<body>
	<div id="tabs" class="tabs">
		<div class="tabs_menu">
			<div class="single_tab">
				<div class="tab_text">
					<?php print __("Motion calibration for camera");?>
				</div>
			</div>
		</div>
		<div class="tabs_content">
			<div class="buttons">
				<button class="back">Back</button>
				<button class="apply">Apply</button>
			</div>
			<div id="tabs_menu" class="tabs_menu">
				<span id="tab_zones" href="zones">General</span>
				<span id="tab_tamper" href="tamper">Archive</span>
			</div>
			<div id="player"></div>
			<div class="tabs_form">
				<div id="pane_zones" class="tab_content">
					<ul>
						<li class="range_div">Pixel Noise (0..100): <br/><input type="text" id="VAE_MOTION_PIXELNOISE" name="VAE_MOTION_PIXELNOISE" value="0"/></li>
						<li class="range_div">Cell Noise (0..100): <br/><input type="text" id="VAE_MOTION_CELLNOISE" name="VAE_MOTION_CELLNOISE" value="0"/></li>
						<li class="range_div">Object size (0..200): <br/><input type="text" id="VAE_MOTION_ZONENOISELEVEL" name="VAE_MOTION_ZONENOISELEVEL" value="0" min="0" max="200"/></li>
					</ul>
				</div>
				<div id="pane_tamper" class="tab_content">
					<fieldset id="form_tamper">
						<legend>Date-time selector</legend>
						<input type="text" id="calendar" name="calendar" value=""/>
						<button id="button_archive">Go to Archive</button><br/><br/>
						<button id="button_live">Go to Live</button>
					</fieldset>
				</div>
			</div>
		</div>
		<div class="tabs_footer"></div>
	</div>
</body>
</html>
