/**
 * @version $Id: validate.js 29360 2013-08-16 12:30:03Z astarostin $
 * ------------------------------------------------------------------------------
 * Validation functions
 * Used for validate VAE attributes. Function names defined in the template.
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2012
 * ------------------------------------------------------------------------------
 */

(function(window){
	"use strict";

	window.Validate = window.Validate || {};
	Validate.VAE = Validate.VAE || {};
	Validate.VAE.motion = Validate.VAE.motion || {};

	Validate.VAE.motion.VAE_MOTION_ACTIVE = function()
	{
		var value = $(Validate.getObj("VAE_MOTION_ACTIVE", this)).val();
		var STORAGE_POLICY = $(Validate.getObj("STORAGE_POLICY", this)).val();

        if (Validate.isAttributeVisible("VAE_MOTION_ACTIVE", this))
        {
            Validate.showAttribute("VAE_MOTION_SEPARATOR", this);
        }

		var attributeList = [
			"VAE_MOTION_MIN_FPS",
			"VAE_MOTION_MAX_FPS",
			"VAE_MOTION_VISUALIZATION",
			"VAE_MOTION_CONFIG",
			"VAE_MOTION_SCHEDULER",
			"VAE_MOTION_CONFIGURATOR",
			"VAE_MOTION_ANALYSIS_INTENSITY",
			"VAE_MOTION_FRAME_RARITY"
		];

		if (value == "yes")
		{
			Validate.showAttribute(attributeList, this);
		} else {
			Validate.hideAttribute(attributeList, this);
		}

		if (STORAGE_POLICY == "-5")
		{
			Validate.showAttribute([
				"VAE_MOTION_CONFIGURATOR",
				"VAE_MOTION_ANALYSIS_INTENSITY"
			], this);
		}
	};

	Validate.VAE.motion.VAE_MOTION_CONFIGURATOR = function ()
	{
		var camera_id = $(this).data("obj");
		var url = $(this).data("url");
		var error_msg = $(this).data("error");
		var self = this;

		var api = new API();
		api.getAttributes({
			obj: camera_id
		})
		.fail(function(code, message){
			Log.error("[" + code + "] " + message);
		})
		.done(function(result){
			var attributes = result.list;

			if (attributes.VAE_MOTION_ACTIVE != "yes" && attributes.STORAGE_POLICY != "-5")
			{
				Log.error(error_msg);
			} else {
				var iAdmin = require("iadmin");

				iAdmin.destroyEditor();
				iAdmin.setFrameContent('/sdi/vae/motion/index.php?objid=' + camera_id, true);
				iAdmin.setContentHeight();
			}
		});
	};

})(window);
