#!/usr/bin/perl

use Socket;
use strict;
use Data::Dumper;
use LWP::UserAgent;
use HTTP::Request::Common;
use XML::Simple;

my $APL='/opt/sarch';
my $APL_VAR='/var/sarch';
my $RESOLV='/etc/resolv.conf';
my $NTPCONF='/etc/ntp.conf';
my $NTPDCONF='/etc/sysconfig/ntpd';
my $TICKER='/etc/ntp/step-tickers';
my $COLLECTSF="/bin/su - apl -c $APL/conf/bin/master_sf_collect";
my $SHOWSF='ls /var/sarch/sf/master/* | tail -4';
my $FINDBACKUP="/bin/su - apl -c $APL/conf/bin/find_backup";
my $SHOWBCK_CNT=20;
my $INSTALLED="$APL_VAR/installed";

my $exit=0;

#-------------------------------------------------------------------------------
sub do_exit {
  print "Exiting...\n";
  $exit=1;
}

#-------------------------------------------------------------------------------
sub apply_updates {
  if ( not -f "$APL/base/bin/sos-updates.pl") {
    print "\nUpdates are not implemented yet\n";
    return;
  }
  system("$APL/base/bin/sos-updates.pl");    
}

#-------------------------------------------------------------------------------
sub check_NameServer {
  my $nserver=shift;
  $_=`/usr/bin/dig +time=3 \@$nserver >/dev/null 2>&1 || echo 'inaccessible'`;
  return 'inaccessible' if /inaccessible/;
  return 'OK';
}

#-------------------------------------------------------------------------------
sub support_files {
  if( -f $INSTALLED) {
     print "Application is not activated\n";
     return;
  } 
  system($COLLECTSF);
  print "Support files:\n";
  system($SHOWSF);
}

#-------------------------------------------------------------------------------
sub create_backup {
  if( -f $INSTALLED) {
     print "Application is not activated\n";
     return;
  }
  print "\nPlease specify backup type (C-config only; A-everything) and comment,\n";
  print "example> A:comment for my backup\n>";
  my $tc = <STDIN>;
  chomp $tc;
  my ($type,$comment);
  if ($tc=~/^([AC])(:(.*))?$/) {
    $type=$1;
    $comment= $3;
    
  } else {
    print "Invalid backup type\n";
  }
  my $args = $type eq 'A' ? '-t' : '';
  if (defined $comment) {
    $comment=~s/^\s*//; $comment=~s/\s*$//; # trim
    $args.=" -c '$comment'";
  }
  my $cmd = "/bin/su - apl -c \"$APL/conf/bin/master_backup $args\"";
  my ($bckid)=`$cmd`=~/Backup identification sequence: \[(\d{6}_\d{6})\]/mi;
  if ($?) {
    print "\nErrors while creating backup\n";
  } else {
    print "\nBackup completed successfully: /var/sarch/backup/$bckid\n";
  }
  print "------------------------------------------------------------------------------\n";
}

#-------------------------------------------------------------------------------
sub restore_backup {
  if( -f $INSTALLED) {
     print "Application is not activated\n";
     return;
  }
  my $ind=0;
  my @list=`$FINDBACKUP`;
  print "\nRestore:\n";
  if (not @list) {
    print "No backups found\n";
    return;
  } elsif(@list<=$SHOWBCK_CNT) {
    print @list;
    print "(specify backup name)\n";
  } else {
    print @list[$ind..$ind+$SHOWBCK_CNT-1];
    $ind+=$SHOWBCK_CNT;
    print "(only first $SHOWBCK_CNT is shown, press N for next page or specify backup name)\n"
  }
  while(1) {
    print ">";
    my $in=<STDIN>;
    chomp $in;
    if ($in=~/^(\d{6}_\d{6})$/) {
      my $bckid=$1;
      print "Restoring configuration $bckid\n";
      system("/bin/su - apl -c 'DEBUG=1 $APL/conf/bin/master_restore $bckid'");
      last;
    } elsif ($in eq 'N' or $in eq 'n') {
      my $top=$ind+$SHOWBCK_CNT<@list?$ind+$SHOWBCK_CNT:@list;
      print @list[$ind..$top-1];
      print "(backups ".($ind+1)."-$top are shown, press N for next page or specify backup name)\n";
      $ind=$top==@list?0:$top;
    }
  }    
  print "------------------------------------------------------------------------------\n";
}

#-------------------------------------------------------------------------------
sub status_NameServer {
  my $action=shift;
# print "----------- $action Name Server[s]------\n";
  if(open(RESOLV,$RESOLV)) {
     while(<RESOLV>) {
       if(/^\s*nameserver\s+([\d\.\:]+)/) { 
          print "nameserver $1";
          print("\t: ". check_NameServer($1)) if $action eq 'checking';
          print "\n";
       }
     } 
     close RESOLV;
  }
}
#-------------------------------------------------------------------------------
sub ask_ntp_server {     # dialog for ntp_server
#-------------------------------------------------------------------------------
  my $ntp_server;
  #------------------------  INTERACTIVE NTP configuration
  for(;;) {
    print "\nPlease specify NTP server:";
    my $ntp = <STDIN>;
    chomp $ntp;
    if($ntp eq 'NONE') {
       print "using self-synchronized NTP (it is not advisable)\n";
       return '';
    }
    print "querying NTP server '$ntp'. Please wait..\n";

    $_=`/usr/sbin/ntpdate -q $ntp 2>&1`;
    if($?) {                     # query fails
      print "Query fails: $_\n";
      print "Server '$ntp' is rejected";
      print "(type NONE for self-synchronization)\n";
      next;
    }else {
      $ntp_server=$ntp;              # set a global variable for use later
      print "query returns: $_";
      print "NTP server '$ntp' is accepted\n";
      last;
    }
  }
  return $ntp_server;
}
#-------------------------------------------------------------------------------
sub set_ntp_server { # place NTP server into configuration files
#-------------------------------------------------------------------------------
   # TBD: error handling
   my $server=shift;
   my $stratum=($server)?10:7;   # use stratum 7 for self-sync
   # clean ntp.conf
   `/usr/bin/perl -ni -e 'print if not /^(server|fudge)/' $NTPCONF`;
   # append with server
   open NTPCONF,">>$NTPCONF";
   print NTPCONF "server 127.127.1.0\n"
                ."fudge  127.127.1.0 stratum $stratum\n";
   print NTPCONF "server $server iburst\n" if $server;
   close NTPCONF;
   # create step-ticker
   open TICKER,">$TICKER";
   print TICKER "$server\n" if $server;
   close TICKER;
   # SYNC_HWCLOCK=yes
   `/usr/bin/perl -pi -e 's|^SYNC_HWCLOCK.*|SYNC_HWCLOCK=yes|' $NTPDCONF`;

   system("/sbin/service ntpd restart");
}

#-------------------------------------------------------------------------------
sub setup_timeserver {
  my $ntp=ask_ntp_server;   # ask and check for correct NTP server name or IP
  set_ntp_server($ntp); 
}

#-------------------------------------------------------------------------------
sub status {
  my $line;
  my %ints = ();
  print "\n\n================================ Network =====================================\n";
  open(IFCONFIG,"/sbin/ifconfig |grep -B3 Ethernet|");
  while(defined($line=<IFCONFIG>))
  {
    my $interface;
    if($line =~ /^(\w+).*flags=/) {
      $interface = $1;
      die "System error\n" if not defined($line=<IFCONFIG>);

      my $ip = `/sbin/ifconfig $interface|grep "inet "|cut -f10 -d" "`;
      print "$interface: $ip\n";
      $ints{$ip}=$interface;

    }
  }
  close(IFCONFIG) or warn "Couldn't execute ifconfig";

  status_NameServer('checking');
  print "------------------------------- NTP Server -----------------------------------\n";
  my $ntpq=`/usr/sbin/ntpq -pn`;
  $ntpq=~s/=\n//;
  $ntpq=~s/=//g;
  print $ntpq;
  my ($sysid,$verid)=('NOT INSTALLED','NOT DEFINED');
  if( -f "$APL/vpatch/bin/vctl") {
     $sysid=`su - apl -c '$APL/vpatch/bin/vctl sysid'`;
     $verid=`su - apl -c '$APL/vpatch/bin/vctl verid'`;
     chomp  $sysid; chomp $verid;
  }
  print "--------------------------- System ID/version --------------------------------\n$sysid / $verid\n";
  print "------------------------------- Application ----------------------------------\n";
  if( -f $INSTALLED) {
     print "Application is not activated\n";
  }else {
   my $status;
   open(PS,"/bin/ps -ef|");
   my $instance = 0;
   while(defined($line=<PS>)){
     if($line =~ /\bcam_patrol\b/) {
       $instance++;
     } 
   }
   close(PS) or warn "Couldn't execute ps\n";
   if ($instance > 0) {
     print "Application is UP and RUNNING\n";
   } else {
     print "Application is DOWN\n";
   }
   if( -f "$APL/var/conf/master/s_master") {   # new way to find status for MASTER system
     print 'Status:'.`cat $APL/var/sdi/system_status`;
   }
   print "---------------------------- NODE / DOMAIN   ---------------------------------\n";
   my $iaddr=gethostbyname('s_master');
   my $master=($iaddr)?inet_ntoa($iaddr):'<undef>';
   print "Master IP: $master\n";
   if(-f "$APL/var/conf/master/s_master") {
     print "Server is MASTER\n";
   } else {
     print "Server is NODE\n";
   }
  }
  print "==============================================================================\n";
}

#-------------------------------------------------------------------------------
sub network {
  system("/usr/sbin/system-config-network-tui")==0 or warn "system error $?\n";
  print "\nATTENTION! network and application services have to be restarted\n"
       ."You may loose session if connected over network\n\n"
       ."Press ENTER to continue";
  $_=<STDIN>;
  restart_app();
  sleep 15;
}
#----------------------------------------------------------- whosthere ---------
sub whosthere {
#-------------------------------------------------------------------------------
  # Dummy routine
  # TODO: implement new logic
  return wantarray?('0.0.0','master'):'0.0.0';
}

#-------------------------------------------------------------------------------
sub change_master{
#
# NOTE1: only IP4 is supported at this time
# NOTE2: function will correct incorrect s_master entries 
#   
 if( -f $INSTALLED) {
     print "Application is not activated\n";
     return;
 } 
 my $master;
 if( -f "$APL/var/conf/master/s_master") { # if master then show a list to chose from
    my $i=1;
    my %iplist=map{($i++,$_)} split(/\n/,`$APL/base/bin/ip_addr_show`);
    if(! %iplist) {
       print "ERROR: Cannot change MASTER. Server does not have a network!\n\n";
       return;
    }elsif(scalar(keys %iplist)==1) {
       $master=$iplist{1};
    }else {              # chose from the list
       print "Choose IP address from the list:\n";
       print "$_ : $iplist{$_}\n" foreach (sort keys %iplist);
       print "Choice > ";
       $_=<STDIN>;
       chomp;
       if( not exists $iplist{$_} ) {
         print "ERROR: Wrong choice\n\n";
         return;
       }
       $master=$iplist{$_};
    }
    print "Using $master for MASTER IP\n";
 } else {                                  # choice for NODE (master has to be on other side)
   print "Enter new master ip: ";
   $master = <STDIN>;
   chomp($master);
   $master=~s/\s//g; # remove spaces from IP address if any
   die "IP address $master is invalid\n" if not $master=~/^(\d\d?\d?)\.(\d\d?\d?)\.(\d\d?\d?)\.(\d\d?\d?)$/;
   die "IP address $master is invalid\n" if $1>255 ||  $2>255 || $3>255 && $4>255;
   my $details=whosthere($master);
   if($details=~/^ERROR/) {
     print "No valid respond from $master\n\n";
     return;
   }
   my ($verid,$stype)=whosthere($master);
   if( $stype ne 'master') {
      print "Master is not identified on $master\n\n";
      return;
   }
 }
 eval {
  my $new = "/etc/hosts.$$";
  open(OLD,"</etc/hosts") or die "Couldn't open /etc/hosts file\n" ;
  my @hosts=<OLD> or die "cannot read /etc/hosts\n";
  close OLD;
  open(NEW,">$new") or die "Couldn't create new /etc/hosts file\n" ;
  my $corrected=0;
  foreach(@hosts) {
    chomp;
    if (not (/^\s*#/ || /^\s*$/)) {  # string is not commented or empty line
      if(/^\s*([\d\.:]+)(\s+[^#]+)(#.*)*$/) { # looks like a valid entry
        my $ip=$1;
        my $names=$2;
        if(!$corrected) { # s_master entry is not corrected yet
          if($ip eq $master) {
             $names=~s/\ss_master\b([^\s#])*//g; # remove s_master if any
             $names=~s/\sva-master\.localdomain\b([^\s#])*//g;      # remove va-master.localdomain if any
             $names=~s/^\s+//;                # remove leading spaces
             $_="$master\ts_master va-master.localdomain $names";   # a new version is created
             $corrected=1;
          } elsif ($names=~/\ss_master\b/ || $names=~/\sva-master\.localdomain\b/) {
             $names=~s/\ss_master\b([^\s#])*//g; # remove s_master
             $names=~s/\sva-master\.localdomain\b([^\s#])*//g;      # remove va-master.localdomain
             if($names=~/\w/) {             # else names are present still
               s/\ss_master\b([^\s#])*//g;  # remove s_master from string
               s/\sva-master\.localdomain\b([^\s#])*//g;            # remove va-master.localdomain from string
             } else {                        # no name except master or remove va-master.localdomain was in names
               $_="$master\ts_master va-master.localdomain";        # new version is created
               $corrected=1;
             }
          }
        } else  {          # already corrected. any mention of s_master has to be removed
          if($ip eq $master) {
            $_="#$_";      # comment out doubled IP
          }elsif ($names=~/\ss_master\b/ || $names=~/\sva-master\.localdomain\b/) {
             $names=~s/\ss_master\b([^\s#])*//g;# remove s_master
             $names=~s/\sva-master\.localdomain\b([^\s#])*//g;  # remove va-master.localdomain
             if($names=~/\w/) {                            # else names are present still
               s/\ss_master\b([^\s#])*//g;     # remove s_master from string
               s/\sva-master\.localdomain\b([^\s#])*//g;        # remove va-master.localdomain from string
             }else {                # no name except master was in names
               $_="#$_";            # comment out (this should never be!)
             }
          }
        }
      }
      else {              # comment out invalid entry
        $_="#$_";
      }
    }
    print(NEW "$_\n") or die("Cannot write a $new file\n");
  }
  if(!$corrected) {
    print(NEW "$master\ts_master va-master.localdomain\n") or die("Cannot write a $new file\n");
  }
  close(NEW) or die "Couldn't close new hosts file\n";
  unlink("/etc/hosts.old");
  system("cp /etc/hosts /etc/hosts.old");
  system("cp $new /etc/hosts");
  unlink($new);
  restart_app();
 };
 if($@) { # exception
    print "\nERROR:$@\ns_master is not changed\n\nPress ENTER";
    $_=<STDIN>;
 } 
}

#-------------------------------------------------------------------------------
sub restart_app{
  if( -f $INSTALLED) {
     print "Application is not activated\n";
     return;
  }
system("/sbin/service patrol stop\n"
     . "/sbin/service httpd stop\n"
     . "/sbin/service postgresql stop\n"
     . "/sbin/service servicemix stop\n"
     . "/sbin/service network restart\n"
     . "sleep 2\n"
     . "/sbin/service servicemix start\n"
     . "/sbin/service postgresql start\n"
     . "/sbin/service httpd start\n"
     . "/sbin/service patrol start");
}

#-------------------------------------------------------------------------------
sub restart{
  system("/sbin/shutdown -r now 'VNSOS restart'");
}

#-------------------------------------------------------------------------------
sub passwd_admin{
 if( -f $INSTALLED) {
     print "Application is not activated\n";
     return;
 }
 if (not -f "$APL/db/bin/reset_psw.pl") {
     warn("\nERROR: Application is not installed\n\n");
     return 1;
  }
  system("/bin/su - apl -c $APL/db/bin/reset_psw.pl >/dev/null") == 0 or warn "system error: $?\n";
}

#-------------------------------------------------------------------------------
sub menu()
{
  my  ($setup_timeserver,$support_files,$create_backup,$restore_backup);
  $setup_timeserver='8. Setup NTP Server'      if -f "$APL/var/conf/master/s_master";
  $support_files   ='9. Collect Support Files' if -f "$APL/var/conf/master/s_master";
  $create_backup   ='10. Backup'        if -f "$APL/var/conf/master/s_master";
  $restore_backup  ='11. Restore'  if -f "$APL/var/conf/master/s_master";
  
  print <<"EOM";
                     Select an option:
1. Show status                         |   7. System update
2. Network/DNS configuration           |   $setup_timeserver
3. Change MASTER IP                    |   $support_files
4. Restart application services        |  $create_backup
5. Restart server                      |  $restore_backup
6. Reset application admin password    |  99. EXIT 
EOM
print "? ";
}

#-------------------------------------------------------------------------------
# Define the actions to take
my %action_to_take = (
  '1' => \&status,
  '2' => \&network,
  '3' => \&change_master,
  '4' => \&restart_app,
  '5' => \&restart,
  '6' => \&passwd_admin,
  '7' => \&apply_updates,
  '8' => \&setup_timeserver,
  '9' => \&support_files,
  '10'=> \&create_backup,
  '11'=> \&restore_backup,
  '99'=> \&do_exit
);

status();
do {
  menu();
  my $choice = <STDIN>;
  chomp($choice);

  if (defined $action_to_take{$choice}) {
    $action_to_take{$choice}->();
  } else {
    print "I didn't understand the command.\n";
  }
} until $exit;

