#!/usr/bin/perl
#
# $Id: xio_status.pl 20359 2010-10-06 12:49:16Z atsibulnik $
#
# (c) 2002-2003 Dmitri Astaltsev

use HTML::Template;     # Templates support
use SKM::DB;
use strict;
use CGI qw/escape unescape/;
use NextCAM::Init;

my $form_info='';
if ($ENV{'REQUEST_METHOD'} eq "GET") {
      $form_info = $ENV{'QUERY_STRING'};
} else {
      my $size_of_form_information = $ENV{'CONTENT_LENGTH'};
      read (STDIN, $form_info, $size_of_form_information);
}
my %args;
foreach(split /&/,$form_info){$args{lc($1)}=unescape($2) if/(\S+)=(\S+)/}

#CONS
my $DEBUG=0;

#VARS
my $dbh = DBNode({PrintError => 1}) || die("ERROR!$DBI::errstr\n");
my %PARAMS;
my $PAGE = $ENV{PATH_TRANSLATED};       # Requested document
my $template = HTML::Template->new(filename => "$PAGE");
my %conf;

###########################################################################
# Prepare list of devices
my @devices = check_devs($ENV{REMOTE_USER},"DEVICES");
$PARAMS{DEVICES}     = \@devices if $template->query(name => 'DEVICES');

my @devices_js = check_devs($ENV{REMOTE_USER},"DEVICES_JS");
$PARAMS{DEVICES_JS}     = \@devices_js if $template->query(name => 'DEVICES_JS');


my $xiolist='';
if ($args{devlist} ne ''){
   $xiolist=$args{devlist};
} else {
   my @devlist;
   @devlist = sqlist("select dev from usr_dev_v where usr='$ENV{REDIRECT_REMOTE_USER}'");

   my @xiolist =();
   foreach (@devlist) { push(@xiolist,$_) if not /^\d/}; # We don't need cameras
   @xiolist = sort(@xiolist);
   $xiolist=join(",",@xiolist);
}
$PARAMS{DEVLIST} = $xiolist if $template->query(name => 'DEVLIST');


###########################################################################
# OUTPUT to html
###########################################################################
print "Cache-Control: no-store, no-cache, must-revalidate\n";
print "Cache-Control: post-check=0, pre-check=0\n";
print "Pragma: no-cache\n";
print "Content-Type: text/html\n\n";

$template  ->  param(%PARAMS);
print $template->output;

####################################################################
#    SUBS
sub debug       {print STDERR "DEBUG @_\n" if $DEBUG>=shift}
sub sqlist{ debug(5,"sqlist:@_\n");map{@{$_}}@{$dbh->selectall_arrayref(@_)}}


####################################################################
## Check cameras allowed for user
sub check_devs {
   my ($user,$LOOP) = @_;   
   my @devs = ($args{devlist} ne '')? (split(/,/,$args{devlist})): sqlist("select dev from usr_dev_v where usr='$user'");
   my @devices = ();
   my $i = 0;
   foreach (@devs) {
	%conf = (%conf, GetCfgs( ('DEVID'=>$_) ) );
 	next if $conf{$_}->{DEVICETYPE} =~/CAMERA/i;
        my $devID = $_;
        my %devs;
        $devs{DEVID}=$devID if $template->query(name => [$LOOP,'DEVID']);
        $devs{I}=$i if $template->query(name => [$LOOP,'I']);
        $devs{LOCATION} = ${$conf{$devID}}{LOCATION} if $template->query(name => [$LOOP,'LOCATION']);
        $devs{NAME} = ${$conf{$devID}}{NAME} if $template->query(name => [$LOOP,'NAME']);
        $devs{DEVICETYPE}=${$conf{$_}}{DEVICETYPE} if $template->query(name => [$LOOP,'DEVICETYPE']);
        $devs{IP} = ${$conf{$devID}}{IP} if $template->query(name => [$LOOP,'IP']);
        $devs{KEYACTION} = ${$conf{$devID}}{KEYACTION} if $template->query(name => [$LOOP,'KEYACTION']);	
	my $img=${$conf{$devID}}{KEYACTION};
	$img =~s/\s/_/g;
        $devs{IMG} = $img if $template->query(name => [$LOOP,'IMG']);	
	if (${$conf{$_}}{DEVICETYPE}=~/SENSOR/i){ # 
	   $devs{SENSOR} = 1 if $template->query(name => [$LOOP,'SENSOR']);
	}
        push(@devices, \%devs);
	++$i;
   }
   return @devices;
}
