#!/usr/bin/perl -w
# -----------------------------------------------------------------------------
#  The part of 'IP cameras retrival' project
#  get/set SONY parameters for sensor controls and relays
#  require admin username and password in sensor control parameters
#  based on analysis Sony Network Camera SNC-RZ30 html pages
# -----------------------------------------------------------------------------
#  Author: ryabovol, 
#  Edited by:
#  QA by:
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------
#  usage:
#         sony_sen_ctl.pl devid=s1                              - show SONY system information
#         sony_sen_ctl.pl objid=123                             - show SONY system information
#         sony_sen_ctl.pl devid=s1 sensor                       - show parameter
#         sony_sen_ctl.pl objid=123 sensor                      - show parameter

use NextCAM::Init;
use strict;
use LWP::UserAgent;
use HTTP::Request::Common;

# VARS -------------------------------------------------------------------------
my ($P) = (split(/\//, $0))[-1]; #name of the program
my $device = shift @ARGV;

# PROC -------------------------------------------------------------------------
sub usage {
   my $err=shift;
   print STDERR "\n$err\n" if $err;
   print STDERR "\nSONY provisioning helper\nUsage:\n"
	."  $P devid=s1                              - show SONY system information\n"
	."  $P objid=123                             - show SONY system information\n"
	."  $P devid=s1 sensor                       - show parameter\n"
	."  $P objid=123 sensor                      - show parameter\n\n";
}

sub show_system_info {
  my $cf = shift;
  my $answ = get_set_sony_param($cf, 'sysinfo');
  my $info;
  $info .= $1."\n" if $answ =~ /var (ModelName=\".+\")/;
  $info .= $1."\n" if $answ =~ /var (SoftVersion=\".+\")/;
  $info .= $1."\n" if $answ =~ /var (Serial=\"\d+\")/;
  
  print "\n$info\n";
}

sub send_request {
 my ($url, $username, $password) = @_;
 my $ua = LWP::UserAgent->new;
 $ua->timeout(3);
 my $req = GET $url;
 $req->authorization_basic($username, $password);
 my $rsp=$ua->request($req);
 return ($rsp->is_success) ? $rsp->content."\n" : "HTTP ERROR [".$rsp->code."]";
}

sub get_set_sony_param {
 my $cf = shift;
 my $key = join '&',@_;
 my $res = send_request("http://$cf->{IP}:$cf->{HTTP_PORT}/command/inquiry.cgi?inqjs=$key", $cf->{USRNAME}, $cf->{PASSWD});
 return ($res =~ /HTTP ERROR/) ? $res.": Cannot get $key\n" : $res;
}

sub set_and_check {
 my $cf = shift;
 my $val = join "\n",@_;
 my $key = join '&', map {/^(.+)=.+/} @_;
 my $old = get_set_sony_param($cf, $key);
 my $set = get_set_sony_param($cf, @_);
 my $new = get_set_sony_param($cf, $key);
 return " Old value:\n$old Set value:\n$val\n$set New value:\n$new";
}

# MAIN -------------------------------------------------------------------------
my $cfg;
usage(), exit if not $device;
if($device =~ /devid=([sr]\d+)/) {	#devid parameter
   my %conf = GetCfgs('DEVID' => $1);
   print(STDERR "CFG ERROR: Device $device is not defined in system\n"), exit 1	if not %conf;
   $cfg = $conf{$1};
}elsif($device =~ /objid=(\d+)/) {	#objid parameter
   my %conf = GetCfgs('OBJID' => $1);
   print(STDERR "CFG ERROR: Device $device is not defined in system\n"), exit 1	if not %conf;
   my $devid = (keys %conf)[0];
   $cfg = $conf{$devid};
}else {
  usage("CFG ERROR: Wrong Device '$device' specification");
  exit 1;
}
print(STDERR "CFG ERROR: This is not SONY sensor control or relay! HW_MODEL=$cfg->{HW_MODEL}\n"),exit 1    if $cfg->{HW_MODEL} ne 'SONY';

if(defined($cfg->{ASSOCIATE}) and $cfg->{ASSOCIATE}) {
    my %conf = GetCfgs('OBJID' => $cfg->{ASSOCIATE});
    $cfg->{HTTP_PORT} = (%conf) ? $conf{(keys %conf)[0]}{HTTP_PORT} : 80;
}
else { $cfg->{HTTP_PORT} = 80; }
        

if(not @ARGV) {		# only show system information
  show_system_info($cfg);
  exit 0;
}

my (@get, @set);
foreach(@ARGV) {
 push(@get, $1)     if /^(\w[\w\.]+)$/;
 push(@set, $1)     if /^(\w[\w\.]+=.+)$/;
}

print set_and_check($cfg, @set)  if @set;
print get_set_sony_param($cfg, @get) if @get;
