#!/usr/bin/perl
#
#  $Id$
#
#  purpose:
#   1. find patch-package on USB attached drive
#   2. check applicable name
#   3. check signature and decode a package
#   4. run package
#   
#  note: 
#   - script runs from root
#   - linux specific
#


my $APL='/opt/sarch';
my $VERSION=`$APL/vpatch/bin/vctl label`; chomp $VERSION;
my $VERID  =`$APL/vpatch/bin/vctl verid`;
my ($LEVEL)=$VERID=~/-p(\d+)$/;
my $GPG="gpg --homedir /$APL/vpatch/etc/.pg --batch -d";
my $LIST='/sbin/fdisk -l';
my $MNT="/tmp/mnt$$";
my $PSTORE="$APL/vpatch/var/tmp";
#----------------------------------------------------------------------------
die("\nVERSION is not defined or software is not installed\n") if ! $VERSION;
die("\nShould be run by root\n") if ($<!=0);
mkdir($MNT,0755) || die "Cannot create mountpoint $MNT";
print "\n\n--------------------------------------------------------------";
print "[Instruction]--\n";
print "Place ServicePack $VERSION-p<number>.sh.pgp on USB-flash\n";
print "and insert flash drive to USB socket on server\n";
print "Note: ServicePack sequence <numner> should be grate then $LEVEL\n";
print "\nPress ENTER when ready [CTRL+C - to exit]\n";
<STDIN>;
#-------------------------------------------------------prepare mount list
my @list;
open(LIST,"$LIST|") || die "Cannot do $LIST: $@";
foreach(<LIST>) {
  push(@list,$1) if m|^(/dev/sd\w?\d)\s.+FAT\d?\d?|;
  push(@list,$1) if m|^Disk\s(/dev/sd\w?):\s+(\d\d\d\d?)\sMB|;
}
close $LIST;
print "Candidates: ". join(' ',@list). "\n";
open(MOUNT,"mount|") || die "Cannot run mount";
my %mounted= map{m|(/dev/s\w+\d)\son\s(\S+)\s|} grep {m|^/dev/sd\w\d\son\s\S+\s|} <MOUNT>;
close MOUNT;
#-------------------------------------------------------------try to mount 
foreach(@list) {
   my $mpoint=$MNT;
   if(defined $mounted{$_}) { # already mounted
     $mpoint=$mounted{$_};
   }else {                
    `umount $MNT 2>/dev/null; mount -r $_ $MNT 2>/dev/null`;
     next if $?;                       # mount fails
   }
   print "mounted: $_ in $mpoint\n";
   opendir(DIR,$mpoint) || die "Cannot read dir $mpoint";
   my @dir= grep { /^${VERSION}-p\d+.sh.gpg$/ } readdir(DIR);
   closedir DIR;
   if(not @dir) {
      print "\tNo ServicePacks are found for $VERSION\n";
      next;
   }
   foreach my $file (@dir) {
     print "\tfound $file\n";
     next if not $file=~/-p(\d+).sh.gpg$/;     #it cannot be
     if ($LEVEL>=$1)  {
       print "\tskipping $file (alredy applied)\n"; 
       next;
     }
     $_=$file; s/.gpg$//;               # remove extention
     print "-------------------------------------------------------------[verification]--\n";
     print `$GPG $mpoint/$file >$PSTORE/$_`;
     print "-----------------------------------------------------------------------------\n";
     if($?) {
       print "\n\nERROR!! Verification fails. $_ cannot be applied \n\n";
       next;
     }
     system("/bin/bash $PSTORE/$_");
   }
   `umount $MNT 2>/dev/null`;
}

my $newVERID  =`$APL/vpatch/bin/vctl verid`;
my ($newLEVEL)=$newVERID=~/-p(\d+)$/;
print "\nNo ServicePacks/patches are applied\n" if $newLEVEL==$LEVEL;
print "-----------------------------------------------------------------------------\n";
