<?php
/*
#------------------------------------------------------------------------------
# Return pre-cached snapshot of DS cell
#------------------------------------------------------------------------------
# Author: Alexey Tsibulnik
# Edited by:
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();

// Per-status camera snapshots: STATUS => URL
$CellType = array();
$vnc_dummy_img = "/TibcoGI/JSXAPPS/mx/images/design1/vnc/vnc_image.jpg";
$web_dummy_img = "/TibcoGI/JSXAPPS/mx/images/design1/vMX/webcell.jpg";

if (isset($_GET['monid']) && isset($_GET['cellid']) && isset($_GET['type'])) {
	$monid = intval($_GET['monid']);
	$cellid = escapeshellarg($_GET['cellid']);
	$type = $_GET['type'];

	$cellid = substr($cellid, 1, -1); // Cut off starting and ending quotes

	$picture_file_name = $monid . "." . $cellid . ".jpg";
	$picture_file = "/opt/sarch/var/vwall/snapshot/" . $picture_file_name;

	if (!is_file($picture_file)) {
		if (strcasecmp($type, "vnc") == 0) {
			header("location: $vnc_dummy_img");
		} else if (strcasecmp($type, "web") == 0) {
			header("location: $web_dummy_img");
		} else {
			header('HTTP/1.0 404 Not Found');
			echo __("picture not found") . "\n";
		}
		exit;
	}

	////////////////////////////////////////////////////////////////////////////////

	set_time_limit(0);
	header("Cache-Control: no-cache, must-revalidate");
	header("Expires: Sat, 26 Jul 1997 05:00:00 GMT");
	header('Content-type: image/jpg; name="' . $picture_file_name . '"');
	header('Content-Transfer-Encoding: binary');
	header('Accept-Ranges: bytes');

	////////////////////////////////////////////////////////////////////////////////
	$range = 0;
	if (isset($_SERVER['HTTP_RANGE']) && ($range = $_SERVER['HTTP_RANGE'])) {
		$range = str_replace('bytes=', '', $range);
		$range = intval(str_replace('-', '', $range), 10);
		$size = filesize($picture_file);

		header('HTTP/1.0 206 Partial Content');
		header('Content-Length: ' . ($size - $range));
		header('Content-Range: bytes ' . $range . '-' . ($size - 1) . '/' . $size);
	} else {
		header('HTTP/1.0 200 OK');
		header('Content-Length: ' . filesize($picture_file));
	}

	////////////////////////////////////////////////////////////////////////////////

	$file = fopen($picture_file, 'rb');
	if ($file !== false) {
		fseek($file, (int) $range);

		while (!feof($file) and !connection_status()) {
			echo fread($file, (1024 * 8));
			flush();
			ob_flush();
		}
	}
}
?>
