<?
require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
SessionManager::isUserLoggedIn() or SessionManager::redirect();
?>

<!DOCTYPE html>
<html>
<head>
<title></title>
<meta charset="utf-8"/>
<link rel="stylesheet" type="text/css" href="css/ve_dialog.css" />
<script src="http://dev.virtualearth.net/mapcontrol/mapcontrol.ashx?v=6.2"></script>
<script>
	var map = null;
	var boolFullRequest = false;
	var timeLastUpdated = null;
	// T&T Project
	var kmlShapeLayer;

	function GetMap()
	{
		map = new VEMap('mapSKM');
		//map.SetDashboardSize("tiny");
		map.LoadMap();
		map.SetMapStyle(VEMapStyle.Hybrid);
		map.SetMapMode(VEMapMode.Mode3D);
		map.ClearInfoBoxStyles();
		timeLastUpdated = (new Date()).getTime();
		displayDevConf();
	}

	function displayDevConf()
	{
		var objDev = [];
		var cameras = parent.resourceTree.getObjects({'type': 'camera'});
		for(var i=0; i<cameras.length; i++)
		{
            var objG = parent.resourceTree.getObject(cameras[i]);
			if(objG.attr("CAM_GEO_CALIBRATION") != "no")
			{
				var o = {
					'obj_id': objG.obj,
					'name': objG.name,
					'ptz': objG.attr('POSITIONCTL'),
					'lat': objG.attr('CAM_GEO_LAT'),
					'lon': objG.attr('CAM_GEO_LONG'),
					'alt': objG.attr('CAM_GEO_ALT')
				};

				if( parent.IsNumeric(o.lat) && parent.IsNumeric(o.lon) )
				{
					if( !parent.IsNumeric(o.alt) ) o.alt = 0;
					objDev.push(o);
				}
			}
		}
		setDevConf(objDev);
	}

	function setDevConf(oDev)
	{
		if(oDev.length != 0)
		{
			map.SetCenterAndZoom(new VELatLong(oDev[0].lat, oDev[0].lon, oDev[0].alt), 10);
			//devShapeIdToCache();
			for(var i=0; i<oDev.length; i++)
			{
				var shape = new VEShape(VEShapeType.Pushpin, new VELatLong(oDev[i].lat, oDev[i].lon, oDev[i].alt));
				shape.SetTitle(oDev[i].name);
				var strD = devDescrSet(oDev[i].obj_id, oDev[i].ptz, null);

				shape.SetDescription(strD);

				var customIcon = new VECustomIconSpecification();
				customIcon.Image = "http://"+parent.jsServerName+":"+parent.jsServerPort+"/TibcoGI/JSXAPPS/mx/pixs/ve_cam_icon.gif";
				customIcon.TextContent = "["+oDev[i].obj_id+"]";
				//customIcon.TextOffset = new VEPixel(0, 0);
				customIcon.TextSize = 7;
				customIcon.TextFont = "Tahoma, Arial";
				customIcon.ForeColor = new VEColor(255, 0, 0, 1);
				shape.SetCustomIcon(customIcon);
				map.AddShape(shape);

				devShapeIdToCache(oDev[i].obj_id, shape.GetID());
			}
		}
		else
		{
			alert("There isn't GEO cofigured devices present.\nPlease contact your system administrator.");
		}

		parent.veDiv = 1;
		Add3DCollection(parent.mx.VE.get3dCollectionId());
		timeLastUpdated = (new Date()).getTime();
		targetingIsAlive();
	}

	function Add3DCollection(collectionID)
	{
		var l = new VEShapeLayer();
		var veLayerSpec = new VEShapeSourceSpecification(VEDataType.VECollection, collectionID, l);
		map.ImportShapeLayerData(veLayerSpec, onFeedLoad);
	}

	function onFeedLoad(feed)
	{
		//alert('RSS or Collection loaded. There are '+feed.length+' items in this list.');
	}

	function ptzLaunch(obj_id)
	{
		var o = {};
		o.ve_ptz = "yes";
		o.obj_id = obj_id;
		o.cell_id = "_ve";
		parent.mx.PTZ.load(o);
	}

	function devShapeIdToCache(obj_id, shape_id)
	{
		parent.resourceTree.getObject(obj_id).attr('VE_SHAPE_ID', shape_id);
	}

	function devGetShapeId(obj_id)
	{
		return parent.resourceTree.getObject(obj_id).attr('VE_SHAPE_ID');
	}

	function devGetPtzPresence(obj_id)
	{
		return parent.resourceTree.getObject(obj_id).attr('POSITIONCTL');
	}

	function setNewEvent(obj_id, event_id)
	{
		var shapeId = devGetShapeId(obj_id);
		var shape = map.GetShapeByID(shapeId);
		if(shape != null)
		{
			var customIcon = new VECustomIconSpecification();
			customIcon.Image = "http://"+parent.jsServerName+":"+parent.jsServerPort+"/TibcoGI/JSXAPPS/mx/pixs/ve_cam_icon_event.gif";
			customIcon.TextContent = "["+obj_id+"]";
			customIcon.TextSize = 7;
	        customIcon.TextFont = "Tahoma, Arial";
			customIcon.ForeColor = new VEColor(255, 0, 0, 1);
			shape.SetCustomIcon(customIcon);
			var ptz = devGetPtzPresence(obj_id);

			var strD = devDescrSet(obj_id, ptz, event_id);
			shape.SetDescription(strD);
		}
	}

	function acknowledgeEventSend(obj_id, event_id)
	{
		var shapeId = devGetShapeId(obj_id);

		var shape = map.GetShapeByID(shapeId);
		if(shape != null)
		{
			var customIcon = new VECustomIconSpecification();
			customIcon.Image = "http://"+parent.jsServerName+":"+parent.jsServerPort+"/TibcoGI/JSXAPPS/mx/pixs/ve_cam_icon.gif";
			customIcon.TextContent = "["+obj_id+"]";
			customIcon.TextSize = 7;
			customIcon.TextFont = "Tahoma, Arial";
			customIcon.ForeColor = new VEColor(255, 0, 0, 1);
			shape.SetCustomIcon(customIcon);
			var ptz = devGetPtzPresence(obj_id);
			var strD = devDescrSet(obj_id, ptz, null);
			shape.SetDescription(strD);

			parent.mx.ELog2.submitAction("Acknowledge", event_id);
			map.HideInfoBox();
		}
	}

	function acknowledgeEventReceived(obj_id)
	{
		var shapeId = devGetShapeId(obj_id);

		var shape = map.GetShapeByID(shapeId);
		if(shape != null)
		{
			var customIcon = new VECustomIconSpecification();
			customIcon.Image = "http://"+parent.jsServerName+":"+parent.jsServerPort+"/TibcoGI/JSXAPPS/mx/pixs/ve_cam_icon.gif";
			customIcon.TextContent = "["+obj_id+"]";
			customIcon.TextSize = 7;
			customIcon.TextFont = "Tahoma, Arial";
			customIcon.ForeColor = new VEColor(255, 0, 0, 1);
			shape.SetCustomIcon(customIcon);
			var ptz = devGetPtzPresence(obj_id);
			var strD = devDescrSet(obj_id, ptz, null);
			shape.SetDescription(strD);
			map.HideInfoBox();
		}
	}

	function devDescrSet(obj_id, ptz, event_id)
	{
		var strD = "";
		if(ptz != "none")
		{
			strD += "<a id='id_a01' href='#' onclick='ptzLaunch("+obj_id+");' ><img src='pixs/ve_ptz_launch.jpg' alt='Launch PTZ control' border='0'/></a>";
		} else {
			strD += "<a id='id_a01' href='#'><img src='pixs/ve_ptz_launch_dis.jpg' alt='PTZ isn't available' border='0'/></a>";
		}
		if(event_id)
		{
			strD += "<a id='id_a02' href='#' onclick=\"acknowledgeEventSend('"+obj_id+"','"+event_id+"');\" ><img src='pixs/ve_ackn_event.jpg' alt='Acknowledge Event id:"+event_id+"' border='0'/></a>";
		} else {
			strD += "<a id='id_a02' href='#' ><img src='pixs/ve_ackn_event_dis.jpg' alt='No new events present' border='0'/></a>";
		}
		strD += "<iframe frameborder='no' scrolling='no' width='320' height='240' src='http://"+parent.jsServerName+"/TibcoGI/JSXAPPS/mx/cell_player.php?name=camera_"+obj_id+"&camera="+obj_id+"&width=320&height=240'/>";
		return strD;
	}

	function targetingMsgHandler(msg)
	{
		timeLastUpdated = (new Date()).getTime();

		try //Internet Explorer
		{
			var trgM = new ActiveXObject("Microsoft.XMLDOM");
			trgM.async = "false";
			trgM.loadXML(msg);
		}
		catch(e)
		{

			try //Firefox, Mozilla, Opera, etc.
			{
				var parser = new DOMParser();
				trgM = parser.parseFromString(msg, "text/xml");
			}
			catch(e) {alert(e.message)}
		}

		try
		{
			var trg = trgM.documentElement;
			if(boolFullRequest)
			{
				if(trg.getAttribute("topic").toLowerCase() == "full_report")
				{
					boolFullRequest = false;
					//targetingFullRequestUpdate();
				}
			}
			else
			{
				if(trg.getAttribute("topic").toLowerCase() == "incremental_report")
				{
					if(trg.getElementsByTagName("cameras").item(0).hasChildNodes())
					{
						targetingCamerasUpdate(trg.getElementsByTagName("cameras").item(0));
					}

					if(trg.getElementsByTagName("targets").item(0).hasChildNodes())
					{
						targetingTargetsUpdate(trg.getElementsByTagName("targets").item(0));
					}
				}
			}
		}
		catch(e) {alert(e.message)}
	}

	function targetingCamerasUpdate(tCS)
	{
		var iPass = false;
		var tNL = tCS.childNodes;
		for(var i=0; i<tNL.length; i++)
		{
			if(tNL.item(i).nodeName.toLowerCase() == "camera")
			{
				var cid = tNL.item(i).getAttribute("id");
				for(var j=0; j<map.GetShapeLayerCount(); j++)
				{
					iPass = false;
					var layer = map.GetShapeLayerByIndex(j);
					if(layer.GetTitle().toLowerCase() == ("cid_"+cid))
					{
						iPass = true;
						targetingChangeCameraParams(layer, tNL.item(i));
						break;
					}
				}
				if(!iPass)
				{
					try
					{
						layer = "camera_layer";
						layer = new VEShapeLayer();
						layer.SetTitle("cid_"+cid);
						map.AddShapeLayer(layer);
						targetingChangeCameraParams(layer, tNL.item(i));
					}
					catch(e) {
					//alert(e.message);
					}
				}
			}
		}
	}

	function targetingChangeCameraParams(layer, node)
	{
		var cid = node.getAttribute("id");
		var tNL = node.childNodes;
		for(var i=0; i<tNL.length; i++)
		{
			if(tNL.item(i).nodeName == "position")
			{
				var la = tNL.item(i).getAttribute("lat");
				var lo = tNL.item(i).getAttribute("long");
				var al = tNL.item(i).getAttribute("alt");
				//var al_m = tNL.item(i).getAttribute("alt_mode");
			}
			else if(tNL.item(i).nodeName == "direction")
			{
				var azim = tNL.item(i).getAttribute("azim");
				var tilt = tNL.item(i).getAttribute("tilt");
				var hfov = tNL.item(i).getAttribute("hfov");
			}
		}

		layer.DeleteAllShapes();

		var objC = parent.resourceTree.getObject(cid);
		if(objC.attr("CAM_GEO_CALIBRATION") != "no") {
			var range = objC.attr('CAM_GEO_RANGE');

			if((range != "none") && (hfov > 0) && (azim >= 0)) {

				var np = 9;
				var points = [];
				var ll = [];
				var distance = range / 1852.0; // [m] to [nm]
				var d_radial = hfov / (np-1.0);
				//points.push(new VELatLong(la, lo, 0.3));
				points.push(new VELatLong(la, lo));
				for(i=0; i<np; i++)
				{
					var radial = ((i * d_radial) - (hfov/2.0) + azim) * Math.PI / 180.0;
					ll = rd_distance(la, lo, distance, radial);
					//points.push(new VELatLong(ll[0], ll[1], 0.3));
					points.push(new VELatLong(ll[0], ll[1]));
				}
				//points.push(new VELatLong(la, lo, 0.3));
				points.push(new VELatLong(la, lo));

				var shape = new VEShape(VEShapeType.Polygon, points);
				shape.SetLineWidth(1);
				shape.SetLineColor(new VEColor(0,0,255,0.3));
				shape.SetFillColor(new VEColor(0,0,255,0.3));
				//shape.SetAltitudeMode(VEAltitudeMode.RelativeToGround);
				shape.HideIcon();
				//shape.SetTitle("none");
				layer.AddShape(shape);
			}
		}
	}

	function targetingTargetsUpdate(tTS)
	{
		var iPass = false;
		var tNL = tTS.childNodes;
		for(var i=0; i<tNL.length; i++)
		{
			if(tNL.item(i).nodeName.toLowerCase() == "target")
			{
				var tid = tNL.item(i).getAttribute("id");
				var tstat = tNL.item(i).getAttribute("status");

				for(var j=0; j<map.GetShapeLayerCount(); j++)
				{
					iPass = false;
					var layer = map.GetShapeLayerByIndex(j);
					if(layer.GetTitle().toLowerCase() == tid)
					{
						iPass = true;
						if(tstat == "active")
						{
							targetingAddPointToTarget(layer, tNL.item(i));
						}
						else if(tstat == "inactive")
						{
							targetingTargetSetInactive(layer);
						}
						else if(tstat == "delete")
						{
							map.DeleteShapeLayer(layer);
						}
						break;
					}
				}
				if(!iPass && tstat == "active")
				{
					try
					{
						layer = "target_layer";
						layer = new VEShapeLayer();
						layer.SetTitle(tid);
						map.AddShapeLayer(layer);
						targetingAddPointToTarget(layer, tNL.item(i));
					}
					catch(e) {
					//alert(e.message);
					}
				}
			}
		}
	}

	function targetingTargetSetInactive(layer)
	{
		for(var i=1; i<layer.GetShapeCount(); i++)
		{
			layer.GetShapeByIndex(i).SetFillColor(new VEColor(192, 192, 192,0.5));
		}
	}

	function targetingAddPointToTarget(layer, element)
	{
		var la_n = element.getAttribute('lat');
		var lo_n = element.getAttribute('long');
		var al_n = element.getAttribute('alt');
		if(al_n < 1.0) al_n = parent.TARGETING_SHAPE_MIN_HEIGHT;

		if(layer.GetShapeCount() > 0)
		{
			if( layer.GetShapeCount() >= parent.TARGETING_TRAIL_MAX_POINTS )
			{
				layer.DeleteShape(layer.GetShapeByIndex(1));
			}

			layer.GetShapeByIndex(0).SetPoints(new VELatLong(la_n, lo_n, al_n));

			var s_o = layer.GetShapeByIndex(layer.GetShapeCount()-1).GetPoints()[0];
			var la_o = s_o.Latitude;
			var lo_o = s_o.Longitude;
			var al_o = s_o.Altitude;

			var points = [
				new VELatLong(la_n, lo_n, al_n),
				new VELatLong(la_o, lo_o, al_o),
				new VELatLong(la_o, lo_o, 0.0),
				new VELatLong(la_n, lo_n, 0.0),
				new VELatLong(la_n, lo_n, al_n)
				];
		}
		else
		{
			var av_shape = new VEShape(VEShapeType.Pushpin, new VELatLong(la_n, lo_n, al_n));
			var customIcon = new VECustomIconSpecification();
			customIcon.Image = "/TibcoGI/JSXAPPS/mx/pixs/ve_trg_24.gif";
			customIcon.TextContent = "[" + element.getAttribute('id') + "]";
			customIcon.ImageOffset = new VEPixel(63, 0);
			customIcon.TextOffset = new VEPixel(0, 0);
			customIcon.TextSize = 6;
			customIcon.TextFont = "Tahoma, Arial";
			customIcon.ForeColor = new VEColor(255, 255, 255, 1);
			av_shape.SetCustomIcon(customIcon);
			var strD = "<img src='http://"+parent.jsServerName+"/TibcoGI/JSXAPPS/mx/pixs/ve_trg_32.gif'/><br/>" +
						"<b>Target_id = " + element.getAttribute('id') + "<br/>" +
						"Initial Data:</b><br/>" +
						"Latitude = " + element.getAttribute('lat') + "<br/>" +
						"Longitute = " + element.getAttribute('long') + "<br/>" +
						"Altitude = " + element.getAttribute('alt');

			av_shape.SetDescription(strD);
            layer.AddShape(av_shape);

			points = [
				new VELatLong(la_n, lo_n, al_n),
				new VELatLong(la_n, lo_n, 0.0),
				new VELatLong(la_n, lo_n, al_n)
				];
		}

		var shape = new VEShape(VEShapeType.Polygon, points);
		shape.SetLineWidth(2);
		shape.SetLineColor(new VEColor(0,0,255,1.0));
		shape.SetFillColor(new VEColor(0,255,0,0.3));
		shape.HideIcon();
		shape.SetTitle(element.getAttribute('time'));
		layer.AddShape(shape);
	}

	function targetingFullRequestUpdate()
	{
		timeLastUpdated = (new Date()).getTime();

		var trg = null;
		try  {
			var requester = new XMLHttpRequest();
		}
		catch (error) {
			try {
				requester = new ActiveXObject("Microsoft.XMLHTTP");
			}
			catch (error) {
				alert('00');
				return false;
			}
		}

		var url = '/TibcoGI/JSXAPPS/mx/ve_full_request.php';

		requester.open("GET", url, false);
		requester.send(null);
		if (requester.readyState == 4) {
			if (requester.status == 200) {
				trg = requester.responseXML;
			} else {
				return false;
			}
		} else {
			return false;
		}

		map.DeleteAllShapeLayers();
		Add3DCollection(parent.mx.VE.get3dCollectionId());

		//-->
		// T&T Project
		/*
		kmlShapeLayer = new VEShapeLayer();
		var shapeSpec = new VEShapeSourceSpecification(VEDataType.ImportXML,"http://demo.videonext.com/tmp/Collection.kml", kmlShapeLayer);
		map.ImportShapeLayerData(shapeSpec);
		GetTiles();
		*/
		//--<
		parent.mx.VE.setDevConf();

		if(trg.getElementsByTagName("cameras").item(0).hasChildNodes())
		{
			targetingCamerasUpdate(trg.getElementsByTagName("cameras").item(0));
		}

		if(trg != null)
		{
			if(trg.getElementsByTagName("targets").item(0).hasChildNodes())
			{
				var tNL = trg.getElementsByTagName("targets").item(0).childNodes;
				for(var i=0; i<tNL.length; i++)
				{
					var tid = tNL.item(i).getAttribute("id");
					var layer = new VEShapeLayer();
					layer.SetTitle(tid);
					map.AddShapeLayer(layer);
					targetingAddPointToTarget(layer, tNL.item(i));

					var t_pts = tNL.item(i).childNodes;
					for(var j=0; j<t_pts.length; j++)
					{
						targetingAddPointToTarget(layer, t_pts.item(j));
					}
				}
			}
		}
	}

	function targetingIsAlive() {
		if( ((new Date()).getTime() - timeLastUpdated) > (3 *parent.TARGETING_UPDATE_TIME_MAX) )
		{
			var conf = confirm("Error: GWM respond timeout.\n Do you want to reconnect?");
			if(conf)
			{
				// reinitialise MessengerTargeting (after connection last)
				timeLastUpdated = (new Date()).getTime();
			}
			else
			{
				alert("GWM not responding. Please contact yor system administrator.");
				return false;
			}

		}
		window.setTimeout(function(){ targetingIsAlive(); }, 20000);
	}

	function rd_distance(lat_c, lon_c, distance, radial) {
		var lat1 = lat_c * Math.PI / 180;
		var lon1 = lon_c * Math.PI / 180;
		var d = distance * Math.PI / (180 * 60);
		var lat2 = Math.asin( Math.sin(lat1)*Math.cos(d) + Math.cos(lat1)*Math.sin(d)*Math.cos(radial) );
		var lon2 = lon1 + Math.atan2(Math.sin(radial)*Math.sin(d)*Math.cos(lat1), Math.cos(d)-Math.sin(lat1)*Math.sin(lat2));
		var result = [];
		result[0] = lat2 * 180 / Math.PI;
		result[1] = lon2 * 180 / Math.PI;
		return result;
	}


	//-->
	// Trinidad & Tobago Project
	//--
	function GetTiles()
	{
		var bounds = [new VELatLongRectangle(new VELatLong(11.6756,-62.514375),new VELatLong(9.67341944444,-60.51134166666))];

		addCustomTileLayer(bounds, "globalLayer", "http://demo.videonext.com/tmp/gl/%4.png", 10, 20, 100);
		addCustomTileLayer(bounds, "presidentsHouseLayer", "http://demo.videonext.com/tmp/ph/%4.png", 14, 20, 110);
		addCustomTileLayer(bounds, "circleLayer", "http://demo.videonext.com/tmp/cr/%4.png", 14, 20, 102);
		addCustomTileLayer(bounds, "stadiumLayer", "http://demo.videonext.com/tmp/st/%4.png", 14, 20, 101);
		addCustomTileLayer(bounds, "hotelLayer", "http://demo.videonext.com/tmp/ho/%4.png", 14, 20, 103);
	}

	function addCustomTileLayer(bounds, layerId, layerSrc, minZoomLevel, maxZoomLevel, zIndex)
	{
		var tileSourceSpec = new VETileSourceSpecification(layerId, layerSrc);
		//tileSourceSpec.NumServers = 1;
		tileSourceSpec.Bounds = bounds;
		tileSourceSpec.MinZoomLevel = minZoomLevel;
		tileSourceSpec.MaxZoomLevel = maxZoomLevel;
		//tileSourceSpec.Opacity = opacity;
		tileSourceSpec.ZIndex = zIndex;
		map.AddTileLayer(tileSourceSpec, true);
	}

	function manageLayerStatus(layerId)
	{
		var button = document.getElementById(layerId+"Button");

		if(button.value.search(" show") > -1)
		{
			map.ShowTileLayer(layerId);
			button.value = button.name + " hide";
		}
		else
		{
			map.HideTileLayer(layerId);
			button.value = button.name + " show";
		}
	}

	function manageKmlLayerStatus()
	{
		if(kmlShapeLayer.IsVisible())
		{
			kmlShapeLayer.Hide();
		}
		else
		{
			kmlShapeLayer.Show();
		}
	}

	//--<

	</script>
	</head>
	<body onload="GetMap();" BGCOLOR="gray" SCROLL="no" style="position:absolute;width:100%;height:100%;left:0;top:0;padding:0;margin:0;border:0;overflow:hidden;">
	<div id='mapSKM' style="position:relative; width:100%; height:100%;"></div>

	<!-- TT Project
	<div id='mapSKM' style="position:relative; width:100%; height:97%;"></div>
	<input name="GLOBAL" id="globalLayerButton" type="button" value="GLOBAL hide" onclick="manageLayerStatus('globalLayer');"/>
	<input name="HOUSE" id="presidentsHouseLayerButton" type="button" value="HOUSE hide" onclick="manageLayerStatus('presidentsHouseLayer');"/>
	<input name="CIRCLE" id="circleLayerButton" type="button" value="CIRCLE hide" onclick="manageLayerStatus('circleLayer');"/>
	<input name="STADIUM" id="stadiumLayerButton" type="button" value="STADIUM hide" onclick="manageLayerStatus('stadiumLayer');"/>
	<input name="HOTEL" id="hotelLayerButton" type="button" value="HOTEL hide" onclick="manageLayerStatus('hotelLayer');"/>
	<input name="VECTORS" id="kmlLayerButton" type="button" value="VECTORS show/hide" onclick="manageKmlLayerStatus();"/>
	-->

	</body>
</html>
