<?php
    require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';
	SessionManager::isUserLoggedIn() or SessionManager::redirect();

    // Prevent caching of request output
    header('Cache-Control: no-cache');
    header('Pragma: no-cache');
?>
<!DOCTYPE html>
<html>
<head>
	<title>MediaExport</title>
	<meta charset="utf-8"/>
	<script>
<?php
	date_default_timezone_set('UTC');

	if (isset($_GET['vobjectid'])) {
		$dev = intval(@$_GET['vobjectid'], 10);
	} else if (isset($_GET['dev'])) {
		$dev = intval(@$_GET['dev'], 10);
	}
	if (isset($_GET['aobjectid'])) {
		$audio = intval(@$_GET['aobjectid'], 10);
	} else if (isset($_GET['audio'])) {
		$audio = intval(@$_GET['audio'], 10);
	}
	if (isset($_GET['starttime'])) {
		$start = intval(@$_GET['starttime'], 10);
	} else if (isset($_GET['start'])) {
		$start = intval(@$_GET['start'], 10);
	}
	if(isset($_GET['endtime'])){
		$end = intval(@$_GET['endtime'], 10);
	} else if (isset($_GET['end'])) {
		$end =  intval(@$_GET['end'], 10);
	}
	if (isset($start)){
		$time_start = date('Y-m-d_H-i-s', $start);
	}
	if (isset($end)){
		$time_end = date('Y-m-d_H-i-s', $end);
	}
	$onnewchunk = isset($_GET['onnewchunk']) ? preg_replace("/[^a-zA-Z0-9.]+/", "", $_GET['onnewchunk']) : 'null';
	$onready = isset($_GET['onready']) ? preg_replace("/[^a-zA-Z0-9.]+/", "", $_GET['onready']) : 'null';
?>
	var server = <? print "'".$_SERVER['SERVER_ADDR']."'"; ?>;
	var auth = <? print (isset($_GET['auth']) && !$_GET['auth']) ? "false" : "true"; ?>;
	var dev   = <? print $dev ? $dev : 'null'; ?>;
	var audio = <? print $audio ? $audio : 'null'; ?>;
	var start = <? print $start ? $start : 'null'; ?>;
	var end   = <? print $end ? $end : 'null'; ?>;
	var onNewChunk = <? print $onnewchunk;?>;
	var onReady = <? print $onready; ?>;
	var timeStart = <? print isset($time_start) ? "'".$time_start."'" : 'null'; ?>;
	var timeEnd = <? print isset($time_end) ? "'".$time_end."'" : 'null'; ?>;
	var format = '<? print Identity::getAttribute("MEDIA_EXPORT_FORMAT"); ?>';
	var classification = '<? print Identity::getAttribute("SYSTEM_CLASSIFICATION"); ?>';
	</script>
	<script src="/sdi/lib/js/jquery.js"></script>
	<script src="/sdi/lib/js/es5-shim.js"></script>
	<script src="/sdi/lib/js/utils.js"></script>
	<script src="/sdi/lib/js/api.js"></script>
	<script src="/sdi/lib/js/mediaexporter.js"></script>
	<script src="js/media_export.js"></script>
</head>
<body>
</body>
</html>
