/**
 * Views Object
 */
VIEWS = {
	list: {},
	lastTabId: null,
	openViews: false,

	/**
	 * Set tab events for drag and drop for views
	 * @param tabId - tab order id
	 */
	setDNDintoViewForTab: function(tabId){
		$("#tab_drag_" + tabId).unbind('dragstart');
		$("#tab_drag_" + tabId).unbind('drag');
		$("#tab_drag_" + tabId).unbind('dragend');

		$("#tab_drag_" + tabId).bind('dragstart', function(event) {
			dragged = true;
			VIEWS.lastTabId = tabId;
			var span = $(this);
			return span.clone()
				.css({'opacity': '.75', 'position': 'absolute', 'z-index': 6000, 'border': 'none', 'zoom':1})
				.removeClass('selected')
				.appendTo( $('body') );
		}).bind('drag', function(ev, dd) {
			$( dd.proxy ).css({
				top: ev.pageY + 10,
				left: ev.pageX + 10
			});
		}).bind('dragend', function(ev, dd) {
			var offset = $('#resource_tree_root').offset();
			var limitX = offset.left + $('#resource_tree_root').width();
			var limitY = offset.top + $('#resource_tree_root').height();
			if(ev.pageX > offset.left && ev.pageX < limitX && ev.pageY > offset.top && ev.pageY < limitY){
				// Dropping vMX tabs is prohibited
				if (mx.CT.getActiveTab().getAttribute("curType") == "vmx") {
					alert(__("Drag'n'drop for vMX tabs is prohibited. Try dnd'ing individual vMX Monitor instead"));
				}
				else {
					var tabpane = mx.MATRIX2.getServer().getJSXByName('tabbedpaneMain');
					var tabs = tabpane.getChildren();
					VIEWS.save(tabs[tabId].getAttribute("initText"), false, true);
				}
			}
			dragged = false;
			$(dd.proxy).remove();
		});
	},

	/**
	 * Show save view dialog
	 * @param viewName - name of view
	 */
	showSaveDialog: function(viewName, viewId) {
		var caption = __("SAVE VIEW");
		var view_id = '';
		var isprotected = '';
		var savecontent = 'checked="checked"';
		if(viewId){
			caption = __("EDIT VIEW");
			view_id = viewId;
			if(VIEWS.list[viewId].isprotected){
				isprotected = 'checked="checked"';
			}
			savecontent = '';
		}

		mx.Dialog.createLayoutDialog(
			'view_dialog',
			caption,
			{'top': '70px', 'width':'312px', 'height':'auto'},
			'<div style="margin-bottom: 5px;">' +
			__("Name") + ':<input type="text" id="view_name" value="' + viewName + '" style="width:120px">' +
			'&nbsp;<label><input type="checkbox" id="view_protected" ' + isprotected + '>' + __("protected")+'</label>' +
			'<input type="hidden" id="view_id" value="' + view_id + '">' +

			'<span id="btn_view_save" class="button save" title="' + __("Save view parameters") + '">' +
			'</span>' +
			'<span id="btn_view_delete" class="button delete" title="' + __("Delete view") + '">' +
			'</span>' +
			'</div>'
		);

		$('#btn_view_save').click(VIEWS.save);
		$('#btn_view_delete').click(VIEWS.checkDrop);
	},

	/**
	 * Check drop view
	 */
	checkDrop: function(){
		var viewId = $('#view_id').val();
		var prompt = Gettext.strargs(__("Do you want to delete view '%1'?"), [VIEWS.list[viewId].name]);

		if (!confirm(prompt))
			return;

		mx.MATRIX2.mask(__("DELETING VIEW..."));
		VIEWS.drop(viewId);
		mx.MATRIX2.mask(false);
	},

	/**
	 * Drop view
	 */
	drop: function(viewId){
		$.ajax({
			type: 'POST',
			async: false,
			data: {'function': 'deleteObject', 'objList': JSON.stringify([viewId])}
		});

		$('#view_dialog').remove();
		VIEWS.openViews = true;
		resourceTree.refresh();
	},

	/**
	 * Save or update view
	 */
	save: function(v_name, v_protected, v_savecontent, v_monid) {
		var viewName = VIEWS.isString(v_name) ? v_name : $('#view_name').val();

		// empty name not allowed 
		if(viewName == ""){
			alert(__("Please input view name"));
			return;
		}
		
		var viewId = $('#view_id').val();
		
		// name duplicates not allowed
		for(var view in VIEWS.list){
			if(VIEWS.list[view].name == viewName){
				if(VIEWS.list[view].owner != resourceTree.getUser().obj && VIEWS.list[view].isprotected){
					alert(__("View") + " '" + viewName + "' " + __("is protected from modifications by owner!"));
					return;
				}
				else{
					var overwright = confirm(__("Do you want to overwrite") + " '" + viewName + "' " + __("view?"));
					if(overwright){
						viewId = VIEWS.list[view].obj;
					}
					else{					
						return;
					}
				}								
			}
		}		

		var savecontent = v_savecontent ? v_savecontent : 0;

		var isProtected = v_protected ? v_protected : $('#view_protected:checked').length;

		var data = {
			version: mx.MATRIX2.getSystemInfo().version,
			content: []
		};
		// Serialize tab
		var viewTab;
		if(savecontent > 0 || VIEWS.lastTabId == null){
			viewTab = mx.CT.getActiveTab();
		}
		else if(VIEWS.lastTabId != null){
			var tabpane = mx.MATRIX2.getServer().getJSXByName('tabbedpaneMain');
			var tabs = tabpane.getChildren();
			viewTab = tabs[VIEWS.lastTabId];
		}

		if(viewTab.getAttribute("curType") == "vmx") {
			var monid = v_monid ? v_monid : 0;
        	var objMonitor = mx.vMX.getMonitorById(monid);
        	if (objMonitor == null) {
        	    if (savecontent > 0) {
            		alert(__("Unknown vMX monitor"));
            		return;
            	}
            	else {
            	    data.content = {
						'name': 'unknown',
						'contents': ''
					};
            	}
        	}
        	else {
        		data.content = {
					'name': objMonitor.name,
					'contents': objMonitor.serializeToJson()
				};
			}
		}
		else {
			data.content = {
				// don't save name if it is a number
				'name': viewTab.getAttribute("initText"),
				'contents': LSC._serialize(viewTab.getFirstChild())
			};
		}

		var viewData = {
			'NAME': viewName,
			'PROTECTED': parseInt(isProtected)
		};
		
		if(viewId == "" || viewId == undefined){
			viewData.OWNER = resourceTree.getUser().obj;
			viewData.ROLEID = resourceTree.role.obj;
		}
		
		if(savecontent > 0){
			viewData.DATA = data;
		}

		if (viewId == "" || viewId == undefined) {
			$.ajax({
				type: "POST",
				async: false,
				data: {'function': 'addObject',	'type': 'view', 'attributes': JSON.stringify(viewData)},
				success: function(data) {viewId = data.obj;},
				failure: function(data) {}
			});
		} else {
			$.ajax({
				type: "POST",
				async: false,
				data: {'function': 'setAttributes', 'obj': viewId, 'attributes': JSON.stringify(viewData)}
			});
		}

		$('#view_dialog').remove();

		VIEWS.lastTabId = null;
		VIEWS.openViews = true;

		resourceTree.refresh();

		return viewId;
	},

	/**
	 * Load view
	 */
	load: function(viewId, tab){
		mx.MATRIX2.mask(__("LOADING VIEW..."));
		var data;
		$.ajax({
			data: {'function': 'getAttribute', 'obj': viewId, 'attribute': 'DATA'},
			async: false,
			success: function(json) {data = $.parseJSON(json.value);}
		});

		var curTab = mx.CT.getActiveTab();

		if(tab != undefined){
			curTab = tab;
		}

		mx.CT.clearTab(curTab);
		LSC._unserialize(curTab.getFirstChild(), data.content.contents, true);

		if(LSC.geHack){
			mx.GE.addGE(LSC.geHack.block);
			if(LSC.geHack.fix_obj_id) {
				mx.GE.lockDeviceOnMap(LSC.geHack.fix_obj_id);
			}
			LSC.geHack = null;
		}
		
		mx.CT.setTabName(curTab.getId(), VIEWS.list[viewId].name, true);

		mx.MATRIX2.mask(false);
	},

	/**
	 * Load views ans save it into cache
	 */
	getViews: function() {

		VIEWS.list = {};

		$.ajax({
			data: {'function': 'getObjectList', 'type': 'view'},
			async: false,
			success: function(data) {
				$.each(data['list'], function() {
					this.type = "view";
					this.name = $('<div/>').text(this.attributes.NAME).html();
					this.owner = parseInt(this.attributes.OWNER);
					this.isprotected = parseInt(this.attributes.PROTECTED);
					this.role_id = parseInt(this.attributes.ROLEID);

					VIEWS.list[this.obj] = this;
				});
			}
		});
	},

	/**
	 * Get HTML representation of Views set, with current sorting and view type
	 */
	getViewsHtml: function() {
		var html = '';
		var htmlList = '';

		$.each(VIEWS.list, function() {
			var objId = this.obj;
			var udid = this.udid || objId;
			var edit = '<img src="/TibcoGI/JSXAPPS/mx/images/design1/resources/settings.png" width="16px" height="16px" title="' + __("Edit view") + '" onclick="VIEWS.showSaveDialog(\''+ this.name + '\',' + objId + ')"/>';
			if(this.isprotected == 1 && this.owner != resourceTree.getUser().obj && resourceTree.role.obj != 31){
				edit = ""
			}

			htmlList +=
				'<li class="tile">' +
					'<span class="view drag inline" obj="' + objId + '">[' + udid + '] ' + this.name + '</span>' + edit +
				'</li>';
		});

		if (htmlList) {
			var display = "none";
			var  show = "collapsed";
			if(VIEWS.openViews){
				display = "block";
				show = "expanded";
				VIEWS.openViews = false;
			}
			html =
				'<li class="'+show+'">' +
					'<div class="hitarea" />' +
					'<span class="inline set drag views" obj="">' + __("Views") + '</span>' +
					'<ul style="display: ' + display + '">' + htmlList + '</ul>' +
				'</li>';
		}
		else if(VIEWS.openViews){
			VIEWS.openViews = false;
		}
		
		return html;
	},
	
	/**
	 * Check is variable a string
	 */
	isString: function(variable){
		if(typeof variable == 'string' || variable instanceof String){
			return true;
		}
		else{
			return false;
		}
	}
};
