//---------------------------------------------------------------------------------------------------------------
// Virtual Earth Class
//---------------------------------------------------------------------------------------------------------------
jsx3.lang.Package.definePackage(
    "mx.VE",                //the full package name
    function(VE) {          //short package name, good to use in this file only.

    VE.addVE = function(objDest)
	{
		if( objDest.setAttribute("playerBlock") == "1" )
		{
			mx.MATRIX2.btnCellClose(objDest.getDescendantOfName('cell_close'));
		} else {
			objDest.removeChildren();
      	}
        var tmpObj = objDest.load("components/ge_cell.xml", false);
        tmpObj.setName("ge_cell");
        objDest.removeAttribute("playerBlock");
        objDest.repaint();
        mx.MATRIX2.getServer().getJSXByName('ge_iframe').setScrolling(jsx3.gui.IFrame.SCROLLNO);
        mx.MATRIX2.getServer().getJSXByName('ge_iframe').setSrc( "ve.php" );
    };

	VE.setNewEvent = function(obj_id, event_id)
	{
		mx.MATRIX2.getIFrame(mx.MATRIX2.getServer().getJSXByName('ge_iframe')).setNewEvent(obj_id, event_id);
	};

	VE.acknowledgeEvent = function(obj_id, event_id)
	{
		mx.MATRIX2.getIFrame(mx.MATRIX2.getServer().getJSXByName('ge_iframe')).acknowledgeEventReceived(obj_id, event_id)
	};

	VE.get3dCollectionId = function()
	{
		var strAPI = "get_cid.php";
		var cid = new jsx3.xml.Document().load(strAPI , 1000);
		if(cid.selectSingleNode("//STATUS").getAttribute("VALUE") == "OK")
		{
			return cid.selectSingleNode("//COLLECTION_ID").getAttribute("VALUE");
		} else {
			return false;
		}
	};

	VE.targetingHandler = function(msg)
	{
		if(veDiv != null)
		{
			var msgSAF = "";
			msgSAF = msg.toString().toLowerCase();

			mx.MATRIX2.getIFrame(mx.MATRIX2.getServer().getJSXByName('ge_iframe')).targetingMsgHandler(msgSAF);
		}
	};
});
