//------------------------------------------------------------------------------------------
// Wall Cell Class. It represents position of a virtual cell in a matrix of wall monitors
//------------------------------------------------------------------------------------------
jsx3.lang.Class.defineClass(
  "mx.vMX.WallCell",
  jsx3.lang.Object,
  [jsx3.util.EventDispatcher],
  function(WallCell, WallCell_prototype) {
    
    var vMX = mx.vMX;
    
    WallCell.BEFORE_REMOVE_MONITOR = "vmxbeforeremovemon";
    
    WallCell_prototype.init = function(row, col) {
      this.row = row;
      this.col = col;
      this.block = null;
      this.group = 0;
      this.need_repaint = 1;
      this.monitor = null;
      this.wall = null;
    };
    
    WallCell_prototype.setContainer = function(objWall) {
      this.wall = objWall;
    };
    
    WallCell_prototype.removeMonitor = function() {
      this.publish({'subject' : vMX.WallCell.BEFORE_REMOVE_MONITOR});
      this.monitor = null;
    };
    
    WallCell_prototype.toString = function() {
        return "[WallCell " + "wallid: " + this.wall.objid + ", " + this.row + "." + this.col +
               ", Monitor: " + this.monitor +"], " + "need_repaint: " + (this.need_repaint?"yes":"no");
    };
  }
);