/******************************************************************************************
*                                                                                         *
*                                 Vector painting for vMX                                 *
*                                                                                         *
******************************************************************************************/

jsx3.lang.Class.defineClass(
  "mx.vMX.SpecialPainting",
  jsx3.lang.Object,
  [],
  function(SpecialPainting, SpecialPainting_prototype) {
    
    var vMX = mx.vMX;
    
    SpecialPainting_prototype.init = function(block) {
       this.curBlock = block;
       this.area_pos = null;
       this.darkblock = null;
     };
     
     
     SpecialPainting_prototype.setBaseRect = function(objRect) { this.area_pos = objRect; };
     
     
     SpecialPainting.prototype.lightOn = function() {
        if(this.darkblock == null) {
           var darkblock = new jsx3.gui.Block('darkblock', 0, 0, '100%', '100%');
           darkblock.setBackground('background-color:black;');

           vMX.setOpacity(darkblock, 0.6);
           darkblock.setRelativePosition(jsx3.gui.Block.ABSOLUTE);
           darkblock.setCanDrop(jsx3.Boolean.TRUE);
           darkblock.setEvent("mx.vMX.getServer().getJSXByName('controlPane').hideMask();mx.vMX.showHideMask(false);",
                              jsx3.gui.Interactive.DROP);
           this.curBlock.setChild(darkblock);
           this.darkblock = darkblock;
           
           var svgblock = new jsx3.vector.Block('svgblock', 0, 0, '100%', '100%');
           svgblock.setRelativePosition(jsx3.gui.Block.ABSOLUTE);
           this.darkblock.setChild(svgblock);
           this.svgblock = svgblock;
        }
        
        this.lighton = true;
        this.darkblock.setVisibility(jsx3.gui.Block.VISIBILITYVISIBLE, true);
        this.curBlock.repaint();
     };
     
     SpecialPainting.prototype.lightOff = function() {
        this.lighton = false;
        this.darkblock.getParent().removeChild(this.darkblock);
        this.darkblock = null;
     };
     
     
     SpecialPainting.prototype.paintTraceLines = function(block, color) {            
        
        color = color || '#E8E8E9';
        
        // topleft
        var x11 = this.area_pos.L, y11 = this.area_pos.T,
            x12 = block.getLeft(), y12 = block.getTop();
        // topright
        var x21 = this.area_pos.L + this.area_pos.W, y21 = this.area_pos.T,
            x22 = block.getLeft()+block.getWidth(), y22 = block.getTop();
        // bottomleft
        var x31 = this.area_pos.L, y31 = this.area_pos.T + this.area_pos.H,
            x32 = block.getLeft(), y32 = block.getTop() + block.getHeight();
        // bottomright
        var x41 = this.area_pos.L + this.area_pos.W, y41 = this.area_pos.T + this.area_pos.H,
            x42 = block.getLeft()+block.getWidth(), y42 = block.getTop()+block.getHeight();
        
      
        var objCanvas = this.svgblock.getCanvas();
        var arrShapes = objCanvas.getChildren();
        var bInit = arrShapes.length == 0;
        
        if(bInit) {
          var polyLeft = new jsx3.vector.Polygon(0, 0);
          var polyBottom = new jsx3.vector.Polygon(0, 0);
          var polyRight = new jsx3.vector.Polygon(0, 0);
          var polyTop = new jsx3.vector.Polygon(0, 0);
          
          var fill = new jsx3.vector.Fill("#34383A");
          fill.setType('gradientradial');
          fill.setAlpha(0.6);
          fill.setAlpha2(0.9);
          fill.setColors("20% #C9CACB 40% #BFC0C1 60% #A5A7A8 80% #848788");
          
          polyLeft.setFill(fill);
          polyBottom.setFill(fill);
          polyRight.setFill(fill);
          polyTop.setFill(fill);
          
          var strokeLine = new jsx3.vector.Stroke(color, 2, 1.0);
          
          var lineLT = new jsx3.vector.Line(0, 0);
          var lineRT = new jsx3.vector.Line(0, 0);
          var lineLB = new jsx3.vector.Line(0, 0);
          var lineRB = new jsx3.vector.Line(0, 0);
          
          lineLT.setStroke(strokeLine);
          lineRT.setStroke(strokeLine);
          lineLB.setStroke(strokeLine);
          lineRB.setStroke(strokeLine);
          
          objCanvas.appendChild(polyLeft);
          objCanvas.appendChild(polyBottom);
          objCanvas.appendChild(polyRight);
          objCanvas.appendChild(polyTop);
          objCanvas.appendChild(lineLT);
          objCanvas.appendChild(lineRT);
          objCanvas.appendChild(lineLB);
          objCanvas.appendChild(lineRB);
        }
        else {
          var polyLeft = arrShapes[0], polyBottom = arrShapes[1], polyRight = arrShapes[2], polyTop = arrShapes[3],
              lineLT = arrShapes[4], lineRT = arrShapes[5], lineLB = arrShapes[6], lineRB = arrShapes[7];
        }
        
        
        polyLeft.setPointsAsNumberArray([x11, y11, x12, y12, x32, y32, x31, y31]);
        polyBottom.setPointsAsNumberArray([x41, y41, x42, y42, x32, y32, x31, y31]);
        polyRight.setPointsAsNumberArray([x21, y21, x22, y22, x42, y42, x41, y41]);
        polyTop.setPointsAsNumberArray([x11, y11, x12, y12, x22, y22, x21, y21]);
        
        lineLT.setPoints(x11, y11, x12, y12);
        lineRT.setPoints(x21, y21, x22, y22);
        lineLB.setPoints(x31, y31, x32, y32);
        lineRB.setPoints(x41, y41, x42, y42);            
        
        this.svgblock.repaint();
     
     };
     
  }
);