/**
 * Various utilities and auxiliary functions
 */

/* Escape text before insertion to html */
$.escape = function(text) {return $('<span/>').text(text).html();};

function contains(target, test){ // target contains test [x,y]
	target = $(target);
	var o = target.offset();
	return o.left <= test[0] && (o.left + target.width()) >= test[0] && o.top <= test[1] && (o.top + target.height()) >= test[1];
}

/* arrayUnique function - remove duplicate values from array */
function arrayUnique( array ) {var p, i, j;for(i = array.length; i;){for(p = --i; p > 0;){if(array[i] === array[--p]){for(j = p; --p && array[i] === array[p];);i -= array.splice(p + 1, j - p).length;}}}return true;}

/* Natural sorting algorithm */
function naturalSort(a,b){function chunkify(t){var tz=[],x=0,y=-1,n=0,i,j;while (i=(j=t.charAt(x++)).charCodeAt(0)){var m=(i==46||(i>=48&&i<=57));if(m!==n){tz[++y]="";n=m;}tz[y]+=j;}return tz;}var aa = chunkify(a);var bb = chunkify(b);for(x=0;aa[x]&&bb[x];x++){if(aa[x]!==bb[x]){var c=Number(aa[x]),d=Number(bb[x]);if(c==aa[x]&&d==bb[x]){return c-d;}else return(aa[x]>bb[x])?1:-1;}}return aa.length - bb.length;}

/**
 * Process API list format [{obj: <objid>, ...}, {obj: <objid>, ...}, ...]
 * to convenient format {<objid>: {}, <objid>: {}, ...}
 * @param list
 */
function processAPIList(list) {
	var result = {};
	$.each(list, function() {
		result[this.obj] = this;
	});
	return result;
}

/**
 * Hack to provide drag'n'drop from resource tree to vMX
 * @param id      id of block
 * @param handler handler function,
 */
dndHandlers = {};
function registerDropHandler(id, obj, handler) {
	dndHandlers[id] = {'handler': handler, 'obj': obj};
}
