jsx3.lang.Package.definePackage("mx.TOUR", function(TOUR) {
// CIRRUS_REPLACE_TOURING_JS_ID001_BEGIN
	//TOUR.tourMaxCells = 3;
// CIRRUS_REPLACE_TOURING_JS_ID001_END

	TOUR.extraDelay = 1000; //delay if player in frame not ready in mls

	TOUR.lastSelectedId = null; //last selected tour jsxid

	TOUR.addTourCell = function(objDest) {
		if(!mx.MATRIX2.checkCellsLimit(mx.MATRIX2.tourCellWeight, true)){
			return null;
		}

		mx.MATRIX2.clearDestinationBlock(objDest);
		objDest.removeAttribute("objectId");
		objDest.setAttribute("playerBlock", "1");
		objDest.setAttribute("tourBlock", "1");

		var tmpObj = mx.language.load_translate(objDest, "components/tour_cell.xml");
		tmpObj.getDescendantOfName('cell_btn_tour').setAttribute("tourListOpen", "true").setTip(__("Hide device list"));
		tmpObj.getDescendantOfName('tour_iframe1').setAttribute("if_tour", "true").setCSSOverride("position:absolute").setDisplay(jsx3.gui.Block.DISPLAYBLOCK, false).setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, false);
		tmpObj.getDescendantOfName('tour_iframe2').setAttribute("if_tour", "true").setCSSOverride("position:absolute").setDisplay(jsx3.gui.Block.DISPLAYBLOCK, false).setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, false);
		tmpObj.getDescendantOfName("block_ptzpreset").setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
		tmpObj.setAttribute('activeTourFrame', '0');
		tmpObj.setAttribute("extra_delay", "0");
		objDest.repaint();

        auditObj.callAddAuditRecord(13, null, {
            digestparams:[__("Add tour")],
            params:{}
        });

		return tmpObj.getId();
	};


	/**
	 * Drop items into touring
	 * @param objThis   cell block
	 * @param objSource resourceTree object | array of objIds
	 * @param preset
	 */
	TOUR.listTourOnDrop = function(objThis, objSource, preset) {

		var objT = objThis.getAncestorOfName("cell_blk");
		var initListSize = objThis.getXML().selectNodes("//record").size();

		if (!$.isArray(objSource) && $.inArray(objSource.type, ['role', 'set', 'camera']) == -1) {
			alert(__("Only Camera, Role or Set could be added to touring component. Please select appropriate type."));
			return;
		}

		// array of appending cameras and ids of existing cameras
		var Ids = [];
		// Get only ids of cameras
		if ($.isArray(objSource)) {
			Ids = resourceTree.getObjects({'type': 'camera', 'obj': objSource});
		} else if (objSource.type == 'set' || objSource.type == 'role') {
			Ids = resourceTree.getObjects({'type': 'camera', 'obj': objSource.objects});
		} else {
			Ids = [objSource.obj];
		}

		if (!Ids.length)
			return;

		// If camera have live creds, add it to touring
		for (var i = 0; i < Ids.length; i++) {

			var obj = resourceTree.getObject(Ids[i]);

			if (obj.cred('L')) {

				var rec = {
					'jsxid': jsx3.CDF.getKey(),
					'jsxtext': obj.name,
					'name': obj.name,
					'ptz': obj.attr("POSITIONCTL"),
					'preset': '',
					'obj_id': obj.obj
				};
				if (preset) {
					rec.jsxtext = Gettext.strargs(__('%1/preset %2'), [rec.name, preset]);
					rec.preset = preset;
				}

				objThis.insertRecord(rec, null, false);

                auditObj.callAddAuditRecord(13, obj.obj, {
                    digestparams:[__("Add camera into tour")],
                    params:{
                        DEVID: obj.obj
                    }
                });
			}
		}

		objThis.repaint();

		var objList = objThis.getXML().selectNodes("//record");
		var preloadFrame = objT.getDescendantOfName("tour_iframe2");
		var preloadRecord = objList.get(1);

		if(initListSize == 0){
			if(window['tour_var_'+objT.getId()]) clearTimeout(window['tour_var_'+objT.getId()]);

			var objRecord = objList.get(0);
			objRecord.setAttribute("visible", "true");
			objThis.selectRecord(objRecord.getAttribute("jsxid"));
			for(i = 1; i<objList.size(); i++) {
				objList.get(i).setAttribute("visible", "false");
			}
			objT.getDescendantOfName("cell_dev_name").setText(objRecord.getAttribute("jsxtext"), true);

			if(objT.getAttribute('activeTourFrame') == '0'){
				var showFrame = objT.getDescendantOfName("tour_iframe1");
				TOUR.setFrameContent(objT, showFrame, objRecord.getAttribute("obj_id"));

				showFrame.setVisibility(jsx3.gui.Block.VISIBILITYVISIBLE, true);
				objT.setAttribute('activeTourFrame', '1');

				if(objList.size()>1){
					preloadRecord.setAttribute("visible", "true");
					objRecord.setAttribute("visible", "false");
					TOUR.setFrameContent(objT, preloadFrame, preloadRecord.getAttribute("obj_id"));

					preloadFrame.setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, false);
				}
			}
		}
		else if(initListSize == 1){
			preloadRecord.setAttribute("visible", "true");
			objList.get(0).setAttribute("visible", "false");
			TOUR.setFrameContent(objT, preloadFrame, preloadRecord.getAttribute("obj_id"));
		}

		objThis.selectRecord(TOUR.lastSelectedId);

		var delayTime = Math.round(objT.getDescendantOfName('delay_txt_tour').getText() * 1000);
		if(objList.size() > 1) {window['tour_var_'+objT.getId()] = window.setTimeout(function(){ mx.TOUR.tourLogic(objT); }, delayTime);}
	};

	TOUR.tourLogic = function(objT) {
		//appLogger.info("tourLogic: "+(new Date()).getTime());

		// This situation appears when touring was not properly closed
		// (via MATRIX2.clearMatrix() or loading new configuration)
		if (!objT.getDescendantOfName('delay_txt_tour'))
			return;

		//do not act if non-active tab #2401
		if(objT.getAncestorOfType(jsx3.gui.Tab) !== mx.CT.getActiveTab()){
			if(window['tour_var_'+objT.getId()]) clearTimeout(window['tour_var_'+objT.getId()]);
			window['tour_var_'+objT.getId()] = window.setTimeout(function(){ mx.TOUR.tourLogic(objT); }, delayTime);
			return;
		}

		var delayTime = Math.round(objT.getDescendantOfName('delay_txt_tour').getText() * 1000);
		var objList = objT.getDescendantOfName('list_tour');

		var showFrame = objT.getAttribute('activeTourFrame') == '1'
			? objT.getDescendantOfName("tour_iframe2")
			: objT.getDescendantOfName("tour_iframe1");

		var tmpObj = objList.getXML().selectNodes("//record");
		var nextRecord = null;

		for(var i = 0; i < tmpObj.size(); i++) {
			if(tmpObj.get(i).getAttribute("visible") == "true") {
				//appLogger.info("tourLogic: "+showFrame+", "+mx.MATRIX2.getIFrame(showFrame)['_mplayer_tour']);
				//appLogger.info("tourLogic: "+mx.MATRIX2.getIFrame(showFrame)['_mplayer_tour'].playerImplStatus);

				if( !mx.MATRIX2.getIFrame(showFrame) || !mx.MATRIX2.getIFrame(showFrame)['_mplayer_tour']) {
					//show loading
					objT.getDescendantOfName('tour_waiting').setVisibility(jsx3.gui.Block.VISIBILITYVISIBLE, true);
					var extra_delay = parseInt(objT.getAttribute("extra_delay"), 10) + TOUR.extraDelay;
					objT.setAttribute("extra_delay", ""+extra_delay);
					if(window['tour_var_'+objT.getId()]) clearTimeout(window['tour_var_'+objT.getId()]);
					window['tour_var_'+objT.getId()] = window.setTimeout(function(){ mx.TOUR.tourLogic(objT); }, TOUR.extraDelay);
					return;
				}
				else {
					//hide loading
					objT.getDescendantOfName('tour_waiting').setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);

					if(objT.getAttribute("extra_delay") > 0){
						appLogger.info("tourLogic: device:"+tmpObj.get(i).getAttribute("jsxtext")+", extra delay time: "+objT.getAttribute("extra_delay")/1000+" sec.");
					}
				}
				objT.setAttribute("extra_delay", "0");

				TOUR.setTourFrames(objT, i);

				break;
			}
		}

		if(window['tour_var_'+objT.getId()]) clearTimeout(window['tour_var_'+objT.getId()]);
		window['tour_var_'+objT.getId()] = window.setTimeout(function(){ mx.TOUR.tourLogic(objT); }, delayTime);
	};

	TOUR.listOpenClose = function(objThis) {
		var objT = objThis.getAncestorOfName("cell_blk");
		if(objThis.getAttribute("tourListOpen") == "true") {
			objThis.setAttribute("tourListOpen", "false").setTip(__("Show device list")).repaint();
			objT.getDescendantOfName('layout_tour').setCols("*,0", true);
		} else {
			objThis.setAttribute("tourListOpen", "true").setTip(__("Hide device list")).repaint();
			objT.getDescendantOfName('layout_tour').setCols("*,250", true);
		}
		window.setTimeout(function(){ mx.MATRIX2.splitterResize(objT); }, 50);
	};

	TOUR.btnTourClose = function(objThis) {
		var objT = objThis.getAncestorOfName("cell_blk");
		objT.getParent().setAttribute("objectId", "-1");
		objT.getParent().setAttribute("playerBlock", "0");
		objT.getParent().removeAttribute("tourBlock");
		objT.getParent().removeChildren();

		mx.MATRIX2.checkCellsLimit(mx.MATRIX2.tourCellWeight, false);
		if(window['tour_var_'+objT.getId()]) clearTimeout(window['tour_var_'+objT.getId()]);
	};

	TOUR.listTourObjectDelete = function(objThis) {
		var objT = objThis.getAncestorOfName("cell_blk");
		if(window['tour_var_'+objT.getId()]) clearTimeout(window['tour_var_'+objT.getId()]);

		var objList = objT.getDescendantOfName('list_tour');
		var objListNodes = objList.getXML().selectNodes("//record");

        if(objListNodes.size() == 1) {
			objT.getDescendantOfName("cell_dev_name").setText(__("Touring control"), true);
			objT.getDescendantOfName('tour_iframe1').setSrc("about:blank").setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
			objT.getDescendantOfName('tour_iframe2').setSrc("about:blank").setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
			objT.setAttribute('activeTourFrame', '0');
			objT.setAttribute("extra_delay", "0");
			TOUR.lastSelectedId = null;
		} else if(objListNodes.size() == 2) {
			if(objList.getXML().selectSingleNode("//record[@jsxid='"+objThis.emGetSession().recordId+"']") == TOUR.lastSelectedId){
				var objRecord = objListNodes.get(0);
			}
			else{
				var objRecord = objListNodes.get(1);
			}
			var showFrame = objT.getDescendantOfName("tour_iframe1");

			TOUR.setFrameContent(objT, showFrame, objRecord.getAttribute("obj_id"));

			showFrame.setVisibility(jsx3.gui.Block.VISIBILITYVISIBLE, true);
			objT.setAttribute('activeTourFrame', '1');
			objT.getDescendantOfName("cell_dev_name").setText(objRecord.getAttribute("jsxtext"), true);

			//empty and hide preload frame
			var preloadFrame = objT.getDescendantOfName("tour_iframe2");
			preloadFrame.setSrc("about:blank").setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);

			TOUR.lastSelectedId = objRecord.getAttribute("jsxid");
			objList.selectRecord(TOUR.lastSelectedId);
		} else {
			var position = 0;
			for(var i=0; i<objListNodes.size(); i++){
				if(objListNodes.get(i).getAttribute("jsxid") == objThis.emGetSession().recordId){
					position = i;
					break;
				}
			}

			//if deleting selected device
			if(objThis.emGetSession().recordId == TOUR.lastSelectedId){
				if(objListNodes.size()-1 == position){
					TOUR.setTourFrames(objT, 0);
				}
				else{
					TOUR.setTourFrames(objT, position+1);
				}
			}
			else if(objList.getXML().selectSingleNode("//record[@jsxid='"+objThis.emGetSession().recordId+"']").getAttribute("visible") == "true"){
				if(objListNodes.size()-1 == position){
					objListNodes.get(0).setAttribute("visible", "true");
				}
				else{
					objListNodes.get(position+1).setAttribute("visible", "true");
				}
				objList.selectRecord(TOUR.lastSelectedId);
			}
			else{
				objList.selectRecord(TOUR.lastSelectedId);
			}


			var delayTime = Math.round(objT.getDescendantOfName('delay_txt_tour').getText() * 1000);
			window['tour_var_'+objT.getId()] = window.setTimeout(function(){ mx.TOUR.tourLogic(objT); }, delayTime);
		}

        var devId = objList.getXML().selectSingleNode("//record[@jsxid='"+objThis.emGetSession().recordId+"']").getAttribute("obj_id");
        auditObj.callAddAuditRecord(13, devId, {
            digestparams:[__("Remove camera from tour")],
            params:{
                DEVID: devId
            }
        });

        objThis.getParent().getParent().deleteRecord(objThis.emGetSession().recordId, true);
	};

	TOUR.setTourFrames = function(objTour, position) {
		if(objTour.getAttribute('activeTourFrame') == '1'){
			var showFrame = objTour.getDescendantOfName("tour_iframe2");
			var preloadFrame = objTour.getDescendantOfName("tour_iframe1");
		}
		else if(objTour.getAttribute('activeTourFrame') == '2'){
			var showFrame = objTour.getDescendantOfName("tour_iframe1");
			var preloadFrame = objTour.getDescendantOfName("tour_iframe2");
		}

		var nextRecord = null;
		var objList = objTour.getDescendantOfName('list_tour');
		var objListNodes = objList.getXML().selectNodes("//record");

		var isLast = false;
		if(position == objListNodes.size() - 1){
			isLast = true;
		}

		if(isLast) {
			nextRecord = objListNodes.get(0);
		} else {
			nextRecord = objListNodes.get(position + 1);
		}
		//appLogger.info("tourLogic: preload "+nextRecord.getAttribute("jsxtext")+", show "+objListNodes.get(position).getAttribute("jsxtext"));

		//preload next frame
		var objId = nextRecord.getAttribute("obj_id");

		TOUR.setFrameContent(objTour, preloadFrame, objId);

		nextRecord.setAttribute("visible", "true");

		var curRecord = objListNodes.get(position);

		//show presets
		var presets = objTour.getDescendantOfName("block_ptzpreset");
		if(curRecord.getAttribute("ptz") != "none" && curRecord.getAttribute("preset") != ""){
			TOUR.sendPTZPreset(curRecord);
		}

		//show preloaded frame
		objList.selectRecord(curRecord.getAttribute("jsxid"));
		TOUR.lastSelectedId = curRecord.getAttribute("jsxid");
		objTour.getDescendantOfName("cell_dev_name").setText(curRecord.getAttribute("jsxtext"), true);
		showFrame.setVisibility(jsx3.gui.Block.VISIBILITYVISIBLE, true);

		//hide current
		if(curRecord != nextRecord){
			curRecord.setAttribute("visible", "false");
		}
		preloadFrame.setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);

		if(objTour.getAttribute('activeTourFrame') == '1'){
			objTour.setAttribute('activeTourFrame', '2');
		}
		else if(objTour.getAttribute('activeTourFrame') == '2'){
			objTour.setAttribute('activeTourFrame', '1');
		}
	};

	/*
		show PTZ preset menu
	*/
	TOUR.editPTZPreset = function(objMatrix, strId, objEvent){
		var cell = objMatrix.getAncestorOfName("cell_blk");
		var doc = objMatrix.getXML();
		var node = doc.selectSingleNode("//record[@jsxid='" + strId + "']");

		if(node.getAttribute("ptz") == "none"){
			return false;
		}

		var inputPreset = cell.getDescendantOfName("textboxPtzPreset");
		if(node && node.getAttribute("preset") != ""){
			inputPreset.setValue(node.getAttribute("preset"), true);
		}

		//if(window.jsDebug){ appLogger.info("TOUR.editPTZPreset: Y=" + objEvent.clientY()); }

		//cell.getDescendantOfName("textboxPtzPreset").setEvent("mx.TOUR.setPTZPreset(this, '"+strId+"')", jsx3.gui.Interactive.EXECUTE);
		cell.getDescendantOfName("buttonPreset").setEvent("mx.TOUR.setPTZPreset(this, '"+strId+"')", jsx3.gui.Interactive.EXECUTE);
        cell.getDescendantOfName("buttonPresetReset").setEvent("mx.TOUR.resetPTZPreset(this, '"+strId+"')", jsx3.gui.Interactive.EXECUTE);
        cell.getDescendantOfName("buttonPresetCancel").setEvent("this.getAncestorOfName('block_ptzpreset').setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);", jsx3.gui.Interactive.EXECUTE);

		var tourListPoition = objMatrix.getAbsolutePosition();
		var eventY = objEvent.clientY();
		var tourListCenter = tourListPoition.T + tourListPoition.H/2;

		var top;
		if(eventY < tourListCenter){
			top = eventY - tourListPoition.T + 5;
		}
		else{
			top = eventY - tourListPoition.T - 65;
		}
		cell.getDescendantOfName("block_ptzpreset").setTop(top, true).setHeight(55, true).setVisibility(jsx3.gui.Block.VISIBILITYVISIBLE, true);
	};

	/*
		set ptz preset to current camera
	*/
	TOUR.setPTZPreset = function(objElement, strId){
		if(window.jsDebug){ appLogger.info("TOUR.setPTZPreset: objElement="+objElement+", strId="+strId); }
		var cell = objElement.getAncestorOfName("cell_blk");
		var preset = cell.getDescendantOfName("textboxPtzPreset").getValue();

		if(preset != parseInt(preset)){
			cell.getDescendantOfName("block_ptzpreset").setHeight(75, true);
			cell.getDescendantOfName("textMsgPreset").setText(__("Wrong preset id!"), true).setColor("#FF0000", true).setDisplay(jsx3.gui.Block.DISPLAYBLOCK, true);
			return;
		}

		var matrix = cell.getDescendantOfName("list_tour");
		var record = matrix.getXML().selectSingleNode("//record[@jsxid='" + strId + "']");
		record.setAttribute("preset", preset);

		var text = "";
		if(preset != ""){
			text = "/preset " + preset;
		}
		record.setAttribute("jsxtext", record.getAttribute("name") + text);
		matrix.repaint();

		if(matrix.getSelectedIds() == strId){
			TOUR.sendPTZPreset(record);
		}
		cell.getDescendantOfName("block_ptzpreset").setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
	};

	/*
		set ptz preset to current camera
	*/
	TOUR.resetPTZPreset = function(objElement, strId){
		if(window.jsDebug){ appLogger.info("TOUR.setPTZPreset: objElement="+objElement+", strId="+strId); }
		var cell = objElement.getAncestorOfName("cell_blk");

        cell.getDescendantOfName("textboxPtzPreset").setValue("");

		var matrix = cell.getDescendantOfName("list_tour");
		var record = matrix.getXML().selectSingleNode("//record[@jsxid='" + strId + "']");
		record.setAttribute("preset", "");
		record.setAttribute("jsxtext", record.getAttribute("name"));
		matrix.repaint();

		cell.getDescendantOfName("block_ptzpreset").setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
	};

	/*
		send ptz preset load to camera
	*/
	TOUR.sendPTZPreset = function(objRecord){
		mx.PTZ.process_response = false;
		mx.PTZ.execCommand(objRecord.getAttribute("obj_id"), 'preset', 'goto', objRecord.getAttribute("preset"), 'low');
	};

	/*
		select device
	*/
	TOUR.onDeviceSelect = function(objMatrix, strId){
		var nodes = objMatrix.getXML().selectNodes("//record");
		var position = 0;
		for(var i = 0; i < nodes.size(); i++) {
			if(nodes.get(i).getAttribute("jsxid") == strId){
				position = i;
				break;
			}
		}
		TOUR.setTourFrames(objMatrix.getAncestorOfName("cell_blk"), position);
	};

	TOUR.sliderChange = function(objThis,fpVALUE) {
		var objT = objThis.getAncestorOfName("cell_blk");
		if(window['tour_var_'+objT.getId()]) clearTimeout(window['tour_var_'+objT.getId()]);
		objT.getDescendantOfName("delay_txt_tour").setText(fpVALUE+5).repaint();
		TOUR.tourLogic(objT);
	};

	TOUR.setFrameContent = function(objTour, objFrame, objId) {
		var frame = mx.MATRIX2.getIFrame(objFrame);

		// this code cause IE to crash if we open touring and start clicking on it because of bug in player plugin
		//if(frame && frame['_mplayer_tour']){
			//appLogger.info("setFrameContent: context, "+objId+" into "+objFrame);
			//frame['_mplayer_tour'].setContext(parseInt(objId, 10), 2);
			//frame['_mplayer_tour'].play();
		//}
		//else{
			//appLogger.info("setFrameContent: URL, "+objId+" into "+objFrame);
			var strSrc = "cell_player.php?name=tour"+
							             "&camera=" + objId +
							             "&width="  + objTour.getDescendantOfName('cell_tour_player').getAbsolutePosition().W +
							             "&height=" + objTour.getDescendantOfName('cell_tour_player').getAbsolutePosition().H +
										 "&noaudit=true";
			objFrame.setSrc(strSrc);
		//}
	};
});
