//---------------------------------------------------------------------------------------------------------------
// This is the TIMELINE package
//---------------------------------------------------------------------------------------------------------------
jsx3.lang.Package.definePackage("mx.TIMELINE", function(TIMELINE) {
	TIMELINE.server = mx.MATRIX2.getServer();
	TIMELINE.currentTimeline = null;
	TIMELINE.timeLine = null;
	/**
	 * @type {TimeLine}
	 */
	TIMELINE.timeline = null;
	TIMELINE.startTime = 0;
	TIMELINE.finishTime = 0;
	TIMELINE.lastTimeRequest = null;
	TIMELINE.granularity = null;
	TIMELINE.sessionId = "123"; //temp chop for sessionID(get from javaAxis web-service)
	TIMELINE.inPercentage = null;
	TIMELINE.inTime = null;
	TIMELINE.outColor = null;
	TIMELINE.outTime = null;
	TIMELINE.multiplier = 1;
	TIMELINE.coverageData = {};
	TIMELINE.initOk = false;
	
	TIMELINE.AODActiveRequests = [];

	/**
	 * Init general timeline and get archive interval
	 */
	TIMELINE.init = function() {
		mx.TIMELINE.addTimeline('gn');
	};

	TIMELINE.addTimeline = function(id, oneLine){
		jsx3.GO('TopTimelineBlock').setText('<div id="StorageTimeline"></div>', true);

		this.timeline = new TimeLine({
			id: "#StorageTimeline",
			variableName: "mx.TIMELINE.timeline",
			isDebug: false,
			oneLine: false
		});

		this.timeline.init();

		var self = this;
		this.timeline.onLoad = function (){
			var timeline = self.timeline;

			var date = new Date();
			timeline.setTime(date.getTime(), true);

			timeline.onTimeChange = function(){ var args = Array.prototype.slice.call(arguments); setTimeout(function(){ self.onTimeChange.apply(self, args); }, 0); };
			timeline.onGetData = function(){ var args = Array.prototype.slice.call(arguments); setTimeout(function(){ self.requestStorageCoverage.apply(self, args); }, 0); };
			timeline.onSelectionChange = function(itimeLine, istartTime, ifinishTime, igranularity) {
				setTimeout(self.onSelectionChange.bind(self, id, itimeLine, istartTime, ifinishTime, igranularity), 0);
			};

			mx.MATRIX2.getServer().getJSXByName("TopTimelineBlock").setAttribute("status", "1");

			self.initOk = true;

			timeline.setParameters({dateFormat: mx.MATRIX2.getIdentityValue("NLS_LONG_DATE_FORMAT")});
			mx.TIMELINE.hideTimeLine(id);
		};

		//load timeline coloring config
		if(TIMELINE.inTime == null){

			TIMELINE.loadConfig();

			TIMELINE.inPercentage = TIMELINE.getConfigAttributesInPercentage();
			TIMELINE.inTime       = TIMELINE.getConfigAttributesInTime();
			TIMELINE.outColor     = TIMELINE.getConfigAttributesOutColor();
			TIMELINE.outTime      = TIMELINE.getConfigAttributesOutTime();
		}
	};

	TIMELINE.setParameters = function(id, params){
		if (this.initOk) {
			var timeline = this.timeline;
			timeline.setParameters(params);
	        if(window.jsDebug){ appLogger.info("TIMELINE.setParameters: OK"); }
		} else {
			window['timeline_setparams_' + id] = window.setTimeout(function (){ TIMELINE.setParameters(id, params); }, 50);
		}
	};

	/**
	 * @param {Number} itime
	 * @param {String} igranularity
	 * @param {Boolean} bound
	 * @returns {Number}
	 */
	TIMELINE.aligningDate = function(itime, igranularity, bound){
		var timestamp = itime;
		if(bound)
		{
			switch (igranularity)
			{
				case 'day':
					timestamp += 24 * 60 * 60 * 1000;
					break;
				case 'hour':
					timestamp += 60 * 60 * 1000;
					break;
			}
		}
		return timestamp;
	};

	//copy ids from active group for service call
	TIMELINE.getGroupIDs = function(group) {
		var tmp = [];
		for(var i=0; i <= group.players.length-1; i++){
			tmp.push(group.players[i].player.devObjId);
		}
		return tmp;
	};

	TIMELINE.showBlockTimeLineDateSelect = function() {
		this.Command.close();
		this.hideErrorSelectedInterval();

		if (jsx3.GO("TopTimelineBlock").getAttribute('utc_f')) {
			TIMELINE.showErrorSelectedInterval();
			return;
		}

		var css = 'top: 0px; left: 125px;';
		if (mx.language.lang_direction == 'rtl') {
			css = 'top: 0px; right: 125px;';
		}

		var self = this;
		mx.TIME.showTimelineDateTimePicker({
			id: 'timeline_cal',
			css: css,
			callback: function (curtime, $input) {
				if(curtime){
					$('input[name="setTimelineTimeButton"]').data("time", curtime.getTime());
				}
			},
			objids: this.getGroupIDs(groupControls.group),
			instance: self
		});

		mx.MATRIX2.invertSeparatorArrows("blockTLButtonsImage");
	};

	TIMELINE.hideBlockTimeLineDateSelect = function() {
		if ($('#timeline_cal').length) {
			$('#timeline_cal').remove();
			mx.MATRIX2.invertSeparatorArrows("blockTLButtonsImage");
		}
	};

	TIMELINE.onblockTLButtonsClick = function() {
		if ($('#timeline_cal').length) {
			TIMELINE.hideBlockTimeLineDateSelect();
		} else {
			TIMELINE.showBlockTimeLineDateSelect();
		}
	};

	TIMELINE.showErrorSelectedInterval = function() {
		var css = {top: 0, width: '200px', 'text-align': 'center'};
		if (mx.language.lang_direction == 'rtl') {
			css.right = '115px';
		} else {
			css.left = '115px';
		}

		mx.Dialog.createDialog("timeline_error", '&nbsp;', css,
			__("Date can not be selected while time interval presents, remove time interval") + '<br/>' +
				'<button id="btn_change_event">OK</button>'
		);
		$('#btn_change_event').click(function() {
			mx.TIMELINE.hideErrorSelectedInterval();
		});
	};

	TIMELINE.hideErrorSelectedInterval = function() {
		$('#timeline_error').remove();
	};

	TIMELINE.showTimeLine = function(id){
		var block_timeline = mx.MATRIX2.getServer().getJSXByName("TopTimelineBlock");
		var bState = block_timeline.getAttribute('status') == "0";
		if(window.jsDebug){ appLogger.info("TIMELINE.showTimeLine:  id="+id+", status="+block_timeline.getAttribute('status')+", bState="+bState); }
		if(id == 'gn'){
			if (bState){
				//if(window.jsDebug){ appLogger.info("TIMELINE.showTimeLine: block_timeline="+block_timeline+" changed to 1"); }
				block_timeline.setAttribute('status', '1');
				block_timeline.getParent().getParent().setCols('324,0,12,*',true);

				if (mx.language.lang_direction == 'rtl') {
					mx.language.rtl_menu();
				}
			}
		}
	};

	TIMELINE.hideTimeLine = function(id){
		var block_timeline = mx.MATRIX2.getServer().getJSXByName("TopTimelineBlock");
		var bState = block_timeline.getAttribute('status') == "1";

		if (this.initOk) {
			if (id == 'gn') {
				if (bState) {
					block_timeline.setAttribute('status', '0');
					block_timeline.getParent().getParent().setCols('324,*,0,0',true);
					TIMELINE.hideErrorSelectedInterval();
					TIMELINE.hideBlockTimeLineDateSelect();
					TIMELINE.Command.close();
				}
			}
		}
		else{
			window.setTimeout(function() {  TIMELINE.hideTimeLine(id); }, 50);
		}
	};

	TIMELINE.setSelectedInterval = function(dateTS1, dateTS2, isFixed, isCallback, timeline_id){
		//if(window.jsDebug){ appLogger.info("TIMELINE.setSelectedInterval: started id="+timeline_id+", dateTS1="+dateTS1+", dateTS2="+dateTS2); }
		if (!dateTS1 || !dateTS2)
			return;

		if (this.initOk) {
			var blockTL = mx.MATRIX2.getServer().getJSXByName("TopTimelineBlock");
			blockTL.setAttribute("utc_f", dateTS1.toString());
			blockTL.setAttribute("utc_t", dateTS2.toString());
			//set interval in timeline with created timestamp
			var objectTimeline = this.timeline;

			if (window.jsDebug) {
				appLogger.info("TIMELINE.setSelectedInterval: timeline sent, dateTS1=" + dateTS1 + ", dateTS2=" + dateTS2 + ", isFixed=" + isFixed + ", isCallback=" + isCallback);
			}

			objectTimeline.setParameters({selection: {fixed: isFixed}});
			objectTimeline.setSelection(dateTS1, dateTS2, isCallback);
		} else {
			window.setTimeout(function() {  TIMELINE.setSelectedInterval(dateTS1, dateTS2, isFixed, isCallback, timeline_id); }, 50);
		}
	};

	TIMELINE.setDisabledSelectedInterval = function(dateTS1, dateTS2, timeline_id){
		//if(window.jsDebug){ appLogger.info("TIMELINE.setDisabledSelectedInterval: started id="+timeline_id+", dateTS1="+dateTS1+", dateTS2="+dateTS2); }
		if (!dateTS1 || !dateTS2)
			return;

		if (this.initOk) {
			var blockTL = mx.MATRIX2.getServer().getJSXByName("TopTimelineBlock");
			blockTL.setAttribute("utc_f", dateTS1.toString());
			blockTL.setAttribute("utc_t", dateTS2.toString());

			if(window.jsDebug){ appLogger.info("TIMELINE.setDisabledSelectedInterval: timeline sent, dateTS1="+dateTS1+", dateTS2="+dateTS2); }
	        //set disbaled interval in timeline with created timestamp
			this.timeline.setDisabledSelection(dateTS1, dateTS2);
		} else {
			window.setTimeout(function() {  TIMELINE.setDisabledSelectedInterval(dateTS1, dateTS2, timeline_id); }, 50);
		}
		//if(window.jsDebug){ appLogger.info("TIMELINE.setSelectedInterval: finished"); }
	};

	TIMELINE.setTime = function(timestamp, isCallback, timeline_id){
		if(window.jsDebug && isCallback){
			appLogger.info("TIMELINE.setTime: timestamp="+timestamp);
		}
		//set time in timeline with created timestamp
		if (this.initOk) {
			if (TIMELINE.lastTimeRequest != null) {
				var control = TIMELINE.server.getJSXByName('layoutControlComponent').controls;
				var diff = timestamp - TIMELINE.lastTimeRequest;
				if (diff > control.minContentJump) {
					mx.MATRIX2.showMessage(__("Timeline"), __("No video found at requested point.<br />Advancing to " + mx.TIME.timestamp2date(timestamp, mx.MATRIX2.getIdentityValue("NLS_LONG_DATE_FORMAT") + " HH:II")))
				}
				window.setTimeout(function () {
					mx.TIMELINE.lastTimeRequest = null;
				}, 500)
			}

			var objectTimeline = this.timeline;

			var isTimeSet = objectTimeline.setTime(timestamp, isCallback);
			if (!isTimeSet) {
				jsx3.GO("layoutControlComponent").controls.pause(true);
			}
		} else {
			window.setTimeout(function() {  TIMELINE.setTime(timestamp, isCallback, timeline_id); }, 50);
		}
	};

	TIMELINE.clearSelection = function(timeline_id, isDisabled) {
		if (this.initOk) {
			if (isDisabled) {
				this.timeline.clearDisabledSelection();
			} else {
				this.timeline.clearSelection();
			}
		}
	};

	TIMELINE.setCloudTimestamp = function(timeline_id, timestamp) {
		if (this.initOk) {
			this.timeline.setCloudTimestamp(parseInt(timestamp));
		}
	};

	TIMELINE.resetCloudTimestamp = function() {
		if (this.initOk) {
			this.timeline.resetCloudTimestamp();
		}
	};

	TIMELINE.onTimeChange = function(timestamp){
		if(window.jsDebug){ appLogger.info("TIMELINE.onTimeChange: timestamp="+timestamp); }
		//TODO check borders
		this.lastTimeRequest = timestamp;

		if (activeGroup_Cell && groupControls.group != syncGroup)
		{
			var list = this.getGroupIDs(activeGroup_Cell);
			list.map(mx.MATRIX2.clearTrail);
		}

		jsx3.GO("layoutControlComponent").controls.setTime(timestamp);
	};

	TIMELINE.onSelectionChange = function(id, itimeLine, istartTime, ifinishTime, igranularity){
		if (id != 'gn' || itimeLine != 'up')
			return;

		// set dates in left and rights timeline textboxes
		var date = new Date();
		// begin date
		date.setTime(istartTime);
		// var month, day, hour, minute;
		// month = date.getMonth() + 1; //month = TIMELINE.alignNumberWithOneZero(month);
		// day = date.getDate(); //day = TIMELINE.alignNumberWithOneZero(day);

		var objControls =  TIMELINE.server.getJSXByName('layoutControlComponent').controls;
		if(objControls.group != null && objControls.group.contextType != 2){
			var mainCell =  objControls.getMainCell();
			//remove timeline selection
			if (istartTime == null && ifinishTime == null){

				mainCell.removeAttribute("markA");
				mainCell.removeAttribute("markB");
				if(window.jsDebug){ appLogger.info('TIMELINE.onSelectionChange: removed selection'); }
			}
			else {
				mainCell.setAttribute("markA", istartTime);
				mainCell.setAttribute("markB", ifinishTime);
			}
		}

		var blockTL = TIMELINE.server.getJSXByName("TopTimelineBlock");
		if (istartTime && ifinishTime) {
			blockTL.setAttribute("utc_f", istartTime.toString());
			blockTL.setAttribute("utc_t", ifinishTime.toString());
		} else {
			blockTL.setAttribute("utc_f", '');
			blockTL.setAttribute("utc_t", '');
		}
	};

	/**
	 * get events data from server
	**/
	TIMELINE.getEventsStatistics = function(startTS, endTS, granularity) {
		if(window.jsDebug){ appLogger.info("TIMELINE.getEventsStatistics: started startTS="+startTS+", endTS="+endTS+", granularity="+granularity); }

		var objList = mx.ELog2.getObjList();
		if(objList == "-1"){
			if(window.jsDebug){ appLogger.info("TIMELINE.getEventsStatistics: NO DEVICES"); }
			return;
		}

		api.getEventsStatistics({
			objList: JSON.stringify(objList.split(' ')),
			beginTime: startTS,
			endTime: endTS,
			granularity: granularity
		})
			.fail(function(code, message){
				if(window.jsDebug){ appLogger.info("TIMELINE.getEventsStatistics: SERVER ERROR=" + message); }
				if(window.jsDebug){ appLogger.info("TIMELINE.getEventsStatistics: DATA NOT RECIEVED"); }
			})
			.done(function(response){
				if(response.statistics.length > 0){
					TIMELINE.sendEventsResponseXML(response.statistics);
				}
			})
			.always(function(){
				if(window.jsDebug){ appLogger.info("TIMELINE.getEventsStatistics: finished"); }
			})
	};

	TIMELINE.sendEventsResponseXML = function(arrData) {
		appLogger.info("TIMELINE.sendEventsResponseXML: started intervals:"+arrData.length);

		var list = [];

		if (arrData.length > 0)
		{
			var row = {list: {}, color: 0x9f2c35, borderColor: 0x9f2c35};
			for (var i = 0; i < arrData.length; i++)
			{
				var value = parseInt(arrData[i].number, 10);
				if (value < 1) value = 1;
				else
					if (value == 1) value = 2;
					else
						if (value > 1000) value = 1000;
				var log10x = Math.log(value) * Math.LOG10E;

				// we think that value <= 1000
				var percent = Math.round(log10x * (100 / 3));

				row.list[arrData[i].time.toString() + '000'] = {
					percentage: percent
				};
			}
			list.push(row);
		}

		mx.ELog2.timeline.setData('up', list);
	    if(window.jsDebug){ appLogger.info("TIMELINE.sendEventsResponseXML: sent to el tl strOutput=" + list); }
	};

	TIMELINE.refreshTimelineContents = function() {
	    if ($.isEmptyObject(this.coverageData))
	        return;

	    var t = this.coverageData;

	    this.requestStorageCoverage(t.timeline, t.start, t.finish, t.granularity);
	};

	/**
	 * onGetData callback for main timeline
	 */
	TIMELINE.requestStorageCoverage = function ( itimeLine, istartTime, ifinishTime, igranularity ){

	    this.coverageData = {
	        'timeline': itimeLine,
	        'start': istartTime,
	        'finish': ifinishTime,
	        'granularity': igranularity
	    };

		if (activeGroup_Cell == null || groupControls.group == syncGroup)
			return;

		this.getStorageCoverage({
			'timeline': this.timeline,
			'timeLine': itimeLine,
			'startTime': istartTime,
			'finishTime': ifinishTime,
			'granularity': igranularity,
			'objids': this.getGroupIDs(activeGroup_Cell)
		});
	};

	/**
	 * Webservice call to fill timeline with data from storage
	 * This function used by main timeline, motionSearch and vMX timelines
	 *
	 * @param {Object} data
	 * fields:
	 *    timeline   - timeline flash object to set data
	 *    timeLine   - 'up'|'down'
	 *    startTime  - left bound of time interval, UTC, ms
	 *    finishTime - right bound of time interval, UTC, ms
	 *    granularity - 'year'|'mon'|'day'|'hour'|'min'|'second'
	 */
	TIMELINE.getStorageCoverage = function(data) {
		/*
		if (this.timeline_check_var)
		{
			clearTimeout(this.timeline_check_var);
		}
		*/

		var camera = resourceTree.getObject(data.objids[0]);
		// for avatar cameras show advanced coverage
		if(camera && camera.attr('AVATARID')){
			TIMELINE.getAdvancedStorageCoverage(data);
			return;
		}

		this.currentTimeline = data.timeline ? data.timeline : this.timeline;
		this.timeLine        = data.timeLine;
		this.startTime       = Math.round(data.startTime / 1000);
		this.finishTime      = Math.round(this.aligningDate(data.finishTime, data.granularity, true) / 1000);
		this.granularity     = data.granularity;
		this.multiplier      = 1;

	    var streamNumber;
		if(data.streamnumber){
			streamNumber = data.streamnumber;
		}
		else{
			/*var player = groupControls.getMainPlayer();
			if(player && player.getParameter){
				streamNumber =  player.getParameter('STREAMNUM');
			}
			if(streamNumber == null || streamNumber == undefined){
				streamNumber = 1;
			}*/
			streamNumber = -1;
		}

		var gran = (this.granularity == "min" ?  "chunk" : this.granularity);

		var self = this;

		$.ajax({
			url: "/storage/coverage",
			type: "GET",
			dataType: "json",
			cache: false,
			data: {
				obj: data.objids[0],
				startTime: this.startTime,
				endTime: this.finishTime,
				granularity: gran,
				streamNumber: streamNumber
			},
			error: function(jqXHR){
				var code = jqXHR.status;
				var message = jqXHR.statusText;
				appLogger.info("Timeline: " + message);
			},
			success: function(result){
				if (result.code == 200)
				{
					self.sendStorageCoverageToTimeline(result);
				} else {
					appLogger.info("Timeline: " + result.error);
				}
			}
		});
	};

	/**
	 *  get advanced storage coverage for timeline
	 */
	TIMELINE.getAdvancedStorageCoverage = function(data) {
		var self = this;

		this.currentTimeline = data.timeline ? data.timeline : this.timeline;
		this.timeLine        = data.timeLine;
		this.startTime       = Math.round(data.startTime / 1000);
		this.finishTime      = Math.round(data.finishTime / 1000);
		this.granularity     = data.granularity;

	    var streamNumber = -1;

		var startTime = this.startTime;
		var endTime = this.finishTime;
		var objId = data.objids[0];
		var gran = "chunk";

		var avatarRequestStatuses = ['QUEUED', 'PROCESSING'];

		$.when(
			$.ajax({
				url: "/storage/coverage",
				type: "GET",
				dataType: "json",
				cache: false,
				data: {
					obj: objId,
					startTime: startTime,
					endTime: endTime,
					granularity: gran,
					streamNumber: streamNumber
				}
			}),
			$.ajax('/cxf/services/aod/get', {
				data: {
					objid: objId,
					created_from: startTime - 60*60,
					created_to: endTime + 60*60,
					status : avatarRequestStatuses
				}
			})
		)
		.fail(function(jqXHR){
			var code = jqXHR.status;
			var message = jqXHR.statusText;
			if(jsDebug){ appLogger.info("getAdvancedStorageCoverage: " + message); }
		})
		.done(function(storageCoverageResponse, aodResponse){
			var storageCoverage = storageCoverageResponse[0];
			var aod = aodResponse[0];
			var objList = Object.keys(storageCoverage.list);

			var rows = [];

			// low resolution row
			var rowLR = {list: {}, color: 0x2e6fab, borderColor: 0x2e6fab, granularity: "chunk"};
			var timestampList = storageCoverage.list[objList[0]][0];
			for (var i = 0; i < timestampList.length; i++) {
				var timestamp = timestampList[i];

				rowLR.list[timestamp + '000'] = {
					percentage: 100
				};
			}
			rows.push(rowLR);

			// high resolution row
			var rowHR = {list: {}, color: 0x9f2c35, borderColor: 0x9f2c35, granularity: "chunk"};
			var timestampList = storageCoverage.list[objList[0]][1];
			for (var i = 0; i < timestampList.length; i++) {
				var timestamp = timestampList[i];

				rowHR.list[timestamp + '000'] = {
					percentage: 100
				};
			}
			rows.push(rowHR);

			// avatar requests row
			var rowAR = {list: {}, color: 0xdca037, borderColor: 0xdca037, granularity: "chunk"};
			var requests = (aod.requests ? aod.requests : []);
			mx.TIMELINE.AODActiveRequests = requests;
			if(requests.length > 0){
				var startChunk = startTime - (startTime - Math.floor(startTime/30)*30);
				for(var i = 0; i < requests.length; i++) {
					var req = requests[i];
					if($.inArray(req.status, avatarRequestStatuses) == -1){
						continue;
					}
					for(var c = startChunk; c <= endTime; c+=30){
						if(req.startTs <= c && c <= req.endTs){
							rowAR.list[c + '000'] = {
								percentage: 100
							};
						}
					}
				}
				if(!$.isEmptyObject(rowAR.list)){
					rows.push(rowAR);
				}
			}

			self.currentTimeline.setData(self.timeLine, rows);
		});
	};
	
	/*
		check is timetamp allready in AOD requestes
	*/
	TIMELINE.isAODRequested = function(timestamp, streamNum) {
		var ts = timestamp/1000;
		var avatarRequestStatuses = ['NOT CONFIRMED', 'QUEUED', 'PROCESSING', 'COMPLETED'];
		
		for(var i = 0; i < mx.TIMELINE.AODActiveRequests.length; i++) {
			var req = mx.TIMELINE.AODActiveRequests[i];
			if(window.jsDebug){ appLogger.info("---------->TIMELINE.isAODRequested: req.status=" + req.status + ", req.streamNum=" + req.streamNum + ", streamNum=" + streamNum); }
			if(req.streamNum != streamNum || $.inArray(req.status, avatarRequestStatuses) == -1){
				continue;
			}

			//if(window.jsDebug){ appLogger.info("---------->TIMELINE.isAODRequested: req.startTs=" + req.startTs + ", req.endTs=" + req.endTs + ", ts="+ts); }
			if(req.startTs < ts && ts < req.endTs){
				if(window.jsDebug){ appLogger.info("---------->TIMELINE.isAODRequested: EXIST"); }
				return true;
			}
		}

		if(window.jsDebug){ appLogger.info("---------->TIMELINE.isAODRequested: NOT EXIST"); }
		return false;
	};

	/*
	TIMELINE.onStorageCoverageError = function() {
		//objectTimeline.drawRedDot(true, 3);
		appLogger.info("Timeline: onStorageCoverageError restart in : 3000 mls");
		if (this.timeline_check_var)
		{
			clearTimeout(this.timeline_check_var);
		}
		this.timeline_check_var = window.setTimeout(this.getStorageCoverage, 3000);
	};
	*/

	TIMELINE.sendStorageCoverageToTimeline = function(result) {
		var list = [];

		var objList = Object.keys(result.list);
		if (objList.length > 0)
		{
			// low resolution row
			var rowLR = {list: {}, color: 0x2e6fab, borderColor: 0x2e6fab, granularity: "chunk"};
			var percentageList = result.list[objList[0]][0];
			for (var timestamp in percentageList) {
				if (!percentageList.hasOwnProperty(timestamp))
					continue;

				rowLR.list[percentageList[timestamp] + '000'] = {
					percentage: 100
				};
			}
			list.push(rowLR);

			// high resolution row
			var rowHR = {list: {}, color: 0x9f2c35, borderColor: 0x9f2c35, granularity: "chunk"};
			var percentageList = result.list[objList[0]][1];
			for (var timestamp in percentageList)
			{
				if (!percentageList.hasOwnProperty(timestamp))
					continue;

				rowHR.list[percentageList[timestamp] + '000'] = {
					percentage: 100
				};
			}
			list.push(rowHR);
		}

		this.currentTimeline.setData(this.timeLine, list);
	};

	TIMELINE.loadConfig = function(){
		TIMELINE.server.getCache().openDocument("/TibcoGI/JSXAPPS/mx/xml/timelineInterface_conf.xml", "ConfigurationDocument");
	};

	TIMELINE.getConfigEndPoint = function(){
		return TIMELINE.server.getCache().getDocument("ConfigurationDocument").selectSingleNode("/data/endpoint/text()");
	};

	TIMELINE.getConfigAttributesInPercentage = function(){
		return TIMELINE.server.getCache().getDocument("ConfigurationDocument").selectSingleNode("/data/attributes/in/percentage/text()");
	};

	TIMELINE.getConfigAttributesInTime = function(){
		return TIMELINE.server.getCache().getDocument("ConfigurationDocument").selectSingleNode("/data/attributes/in/time/text()");
	};

	TIMELINE.getConfigAttributesOutColor = function(){
		return TIMELINE.server.getCache().getDocument("ConfigurationDocument").selectSingleNode("/data/attributes/out/color/text()");
	};

	TIMELINE.getConfigAttributesOutTime = function(){
		return TIMELINE.server.getCache().getDocument("ConfigurationDocument").selectSingleNode("/data/attributes/out/time/text()");
	};

	TIMELINE.jump2event = function(timestamp, cellId){
		if(window.jsDebug){ appLogger.info("TIMELINE.jump2event: timestamp=" + timestamp); }
	    var cells = jsx3.GO("layoutControlComponent").controls.getGroupCells();
	    for(var i = 0; i < cells.length; i++){
	        if(cells[i].getId() == cellId){
	            TIMELINE.server.getJSXByName('layoutControlComponent').controls.setTime(timestamp);
	            return true;
	        }
	    }
	    alert(__("Player not in active group"));
		return false
	};

	TIMELINE.Command = {
		toggle: function() {
			$('#timelineCommand').length
				? this.close()
				: this.open();
		},

		close: function() {
			if ($('#timelineCommand').length) {
				$('#timelineCommand').remove();
				mx.MATRIX2.invertSeparatorArrows('blockTLButtonsCommandImage');
			}
		},

		open: function() {

			if ($('#timelineCommand').length)
				return;

			TIMELINE.hideBlockTimeLineDateSelect();
			TIMELINE.hideErrorSelectedInterval();

			if (jsx3.GO("TopTimelineBlock").getAttribute('utc_f')) {
				TIMELINE.showErrorSelectedInterval();
				return;
			}

			$('body').append(
				'<div id="timelineCommand">' +
					'<input type="text" value="" title="Input formats: ' +
						'hh:mm[:ss] - time in current day; ' +
						'DD hh:mm[:ss] - day in current month + time; ' +
						'MM/DD hh:mm[:ss] - month/day in current year + time; ' +
						'YY/MM/DD hh:mm[:ss] - full format;' + '"/><button>OK</button><br>' +
				'</div>'
			);
			$('#timelineCommand input').keypress(function(e) {
				if (e.keyCode == 13) {
					mx.TIMELINE.Command.process();
				} else {
					mx.TIMELINE.Command.removeError();
				}
			}).focus();
			$('#timelineCommand button').click(function() {mx.TIMELINE.Command.process()});
			mx.MATRIX2.invertSeparatorArrows('blockTLButtonsCommandImage');
		},

		process: function() {

			var command = $.trim($('#timelineCommand input').val()),
				formats = [
					'HH:II',
					'HH:II:SS',
					'DD HH:II',
					'DD HH:II:SS',
					'MM/DD HH:II',
					'MM/DD HH:II:SS',
					'YY/MM/DD HH:II',
					'YY/MM/DD HH:II:SS'
				],
				timestamp, i;

			command = command.replace(/ +/, ' ');

			for (i=0; i<formats.length; i++) {
				timestamp = mx.TIME.date2timestamp(command, formats[i]);
				if (timestamp) {
					mx.TIMELINE.setTime(timestamp, true, 'gn');
					return;
				}
			}

			mx.TIMELINE.Command.setError();
		},

		setError: function() {
			$('#timelineCommand').addClass('error');
		},

		removeError: function() {
			$('#timelineCommand').removeClass('error');
		}
	}
});
