//---------------------------------------------------------------------------------------------------------------
// This is the TIME package
//---------------------------------------------------------------------------------------------------------------
jsx3.lang.Package.definePackage("mx.TIME", function(TIME) {

	TIME.currentTimezoneOffset = -1*(new Date()).getTimezoneOffset()*60*1000;

	TIME.localTimezoneOffset = -1*(new Date()).getTimezoneOffset()*60*1000;

	TIME.updateInterval = 60*60*1000; //mls

	TIME.dateFormat = mx.MATRIX2.getIdentityValue("NLS_LONG_DATE_FORMAT");

	TIME.lastUpdated = 0;

	TIME.timezones = [];

	TIME.applyCameraTimezone = function(timezone) {
		var doc = mx.MATRIX2.getServer().Cache.getDocument('TIME_timezones');

		if(window.jsDebug){ appLogger.info("TIME.applyCameraTimezone: doc="+doc+""); }
		if(window.jsDebug){ appLogger.info("TIME.applyCameraTimezone: node="+doc.selectSingleNode("//record[@jsxtext='"+timezone+"']")); }
		if(window.jsDebug){ appLogger.info("TIME.applyCameraTimezone: newTimezone="+timezone); }
		var id = doc.selectSingleNode("//record[@jsxtext='"+timezone+"']").getAttribute("jsxid");
		var select_timezone = mx.MATRIX2.getServer().getJSXByName("selectTimezone");
		select_timezone.setXMLId('TIME_timezones').setValue(id);
		select_timezone.repaint();
		TIME.changeTimezone();
	};

	TIME.changeTimezone = function(){
        var doc = mx.MATRIX2.getServer().Cache.getDocument('TIME_timezones');
        var node = doc.selectSingleNode("//record[@jsxid='"+mx.MATRIX2.getServer().getJSXByName("selectTimezone").getValue()+"']");
        var offset = node.getAttribute("offset");
        var name = node.getAttribute("jsxtext");

		TIME.currentTimezoneOffset = parseInt(offset, 10);

		var eLog2_container = document.getElementById("eLog2_container");
		for (var i = 0; i < eLog2_container.childNodes.length; i++) {
			var eventDOM = eLog2_container.childNodes[i];
			eventDOM.childNodes[4].innerHTML = mx.TIME.timestamp2date(eventDOM.getAttribute("utctime_when") * 1000);
		}

		var block_timeline = jsx3.GO("TopTimelineBlock");
		if(block_timeline.getAttribute('status') == "1"){
            var objControls =  jsx3.GO('layoutControlComponent').controls;
            var objCell = jsx3.GO(objControls.group.players[objControls.group.getPrimaryPlayerPos()].player.id);
			var startTS = objCell.getAttribute("markA");
			var endTS = objCell.getAttribute("markB");
            if(window.jsDebug){ appLogger.info("TIME.changeTimezone: new GN timeline: startTS="+startTS+", endTS="+endTS); }

			if(startTS != undefined && startTS != 'null' && endTS != undefined && endTS != 'null'){
				var isFixed = false;
				//if event set fixed interval
				if(objCell.getAttribute("eventid") != "-1"){
					isFixed = true;
				}

				mx.TIMELINE.setSelectedInterval(startTS, endTS, isFixed, false, 'gn');
			}

			var group = objControls.group;
			if(group){
				mx.TIMELINE.setTime(group.getCurrentTS(), false, 'gn');
			}
		}

        var params = {timezoneOffset: {}};
		for(var i = 0; i < TIME.timezones.length; i++){
		    if(name == TIME.timezones[i].name){
                var curYear = (new Date().getFullYear());
                params.timezoneOffset[curYear] = TIME.timezones[i].years[curYear];
			}
		}
        mx.TIMELINE.setParameters('gn', params);

		if(mx.MATRIX2.MotionSearch != null){
			mx.MATRIX2.MotionSearch.timeline.setParameters(params);
		}

		if(mx.ELog2.mode == "archive"){
			mx.ELog2.setArchiveInterval(mx.ELog2.startTs, true);
		}

		if(window.jsDebug){ appLogger.info("TIME.changeTimezone: changed to "+(offset/(60*60*1000))); }
	};

	TIME.setTimezone = function(offset){
        var doc = mx.MATRIX2.getServer().Cache.getDocument('TIME_timezones');
        var node = doc.selectSingleNode("//record[@offset='"+offset+"']");
		if(node == null){
			var allNodes = doc.selectNodes("//record");
			node = allNodes.get(0);
		}
        mx.MATRIX2.getServer().getJSXByName("selectTimezone").setValue(node.getAttribute("jsxid"));
	};

	TIME.updateTimezones = function(){
        TIME.timezones = [];

		var devices = resourceTree.getObjects({}, false);

        var timezone_names = [], timezone_years = [];
		var curTimezoneName, curTimezoneValue, found;

		for(var i = 0; i < devices.length; i++){
			found = false;
			curTimezoneName = resourceTree.getObject(devices[i]).attr('TIME_ZONE');

			for(var j = 0; j < TIME.timezones.length; j++){
				if(curTimezoneName == TIME.timezones[j].name){
					found = true;
					break;
				}
			}
			if(!found){
				if(curTimezoneName !== null){
                    timezone_names.push(curTimezoneName);
				}
			}
		}

        var currentYear = (new Date()).getFullYear();
        timezone_years.push(currentYear - 3,currentYear - 2,currentYear - 1, currentYear, currentYear + 1);

        timezone_names.push("UTC");

        $.ajax({
			url: '/api/call.php',
			data: {
                'function': 'getTimezoneInformationList',
                'timezoneList': JSON.stringify(timezone_names),
                'yearList': JSON.stringify(timezone_years)
            },
			async: false,
			dataType: 'json',
			success: function(data) {
                if(data.error == ""){
                    $.each( data.list, function(key, value){
				        if(window.jsDebug){ appLogger.info("TIME.updateTimezones: years="+value+", curTimezoneName="+key); }
					    TIME.timezones.push({name:unescape(key), years:value});
                    });

                    TIME.timezonesToCDF();
                }
            }
		});

		window.setTimeout(function(){ mx.TIME.updateTimezones(); }, TIME.updateInterval);
	};

	TIME.timezonesToCDF = function(){
        var key, name, offset, local_key = null;
        var now = new Date();
        var curYear = now.getFullYear();

		var str = '<data jsxid="jsxroot">';
        local_key = jsx3.xml.CDF.getKey();
        str+= '<record jsxid="'+local_key+'" offset="' + TIME.localTimezoneOffset + '" jsxtext="Local" />'
		for(var i = 0; i < TIME.timezones.length; i++){
            key = jsx3.xml.CDF.getKey();
            offset = TIME.timezones[i].years[curYear].offset*1000;
            name = TIME.timezones[i].name;
			str+= '<record jsxid="' + key + '" offset="' + offset + '" jsxtext="' + name + '" />'
		}
		str+= '</data>';

		if(window.jsDebug){ appLogger.info("TIME.timezonesToCDF: str="+str); }

		var doc = jsx3.xml.CDF.Document.newDocument().loadXML(str);

		mx.MATRIX2.getServer().Cache.setDocument('TIME_timezones', doc);

		var select_timezone = mx.MATRIX2.getServer().getJSXByName("selectTimezone");
		select_timezone.setEvent("mx.TIME.changeTimezone();", jsx3.gui.Interactive.SELECT);
		select_timezone.setXMLId('TIME_timezones').setValue(local_key);
		select_timezone.repaint();
	};


	TIME.getDST = function(timestamp) {
		var key = jsx3.GO("selectTimezone").getValue();
		var curTimezoneRecord = mx.MATRIX2.getServer().Cache.getDocument('TIME_timezones').selectSingleNode("//record[@jsxid='"+key+"']");
		var curTimezone = curTimezoneRecord.getAttribute("jsxtext");
		var tsYear = (new Date(timestamp)).getFullYear();
		for(var i = 0; i < TIME.timezones.length; i++){
			if(TIME.timezones[i].name == curTimezone){
				if(timestamp > TIME.timezones[i].years[tsYear].startDST*1000 && timestamp < TIME.timezones[i].years[tsYear].endDST*1000){
                    return TIME.timezones[i].years[tsYear].offsetDST*1000 - TIME.timezones[i].years[tsYear].offset*1000;
				}
			}
		}

		return 0;
	};

	/**
	 * Build string representation of timestamp
	 * @param timestamp    int    timestamp in milliseconds
	 * @param {String} [format = NLS_LONG_DATE_FORMAT + HH:II:SS] format string, ex. "YYYY/MM/DD HH:II:SS".
	 */
	TIME.timestamp2date = function (timestamp, format) {
		timestamp = parseInt(timestamp, 10);
		format = format || TIME.dateFormat + " HH:II:SS";

		return TIME.formatUTCDate(timestamp + TIME.getDST(timestamp) + TIME.currentTimezoneOffset, format);
	};


	/**
	 *
	 * @param {Integer} timestamp
	 * @param {String} [format = TIME.dateFormat + " HH:II:SS"]
	 */
	TIME.formatUTCDate = function(timestamp, format) {
		timestamp = parseInt(timestamp, 10);
		format = format || TIME.dateFormat + " HH:II:SS";
		var date = new Date(timestamp);

		format = format.replace('YYYY', date.getUTCFullYear());
		format = format.replace('YY',   String(date.getUTCFullYear()).substr(2));
		format = format.replace('MM',  (date.getUTCMonth()+1<10) ?  "0"+(date.getUTCMonth()+1)  : date.getUTCMonth()+1);
		format = format.replace('DD',  (date.getUTCDate()<10)    ?  "0"+date.getUTCDate()       : date.getUTCDate());

		format = format.replace('HH?:',
			date.getUTCHours() > 0
				? ((date.getUTCHours()<10) ? "0"+date.getUTCHours() : date.getUTCHours()) + ':'
				: ''
		);
		format = format.replace('II?:',
			date.getUTCMinutes() > 0
				? ((date.getUTCMinutes()<10) ? "0"+date.getUTCMinutes() : date.getUTCMinutes()) + ':'
				: ''
		);
		format = format.replace('SS?',
			date.getUTCSeconds() > 0
				? ((date.getUTCSeconds()<10) ? "0"+date.getUTCSeconds() : date.getUTCSeconds())
				: ''
		);

		format = format.replace('HH',  (date.getUTCHours()<10)   ?  "0"+date.getUTCHours()      : date.getUTCHours());
		format = format.replace('II',  (date.getUTCMinutes()<10) ?  "0"+date.getUTCMinutes()    : date.getUTCMinutes());
		format = format.replace('SS',  (date.getUTCSeconds()<10) ?  "0"+date.getUTCSeconds()    : date.getUTCSeconds());

		return format;
	};

	/**
	 *  show timeline date and time picker
	 */
	TIME.showTimelineDateTimePicker = function(data) {
		data.id   = data.id || 'datetimepicker';
		data.css = data.css || '';
		data.parent = data.parent || $('body');
		data.minDate = '1970/01/01';
		data.maxDate = 0;

		if ($.isArray(data.objids)) {
			var hasAvatarDevices = false;
			for(var i = 0; i < data.objids.length; i++){
				var device = resourceTree.getObject(data.objids[i]);
				if(device != null && device.attr("AVATARID")){
					hasAvatarDevices = true;
					break;
				}
			}

			if(!hasAvatarDevices){
				$.ajax({
					data: {'function': 'getStorageUsageTotals', objList: JSON.stringify(mx.TIMELINE.getGroupIDs(groupControls.group))},
					async: false,
					cache: true,
					success: function(list) {
						list = list['list'];

						// find oldest time for all cameras in response
						var oldestTime = 0;
						$.each(list, function(i, v) {
							if (!oldestTime || oldestTime > v.oldestTime) {
								oldestTime = v.oldestTime;
							}
						});
						oldestTime *= 1000;
						oldestTime -= 48*3600*1000;

						var t = new Date( oldestTime );
						data.minDate = t.getFullYear() + '/' +
							(t.getMonth()+1<10?'0':'') + (t.getMonth()+1) + '/' +
							(t.getDate()<10?'0':'') + t.getDate();
					}
				});
			}
		}

		var strDateTime = TIME.timestamp2date((new Date()).getTime(), "YYYY/MM/DD HH:II");

		var options = {
			parentID: data.parent,
			left: 15,
			validateOnBlur: true,
			mask: true,
			value: strDateTime,
			lazyInit: false,
			allowBlank: false,
			monthChangeSpinner: false,
			minDate: data.minDate,
			maxDate: data.maxDate,
			onChangeDateTime: data.callback,
			onShow: function(current_time,$input){
				if(jsx3.CLASS_LOADER.IE){
					$('.xdsoft_datetimepicker.xdsoft_.xdsoft_noselect').attr("tabindex", -1).focus();
				}
			}
		};

		// create calendar container
		data.parent.append('<div id="' + data.id + '" style="position: absolute; ' + data.css + ' z-index: 100;">'+
			'<input name="' + data.id + '" type="text" value="">'+
			'<input name="setTimelineTimeButton" type="button" value="'+__("Go!")+'" alt="'+__("Go to selected date in timeline")+'" title="'+__("Go to selected date in timeline")+'">'+
			'</div>');
		// create calendar
		$('input[name="' + data.id + '"]').datetimepicker(options);

		$('input[name="setTimelineTimeButton"]').on("click", function(){
			var datetimepicker = $('input[name="' + data.id + '"]').data('xdsoft_datetimepicker');
			datetimepicker.data('xdsoft_datetime').setCurrentTime($('input[name="' + data.id + '"]').val());
			datetimepicker.trigger('changedatetime.xdsoft');

			var time = $(this).data("time");
			if(time){
				var ts = parseInt(time) - (new Date()).getTimezoneOffset()*60*1000 - mx.TIME.currentTimezoneOffset;
				data.instance.setTime(ts, true, 'gn');
				data.instance.hideBlockTimeLineDateSelect();
			}
		});
	};

	TIME.calendar = function(data) {

		data.id   = data.id   || 'calendar';
		data.css = data.css || '';
		data.parent = data.parent || $('body');

		var options = {
			day: new Date(),
			days: 1,
			showMonths: 1,
			monthSelect: false,
			callback: data.callback
		};


		if ($.isArray(data.objids)) {
			$.ajax({
				data: {'function': 'getStorageUsageTotals', objList: JSON.stringify(mx.TIMELINE.getGroupIDs(groupControls.group))},
				async: false,
				cache: true,
				success: function(list) {

					list = list['list'];

					// find oldest time for all cameras in response
					var oldestTime = 0;
					$.each(list, function(i, v) {
						if (!oldestTime || oldestTime > v.oldestTime) {
							oldestTime = v.oldestTime;
						}
					});
					oldestTime *= 1000;
					oldestTime -= 48*3600*1000;

					options.dCheck = function(day) {
						if (day.getTime() < oldestTime)
							return false;
						return true;
					}
				}
			});
		}

		// Create calendar div
		data.parent.append('<div id="' + data.id + '" style="position: absolute; ' + data.css + ' z-index: 100;"></div>');
		$('#' + data.id).jCal(options);
	};

	TIME.parseDate = function(val,format) {

		function _isInteger(val) {
			var digits="1234567890", i;
			for (i=0; i < val.length; i++) {
				if (digits.indexOf(val.charAt(i))==-1) { return false; }
			}
			return true;
		}

		function _getInt(str,i,minlength,maxlength) {
			for (var x=maxlength; x>=minlength; x--) {
				var token=str.substring(i,i+x);
				if (token.length < minlength) { return null; }
				if (_isInteger(token)) { return token; }
			}
			return null;
		}

		val=val+"";
		format=format+"";

		var i_val = 0,
			i_format = 0,
			c = "",
			token = "",
			x, y,
			now = new Date(),
			year = now.getFullYear(),
			month = now.getMonth() + 1,
			date = now.getDate(),
			hh = now.getHours(),
			mm = now.getMinutes(),
			ss = now.getSeconds();

		while (i_format < format.length) {
			// Get next token from format string
			c=format.charAt(i_format);
			token="";
			while ((format.charAt(i_format)==c) && (i_format < format.length)) {
				token += format.charAt(i_format++);
			}
			// Extract contents of value based on format token
			if (token=="YYYY" || token=="YY" || token=="Y") {
				if (token=="YYYY") { x=4;y=4; }
				if (token=="YY")   { x=2;y=2; }
				if (token=="Y")    { x=2;y=4; }
				year=_getInt(val,i_val,x,y);
				if (year==null) { return 0; }
				i_val += year.length;
				if (year.length==2) {
					if (year > 70) { year=1900+(year-0); }
					else { year=2000+(year-0); }
				}
			}
			else if (token=="MM"||token=="M") {
				month=_getInt(val,i_val,token.length,2);
				if(month==null||(month<1)||(month>12)){return 0;}
				i_val+=month.length;}
			else if (token=="DD"||token=="D") {
				date=_getInt(val,i_val,token.length,2);
				if(date==null||(date<1)||(date>31)){return 0;}
				i_val+=date.length;}
			else if (token=="HH"||token=="H") {
				hh=_getInt(val,i_val,token.length,2);
				if(hh==null||(hh<0)||(hh>23)){return 0;}
				i_val+=hh.length;}
			else if (token=="II"||token=="I") {
				mm=_getInt(val,i_val,token.length,2);
				if(mm==null||(mm<0)||(mm>59)){return 0;}
				i_val+=mm.length;}
			else if (token=="SS"||token=="S") {
				ss=_getInt(val,i_val,token.length,2);
				if(ss==null||(ss<0)||(ss>59)){return 0;}
				i_val+=ss.length;}
			else {
				if (val.substring(i_val,i_val+token.length)!=token) {return 0;}
				else {i_val+=token.length;}
			}
		}
		// If there are any trailing characters left in the value, it doesn't match
		if (i_val != val.length) { return 0; }
		// Is date valid for month?
		if (month==2) {
			// Check for leap year
			if ( ( (year%4==0)&&(year%100 != 0) ) || (year%400==0) ) { // leap year
				if (date > 29){ return 0; }
			}
			else { if (date > 28) { return 0; } }
		}
		if ((month==4)||(month==6)||(month==9)||(month==11)) {
			if (date > 30) { return 0; }
		}

		var newdate=new Date(year,month-1,date,hh,mm,ss);
		return newdate.getTime();
	};

	TIME.date2timestamp = function(value, format) {
		format = format || TIME.dateFormat + " HH:II:SS";

		var timestamp = TIME.parseDate(value, format);
		if (!timestamp)
			return timestamp;

		timestamp -= TIME.getDST(timestamp);
		timestamp -= (new Date()).getTimezoneOffset()*60*1000;
		timestamp -= TIME.currentTimezoneOffset;

		return timestamp;
	}
});
