//---------------------------------------------------------------------------------------------------------------
// This is the system state Matrix GUI Package
//---------------------------------------------------------------------------------------------------------------
jsx3.lang.Package.definePackage(
    "mx.STATE",                //the full package name
    function(STATE) {          //short package name, good to use in this file only.
	STATE.checkSystemPeriod = 60*1000; //in mls - 1 minute
	STATE.expired = false;
	STATE.curState = 'UNKNOWN';

	STATE.api = new API();

	STATE.checkSystemState = function(){
		this.api.getSystemStatus()
			.fail(STATE.checkSystemStateTimeout)
			.done(STATE.checkSystemStateResponse);

		window.setTimeout(function(){ STATE.checkSystemState(); }, STATE.checkSystemPeriod);
	};

	STATE.checkSystemStateResponse = function(sysSummaryObject){
		STATE.setIcon(sysSummaryObject.status);
		STATE.expired = false;
	};

	STATE.checkSystemStateTimeout = function(objEvent){
		STATE.setIcon("CRITICAL");
		STATE.expired = true;
	};

	STATE.showSystemState = function(){
		this.api.getSystemStatus()
			.fail(STATE.showSystemStateTimeout)
			.done(STATE.showSystemStateResponse);
	};

	STATE.showSystemStateResponse = function(sysSummaryObject){
		var text = "";

		for(var i = 0; i < sysSummaryObject.reasons.length; i++){
			if(sysSummaryObject.reasons[i] != "null"){
				text+= sysSummaryObject.reasons[i] + "<br />";
			}
		}

		mx.Dialog.createDialog("system_status_dialog", __("System status") + ": " + sysSummaryObject.status, {'width': '315px', 'left': '3px', 'top':'70px'}, text/*, parent*/);
	};

	STATE.showSystemStateTimeout = function(code, message){
		if(window.jsDebug){ appLogger.info("STATE.showSystemStateTimeout: " + message); }
		STATE.setIcon("CRITICAL");
		STATE.expired = true;
	};

	STATE.setIcon = function(strType){
		//if(window.jsDebug){ appLogger.info("STATE.setIcon: strType="+strType); }

        if(strType == "ONLINE" || strType == ""){
            strType = "NORMAL";
        }
        else if(strType == "OFFLINE" || strType == "STOPPING"){
            strType = "STOP";
        }
        else if(strType == "STARTING"){
            strType = "UNKNOWN";
        }
        else if(strType == "BROKEN"){
            strType = "CRITICAL";
        }
        else if(strType == "ALERT"){
            strType = "WARNING";
        }

		var button = $('#res_btn_system_state');

		if(STATE.curState != strType) {
			if(window.jsDebug){ appLogger.info("STATE.setIcon: change from " + STATE.curState + " to " + strType); }

			// Change button style
			button.toggleClass('system_state_' + STATE.curState.toLowerCase() + ' system_state_' + strType.toLowerCase());
			STATE.curState = strType;

			if($('#system_status_dialog').length){
				STATE.showSystemState();
			}

			if(jsx3.GO('mainLayout').getCols().split(",")[0] == 0 && strType != "NORMAL"){
				mx.CT.mainLayoutChange();
			}
		}
	};

});
