jsx3.lang.Package.definePackage("mx.PTZ", function(PTZ) {

	PTZ.ptz_tours        = null; // description of ptz tours of currently selected camera
	PTZ.camera_id        = null; // Current camera id
	PTZ.cell_id     	 = null; // Current cell id
	PTZ.lock_incheck     = false;// Lock already checking
	PTZ.lock_ts		     = null; // Lock timestamp
	PTZ.lock_timeout     = null; // Lock timeout
	PTZ.alive_ts  = null;    // Session update last ts
	PTZ.alive_timeout  = 30*1000;// Session timeout, mlsec
	PTZ.lock_priority    = null; // Lock priority
	PTZ.last_command    = null;  // last command
	PTZ.process_response = true; // Need process response
	PTZ.preset_number    = 100;  // Number of presets avaliable in ptz control and ptz tour
	PTZ.can_view         = null; // set to 1 if user can run ptz tours (PTZ::Control credentials)
	PTZ.can_edit         = null; // set to 1 if user can modify ptz tours (PTZ::Manage credentials)
	PTZ.curr_edit_tour   = '';   // Name of currently edited tour
	PTZ.curr_run_tour    = {};   // Currently running tours for all cameras
	PTZ.tour_alive_ts    = 0;   // Tour last keep alive timestamp
	PTZ.tour_audit_cat   = 10;

	PTZ.init = function() {
		if(resourceTree.role.obj != undefined){
			PTZ.lock_timeout = mx.MATRIX2.getIdentityValue("PTZ_LOCK_TIMEOUT")*1000;
			PTZ.lock_priority = mx.MATRIX2.getObjectAttribute(resourceTree.role.obj, "PTZ_PRIORITY");
		}
		else{
			window.setTimeout(function(){
				mx.PTZ.init();
			}, 100);
		}
	};

	PTZ.load = function(objThis) {
		var ptzD = mx.MATRIX2.getServer().getJSXByName("ptzDialog");

		var cellId, objectId;

		if(objThis.ve_ptz) {
			cellId = objThis.cell_id;
			objectId = objThis.obj_id;
		} else {

			var objP = objThis.getClass().getName() == "jsx3.gui.ImageButton"
				? objThis.getAncestorOfName('cell_blk')
				: objThis;

			cellId = objP.getAttribute("cellId");
			objectId = objP.getAttribute("objectId");
		}

		ptzD.setDimensions(0, 0, 220, 600, true);
		ptzD.getFirstChild().setText("[id: "+objectId+"]", true);

		var extended = mx.MATRIX2.getIdentityValue("PTZ_EXTENDED_PRESETS");
		var roleId = resourceTree.role.obj;
		var url = "/ptz/PTZ_tab.php?dev="+objectId+"_"+cellId+"&objid="+objectId+"&save_preset=YES&extended_presets="+extended+"&roleId="+roleId;
		if(window.jsDebug){ appLogger.info("PTZ: url=" + url); }
		ptzD.getDescendantOfName('iframe_ptz').setSrc(url);

		//--needed for MAC scrollbars
		if(navigator.appVersion.indexOf("Mac")!=-1){
			ptzD.getFirstChild().setCSSOverride("overflow: auto;");
			ptzD.getLastChild().setCSSOverride("overflow: auto;");
		}

		ptzD.setVisibility(jsx3.gui.Block.VISIBILITYVISIBLE, true);
		PTZ.camera_id = objectId;
		// hide ptz tours window, if it was opened
		PTZ.close_ptz_tour_window();
	};

	PTZ.checkLoad = function(objThis) {
        var objPl = objThis.getAncestorOfName('cell_blk');
		var nPlayer = mx.MATRIX2.getObjFromIFrame('_mplayer_', objPl);
		if(nPlayer === undefined || nPlayer == null){
			window.setTimeout(function(){ mx.PTZ.checkLoad(objThis); }, 50);
			return;
		}

        var objControls = jsx3.GO('layoutControlComponent').controls;
        if(objControls.group == null || !objControls.group.isPlayerInGroup(nPlayer)){
            alert(__("This player not in active group!"));
            return;
        }

        PTZ.load(objThis);
	};

	PTZ.ptzDialogHide = function() {
		var objP = mx.MATRIX2.getServer().getJSXByName("ptzDialog");
		objP.getDescendantOfName('iframe_ptz').setSrc("about:blank");
		objP.setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
		this.close_ptz_tour_window();
		this.unlockDevice();
	};

	PTZ.setPTZDialogSize = function(w, h) {
		mx.MATRIX2.getServer().getJSXByName("ptzDialog").setDimensions(null, null, w, h, true);
	};

	PTZ.sendCommand = function(command) {
		if(window.jsDebug){ appLogger.info("PTZ.sendCommand: " + command); }
		$.ajax({
			'url': '/ptz/cgi-bin/send_message.pl',
			'async': true,
			'data': {data: command},
			'success': this.processCommandResponse
		});
	};

	PTZ.processCommandResponse = function(data, textStatus, XMLHttpRequest) {
		if(window.jsDebug){ appLogger.info("PTZ.processCommandResponse: " + data); }

		if(!PTZ.process_response){
			PTZ.process_response = true;
			return;
		}

		var ptzD = mx.MATRIX2.getServer().getJSXByName("ptzDialog");
		var frame = mx.MATRIX2.getIFrame(ptzD.getDescendantOfName('iframe_ptz'));

		if(data.lockinfo && data.lockinfo.allow_override != undefined && PTZ.last_command != "mode=lock&cmd=release" && PTZ.last_command != "mode=lock&cmd=keepalive"){
			PTZ.checkLock(data.lockinfo.allow_override)
		}
	};

	/*
		check lock state
	*/
	PTZ.checkLock = function(lockOverride){
		if(PTZ.lock_incheck){
			return;
		}

		if(window.jsDebug){ appLogger.info("PTZ.checkLock: lockOverride="+lockOverride); }
		PTZ.lock_incheck = true;

		if(lockOverride == "sameuser"){
			PTZ.lockDevice();
			PTZ.setLockTimeout();
		}
		else if(lockOverride == "no"){
			alert(__("Another lock is higher priority. You have to wait until controls are released. Please try again later."))
		}
		else if(lockOverride == "yes"){
			var getLock = confirm(__("Another lock is in place. Do you want to override?"));
			if(getLock){
				PTZ.overrideLock();
				PTZ.lockDevice();
			}
			else{
				PTZ.ptzDialogHide();
			}
		}
		PTZ.lock_incheck = false
	};

	/*
		get lock state
	*/
	PTZ.getLock = function(){
		this.execCommand(PTZ.camera_id, "lock", "cmd", "lock", PTZ.lock_priority)
	};

	/*
		override lock
	*/
	PTZ.overrideLock = function(){
		this.execCommand(PTZ.camera_id, "lock", "cmd", "override", PTZ.lock_priority)
	};

	/*
		release lock
	*/
	PTZ.releaseLock = function(){
		this.execCommand(PTZ.camera_id, "lock", "cmd", "release", PTZ.lock_priority)
	};

	/*
		extend lock
	*/
	PTZ.extendLock = function(){
		this.execCommand(PTZ.camera_id, "lock", "cmd", "keepalive", PTZ.lock_priority)
	};

	/**
	* lock device
	*/
	PTZ.lockDevice = function() {
		if(window.jsDebug){ appLogger.info("PTZ.lockDevice: " + PTZ.cell_id); }

		if(jsx3.GO(PTZ.cell_id)){
			var icon = jsx3.GO(PTZ.cell_id).getDescendantOfName("device_type_image");
			icon.setSrc('images/design1/resources/camera_ptz_locked.png').repaint();
		}

		PTZ.setDeviceJitterBuffer(PTZ.camera_id, false);
		PTZ.setLockTimeout();
	};

	/**
	* unlock device
	*/
	PTZ.unlockDevice = function() {
		if(window.jsDebug){ appLogger.info("PTZ.unlockDevice: " + this.cell_id); }

		if(jsx3.GO(this.cell_id)){
			var icon = jsx3.GO(this.cell_id).getDescendantOfName("device_type_image");
			icon.setSrc('images/design1/resources/camera_ptz.png').repaint();
		}

		if(this.lock_ts != null){
			this.clearLockTimeout();
			this.releaseLock();
			PTZ.setDeviceJitterBuffer(PTZ.camera_id, true);
		}

		clearTimeout(window["ptz_keeplock"]);
	};

	/**
	* set PTZ lock timeout
	*/
	PTZ.setLockTimeout = function() {
		if(window.jsDebug){ appLogger.info("PTZ.setLockTimeout=" + PTZ.lock_ts); }
		PTZ.lock_ts = (new Date()).getTime();
		PTZ.checkLockTimeout();
	};

	/**
	* clear PTZ lock timeout
	*/
	PTZ.clearLockTimeout = function() {
		if(window.jsDebug){ appLogger.info("PTZ.clearLockTimeout"); }
		PTZ.lock_ts = null;
		PTZ.alive_ts = null;
		clearTimeout(window["ptz_lock"]);
	};

	/**
	* check PTZ lock timeout
	*/
	PTZ.checkLockTimeout = function() {
		var diff = (new Date()).getTime() - this.lock_ts;
		if(window.jsDebug){ appLogger.info("PTZ.checkLockTimeout: diff="+diff); }
		if(diff >= this.lock_timeout){
			this.ptzDialogHide();
			this.unlockDevice();
		}
		else{
			var diff2 = (new Date()).getTime() - this.alive_ts;
			if(diff2 > this.alive_timeout){
				this.keepLockAlive()
			}
			clearTimeout(window["ptz_lock"]);
			window["ptz_lock"] = window.setTimeout(function(){ mx.PTZ.checkLockTimeout(); }, 2000);
		}
	};

	/**
	* check PTZ session timeout
	*/
	PTZ.keepLockAlive = function() {
		if(window.jsDebug){ appLogger.info("PTZ.keepLockAlive: " + PTZ.camera_id); }
		PTZ.alive_ts = (new Date()).getTime();
		PTZ.extendLock();
		//clearTimeout(window["ptz_keeplock"]);
		//window["ptz_keeplock"] = window.setTimeout(function(){ mx.PTZ.keepLockAlive(); }, PTZ.alive_timeout);
	};

	/**
	* set device jitter buffer
	*/
	PTZ.setDeviceJitterBuffer = function(playerId, on) {
		var cells = $('div[label="cell_blk"][objectid="'+playerId+'"]');

		$.each(cells, function() {
			var cell = mx.MATRIX2.getServer().getJSXById(this.id);
			var nPlayer = mx.MATRIX2.getObjFromIFrame('_mplayer_', cell);
			if(on){
				nPlayer.turnOnJitterBuffer();
			}
			else{
				nPlayer.turnOffJitterBuffer();
			}
		});
	};

	PTZ.clickOnScreen = function(player, x, y) {
		// Check Credentials
		if(resourceTree.cred(player.devObjId, 'p')) {
			this.execCommand(player.devObjId, "rel", "size", $('#' + player.id).width() + "x" + $('#' + player.id).height() + "&xy="+x+","+y, PTZ.lock_priority)
		}
	};

	PTZ.moveAbs = function(objId, Pdegree, Tdegree) {
		// Check Credentials
		if(resourceTree.cred(objId, 'p')) {
			this.execCommand(objId, "abs", "pt", Pdegree+","+Tdegree, PTZ.lock_priority);
		}
	};

    /**
     * execute ptz command
     */
	PTZ.execCommand = function(objId, mode, command, value, priority) {
		// Check Credentials
		if(resourceTree.cred(objId, 'p')) {
			var appendix = "";
			if(priority !== undefined){
				appendix = "&priority=" + priority;
			}
			this.last_command = "mode=" + mode + "&" + command + "=" + value;
			this.sendCommand("<PTZ_Command>do.ptz?dev=" + objId + "&mode=" + mode + "&" + command + "=" + value + appendix + "</PTZ_Command>");

			mx.MATRIX2.clearCurrentDesignationTargets(objId);
		}
	};

	/**
	 * Open PTZ tours dialog window
	 */
	PTZ.manage_ptz_tours = function(id, presets) {

		// Receive number of presets in PTZ dialog; default is 100
		PTZ.preset_number = presets || PTZ.preset_number;

		// Receive user credentionals
		PTZ.can_view = resourceTree.cred(PTZ.camera_id, 'p');
		PTZ.can_edit = resourceTree.cred(PTZ.camera_id, 'P');

		mx.Dialog.createLayoutDialog(
			'ptz_tour',
			__("PTZ TOUR"),
			{'top': '520px', 'width':'312px', 'height':'auto'},
			'<div id="ptz_tour_container"></div>'
		);
		if (mx.language.lang_direction == 'rtl') {
			$('#ptz_tour_container').css({'direction': 'rtl', 'text-align': 'right'});
		}

		PTZ.load_ptz_tours();
		PTZ.paint_ptz_tour_window();
	};

	/**
	 * Keep PTZ tour alive
	 */
	PTZ.keep_ptz_tour_alive = function() {
		var now = (new Date()).getTime();
		if(now - PTZ.tour_alive_ts > 12*1000){
			if(window.jsDebug){ appLogger.info("PTZ.keep_ptz_tour_alive"); }
			PTZ.tour_alive_ts = now;
			PTZ.setLockTimeout();
			PTZ.keepLockAlive();
		}
	};

	/**
	 * Close PTZ tours window
	 */
	PTZ.close_ptz_tour_window = function() {
		$('#ptz_tour').remove();
	};


	/**
	 * Paint tours selector window
	 */
	PTZ.paint_ptz_tour_window = function() {

		$('#ptz_tour_container').html(
			'<span id="ptz_choose_span">' + __("Choose PTZ tour:") + '</span>' +
			'<select id="ptz_tour_selector"></select>'
		).mousemove(function(event) {
			mx.PTZ.keep_ptz_tour_alive();
		});

		if (PTZ.can_view) {
			$('#ptz_tour_container').append(
				'<img id="ptz_tour_start" src="images/design1/player_controls/play_disabled.png"  title="' + __("Start PTZ tour") + '">' +
				'<img id="ptz_tour_stop"  src="images/design1/player_controls/pause_disabled.png" title="' + __("Stop PTZ tour")  + '">'
			);
		}

		$('#ptz_tour_container').append('<div id="ptz_tour_descr"></div>');

		if (PTZ.can_edit) {
			$('#ptz_tour_container').append(
				'<div id="ptz_tour_menu">' +
					'<a href="#" class="dialog_command" id="ptz_tour_new">'    + __("NEW", "ptz tour") + '</a> ' +
					'<a href="#" class="dialog_command" id="ptz_tour_edit">'   + __("EDIT", "ptz tour") + '</a> ' +
					'<a href="#" class="dialog_command" id="ptz_tour_delete">' + __("DELETE", "ptz tour") + '</a>' +
				'</div>'
			);
		}

		$('#ptz_tour_selector').unbind('change').change(function() {PTZ.repaint_ptz_tour()});
		// Build tours selector
		PTZ._repaint_ptz_tours_selector();

		// Select edited tour, if nesessary
		if (PTZ.curr_edit_tour) {
			$('#ptz_tour_selector option[value="' + PTZ.curr_edit_tour + '"]').prop("selected", true);
			PTZ.curr_edit_tour = '';
		}

		PTZ.repaint_ptz_tour();
	};

	/**
	 * Paint edit window, to modify or add new PTZ tour
	 * @param tour_name  name of tour to edit
	 */
	PTZ.paint_ptz_tour_edit = function(tour_name) {

		if (!tour_name) {
			PTZ.curr_edit_tour = '';
			tour_name = __("New PTZ tour")
		} else {
			// Remember tour that we want to edit
			PTZ.curr_edit_tour = tour_name;
		}

		$('#ptz_tour_container').html(
			'<span id="ptz_choose_span">' + __("PTZ tour name:") + '</span>' +
			'<input type="text" id="ptz_tour_name_input" value="">' +
			'<div id="ptz_tour_descr"></div>' +
			'<div id="ptz_tour_menu">' +
				'<a href="#" class="dialog_command" id="ptz_tour_edit_save">'   + __("SAVE TOUR", "ptz tour") + '</a> ' +
				'<a href="#" class="dialog_command" id="ptz_tour_edit_cancel">' + __("CANCEL", "ptz tour")  + '</a>' +
			'</div>'
		);

		$('#ptz_tour_name_input').val(tour_name);
		$('#ptz_tour_edit_cancel').click( PTZ.paint_ptz_tour_window );
		$('#ptz_tour_edit_save').click( PTZ.save_ptz_tour );

		$('#ptz_tour_descr').html(
			'<table style="width:100%">' +
			'<tr>' +
				'<td width="60" id="ptz_preset_list"></td>' +
				'<td width="30"><button id="ptz_add_preset_button" style="padding: 0">&nbsp;-&gt&nbsp;</button></td>' +
				'<td><div id="ptz_edit_tour_container" style="width:100%"><table id="ptz_tour_preset_list" style="width:100%;height:100%"></table></div></td>' +
			'</tr>' +
			'</table>'
		).css('overflow', 'hidden');

		// Add preset list to choose from
		var preset_list = '';
		for (var i = 1; i <= PTZ.preset_number; i++) {
			/* i18n: %1 is a preset number (1-100) */
			preset_list += '<option value="' + i + '">' + Gettext.strargs(__("Preset %1"), [i]) + '</option>';
		}
		preset_list = '<select id="ptz_tour_preset_selector" size="5">' + preset_list + '</select>';
		$('#ptz_preset_list').html(preset_list);

		// Add presets in tour, if such tour exist
		var tour_preset_list = '';
		if (tour_name && PTZ.ptz_tours[tour_name]) {
			for (i = 0; i < PTZ.ptz_tours[tour_name].length; i++) {
				tour_preset_list += PTZ._ptz_tour_preset_row(PTZ.ptz_tours[tour_name][i]);
			}
		}
		$('#ptz_tour_preset_list').html(tour_preset_list);

		// Add button click handler, must add preset to tour
		$('#ptz_add_preset_button').click(function() {
			if (!$('#ptz_tour_preset_selector').val())
				return;
			// add preset into list
			$('#ptz_tour_preset_list').append(PTZ._ptz_tour_preset_row({'preset': $('#ptz_tour_preset_selector').val(), 'time': 5}) );
			// scroll list to the bottom
			$('#ptz_edit_tour_container').attr('scrollTop', '10000');


		});

	};

	/**
	 * Save currently editing tour and return to tour selection
	 */
	PTZ.save_ptz_tour = function() {

		// Check for empty tour name
		var tour_name = $.trim($('#ptz_tour_name_input').val());

		if (!tour_name || tour_name.search(/(\||#|")/g) >= 0) {
			alert(__("You must specify valid tour name, it cannot contain chars |,#,\""));
			return;
		}
		// Check for empty tour
		if (!$('#ptz_tour_preset_list tr').size()) {
			alert(__("You must add at least one step to ptz tour"));
			return;
		}
		// Check for an incorrect step time
		$('#ptz_tour_preset_list tr input').each(function() {
			this.value = $.trim(this.value);
		});
		var $preset_times = $('#ptz_tour_preset_list tr input');
		for (var i = 0; i < $preset_times.size(); i++) {
			if (!$preset_times[i].value || !parseInt($preset_times[i].value) || $preset_times[i].value.search(/\D/) != -1) {
				alert(__("Incorrect value for time"));
				$preset_times[i].focus();
				return;
			}
		}

		var new_tour = PTZ.ptz_tours[tour_name] ? false : true;

		if (!PTZ.curr_edit_tour && !new_tour) {
			if (!confirm(Gettext.strargs(__("Do you really want to overwrite existing ptz tour '%1'?"), [tour_name])))
				return;
		}

		if (PTZ.curr_edit_tour) {
			delete PTZ.ptz_tours[PTZ.curr_edit_tour];
		}

		PTZ.ptz_tours[tour_name] = [];
		$('#ptz_tour_preset_list tr').each(function() {
			PTZ.ptz_tours[tour_name].push({
				'preset': $(this).attr('preset'),
				'time':   $(this).find('input').val()
			});
		});

		PTZ.curr_edit_tour = tour_name;	// remember name of edited tour to select it
		PTZ.save_ptz_tours();
		PTZ.paint_ptz_tour_window();

		auditObj.callAddAuditRecord(PTZ.tour_audit_cat, PTZ.camera_id, {
			digestparams:[ new_tour ? __("Create") : __("Edit") ],
			params:{
				NAME : tour_name
			}
		});
	};

	/**
	 * Run when current tour changed in selector.
	 * Repaint menu and view of current tour.
	 */
	PTZ.repaint_ptz_tour = function() {

		var tour_name = $('#ptz_tour_selector').val();

		// Paint menu according to currently selected tour
		if (!tour_name) {
			$('#ptz_tour_edit,#ptz_tour_delete,#ptz_tour_start,#ptz_tour_stop').css('display', 'none');
		} else {
			$('#ptz_tour_edit,#ptz_tour_delete,#ptz_tour_start,#ptz_tour_stop').css('display', 'inline');

			// If this tour currently running, hide start button
			if (PTZ.curr_run_tour[PTZ.camera_id] == tour_name) {
				$('#ptz_tour_start').css('display', 'none');
			} else {
				$('#ptz_tour_stop').css('display', 'none');
			}
			// Handlers for menu items
			$('#ptz_tour_edit').unbind('click').click(function () {PTZ.paint_ptz_tour_edit(tour_name)});
			$('#ptz_tour_delete').unbind('click').click(function () {PTZ.delete_ptz_tour(tour_name)});
			$('#ptz_tour_start').unbind('click').click(function () {PTZ.activate_ptz_tour(tour_name, 1)});
			$('#ptz_tour_stop').unbind('click').click(function () {PTZ.activate_ptz_tour(tour_name, 0)});
		}
		$('#ptz_tour_new').unbind('click').click(function () {PTZ.paint_ptz_tour_edit("")});

		// If tour is selected, show it in table
		var $descr = $('#ptz_tour_descr');
		if (tour_name) {
			var html =
			'<table class="tour_descr">' +
				'<tr>' +
					'<th>' + __('Step') +      '</th>' +
					'<th>' + __("Preset #") +  '</th>' +
					'<th>' + __("Time, sec") + '</th>' +
				'</tr>';

			for (var i = 0; i < PTZ.ptz_tours[tour_name].length; i++) {
				html +=
				'<tr>' +
					'<td>' + (i+1) + '</td>' +
					'<td>' + PTZ.ptz_tours[tour_name][i].preset + '</td>' +
					'<td>' + PTZ.ptz_tours[tour_name][i].time   + '</td>' +
				'</tr>';
			}

			html += '</table>';

			$descr.html(html);
		} else {
			$descr.html('');
		}
	};

	/**
	 * Delete PTZ tour from inner representation and save into database
	 * @param name    name of tour to delete
	 */
	PTZ.delete_ptz_tour = function(name) {

		if (!PTZ.can_edit || !PTZ.ptz_tours[name])
			return;

		if (confirm(__("Do you really want to delete PTZ tour?"))) {
			delete PTZ.ptz_tours[name];
			PTZ.save_ptz_tours();

			$("#ptz_tour_selector option:selected").remove();
			PTZ.repaint_ptz_tour();

			auditObj.callAddAuditRecord(PTZ.tour_audit_cat, PTZ.camera_id, {
				digestparams:[ __("Delete") ],
				params:{
					NAME : name
				}
			});
		}
	};

	/**
	 * Activate / deactivate selected ptz tour
	 * @param tour_name   name of tour to activate / deactivate
	 * @param is_start    if 0 then deactivate tour, else - activate tour
	 */
	PTZ.activate_ptz_tour = function (tour_name, is_start) {
		if (!PTZ.can_view)
			return;

		if (!is_start) {	// Deactivate tour
			PTZ.sendCommand('<PTZ_Command>do.ptz?dev=' + PTZ.camera_id + '&mode=stopptztour</PTZ_Command>');
			//PTZ.execCommand(PTZ.camera_id, "stopptztour", "1", "1", PTZ.lock_priority)
			PTZ.curr_run_tour[PTZ.camera_id] = '';
			$('#ptz_tour_stop').css('display', 'none');
			$('#ptz_tour_start').css('display', 'inline');

			auditObj.callAddAuditRecord(PTZ.tour_audit_cat, PTZ.camera_id, {
				digestparams:[ __("Stop") ],
				params:{
					NAME : tour_name
				}
			});
		} else {
			var str = PTZ._get_ptz_tour_string(tour_name);
			if (!str)
				return;

			PTZ.sendCommand('<PTZ_Command>do.ptz?dev=' + PTZ.camera_id + '&mode=setptztour&override=' + Math.round(PTZ.lock_timeout / 1000) + '&tour=' + str + '</PTZ_Command>');
			//PTZ.execCommand(PTZ.camera_id, "setptztour", "override", PTZ.lock_timeout + "&tour=" + str, 1)
			PTZ.curr_run_tour[PTZ.camera_id] = tour_name;
			$('#ptz_tour_stop').css('display', 'inline');
			$('#ptz_tour_start').css('display', 'none');

			auditObj.callAddAuditRecord(PTZ.tour_audit_cat, PTZ.camera_id, {
				digestparams:[ __("Activate") ],
				params:{
					NAME : tour_name
				}
			});
		}
		PTZ._repaint_ptz_tours_selector();
		$('#ptz_tour_selector option[value="' + tour_name + '"]').prop("selected", true);
	};

	/**
	 * Load ptz tours from server and parse them into inner representation in PTZ.ptz_tours
	 */
	PTZ.load_ptz_tours = function() {

		// Load ptz tours
		PTZ.ptz_tours = {};
		$.ajax({
			url: '/api/call.php',
			data: {
				'function':   'getAttribute',
				'obj':        PTZ.camera_id,
				'attribute':  'PTZ_TOURS'
			},
			dataType: 'json',
			async: false,
			cache: false,
			success: function(data) {
				PTZ.ptz_tours = $.parseJSON(data['value']) || {};
			}
		});
	};

	/**
	 * Generate string representing all PTZ tours for camera and save it in database
	 */
	PTZ.save_ptz_tours = function() {
		$.ajax({
			url: '/api/call.php',
			type: "POST",
			data:
			{
				'function':   'setAttributes',
				'obj':        PTZ.camera_id,
				'attributes': JSON.stringify({'PTZ_TOURS': JSON.stringify(PTZ.ptz_tours)})
			},
			async: false
		});
	};

	/**
	 * Auxiliary function, builds ptz tour selector
	 */
	PTZ._repaint_ptz_tours_selector = function() {

		var key, i, selector = '';
		var keys = []; // array of tour names to sort
		for(key in PTZ.ptz_tours) if (PTZ.ptz_tours.hasOwnProperty(key)) {
			if (key) {
				keys.push(key);
			}
		}
		keys.sort();
		for (i = 0; i < keys.length; i++) {
			selector += '<option value="' + keys[i] + '">' + keys[i] + '</option>';
		}

		$('#ptz_tour_selector').html(selector);
		$('#ptz_tour_selector option').each(function () {
			$(this).text(this.value + (this.value == PTZ.curr_run_tour[PTZ.camera_id] ? ' ' + __("(running)") : ''));
		});
	};

	/**
	 * Auxiliary function, get string representation for one specified tour
	 * @param name   name of tour
	 */
	PTZ._get_ptz_tour_string = function(name) {

		if (!PTZ.ptz_tours[name])
			return null;

		var i, points = [];
		for (i = 0; i < PTZ.ptz_tours[name].length; i++) {
			points.push(PTZ.ptz_tours[name][i]['preset'] + ':' + PTZ.ptz_tours[name][i]['time']);
		}

		return points.join('|');
	};


	/**
	 * Auxiliary function, return html for table row, which contains one editable step of tour
	 */
	PTZ._ptz_tour_preset_row = function(obj) {
		if (!obj.preset)
			return '';
		return '<tr preset="' + obj.preset + '">' +
			'<td>' + obj.preset + '</td> ' +
			'<td class="ptz_tour_row_edit"><input type="text" value="' + obj.time + '" /> ' + __("sec") + '</td>' +
			'<td><img src="images/design1/dialog/close.png" onclick="$(this).parent().parent().remove()" /></td>' +
		'</tr>';
	};

});
