/**
 * @version $id:$
 * ------------------------------------------------------------------------------
 * media export logic
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2012
 * ------------------------------------------------------------------------------
 */

(function(window){
	"use strict";

	var exporter;

	$(document).ready(function(){
		exporter = new MediaExporter();
		exporter.init("body")
			.fail(function(){
				var message = "cannot init media export plugin";
				window.console && window.console.log(message);
				onNewDataChunk(null, null, message);
			})
			.done(function(){
				onExporterReady();

				this.subscribe("progress", function(size, progress){
					onNewDataChunk(size, progress);
				}, "mediaExporter");

				this.subscribe("error", function(message){
					window.console && window.console.info(message);
					onNewDataChunk(null, null, message);
				}, "mediaExporter");
			});
	});

	function onNewDataChunk(size, progress, error_string)
	{
		if (window.onNewChunk != null && typeof(onNewChunk) === "function")
		{
			try
			{
				window.onNewChunk(size, progress, error_string);
			}
			catch (e)
			{
			}
		}
	}

	function start_export(callback)
	{
		if (parent.mx) {
			parent.mx.MATRIX2.exportCanceled = false;
		}

		var outFileName = null;
		if (outFileName == null)
		{
			if (window.classification != "PUBLIC") {
				outFileName = window.classification.toUpperCase() + "_";
			}
			else {
				outFileName = "";
			}
			outFileName += "media_export_vid_" + window.dev;
			if (audio) {
				outFileName += "_aid_" + window.audio;
			}
			outFileName += "_stm_" + start + "_etm_" + window.end + '.' + window.format;
		}

		outFileName = exporter.selectOutputFile(outFileName);
		if (!outFileName) {
			return;
		}

		if (window.auth) {
			var authParameters = {
				"return": "mediastreamauth",
				"streamtype": "archive",
				"objid": window.dev,
				"time_start": window.timeStart,
				"time_end": window.timeEnd,
				"fmt": window.format
			};

			if (window.audio) {
				authParameters["audioobjid"] = window.audio;
			}

			var api = new API();
			api.authorizationManager(authParameters)
				.fail(function(code, message){
					alert("[" + code + "] " + message);
				})
				.done(function(response){
					callback(response.result.url + "&authorizationid=" + response.result.authid, outFileName);
				});
		} else {
			// Special case for disabled ticket authorization -- single server node assumed (NGC request)
			var streamURL = "rtsp://" + server + ":8554/xmedia?dev=" + window.dev + "&objid=" + window.dev + "&start=" + window.start + "&end=" + window.end;

			if (window.audio) {
				streamURL += '&audio=a' + window.audio;
			}

			streamURL += '&fmt=' + window.format;

			callback(streamURL, outFileName);
		}
	}

	function onExporterReady()
	{
		if (window.onReady != null && typeof(window.onReady) === "function") {
			try
			{
				window.onReady();
			}
			catch (e)
			{
			}
		}

		start_export(function(url, outFileName){
			if (!exporter.startExport(url, outFileName))
			{
				alert("Export failed. See java console");
			}
		});
	}

})(window);
