//---------------------------------------------------------------------------------------------------------------
// This is the Main (initial) Class
//---------------------------------------------------------------------------------------------------------------
jsx3.lang.Package.definePackage("mx.MATRIX2", function(MATRIX2) {
	MATRIX2.cellIdList = [];

	MATRIX2.loaded = false;

	//cells weight limitation
	MATRIX2.curCellsWeight = 0;
    MATRIX2.curVideoCellWeight = 0;

	if(jsx3.CLASS_LOADER.IE){
		MATRIX2.maxCellsWeight = 40;
	}
    else if($.browser.chrome){
        MATRIX2.maxCellsWeight = 40;
    }
	else if($.browser.safari){
		MATRIX2.maxCellsWeight = 60;
	}
	else{
		MATRIX2.maxCellsWeight = 40;
	}
	MATRIX2.videoCellWeight = 1;
	MATRIX2.tourCellWeight = 2;
	MATRIX2.map3dCellWeight = 5;
	MATRIX2.elogCellWeight = 10;

	// array of timeout ids, which stop flashing of cells. Used in setAlert/stopAlert
	// structure: alert cell id => timeout id
	MATRIX2.alertTimeouts = {};

	MATRIX2.identity = { lastUpdated: 0 };

	MATRIX2.MotionSearch = null;

	//get TibcoGI server
	MATRIX2.getServer = function() {
		return matrix2;
	};

	MATRIX2.checkState = function(type, id){
		if(type == 'timeline'){
			var block_timeline = mx.MATRIX2.getServer().getJSXByName("TopTimelineBlock");
			if(window.jsDebug){ appLogger.info("MATRIX2.checkState: block_timeline="+block_timeline); }
			var bState = (block_timeline.getAttribute('status') == "1");
			if(window.jsDebug){ appLogger.info("MATRIX2.checkState: block_timeline.getAttribute('status')="+block_timeline.getAttribute('status')); }
		}
		window.setTimeout(function() {  MATRIX2.checkState(type, id); }, 100);
	};

	/**
	 * Show mask over whole matrix
	 * @param message - mask message | false, if mask has to be removed
	 */
	MATRIX2.mask = function(message) {
		var block = mx.MATRIX2.getServer().getRootBlock();
		if(message) {
			block.showMask(message);
			block.setCursor('waitIndicator', true);
		}
		else {
			block.hideMask();
			block.setCursor('default', true);
		}
	};


	/**
	 * Matrix initialization
	 */
	MATRIX2.init = function() {
		// jQuery ajax setup
		// TODO: remove global ajax setup, use local setup when call
		$.ajaxSetup({
			url: "/api/call.php",
			type: "GET",
			cache: false,
			dataType: "json"
		});

		// CIRRUS_REPLACE_LOGIC_JS_ID002_BEGIN
		mx.MATRIX2.setProductName();
		// CIRRUS_REPLACE_LOGIC_JS_ID002_END

		mx.MATRIX2.getServer().getJSXByName("pane_elogsmall").setAttribute("playerBlock","0");

		//tabs init
		var tabs = mx.MATRIX2.getServer().getJSXByName('tabbedpaneMain').getChildren();
		for(var i=0;i<tabs.length;i++){
			//if no children in tab
			if(!tabs[i].getFirstChild().getFirstChild()){
				tabs[i].getFirstChild().setAttribute("playerBlock", "0");
			}
		}

		mx.CT.initTabs();

		//attach controls class
		var control = jsx3.GO("layoutControlComponent");
		control.controls = new mx.GroupControl(control,null,30000,true,true,true,new Date().getTime()-300000,new Date().getTime());
		// Global variable to easy access to GroupControls
		groupControls = control.controls;

		mx.CT.onTabSelect(tabs[0]);
        mx.MATRIX2.checkSystemClassification();

		if(window.jsUserCellWarn == ""){
			window.jsUserCellWarn = 1000000;
		}
		if(window.jsUserCellMax == ""){
			window.jsUserCellMax = 1000000;
		}

		window.jsUserCellWarn = parseInt(jsUserCellWarn, 10);
		window.jsUserCellMax = parseInt(jsUserCellMax, 10);

		if(window.jsUserCellWarn > window.jsUserCellMax){ window.jsUserCellWarn = window.jsUserCellMax; }

		//MATRIX2.initAvatarOnDemand();

		// show content download manager icon
		showElementsWithName('image_cdm');
		MATRIX2.getServer().getJSXByName("image_cdm").setCanDrag(jsx3.Boolean.TRUE);
		
		mx.MATRIX2.addHTMLSound("notify", "assets/eventlog/notify.mp3");
// CLARE_REPLACE_MATRIXJS_ID003_BEGIN

// CLARE_REPLACE_MATRIXJS_ID003_END
	};


	//------------------------------------------------------------------------------------------------------------------------------
	// Create Cell
	//------------------------------------------------------------------------------------------------------------------------------
	MATRIX2.createCell = function(objId, objName, objDest, elAlert, ts_from, ts_to, inArchive, isLimitChecked, noAudit, streamNum) {
		if(window.jsDebug){ appLogger.info("MATRIX2.createCell: objDest="+objDest); }

		if(typeof(objDest) == "string"){
			objDest = MATRIX2.getServer().getJSXById(objDest);
		}

		var needCheckUserLimit = !(objDest.getAttribute("playerWarning") == "1" || objDest.getAttribute("playerBlock") == "1");

		MATRIX2.clearDestinationBlock(objDest);

		if(!MATRIX2.checkCellsLimit(MATRIX2.videoCellWeight, true)){
			return null;
		}
		MATRIX2.curVideoCellWeight++;

		if(needCheckUserLimit && !isLimitChecked && !MATRIX2.checkUserCellsLimit(objId, objName, objDest, elAlert, ts_from, ts_to, inArchive)){
			return null;
		}

		var camera = resourceTree.getObject(objId);
		
		var objControls = mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls;

		var modeA, modeL;

		// Check credentials for Live and Archive Playback access
		if( ts_from != null && ts_to != null && camera.cred('A') ) {
			modeA = true;
		} else {
			modeA = false;
			modeL = camera.cred('L');
		}

		if(camera.cred('A')) {
			modeA = true;
			if(inArchive == true){
				modeL = false;
			}
		}

		//DE690
		if(!modeL && modeA && ts_from == null && ts_to == null){
			var now = MATRIX2.getServerTime();
			if(ts_from == null){
				ts_from = now - 300000;
			}
			if(ts_to == null){
				ts_to = now;
			}
		}

		//if(window.jsDebug){ appLogger.info("MATRIX2.createCell: modeA="+modeA+", modeL="+modeL+", ts_from="+ts_from+", ts_to="+ts_to); }
		objDest.setAttribute("playerBlock", "1");
		var cellId = "_"+ifr_count;

		var path = "components/gui_cell.xml";
		var cellObj = mx.language.load_translate(objDest, path);

		cellObj.messageSet = function(strI) {
			var strM = "<table width='100%' height='100%'><tr><td><center><font size='1'>" + strI + "</font></center></td></tr></table>";
			this.getDescendantOfName('message_player').setText(strM, true);
		};

		cellObj.messageShow = function() {
			if(jsx3.CLASS_LOADER.IE || jsx3.CLASS_LOADER.SAF) {
				this.getDescendantOfName('iframe_player').setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
				this.getDescendantOfName('image_player').setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
				this.getDescendantOfName('message_player').setDisplay(jsx3.gui.Block.DISPLAYBLOCK, true);
			} else if(jsx3.CLASS_LOADER.FX) {
				// Must be replaced with Dialog component, centered in the cell
				//alert(this.getDescendantOfName('message_player').getText());
				alert(__("Cell set problem (Possible cause - not sufficient credentials).\n Please contact your system administrator."));
			}
		};

		cellObj.messageHide = function() {
			if(jsx3.CLASS_LOADER.IE || jsx3.CLASS_LOADER.SAF) {
				this.getDescendantOfName('message_player').setDisplay(jsx3.gui.Block.DISPLAYNONE , true);
				this.getDescendantOfName('image_player').setDisplay(jsx3.gui.Block.DISPLAYBLOCK, true);
				this.getDescendantOfName('iframe_player').setDisplay(jsx3.gui.Block.DISPLAYBLOCK, true);
			} else if(jsx3.CLASS_LOADER.FX) {
			}
		};

		if(!modeA && !modeL) {
			if(jsx3.CLASS_LOADER.IE || jsx3.CLASS_LOADER.SAF) {
				var strI = __("Not sufficient credentials to play the video stream.<br><i>Please contact your system administrator.</i>");
				var strM = "<table width='100%' height='100%'><tr><td><center><font size='1'>"+strI+"</font></center></td></tr></table>";
				cellObj.getDescendantOfName('iframe_player').setDisplay(jsx3.gui.Block.DISPLAYNONE, false);
				cellObj.getDescendantOfName('image_player').setDisplay(jsx3.gui.Block.DISPLAYNONE, false);
				cellObj.getDescendantOfName('message_player').setDisplay(jsx3.gui.Block.DISPLAYBLOCK, false);
				cellObj.getDescendantOfName('message_player').setText(strM , false);
				cellObj.getDescendantOfName('message_player').getParent().repaint();

				cellObj.getDescendantOfName('cell_dev_type').setCanDrag(jsx3.Boolean.FALSE, false);
				cellObj.getDescendantOfName('cell_dev_state').setDisplay(jsx3.gui.Block.DISPLAYNONE, false);
				cellObj.getDescendantOfName('cell_dev_name').setText("");
				cellObj.getDescendantOfName('cell_joystick').setDisplay(jsx3.gui.Block.DISPLAYNONE, false);
				cellObj.getDescendantOfName('cell_sound').setDisplay(jsx3.gui.Block.DISPLAYNONE, false);
				cellObj.getDescendantOfName('cell_pin').setDisplay(jsx3.gui.Block.DISPLAYNONE, false);
				cellObj.getDescendantOfName('cell_jump').setDisplay(jsx3.gui.Block.DISPLAYNONE, false);
				objDest.repaint();
				return cellObj;
			} else if(jsx3.CLASS_LOADER.FX) {
				alert(__("Not sufficient credentials to play the video stream.\nPlease contact your system administrator."));
				objDest.removeChildren();
				objDest.setAttribute("playerBlock", "0");
				return cellObj;
			}
		}

		cellObj.setAttribute("objectId", objId.toString());
		cellObj.setAttribute("cellId", cellId.toString());
		cellObj.setAttribute("eventid", "-1");
		cellObj.setAttribute("time_zone", camera.attr("TIME_ZONE"));

		cellObj.setAttribute("onmouseover", "mx.MATRIX2.changeSrcMEnter(this, event)");
		cellObj.setAttribute("onmouseout", "mx.MATRIX2.changeSrcMLeave(this, event)");

		var headerName = objName;
		//if cell is event set eventId and timestamps
		if (objName.indexOf(__("Event ID: ")) != -1) {
			var newEventId = objName.slice(__("Event ID: ").length);
			cellObj.setAttribute("eventid", newEventId);

			cellObj.setAttribute("ts_from", ts_from.toString());
			cellObj.setAttribute("ts_to", ts_to.toString());
			cellObj.setAttribute("event_ts_from", ts_from.toString());
			cellObj.setAttribute("event_ts_to", ts_to.toString());
			headerName += " - " + camera.name;

            var j2e_button = cellObj.getDescendantOfName('cell_jump2event');
            j2e_button.setTip(__("Jump to event"));
            j2e_button.setEvent("mx.MATRIX2.setSelectedGroup(this, false, false); mx.TIMELINE.jump2event("+ts_from.toString()+", '"+cellObj.getId()+"');", jsx3.gui.Interactive.EXECUTE);
			MATRIX2.setButtonInCellHeader(cellObj, 'cell_jump2event', true);
		}
		else{
			headerName = (camera.attr('UDID') == null ? '' : '['+camera.attr('UDID')+'] ') + headerName;
		}

		cellObj.setAttribute("cell_age_utc", (new Date()).getTime().toString());
		cellObj.getDescendantOfName('cell_dev_name').setText(headerName, false);

		cellObj.getDescendantOfName("device_type_image").setSrc('images/design1/resources/' + camera.image);

		// Check PTZ
		if(!camera.cred('p') || camera.attr('POSITIONCTL') == "none" || !camera.attr('POSITIONCTL')) {
			MATRIX2.setButtonInCellHeader(cellObj, 'cell_joystick', false);
			cellObj.setAttribute("position_control", "0");
		} else {
			// forbid creation of target for PTZ cameras
			MATRIX2.setButtonInCellHeader(cellObj, 'set_target', false);

            cellObj.getDescendantOfName('cell_joystick').setEvent("mx.MATRIX2.setSelectedGroup(this, false, false); mx.PTZ.checkLoad(this)", jsx3.gui.Interactive.EXECUTE);
			cellObj.setAttribute("position_control", "1");
		}

		var pObj = objDest.getDescendantOfName('cell_player');
		pObj.setOverflow(jsx3.gui.Block.OVERFLOWHIDDEN);
		pObj.getDescendantOfName('iframe_player').setScrolling(jsx3.gui.IFrame.SCROLLNO);

		objDest.setText("", true);

		//detect audio params
		var assocAudioRec = resourceTree.getObject({'belongs2devid': objId});
		var audioId = "";

		if( modeL ) {
			cellObj.setAttribute("player_mode", "0"); // 0-live
			cellObj.getDescendantOfName('cell_dev_state').setAttribute("onclick","mx.MATRIX2.quickSwitch2archive(jsx3.GO(this.id).getAncestorOfName('cell_blk'), false);");
			var strSrc = "cell_player.php?name="+cellObj.getId()+
			"&camera="+objId+
			"&width="+(pObj.getAbsolutePosition().W)+
			"&height="+(pObj.getAbsolutePosition().H);

            if(assocAudioRec && camera.attr('AUDIO') == "on" && assocAudioRec.obj && assocAudioRec.cred('L')) {
                audioId = assocAudioRec.obj;
			    strSrc+= "&audioobjid=" + assocAudioRec.obj;
		    }

			cellObj.getDescendantOfName('cell_dev_state').setTip(__("Switch cell to Archive"));

			MATRIX2.setButtonInCellHeader(cellObj, 'cell_deliver', false);
		}
		else {
			cellObj.setAttribute("player_mode", "1"); // 1 or ... - archive
			cellObj.getDescendantOfName('cell_dev_state').setAttribute("onclick","mx.MATRIX2.quickSwitch2live(jsx3.GO(this.id).getAncestorOfName('cell_blk'), false);");
			var strSrc = "cell_player.php?name="+cellObj.getId()+
			"&camera="+objId+
			"&width="+(pObj.getAbsolutePosition().W)+
			"&height="+(pObj.getAbsolutePosition().H)+
			"&ts_from=" + mx.TIME.formatUTCDate(ts_from, 'YYYY-MM-DD HH-II-SS') +
			"&ts_to=" + mx.TIME.formatUTCDate(ts_to, 'YYYY-MM-DD HH-II-SS') +
			"&initstate=Idle";

            if(assocAudioRec && camera.attr('AUDIO') == "on" && assocAudioRec.obj && assocAudioRec.cred('A')) {
                audioId = assocAudioRec.obj;
			    strSrc+= "&audioobjid=" + assocAudioRec.obj;
		    }

            if(cellObj.getAttribute("eventid") != "-1"){
                strSrc+= "&eventid=" + cellObj.getAttribute("eventid");
            }

			if(noAudit == true){
                strSrc+= "&noaudit";
            }

			cellObj.getDescendantOfName('cell_dev_state').setTip(__("Switch cell to Live"));
			cellObj.getDescendantOfName('cell_dev_state').setSrc('images/design1/gui_cell/cell_archive.png');

			if(camera.attr('AVATARID')){
				MATRIX2.setButtonInCellHeader(cellObj, 'cell_deliver', true);
			}
			
			objControls.allowJumpOverHolesInArchive = 0;
		}

		strSrc+= "&skip_gaps=" + jsx3.GO('layoutControlComponent').controls.allowJumpOverHolesInArchive;

        if (camera.attr('AVATARID')) {
			// detect default value
			var initStreamNum = 1;			
			var LRDeliveryArr = [
				"LIVE_LR|ARCHIVE_LR",
				"LIVE_LR|ARCHIVE_LR|ARCHIVE_EVENTS_NR|METADATA_EVENTS",
				"ARCHIVE_EVENTS_LR|METADATA_EVENTS",
				"METADATA_EVENTS"
			];
			if($.inArray(camera.attr('AV_DELIVERY_HR'), LRDeliveryArr) != -1){
				initStreamNum = 0;
			}
			
			// use passed parameter if exists
			if(streamNum !== undefined){
				initStreamNum = streamNum;
			}
			
            strSrc+= "&streamnum=" + initStreamNum;
			MATRIX2.updateResolutionButton(cellObj.getDescendantOfName('cell_stream_quality'), initStreamNum);
        }

		strSrc = '/TibcoGI/JSXAPPS/mx/' + strSrc;
		if(window.jsDebug){
            strSrc+= "&debug=1";
            appLogger.info("MATRIX2.createCell: strSrc=" + strSrc);
        }
		cellObj.getDescendantOfName('cell_dev_state').repaint();
		pObj.getDescendantOfName('iframe_player').setSrc(strSrc);

		if(jsx3.CLASS_LOADER.IE) {
			pObj.getDescendantOfName('image_player').setCSSOverride("filter:progid:DXImageTransform.Microsoft.Alpha(opacity=20)");
		}

		pObj.getDescendantOfName('image_player').setWidth(pObj.getAbsolutePosition().W);
		pObj.getDescendantOfName('image_player').setHeight(pObj.getAbsolutePosition().H);
		ifr_count++;

		if(elAlert) {
			MATRIX2.setAlert(objDest.getDescendantOfName('cell_alert'));
		}

		/////////////////////////////////////////////////////////////////////////////////////////////
		// check analytics parameters
		var attrDayOfWeek = ["ssunday","smonday","stuesday","swednesday","sthursday","sfriday","ssaturday"];
		var dayIndex = (new Date()).getDay();
		var daySchedule = camera.attr(attrDayOfWeek[dayIndex]);
		var scheduleActive = false;

		// Check if schedule is active
		if(daySchedule && daySchedule != ""){
			//Example: 12:00-13:00!AN|15:00-16:00!AN|
			var todaySchedules = daySchedule.split("|");
			for(var i = 0; i < todaySchedules.length; i++){
                var scheduleType = todaySchedules[i].split("!");
				if(todaySchedules[i] != "" && scheduleType[1] == "AN"){
					var todayTimes = todaySchedules[i].slice(0, 11).split("-");
					var startTime = todayTimes[0].split(":");
					var endTime = todayTimes[1].split(":");
					var startH = parseInt(startTime[0], 10);
					var startM = parseInt(startTime[1], 10);
					var endH = parseInt(endTime[0], 10);
					var endM = parseInt(endTime[1], 10);
					var curH = (new Date()).getUTCHours();
					var curM = (new Date()).getUTCMinutes();
					if(
					(startH<curH || (startH==curH && startM<=curM))
					&&
					(endH>curH || (endH==curH && endM>curM))){
						scheduleActive = true;
					}
					//appLogger.info("ANALYTICS: "+startTime[0]+":"+startTime[1]+" "+endTime[0]+":"+endTime[1]);
				}
			}
		}

		// CIRRUS_REPLACE_MATRIX2_JS_ID001_BEGIN
		var analyticsState = camera.attr('VAE_VISUALIZATION');

		cellObj.getDescendantOfName('cell_anl').setEvent("mx.MATRIX2.setSelectedGroup(this, false, false);OnAnalyticsState(this.getId());", jsx3.gui.Interactive.EXECUTE);

		//appLogger.info("Analytics: " + camera.attr('analytics') + ", Analytics visualisation: " + camera.attr('analytics_visualization'));
		// If analytics is in active state
		if(camera.attr('VAE_ACTIVE') == 'yes' || (camera.attr('VAE_ACTIVE') == 'schedule' && scheduleActive)){
			MATRIX2.setButtonInCellHeader(cellObj, 'cell_anl', true);
			OnAnalyticsState(cellObj.getDescendantOfName('cell_anl').getId(), analyticsState);
		}
		/////////////////////////////////////////////////////////////////////////////////////////////
		// CIRRUS_REPLACE_MATRIX2_JS_ID001_END

		///////////////////////////////////////////S613
		// Applying Audio support
        var audioObj = resourceTree.getObject(audioId);
		if(window.jsDebug){ appLogger.info("MATRIX2.createCell: camera.attr('audio')="+camera.attr('AUDIO')+", audioId="+audioId+", audioObj="+audioObj); }
		if(audioId != "" && audioObj){
			var soundButton = cellObj.getDescendantOfName('cell_sound');
			soundButton.setImage("jsxuser:///images/design1/gui_cell/cell_audio_off.png");
			soundButton.repaint();
			MATRIX2.setButtonInCellHeader(cellObj, 'cell_sound', true);

			//if devices from same node
			//if(false && camera.attr("legacyNodeName") == assocAudioRec.attr("legacyNodeName")){
				soundButton.setEvent("mx.MATRIX2.setSelectedGroup(this, false, false); mx.MATRIX2.playBuildInSound(this);", jsx3.gui.Interactive.EXECUTE);
			/*}
			else{
				cellObj.setAttribute("assocAudioId", assocAudioRec.obj);
				cellObj.setAttribute("state","pause");

				soundButton.setEvent("mx.MATRIX2.playSound(this,true);", jsx3.gui.Interactive.EXECUTE);
				soundButton.getAncestorOfName("cell_blk").getDescendantOfName('iframe_sound_player').setSrc("cell_player.php?camera="+assocAudioRec.obj+"&name=SoundPlayer"+cellObj.getId()+"&width=1&height=1&initstate=Idle");
			}*/
		}
		else{
			MATRIX2.setButtonInCellHeader(cellObj, 'cell_sound', false);
		}

        // Check device metadata support
        if (camera.attr('STAT_METADATA_RECEIVING') == "YES") {
            if (window.jsDebug) {
                appLogger.info("MATRIX2.createCell: metadata=" + camera.attr('METADATATAG_INFO'));
            }
            var metadata = $.parseJSON(camera.attr('METADATATAG_INFO'));
            var strData = '<data jsxid="jsxroot">';
            for (var i = 0; i < metadata.length; i++) {
                strData += '<record jsxid="' + jsx3.xml.CDF.getKey() + '" jsxtext="' + metadata[i].description + '" jsxtip="' + metadata[i].description + '" tag="' + metadata[i].tag + '"/>';
            }
            strData += '</data>';

            //if(window.jsDebug){ appLogger.info("MATRIX2.createCell: metadata length="+metadata.length+", CDF=" + strData); }

            if (metadata.length > 0) {
                var doc = jsx3.xml.CDF.Document.newDocument().loadXML(strData);

                var doc_name = 'CELL_METADATA_' + camera.obj;
                mx.MATRIX2.getServer().Cache.setDocument(doc_name, doc);

                var select_timezone = cellObj.getDescendantOfName('matrixMetadata');
                select_timezone.setEvent("mx.MATRIX2.setSelectedGroup(this, false, false);mx.MATRIX2.setCellMetadata(this);", jsx3.gui.Interactive.CHANGE);
                select_timezone.setXMLId(doc_name).repaint();

                cellObj.getDescendantOfName('layoutCellContent').setCols("*,0", true);
                cellObj.setAttribute("tweak_open", "0");
                cellObj.getDescendantOfName('cell_metadata').setEvent("mx.MATRIX2.openHideCellTweak(this);", jsx3.gui.Interactive.EXECUTE);
                cellObj.getDescendantOfName('cell_metadata').setTip(__("Show metadata tweak panel"));
				MATRIX2.setButtonInCellHeader(cellObj, 'cell_metadata', true);
            }
        }
        else {
			MATRIX2.setButtonInCellHeader(cellObj, 'cell_metadata', false);
        }

        //check geo parameters
        if(window.jsDebug){ appLogger.info("MATRIX2.createCell: cam_geo_calibration="+camera.attr('CAM_GEO_CALIBRATION')+", lat=" + camera.attr("CAM_GEO_LAT")+", long="+camera.attr("CAM_GEO_LONG")); }
        if(camera.attr('CAM_GEO_CALIBRATION') != "no" && camera.attr("CAM_GEO_LAT") != "" && camera.attr("CAM_GEO_LONG") != ""){
			var cell_jump2geo = cellObj.getDescendantOfName('cell_jump2geo');
			cell_jump2geo.subscribe(
				jsx3.gui.Interactive.EXECUTE,
				function(){
					mx.MATRIX2.setSelectedGroup(cell_jump2geo, false, false);
					if (mx.GE.isGE())
					{
						mx.GE.showCameras(objId, false);
					}
					if (mx.MAP.isMap())
					{
						var mapCells = $('div[label="map_cell"]');

						$.each(mapCells, function() {
							var curCell = mx.MATRIX2.getServer().getJSXById(this.id);
							mx.MAP.panTo(curCell, objId);
						});				
					}
				}
			);

			cell_jump2geo.setTip(__("Show camera in map"));
			MATRIX2.setButtonInCellHeader(cellObj, 'cell_jump2geo', true);
            if(window.jsDebug){ appLogger.info("MATRIX2.createCell: button set OK"); }
        }
        else{
			MATRIX2.setButtonInCellHeader(cellObj, 'set_target', false);
			MATRIX2.setButtonInCellHeader(cellObj, 'cell_jump2geo', false);
        }

        //S874
		cellObj.getDescendantOfName('cell_timezone').setEvent('mx.TIME.applyCameraTimezone("' + camera.attr('TIME_ZONE') + '");', jsx3.gui.Interactive.EXECUTE);

		MATRIX2.cellIdList.push(cellObj.getId());

		return cellObj;
	};

	/*
		show/hide button in cell header
	*/
	MATRIX2.setButtonInCellHeader = function(objCell, strButton, status){
		var newState = status ? jsx3.gui.Block.DISPLAYBLOCK : jsx3.gui.Block.DISPLAYNONE;
		objCell.getDescendantOfName(strButton).setDisplay(newState, true);
		MATRIX2.updateCellHeader(objCell);
	};

	/*
		update layout of cell header
	*/
	MATRIX2.updateCellHeader = function(objCell){
		var newWidth = 0;
		var buttons = objCell.getDescendantOfName("cell_header").getChild(2).getDescendantsOfType(jsx3.gui.ImageButton, true);
		for(var i = 0 ; i < buttons.length ; i++){
			if(buttons[i].getDisplay() != jsx3.gui.Block.DISPLAYNONE){
				newWidth+= buttons[i].getWidth() + 2;
			}
		}
		var colSizes = objCell.getDescendantOfName("cell_header").getCols().split(",");
		objCell.getDescendantOfName("cell_header").setCols("*,"+colSizes[1]+","+newWidth+",20", true);
	};

    /*
    * open/hide cell tweak panel
    * */
	MATRIX2.openHideCellTweak = function(objButton){
        var cell_blk = objButton.getAncestorOfName("cell_blk");
        if(cell_blk.getAttribute("tweak_open") == "0"){
            objButton.setTip(__("Hide metadata tweak panel"));
            cell_blk.setAttribute("tweak_open", "1");
            cell_blk.getDescendantOfName('layoutCellContent').setCols("*,150", true);
        }
        else{
            objButton.setTip(__("Show metadata tweak panel"));
            cell_blk.setAttribute("tweak_open", "0");
            cell_blk.getDescendantOfName('layoutCellContent').setCols("*,0", true);
        }

        //set new applet player size
        var nPlayer = MATRIX2.getObjFromIFrame('_mplayer_', cell_blk);
		var playerW = cell_blk.getDescendantOfName('cell_player').getAbsolutePosition().W;
		var playerH = cell_blk.getDescendantOfName('cell_player').getAbsolutePosition().H;
		if(playerW != 0 && playerH != 0 && nPlayer != undefined && nPlayer != null) {
			nPlayer.setSize(playerW, playerH);
        }
	};

    /*
    * set cell metadata to player
    * */
	MATRIX2.setCellMetadata = function(objMatrix){
        var objCell = objMatrix.getAncestorOfName("cell_blk");
        var nPlayer = MATRIX2.getObjFromIFrame('_mplayer_', objCell);
        var selNodes = objMatrix.getSelectedNodes();

        var jsonParam = "[";
		var jsonParamObject = [];

		for (var i = 0; i < selNodes.size(); i++){
			jsonParam += '{"tag":"' + selNodes.get(i).getAttribute("tag") + '", "view" : [ "value" ]},';
			jsonParamObject.push({
				"tag": selNodes.get(i).getAttribute("tag"),
				"view": ["value"]
			});
		}
		if (selNodes.size() > 0 && jsonParam !== "["){
			jsonParam = jsonParam.substring(0, jsonParam.length - 1);
		}
		jsonParam += "]";

        if(nPlayer){
			var isApplet = !(navigator.appVersion.indexOf("Mac") > -1 || navigator.appVersion.indexOf("Windows") > -1);
			var value = jsonParam;
			if (!isApplet)
			{
            	value = jsonParamObject;
			}
			nPlayer.playerImpl.setParameter("metadataTagInfo", value);

            if(window.jsDebug){ appLogger.info("MATRIX2.setCellMetadata: jsonParam=" + jsonParam); }
        }
        else{
            //delay if player not initialized
            if(window['metadata_var_'+objCell.getId()]){
                clearTimeout(window['metadata_var_'+objCell.getId()]);
            }
		    window['metadata_var_'+objCell.getId()] = window.setTimeout(function() { MATRIX2.setCellMetadata(objMatrix); }, 100);
        }
	};

	//check cell limit
	MATRIX2.checkCellsLimit = function(weight, isAddRemove){ //isAddRemove: true - add, false remove
		if(isAddRemove){
			if(MATRIX2.curCellsWeight + weight > MATRIX2.maxCellsWeight){
				alert(__("Cells limit reached! Cell couldn't be added."));
				return false;
			}
			else{
				MATRIX2.curCellsWeight+= weight;
				//appLogger.info("checkCellsLimit: ADD, new weight "+MATRIX2.curCellsWeight);
				return true;
			}
		}
		else{
			MATRIX2.curCellsWeight-= weight;
			//appLogger.info("checkCellsLimit: REM, new weight "+MATRIX2.curCellsWeight);
			return true;
		}
	};

	/*
		execute delayed video cell drop
	*/
	MATRIX2.delayedCellDrop = function(cellId){
        var cell = mx.MATRIX2.getServer().getJSXById(cellId);
        if(cell.delayedDrop != null){
		    MATRIX2.createCell(cell.delayedDrop.objId, cell.delayedDrop.objName, cell.delayedDrop.objDest, cell.delayedDrop.elAlert, cell.delayedDrop.ts_from, cell.delayedDrop.ts_to, cell.delayedDrop.inArchive, true);
		    window.setTimeout(function(){ cell.delayedDrop = null; }, 100);
        }
	};

	/*
		cancel delayed video cell drop
	*/
	/*
	MATRIX2.cancelDelayedCellDrop = function(cellId){
		mx.MATRIX2.curCellsWeight -= mx.MATRIX2.videoCellWeight;
        mx.MATRIX2.curVideoCellWeight--;
        var cell = mx.MATRIX2.getServer().getJSXById(cellId);
        cell.delayedDrop = null;
        cell.removeAttribute("playerWarning").setText("", true);
	};
	*/

	//check user cell limit
	MATRIX2.checkUserCellsLimit = function(objId, objName, objDest, elAlert, ts_from, ts_to, inArchive){
		//if(window.jsDebug){ appLogger.info("MATRIX2.checkUserCellsLimit: weight=" + MATRIX2.curCellsWeight + "; params:" + objId +","+ objName +","+ objDest +","+ elAlert +","+ ts_from +","+ ts_to +","+ inArchive); }
		var newWeight = MATRIX2.curVideoCellWeight;

		var message = "";

        if(window.jsDebug){ appLogger.info("MATRIX2.checkUserCellsLimit: New="+newWeight+", Warn="+parseInt(window.jsUserCellWarn)+", Max="+parseInt(window.jsUserCellMax)); }

		if(newWeight > parseInt(window.jsUserCellWarn) && newWeight <= parseInt(window.jsUserCellMax)){

			objDest.delayedDrop = {};
			objDest.delayedDrop.objId = objId;
			objDest.delayedDrop.objName = objName;
			objDest.delayedDrop.objDest = objDest;
			objDest.delayedDrop.elAlert = elAlert;
			objDest.delayedDrop.ts_from = ts_from;
			objDest.delayedDrop.ts_to = ts_to;
			objDest.delayedDrop.inArchive = inArchive;

			message+= "<div id='limit_alert" + objDest.getId() + "' name='limit_alert' style='background-color:#FF9400; width:100%; height:100%; text-align:center'>";
			message+= "<table width='100%' height='100%' valign='middle'>";
			message+= "<tr><td>";
			message+= __("More video cells could slow down your perfomance!");
			message+= "<br /><input type='button' value='"+__("Continue")+"' onclick='mx.MATRIX2.delayedCellDrop(\"" + objDest.getId() + "\")' />";
			message+= "<input type='button' value='"+__("Cancel")+"' onclick='mx.MATRIX2.clearDestinationBlock(mx.MATRIX2.getServer().getJSXById(\""+objDest.getId()+"\"))' />";
			message+= "</td></tr>";
			message+= "</table>";
			message+= "</div>";

			objDest.setAttribute("playerWarning", "1").setText(message, true).repaint();
			if(window.jsDebug){ appLogger.info("MATRIX2.checkUserCellsLimit: WARN"); }
			return false;
		}
		else if(newWeight > parseInt(window.jsUserCellMax)){
			message+= "<div id='limit_alert" + objDest.getId() + "' name='limit_alert' style='background-color:#B70000; width:100%; height:100%; text-align:center'>";
			message+= "<table width='100%' height='100%' valign='middle'>";
			message+= "<tr><td>";
			message+= __("You reached video cells limit!");
			message+= "<br /><input type='button' value='"+__("Cancel")+"' onclick='mx.MATRIX2.clearDestinationBlock(mx.MATRIX2.getServer().getJSXById(\""+objDest.getId()+"\"))' />";
			message+= "</td></tr>";
			message+= "</table>";
			message+= "</div>";
			objDest.setText(message, true).repaint();
			if(window.jsDebug){ appLogger.info("MATRIX2.checkUserCellsLimit: ALERT"); }
			MATRIX2.curVideoCellWeight--;
			return false;
		}

		objDest.delayedDrop = null;
		if(window.jsDebug){ appLogger.info("MATRIX2.checkUserCellsLimit: OK"); }
		return true;
	};


	MATRIX2.beforeSplitterResize = function(objSplitter){
		if(jsx3.CLASS_LOADER.IE || jsx3.CLASS_LOADER.SAF) {
		} else if(jsx3.CLASS_LOADER.FX) {//DE462
 			objSplitter.getFirstChild().showMask();
			objSplitter.getLastChild().showMask();
		}
	};

	MATRIX2.afterSplitterResize = function(objSplitter, objEVENT, objGUI, fpPCT1){
		if(jsx3.CLASS_LOADER.IE || jsx3.CLASS_LOADER.SAF) {
		} else if(jsx3.CLASS_LOADER.FX) {//DE462
			objSplitter.getFirstChild().hideMask();
			objSplitter.getLastChild().hideMask();
		}

		objSplitter._jsxmoving = true;
		objSplitter._doResizeEnd(objEVENT);

		objSplitter._jsxmoving = true;
		objSplitter._doResizeEnd(objEVENT);

		//DE3595
		var timeout = 0;
		if(jsx3.CLASS_LOADER.IE){
			timeout = 100
		}
		window.setTimeout(function(){
			if(window.jsDebug){ appLogger.info("MATRIX2.afterSplitterResize: objGUI="+objGUI+",fpPCT1="+fpPCT1); }
			mx.MATRIX2.splitterResize(objSplitter, objEVENT);
		}, timeout)
	};

	/**
	 *
	 * @param objDest  {Tibco object} - object to add splitter
	 * @param splOrientation  orientation of splitter
	 * @param percent_first   size of first subcontainer, %
	 * @param checkSize       check size of objDest
	 */
	MATRIX2.addSplitter = function(objDest, splOrientation, percent_first, checkSize) {
		// Parameters by default
		percent_first = percent_first || '50%';
		if (checkSize == undefined) {
			checkSize = true;
		}

		if (checkSize) {
			if(splOrientation == jsx3.gui.Splitter.ORIENTATIONH) {
				if( objDest.getAbsolutePosition().W < (2 * splSubcontainer_1_2_min)+3 ) {
					alert(__("Cell size isn't enough to be split.\nPlease increase the cell size."));
					return false;
				}
			} else if(splOrientation == jsx3.gui.Splitter.ORIENTATIONV) {
				if( objDest.getAbsolutePosition().H < (2 * splSubcontainer_1_2_min)+3 ) {
					alert(__("Cell size isn't enough to be split.\nPlease increase the cell size."));
					return false;
				}
			} else {
				alert("ERROR: in addSplitter procedure.");
				return false;
			}
		}

		MATRIX2.clearDestinationBlock(objDest);

		objDest.removeAttribute("playerBlock");
		var objSplitter = new jsx3.gui.Splitter(('spl'+ifr_count), splOrientation);
		objSplitter.setSubcontainer1Min(splSubcontainer_1_2_min);
		objSplitter.setSubcontainer2Min(splSubcontainer_1_2_min);

		objSplitter.setSubcontainer1Pct(percent_first);

		// Modify minimum cell size in all parent splitters up in hierarchy
		var tmpDest = objDest;
		var curMinSize = splSubcontainer_1_2_min * 2;
		while (tmpDest.getParent().getSubcontainer1Min) {

			var parentSplitter = tmpDest.getParent();

			// Modify only splitters with the same orientation
			if (parentSplitter.getOrientation() == splOrientation) {
				// check last symbol from name (it is cell number, 1 or 2)
				if(tmpDest.getName().match(/1$/)) {
					parentSplitter.setSubcontainer1Min(curMinSize);
				} else {
					parentSplitter.setSubcontainer2Min(curMinSize);
				}

				// Next splitter must be bigger than current
				curMinSize += splSubcontainer_1_2_min;
			}

			// Go up in hierarchy
			tmpDest = tmpDest.getParent().getParent();
		}

		ifr_count++;

		objSplitter.setEvent("mx.MATRIX2.beforeSplitterResize(this);", jsx3.gui.Interactive.BEFORE_RESIZE);
		objSplitter.setEvent("mx.MATRIX2.afterSplitterResize(this,objEVENT,objGUI,fpPCT1);", jsx3.gui.Interactive.AFTER_RESIZE);

		objSplitter.getFirstChild().setCanDrop(jsx3.Boolean.TRUE);
		objSplitter.getFirstChild().setEvent("mx.MATRIX2.handleOnDrop(objSOURCE, this, strDRAGID);", jsx3.gui.Interactive.DROP);
		objSplitter.getFirstChild().setAttribute("playerBlock", "0");
		objSplitter.getFirstChild().setBackgroundColor(MATRIX2.getServer().getJSXByName('block_main').getBackgroundColor());
		objSplitter.getFirstChild().setOverflow(jsx3.gui.Block.OVERFLOWEXPAND);
		objSplitter.getFirstChild().setClassName("drop");

		objSplitter.getLastChild().setCanDrop(jsx3.Boolean.TRUE);
		objSplitter.getLastChild().setEvent("mx.MATRIX2.handleOnDrop(objSOURCE, this, strDRAGID);", jsx3.gui.Interactive.DROP);
		objSplitter.getLastChild().setAttribute("playerBlock", "0");
		objSplitter.getLastChild().setBackgroundColor(MATRIX2.getServer().getJSXByName('block_main').getBackgroundColor());
		objSplitter.getLastChild().setOverflow(jsx3.gui.Block.OVERFLOWEXPAND);
		objSplitter.getLastChild().setClassName("drop");

		objDest.setChild(objSplitter);
		//objDest.setClassName('');
		objDest.repaint();
		return objSplitter;
	};

	MATRIX2.addSplitterCrest = function(objDest) {

		if( (objDest.getAbsolutePosition().W < (2 * splSubcontainer_1_2_min)+3) || (objDest.getAbsolutePosition().H < (2 * splSubcontainer_1_2_min)+3)) {
				alert(__("Cell size isn't enough to be split.\nPlease increase the cell size."));
				return false;
		}

		var objSplitter = MATRIX2.addSplitter(objDest, jsx3.gui.Splitter.ORIENTATIONH);
		MATRIX2.addSplitter(objSplitter.getFirstChild(), jsx3.gui.Splitter.ORIENTATIONV);
		MATRIX2.addSplitter(objSplitter.getLastChild(), jsx3.gui.Splitter.ORIENTATIONV);
	};

	MATRIX2.addSplitter_3x2 = function(objDest){
		if( (objDest.getAbsolutePosition().W < (3 * splSubcontainer_1_2_min)+3) || (objDest.getAbsolutePosition().H < (2 * splSubcontainer_1_2_min)+3))
		{
			alert(__("Cell size isn't enough to be split.\nPlease increase the cell size."));
			return false;
		}

		var objSplitter = MATRIX2.addSplitter(objDest, jsx3.gui.Splitter.ORIENTATIONH, '33%');

		MATRIX2.addSplitter(objSplitter.getFirstChild(), jsx3.gui.Splitter.ORIENTATIONV);
		MATRIX2.addSplitterCrest(objSplitter.getLastChild());
	};

	MATRIX2.addSplitter_4x3 = function(objDest){
		if( (objDest.getAbsolutePosition().W < (4 * splSubcontainer_1_2_min)+3) || (objDest.getAbsolutePosition().H < (3 * splSubcontainer_1_2_min)+3))
		{
			alert(__("Cell size isn't enough to be split.\nPlease increase the cell size."));
			return false;
		}
		var objSplitter = MATRIX2.addSplitter(objDest, jsx3.gui.Splitter.ORIENTATIONV, '66%');

		MATRIX2.addSplitter(objSplitter.getFirstChild(), jsx3.gui.Splitter.ORIENTATIONH);
		MATRIX2.addSplitterCrest(objSplitter.getFirstChild().getFirstChild().getLastChild());

		MATRIX2.addSplitter(objSplitter.getLastChild(), jsx3.gui.Splitter.ORIENTATIONH);
		MATRIX2.addSplitter(objSplitter.getLastChild().getFirstChild().getFirstChild(), jsx3.gui.Splitter.ORIENTATIONH);
		MATRIX2.addSplitter(objSplitter.getLastChild().getFirstChild().getLastChild(), jsx3.gui.Splitter.ORIENTATIONH);
	};

    MATRIX2.splitterResize = function(objThis, objEVENT) {
		var objIFrames = objThis.getDescendantsOfType("jsx3.gui.IFrame", false);
		for(var i=0; i<objIFrames.length; i++) {
			if( objIFrames[i].getAttribute("if_player") ) {
				var objCell = objIFrames[i].getAncestorOfName('cell_blk');
				//var plId = objCell.getId();

				var playerW = objIFrames[i].getParent().getAbsolutePosition().W;
				var playerH = objIFrames[i].getParent().getAbsolutePosition().H;

				//appLogger.info("splitterResize: objIFrames["+i+"] cell_blk H="+objIFrames[i].getAncestorOfName('cell_blk').getAbsolutePosition().H);
				//appLogger.info("splitterResize: objIFrames["+i+"] header H="+objIFrames[i].getAncestorOfName('cell_blk').getDescendantOfName('cell_header').getAbsolutePosition().H);
				//appLogger.info("splitterResize: objIFrames["+i+"] cell_player H="+objIFrames[i].getAncestorOfName('cell_blk').getDescendantOfName('cell_player').getAbsolutePosition().H);
				var nPlayer = MATRIX2.getObjFromIFrame('_mplayer_', objCell);
				if(playerW != 0 && playerH != 0 && nPlayer != undefined && nPlayer != null) {
					nPlayer.setSize(playerW, playerH);
					if(window.jsDebug){ appLogger.info("MATRIX2.splitterResize: objIFrames["+i+"]="+objIFrames[i]+", playerW="+playerW+", playerH="+playerH); }
					if(navigator.appVersion.indexOf("Mac") != -1){
						nPlayer.setSize(playerW - 1, playerH - 1);
					}
				}
				var img = objIFrames[i].getParent().getDescendantOfName("image_player");
				img.setWidth(playerW);
				img.setHeight(playerH);
				img.repaint();
			}
			else if(objIFrames[i].getAttribute("if_tour")) {

				// Calculate new size of frame
				var playerW = objIFrames[i].getAncestorOfName("cell_tour_player").getAbsolutePosition().W;
				var playerH = objIFrames[i].getAncestorOfName("cell_tour_player").getAbsolutePosition().H;
				if (jsx3.CLASS_LOADER.SAF) {
					playerW--;
					playerH--;
				}

				var nPlayer = null;
				nPlayer = mx.MATRIX2.getIFrame(objIFrames[i])['_mplayer_tour'];
				if(nPlayer!=null && playerW != 0 && playerH != 0) {
					nPlayer.setSize(playerW, playerH);
				}
			}
		}
// CIRRUS_REPLACE_MATRIX2_JS_ID004_BEGIN
		// If top level block has been resized, must updated vMX wall layouts
		if(objThis.getDescendantOfName("content_block")) {
			mx.vMX.onLayoutResize();
		}
// CIRRUS_REPLACE_MATRIX2_JS_ID004_END
		// resize eLog2
		if(objThis.getDescendantOfName("eLog2Root")) {
			mx.ELog2.checkSize();
		}

		// update view of OM cells
		var arrOMCells = objThis.findDescendants(function(m){return m.getName()=="om_cell";}, false, true, false, false);
		for(var omIndex = 0; omIndex < arrOMCells.length; omIndex++) {
			mx.OM.updateContentView(arrOMCells[omIndex]);
		}
	};

	MATRIX2.clearDestinationBlock = function(objBlock){
		if(typeof(objBlock) == "string"){
			objBlock = MATRIX2.getServer().getJSXById(objBlock);
		}
		if(window.jsDebug){ appLogger.info("MATRIX2.clearDestinationBlock: playerBlock="+objBlock.getAttribute("playerBlock")+", tourBlock="+objBlock.getAttribute("tourBlock")+", eLog2Block="+objBlock.getAttribute("eLog2Block")+", playerWarning="+objBlock.getAttribute("playerWarning")); }

		if(objBlock.getAttribute("playerBlock") == "1" && objBlock.getDescendantOfName('cell_close')) {
			return MATRIX2.btnCellClose(objBlock.getDescendantOfName('cell_close'));
		} else if(objBlock.getAttribute("tourBlock") == "1" && objBlock.getDescendantOfName('cell_btn_close')) {
			return mx.TOUR.btnTourClose(objBlock.getDescendantOfName('cell_btn_close'));
		} else if(objBlock.getAttribute("eLog2Block") == "1"){
			mx.ELog2.elHide();
			return "elog2";
		} else if (objBlock.getAttribute("playerWarning") == "1") {
			mx.MATRIX2.checkCellsLimit(MATRIX2.videoCellWeight, false);
            mx.MATRIX2.curVideoCellWeight--;
            objBlock.delayedDrop = null;
			objBlock.setAttribute("playerBlock", "0");
			objBlock.setAttribute("playerWarning", "0");
			objBlock.setText("", true);
		} else {
			objBlock.setText("", true);
			return "dom";
		}
	};

	/**
	 *
	 * @param objDest  block to add url cell
	 * @param _param    cell parameters, {url, refresh}
	 */
	MATRIX2.addUrlCell = function(objDest, _param) {
		var param = {
			url: MATRIX2.getIdentityValue('URL_HOME_PAGE'),
			refresh: 0
		};
		$.extend(param, _param);

		MATRIX2.clearDestinationBlock(objDest);

		objDest.removeAttribute("playerBlock");
		mx.language.load_translate(objDest, "components/url_cell.xml");

		objDest.getDescendantOfName("adressUrl").setValue(param['url'], true);
		MATRIX2.setUrlComponent(objDest.getDescendantOfName('adressUrl'));
		objDest.repaint();

		if (param['refresh']) {
			objDest.getDescendantOfName("intervalSec").setValue(param['refresh']);
			objDest.getDescendantOfName('checkboxRefresh').getRendered().children[0].checked = true;
			MATRIX2.checkRefresh(objDest.getDescendantOfName('checkboxRefresh'));
		}
	};

	MATRIX2.setUrlComponent = function(objTHIS) {
		var objComponent = objTHIS.getParent().getParent().getParent().getParent().getParent();

		var strU = objTHIS.getValue().replace(/^\s+|\s+$/g, '');
		var protocol = "http:";
		if(strU.search(/:\/\//g)!=-1){
			protocol = strU.slice(0, strU.search(/:\/\//g)+1).toLowerCase();
			strU = strU.slice(strU.search(/:\/\//g)+3, strU.length).toLowerCase();
		}

		strU = protocol+"//"+strU;
		objTHIS.setValue(strU);

		objComponent.getDescendantOfName('url_iframe').setSrc(strU);
		objComponent.repaint();
	};

	MATRIX2.checkRefresh = function(objCheckbox) {
		//appLogger.info("checkRefresh: "+objCheckbox.getChecked()+", jsx3.gui.CheckBox.CHECKED="+jsx3.gui.CheckBox.CHECKED);
		var objUrlCell = objCheckbox.getAncestorOfName('main_url_block');
		// Checkbox in block checkboxRefresh
		if(objCheckbox.getRendered().children[0].checked) {
			MATRIX2.refreshUrlCell(objUrlCell);
		}
		else {
			MATRIX2.stopRefreshUrlCell(objUrlCell);
		}
	};

	MATRIX2.showhideUrlConfig = function(objButton, isShow){
		var layout = objButton.getAncestorOfName("layoutUrl");
		if(isShow){
			layout.setRows("25,25,*",true);
			objButton.setEvent("mx.MATRIX2.showhideUrlConfig(this,false);", jsx3.gui.Interactive.EXECUTE);
			objButton.setImage("jsxuser:///images/design1/url/url_collapse.png");
			objButton.setTip(__("Hide URL config"));
		}else{
			layout.setRows("25,0,*",true);
			objButton.setEvent("mx.MATRIX2.showhideUrlConfig(this,true);", jsx3.gui.Interactive.EXECUTE);
			objButton.setImage("jsxuser:///images/design1/url/url_expand.png");
			objButton.setTip(__("Show URL config"));
		}
		objButton.repaint();
	};

	MATRIX2.stopRefreshUrlCell = function(objUrlCell) {
		//appLogger.info("stopRefreshUrlCell: "+objUrlCell);
		if(window['url_var_'+objUrlCell.getId()]){ clearTimeout(window['url_var_'+objUrlCell.getId()]); }
	};

	MATRIX2.refreshUrlCell = function(objUrlCell) {
		//appLogger.info("refreshUrlCell: "+objUrlCell);
		var interval = parseInt(objUrlCell.getDescendantOfName("intervalSec").getValue(),10)*1000;
		objUrlCell.getDescendantOfName("url_iframe").repaint();
		if(window['url_var_'+objUrlCell.getId()]){ clearTimeout(window['url_var_'+objUrlCell.getId()]); }
		window['url_var_'+objUrlCell.getId()] = window.setTimeout(function() { MATRIX2.refreshUrlCell(objUrlCell); }, interval);
	};

	MATRIX2.removeUrlCell = function(btnClose) {
		MATRIX2.stopRefreshUrlCell(btnClose.getAncestorOfName('main_url_block'));
		var container = btnClose.getAncestorOfName('main_url_block').getParent();
		container.setAttribute("playerBlock", "0");
		container.removeChildren();
	};

	MATRIX2.handleOnDrop = function(objSource, objDest, strId) {
		if(window.jsDebug){ appLogger.info("MATRIX2.handleOnDrop: objSource="+objSource+", objDest="+objDest+", strId="+strId); }

		//drag variable unset must be before cell creation for Firefox support
		dragged = false;
		dragged_splitter = false;
		glbLegacyNodename = "";
		glbLegacyDevId = "";

		jsx3.gui.Interactive.hideSpy();
		MATRIX2.getServer().getJSXByName('controlPane').hideMask();

		// Cannot drop anything on elog
		if (objDest.getName() == jsx3.GO("eLog2Root").getParent().getName())
			return;

		// Resize pane_elogsmall if needed
		if (objDest.getName() == 'pane_elogsmall') {
			var splitter = objDest.getParent();
			if(splitter.getSubcontainer2Min() == 15 && objDest.getAbsolutePosition().H < mx.ELog2.lowerAreaSize) {
				 splitter.setSubcontainer2Min(mx.ELog2.lowerAreaSize);
				 splitter.setSubcontainer1Pct("75%", true);
				 mx.MATRIX2.splitterResize(splitter);
			}
		}

		// Handle motion search cell
		if (objDest.getAttribute('motionSearch') == '1') {
			if (objSource.getName() == 'matrixWitnesses' || objSource.getName() == 'screenshot') {

				var objId;
				var dialog = jsx3.GO("eLog2Root").getDescendantOfName('eLog2dialog');
				if (objSource.getName() == 'screenshot') {
					objId = dialog.getAttribute("objId");
				} else {
					var witnessesDoc = dialog.getDescendantOfName('matrixWitnesses').getXML();
					objId = witnessesDoc.selectSingleNode("//record[@jsxid='" + strId + "']").getAttribute("objid");
				}
				$('#' + objDest.getFirstChild().getId()).trigger('drop', resourceTree.getObject(objId));
			}
			return;
		}

		
		// Handle dnd inside 2d map cells
		if (objDest.getFirstChild() && objDest.getFirstChild().getName() == 'map_cell') {
			var objId = null;
			if (objSource.type) { // from resource tree
				objId = objSource.obj;
			}
			else if(objSource.getName() == 'cell_dev_type') { // from cell header
				objId = objSource.getAncestorOfName('cell_blk').getAttribute('objectId');
			}
			
			mx.MAP.onDndOut(objDest.getRendered());
			
			if(objId != null){
				mx.MAP.panTo(objDest.getFirstChild(), objId);
			}
				
			return;
		}

		// DnD from resource tree
		if (objSource.type) {
			if(objSource.type == "view"){
				VIEWS.load(strId);
				return;
			}

			if (objDest.getAttribute("playerBlock")) {

				if (objSource.type == 'avatar' || (objSource.type == 'device' && objSource.attributes.DEVICETYPE == 'AVATAR')) {
					mx.MATRIX2.clearDestinationBlock(objDest);
					var avatarCell = new AvatarCell(objDest, objSource);
					avatarCell.render();
					return;
				}

				if (objDest.getDescendantOfName('list_tour')) {
					mx.TOUR.listTourOnDrop(objDest.getDescendantOfName('list_tour'), objSource);
					return;
				}

				if (objSource.type == 'camera') {
					mx.MATRIX2.createCell(objSource.obj, objSource.name, objDest, false);
					return;
				} else if (objSource.type == 'set' || objSource.type == 'role') {
					if (resourceTree.getObjects({'type': 'camera', 'obj': objSource.objects}).length) {
						mx.TOUR.addTourCell(objDest);
						mx.TOUR.listTourOnDrop(objDest.getDescendantOfName('list_tour'), objSource.objects);
					} else {
						mx.OM.createOMCell(objDest, objSource);
					}

				}
				else {
					mx.OM.createOMCell(objDest, objSource);
				}
				return;
			}

			if (objDest.getFirstChild().getName() == 'om_cell') {
				mx.OM.handleOnDrop(objDest, objSource);
			}

			if (objDest.getFirstChild().getName() == 'ge_cell') {
				if (objSource.type == 'camera' || objSource.type == 'door' || objSource.type == 'sensor' || objSource.type == 'relay') {
					mx.GE.lockDeviceOnMap(objSource.obj);
				} else if (objSource.type == 'set') {
					mx.GE.showCameras(objSource.objects.join(','), true);
				}
			}
		}

		if(!objDest.getAttribute('playerBlock')) {
			return;
		}

		// if trying to drop cell or event into itself, return
		if (objSource.getName() == 'cell_dev_type' && objSource.getAncestorOfName('cell_blk').getParent() == objDest) {
			MATRIX2.changeSrcMLeave(objSource.getAncestorOfName("cell_blk"));
			return;
		}

		// DnD from elog, components etc.
		MATRIX2.clearDestinationBlock(objDest);
		switch (objSource.getName()) {

			case 'paneELog2':
				// if dragging eLog, simulate it dropping
				mx.MATRIX2.checkCellsLimit(mx.MATRIX2.elogCellWeight, false);
			case 'image_elog2':
			case 'image_elog2_detailed':
				mx.ELog2.elDrop(objDest);
			break;

			case 'image_spl_h':
				MATRIX2.addSplitter(objDest, jsx3.gui.Splitter.ORIENTATIONV, "50%");
			break;

			case 'image_spl_v':
				MATRIX2.addSplitter(objDest, jsx3.gui.Splitter.ORIENTATIONH, "50%");
			break;

			case 'image_spl_c':
				MATRIX2.addSplitterCrest(objDest);
			break;

			case 'image_spl_3x2':
				MATRIX2.addSplitter_3x2(objDest);
			break;

			case 'image_spl_4x3':
				MATRIX2.addSplitter_4x3(objDest);
			break;

			case 'image_ge':
				mx.GE.addGE(objDest);
			break;

			case 'image_map':
				mx.MAP.addMap(objDest);
			break;

			case 'image_tour':
				mx.TOUR.addTourCell(objDest);
			break;

			case 'url_control':
				MATRIX2.addUrlCell(objDest);
			break;

			case 'image_cdm':
				mx.CDM.addCell(objDest);
			break;

			case 'matrixWitnesses':
			case 'screenshot':
				mx.ELog2.dropstarted = true;
				mx.ELog2.onEventWitnessDrop(objSource, objDest, strId);
			break;

			case 'cell_dev_type':
				var cellObj = objSource.getAncestorOfName('cell_blk');
				var objectId = cellObj.getAttribute('objectId');

				if(cellObj.getAttribute("eventid") == -1) { // If ordinary cell re-drop
					var objName = objSource.getParent().getParent().getDescendantOfName("cell_dev_name").getText();
					var isArchive = MATRIX2.getObjFromIFrame('_mplayer_', cellObj).contextType == 3;
					MATRIX2.btnCellClose(cellObj.getDescendantOfName("cell_close"));
					MATRIX2.createCell(objectId, objName, objDest, false, null, null, isArchive);
				}
				else { // if event re-drop from cell to cell
					var curEventId = cellObj.getAttribute("eventid");
					var event_ts_from = cellObj.getAttribute("event_ts_from");
					var event_ts_to = cellObj.getAttribute("event_ts_to");
					var time_zone = cellObj.getAttribute("time_zone");

					MATRIX2.btnCellClose(cellObj.getDescendantOfName("cell_close"));
					// emulate event cell drop
					var newCell = MATRIX2.createCell(objectId, __("Event ID: ")+curEventId, objDest, false, event_ts_from, event_ts_to);
					newCell.setAttribute("time_zone",time_zone);
					newCell.setAttribute("dst_from", "0");
					newCell.setAttribute("dst_to", "0");
					newCell.setAttribute("close_previous","true");

					isPlayInArchive = true;
					mx.MATRIX2.setSelectedGroup(objDest.getDescendantOfName("cell_select"),null,true);
				}
			break;
		}
	};

	MATRIX2.showDropMasks = function(strDSV) {
		MATRIX2.setDraggedSplitterVar(strDSV);
		//MATRIX2.getServer().getJSXByName('controlPane').showMask('');
// CIRRUS_REPLACE_MATRIX2_JS_ID005_BEGIN
		mx.vMX.showHideMask(true);
// CIRRUS_REPLACE_MATRIX2_JS_ID005_END
	};

	MATRIX2.hideDropMasks = function() {
		MATRIX2.getServer().getJSXByName('controlPane').hideMask();
// CIRRUS_REPLACE_MATRIX2_JS_ID006_BEGIN
		mx.vMX.showHideMask(false);
// CIRRUS_REPLACE_MATRIX2_JS_ID006_END
	};

	MATRIX2.changeSrcMEnter = function(block, event) {

		if (!dragged)
			return;

		var objT = MATRIX2.getServer().getJSXById(block.id).getParent();
		var objP = MATRIX2.getServer().getJSXById(block.id).getDescendantOfName('cell_player');
		if (!objP)
			return;

		var frame = objP.getDescendantOfName('iframe_player');
		var img = objP.getDescendantOfName('image_player');

		//if elog
		if(objT.getAttribute("eLog2Block") == "1") {
			img.setSrc("images/design1/eLog2/eLog2_event_over.gif");
			img.setWidth(320, false);
			img.setHeight(210, false);
			img.setTop((frame.getAbsolutePosition().H/2-105), false);
			img.setLeft((frame.getAbsolutePosition().W/2-160), false);

			img.setVisibility(jsx3.gui.Block.VISIBILITYVISIBLE, false);
			frame.setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
			img.repaint();
		}

		// if player
		if (!objT.getAttribute("playerBlock")) {
			$('#' + objT.getId() + ' iframe').css('visibility', 'hidden');
		}

		if(dragged_splitter) {

			// dragged_splitter_type can be:
			// 1x2, 2x1, 2x2, 3x2, 4x3, map3d
			img.setHeight(10, false);
			img.setWidth(10, false);
			img.setTop((frame.getAbsolutePosition().H/2-5), false);
			img.setLeft((frame.getAbsolutePosition().W/2-5), false);
			img.setSrc("images/design1/layout/" + dragged_splitter_type + ".png");

			if(dragged_splitter_type == 'map3d') {
				img.setWidth(13, false);
			}
			img.setVisibility(jsx3.gui.Block.VISIBILITYVISIBLE, false);
			img.repaint();
		}
		frame.setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
	};

	MATRIX2.changeSrcMLeave = function(block, event) {

		var objT = block.id ? MATRIX2.getServer().getJSXById(block.id).getParent() : block.getParent();

		if (!objT)
			return;

		if (!objT.getAttribute("playerBlock")) {
			$('#' + objT.getId() + ' iframe').css('visibility', 'visible');
		}

		if(!event || (dragged && !contains(block, [event.pageX, event.pageY]))) {

			var frame = objT.getDescendantOfName('iframe_player');
			var img = objT.getDescendantOfName('image_player');

			if (!frame)
				return;

			img.setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
			frame.setVisibility(jsx3.gui.Block.VISIBILITYVISIBLE, true);
		}
	};

	MATRIX2.setDraggedVar = function(bln, objSOURCE, strId) {
		dragged = bln;
		if(objSOURCE.getName()=="elMatrix"){ // if dragged event
			glbLegacyNodename = "eventlog";
		}
		else{ // if dragged device
			glbLegacyNodename = objSOURCE.getRecord(strId).legacyNodeName;
			glbLegacyDevId = objSOURCE.getRecord(strId).legacyId;
		}
	};

	MATRIX2.setDraggedSplitterVar = function(type) {
		dragged = true;
		dragged_splitter = true;
		dragged_splitter_type = type;
	};

	// Handles event when DROP over unhandeled event
	jsx3.gui.Event.subscribe(jsx3.gui.Event.MOUSEUP, function() {
		if(dragged) {
			if(dragged_splitter){
				mx.MATRIX2.getServer().getJSXByName('controlPane').hideMask();
			}
			dragged = false;
			dragged_splitter = false;
			glbLegacyNodename = "";
			glbLegacyDevId = "";
		}

		LSC.hideConfMenu();

		//appLogger.info("jsx3.gui.Event.MOUSEUP OK");
	});

	/**
	 * Clear matrix leyout
	 */
	MATRIX2.clearMatrix = function() {
		appLogger.time('clearMatrix');

		//appLogger.info("clearMatrix: START");

// CLARE_REPLACE_MATRIX2_JS_ID001_BEGIN
		// GE show/hide
		MATRIX2.getServer().getJSXByName("image_ge").setCanDrag(jsx3.Boolean.TRUE);
		showElementsWithName("image_ge");
// CLARE_REPLACE_MATRIX2_JS_ID001_END

		//contol must be cleared BEFORE group object removal
		soundPlayerInstance = null;

		if(activeGroup_Cell == null) {
			activeGroup_Cell = MATRIX2.getObjFromIFrame('groupIFAPlayer');
		}
		else{
			activeGroup_Cell.reset();
		}

		if(syncGroup == null) {
			syncGroup = MATRIX2.getObjFromIFrame('groupIFGPlayer');
		}
		else{
			syncGroup.reset();
		}

		var objControls = mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls;
		objControls.unsetGroup(null);

		//check eventLog
		mx.ELog2.createDefaultFilters();

		// Do not show eEog by default
		if(!mx.ELog2.hidden) {
			mx.ELog2.elHide();
		}

		// Now clear all visible non-vMX tabs
		var arrTabs = mx.MATRIX2.getServer().getJSXByName("tabbedpaneMain").getChildren();
		for(var i = 0; i < arrTabs.length; i++) {
			if(arrTabs[i].getDisplay() == jsx3.gui.Block.DISPLAYNONE || arrTabs[i].getAttribute("wallid") != null)
				continue;

			mx.CT.removeTab(arrTabs[i]);
			arrTabs[i].removeAttribute("currentActive");
		}
		mx.CT.createNewTab();

		// Clear pane_elogsmall
		var elogsmall = jsx3.GO('pane_elogsmall');
		var splitter = elogsmall.getParent();
		elogsmall.removeChild(0);
		elogsmall.setAttribute("playerBlock", "0");
		splitter.setSubcontainer2Min(15).setSubcontainer1Pct("98%", true);
		mx.MATRIX2.splitterResize(splitter);

		if(mx.MATRIX2.getServer().getJSXByName("ptzDialog").getVisibility() == jsx3.gui.Block.VISIBILITYVISIBLE) {
			mx.MATRIX2.getServer().getJSXByName("ptzDialog").setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
		}

		MATRIX2.getServer().getJSXByName('layoutControlComponent').controls.checkTimeline();
		MATRIX2.getServer().getJSXByName("menuconfblock").setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);

		MATRIX2.curVideoCellWeight = 0;
		MATRIX2.curCellsWeight = 0;

		appLogger.timeEnd('clearMatrix');
		//appLogger.info("clearMatrix: END");
	};

	MATRIX2.btnCellClose = function(objTHIS) {
		if(window.jsDebug){ appLogger.info("MATRIX2.btnCellClose: objTHIS="+objTHIS); }
        var objPl = objTHIS.getAncestorOfName('cell_blk');

		if(objTHIS.getAncestorOfName('ge_cell')) {
			Targeting.stop();
			objPl = objTHIS.getAncestorOfName('ge_cell').getParent();
			showElementsWithName("image_ge");
			mx.MATRIX2.checkCellsLimit(MATRIX2.map3dCellWeight, false);
			mx.GE.lockedCameraId = null;

			objPl.setAttribute("playerBlock", "0");
			objPl.removeChildren();
			return;
		} else
		if (objTHIS.getAncestorOfName('map_cell')) {
			objPl = objTHIS.getAncestorOfName('map_cell').getParent();
			showElementsWithName("image_map");

			objPl.setAttribute("playerBlock", "0");
			objPl.removeChildren();
			return;
		} else {
			mx.MATRIX2.checkCellsLimit(MATRIX2.videoCellWeight, false);
            mx.MATRIX2.curVideoCellWeight--;
            objPl.delayedDrop = null;
		}

        var objId = objPl.getAttribute("objectId");
		var objectParent = objPl.getParent();
		var nPlayer = MATRIX2.getObjFromIFrame('_mplayer_', objPl);
		if(objectParent.getName() != 'pane_elogsmall' && objectParent.getAncestorOfName('pane_elogsmall')==null){
			if(window['finish_record_var'+objPl.getId()]){ clearTimeout(window['finish_record_var'+objPl.getId()]); }
			if(window['alert_record_var'+objPl.getId()]){ clearTimeout(window['alert_record_var'+objPl.getId()]); }
			var tab = objPl.getAncestorOfType(jsx3.gui.Tab);
			mx.CT.removeRecDeviceFromTab(tab, objPl);
		}else if(objectParent.getName() == 'pane_elogsmall'){
			var splitter = objectParent.getParent();
			splitter.setSubcontainer2Min(15);
			splitter.setSubcontainer1Pct("98%", true);
			mx.MATRIX2.splitterResize(splitter);
		}
		var objControls = mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls;

		// remove audio player from groups if exists
		if(objPl.getName()=="cell_blk" && nPlayer && objPl.getAttribute("assocAudioId"))
		{
			var sp = null;
			sp = MATRIX2.getObjFromIFrame('_mplayer_SoundPlayer', objPl);

			if(sp)
			{
				sp.playerImpl.beforeStop();
				sp.stop();

				if(syncGroup!=null && syncGroup.isPlayerInGroup(sp)){
					syncGroup.removePlayer(sp);
				}
				if(activeGroup_Cell!=null && activeGroup_Cell.isPlayerInGroup(sp)){
					activeGroup_Cell.removePlayer(sp);
				}
			}
		}

		// if removing active player, disable joystick commands
		if (activeGroup_Cell && activeGroup_Cell.isPlayerInGroup(nPlayer)) {
			HWJoystick.setObj(null);
		}

		//remove deleting player from groups
		if(nPlayer){
			if(syncGroup!=null && syncGroup.isPlayerInGroup(nPlayer)){
				syncGroup.removePlayer(nPlayer);
			}
			if(activeGroup_Cell!=null && activeGroup_Cell.isPlayerInGroup(nPlayer)){
				activeGroup_Cell.removePlayer(nPlayer);
			}
			if(objControls.group!=null){
				if((objControls.group.getGroupSize()-objControls.group.getNumOfAudioDevices())==0){
					//soundPlayerInstance = null;
					objControls.unsetGroup(null);
				}
			}

			nPlayer.playerImpl.beforeStop();
		}

		// remove player from player list
		var length = MATRIX2.cellIdList.length;
		for (var i = 0; i < length; i++)
		{
			if (MATRIX2.cellIdList[i] == objPl.getId())
			{
				MATRIX2.cellIdList.splice(i, 1);
				break;
			}
		}

		// reset empty groups
		if(activeGroup_Cell!=null && (activeGroup_Cell.getGroupSize()-activeGroup_Cell.getNumOfAudioDevices())==0){
			activeGroup_Cell.reset();
		}
		if(syncGroup!=null && (syncGroup.getGroupSize()-syncGroup.getNumOfAudioDevices())==0){
			syncGroup.reset();
		}

		if(soundPlayerInstance!=null && (objControls.group==null || objControls.group.getNumOfAudioDevices()==0)){
			soundPlayerInstance = null;
		}

        if(MATRIX2.activeSoundCellId == objPl.getId()){
            MATRIX2.activeSoundCellId = null;
        }

		mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls.checkTimeline();
		mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls.detectMainPlayerPos();

		objControls.setAccess(true,true,true,true);

        if(mx.PTZ.camera_id == objId){
            mx.PTZ.ptzDialogHide();
        }

		objectParent.setAttribute("playerBlock", "0");
		objectParent.setAttribute("playerWarning", "0");
		objectParent.removeChildren();

		//if in eLog enaled "Selected" filter
		if(mx.ELog2.device == 'selected' && !mx.ELog2.dropstarted){ //if "Selected" filter(and not elog dnd DE2177)
			mx.ELog2.setFilterValue('device', "selected");
		}

		if(window.jsDebug){ appLogger.info("MATRIX2.btnCellClose: end"); }
		return "cellclose";
	};

	MATRIX2.btnPinHandler = function(objTHIS) {
		var objControls = mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls;
		var objPl = objTHIS.getAncestorOfName('cell_blk');

		if(syncGroup == null) {
			syncGroup = MATRIX2.getObjFromIFrame('groupIFGPlayer');
		}

		if(activeGroup_Cell == null) {
			activeGroup_Cell = MATRIX2.getObjFromIFrame('groupIFAPlayer');
		}

		var nPlayer = MATRIX2.getObjFromIFrame('_mplayer_', objPl);

		if(syncGroup===undefined || activeGroup_Cell===undefined || nPlayer===undefined || syncGroup==null || activeGroup_Cell==null || nPlayer==null){
			window.setTimeout(function(){ MATRIX2.btnPinHandler(objTHIS); }, 50);
			return;
		}

		//check audio presence
		if(objPl.getAttribute("assocAudioId")){
			var sp = MATRIX2.getObjFromIFrame('_mplayer_SoundPlayer', objPl);
			if(sp==null || sp===undefined){
				window.setTimeout(function(){ MATRIX2.btnPinHandler(objTHIS); }, 50);
				return;
			}
		}

		//if cell already pinned
		if(objTHIS.getState() == jsx3.gui.ImageButton.STATE_ON) {
			objTHIS.setImage("jsxuser:///images/design1/gui_cell/cell_pin.png");

			objPl.getDescendantOfName('cell_dev_name').setColor("5F696D");
			objPl.getDescendantOfName('cell_header').setBackground('background-image:url(./images/design1/gui_cell/cell_header_bg.gif);background-repeat:repeat-x;').repaint();
			objTHIS.setState(jsx3.gui.ImageButton.STATE_OFF);

			if(syncGroup.isPlayerInGroup(nPlayer)) {
				// remove sound player from syncGroup if exists
				if(objPl.getAttribute("assocAudioId")){
					if(objControls.group!=null && objControls.group.isPlayerInGroup(nPlayer) && objPl.getAttribute("state")=="playing"){
						var sButton = objPl.getDescendantOfName('cell_sound');
						mx.MATRIX2.pauseSound(sButton);
					}
				}

				syncGroup.removePlayer(nPlayer);

				if(objControls.group!=null && (objControls.group.getGroupSize()-objControls.group.getNumOfAudioDevices())==0) { // if empty active group
					//activeGroup_Cell.reset();// = null;
					objControls.unsetGroup(null);
				}
			}

			if((syncGroup.getGroupSize()-syncGroup.getNumOfAudioDevices())==0){
				syncGroup.reset();
			}

			if((syncGroup.getGroupSize()-syncGroup.getNumOfAudioDevices())==0 && (activeGroup_Cell.getGroupSize()-activeGroup_Cell.getNumOfAudioDevices())==0){ //TA1075
				mx.MATRIX2.setSelectedGroup(objTHIS.getAncestorOfName('cell_blk').getDescendantOfName('cell_select'),null,null);
			}

			if (objPl.getAttribute('recording') == '1') {
				objPl.getDescendantOfName('cell_dev_state').setSrc('images/design1/gui_cell/cell_live.png').repaint();
				objPl.setAttribute('recording', '0');
			}

			if(objPl.getAttribute("position_control") == "1"){
				MATRIX2.setButtonInCellHeader(objPl, 'cell_joystick', true);
			}

		} else { //if cell not pinned
			//appLogger.info("btnPinHandler: pin cell start");
			objTHIS.setState(jsx3.gui.ImageButton.STATE_ON);
			objTHIS.setImage("jsxuser:///images/design1/gui_cell/cell_pin_red.png");

			if(activeGroup_Cell!=null && activeGroup_Cell.isPlayerInGroup(nPlayer)){
				activeGroup_Cell.removePlayer(nPlayer);
				//appLogger.info("btnPinHandler:video removed from activeGroup_Cell");
			}
			if(activeGroup_Cell!=null && activeGroup_Cell.isPlayerInGroup(sp)){
				activeGroup_Cell.removePlayer(sp);
				//appLogger.info("btnPinHandler: sound removed from activeGroup_Cell");
			}

			//MATRIX2.traceGroup(activeGroup_Cell);
			//MATRIX2.traceGroup(syncGroup);
			syncGroup.addPlayer(nPlayer);
			//appLogger.info("btnPinHandler:added to syncGroup");

			if(syncGroup.contextType==2){
				objPl.setAttribute("player_mode", "0");
			}
			if(syncGroup.contextType==3){
				objPl.setAttribute("player_mode", "1");
			}

			//if player in Active group and pinned make it green
			if( (objControls.group!=null && objControls.group.isPlayerInGroup(nPlayer)) ||
				((syncGroup.getGroupSize()-syncGroup.getNumOfAudioDevices())>0 && (activeGroup_Cell.getGroupSize()-activeGroup_Cell.getNumOfAudioDevices())==0) ) {
				for(var i=0; i<syncGroup.getGroupSize(); i++) {
					if(syncGroup.getPlayer(i).getParameter('DEVICE_TYPE')=="C"){
						var plCell = mx.MATRIX2.getServer().getJSXById(syncGroup.getPlayer(i).id);
						plCell.getDescendantOfName('cell_dev_name').setColor("white");
						plCell.getDescendantOfName('cell_header').setBackground('background-image:url(./images/design1/gui_cell/cell_header_bg_blue.gif);background-repeat:repeat-x;').repaint(); //cell_header_bg_green
					}
				}

				objControls.setGroup(syncGroup,false,true);

				if(objPl.getAttribute("assocAudioId")){
					var sButton = objPl.getDescendantOfName('cell_sound');
					if(objPl.getAttribute("state")=="playing"){
						mx.MATRIX2.playSound(sButton);
					}else if(objControls.group!=null && objControls.group.isPlayerInGroup(nPlayer) && objControls.group.getNumOfAudioDevices()==0 && objPl.getAttribute("state")=="pause"){
						mx.MATRIX2.pauseSound(sButton);
					}
				}

				//set timeline position
				if(objControls.group.contextType==3){
					mx.TIMELINE.timeline.clearColorScale();
				}

			} else {
				//objPl.getDescendantOfName('cell_dev_name').setColor("white");
				objPl.getDescendantOfName('cell_header').setBackground('background-image:url(./images/design1/gui_cell/cell_header_bg.gif);background-repeat:repeat-x;').repaint();//cell_header_bg_red
			}
			//MATRIX2.traceGroup(activeGroup_Cell);
			//MATRIX2.traceGroup(syncGroup);
			//appLogger.info("btnPinHandler:!!!!!!!!!!!!!!!!!!!!!!!!!!!2");
			////////////////////////////////
			// if join to live group
			//appLogger.info("btnPinHandler: syncGroup.contextType="+syncGroup.contextType);
			if (syncGroup.contextType==2 && objControls.getMainCell().getAttribute('recording') == '1') {
				objControls.startRecord(objControls.getMainCell().getAttribute('markA'));
			} else if(syncGroup.contextType==2){
				   for(i=0;i<syncGroup.players.length;i++){// change all headers to live
					var objPlayerCell = objTHIS.getServer().getJSXById(syncGroup.players[i].player.id);
					if(syncGroup.players[i].player.getParameter("isAudio")!="true" && objPlayerCell){
						objPlayerCell.setAttribute("player_mode", "0");
						objPlayerCell.getDescendantOfName('cell_dev_state').setAttribute("onclick","mx.MATRIX2.quickSwitch2archive(jsx3.GO(this.id).getAncestorOfName('cell_blk'), true);");
						objPlayerCell.getDescendantOfName('cell_dev_state').setSrc('images/design1/gui_cell/cell_live.png').repaint();
						//--TD--> Credentials
						var objP = mx.MATRIX2.getServer().getJSXById(syncGroup.players[i].player.id);

						if(!resourceTree.cred(objP.getAttribute("objectId"), 'L')) {
							objP.messageSet(__("Not sufficient credentials to play the video stream.<br><i>Please contact your system administrator.</i>"));
							objP.messageShow();
						} else {
							objP.messageHide();
						}
						//--TD--<
		 			}
					//--TD--> DE354:
					if(objTHIS.getServer().getJSXById(syncGroup.players[i].player.id) && objTHIS.getServer().getJSXById(syncGroup.players[i].player.id).getAttribute("position_control") == "1") {
						objTHIS.getServer().getJSXById(syncGroup.players[i].player.id).getDescendantOfName('cell_joystick').setEnabled(jsx3.gui.Form.STATEENABLED, true);
					}
					//--TD--<
				}
			}

			//if join to archive group
			if(syncGroup.contextType==3){
				   for(i=0;i<syncGroup.players.length;i++){// change all headers to live
					var objPlayerCell = objTHIS.getServer().getJSXById(syncGroup.players[i].player.id);
					if(syncGroup.players[i].player.getParameter("isAudio")!="true" && objPlayerCell){
						objPlayerCell.setAttribute("player_mode", "1");
						objPlayerCell.getDescendantOfName('cell_dev_state').setAttribute("onclick","mx.MATRIX2.quickSwitch2live(jsx3.GO(this.id).getAncestorOfName('cell_blk'), true);");
						objPlayerCell.getDescendantOfName('cell_dev_state').setSrc('images/design1/gui_cell/cell_archive.png').repaint();
						//--TD--> Credentials
						var objP = mx.MATRIX2.getServer().getJSXById(syncGroup.players[i].player.id);

						if(!resourceTree.cred(objP.getAttribute("objectId"), 'A')) {
							objP.messageSet(__("Not sufficient credentials to play the video stream.<br><i>Please contact your system administrator.</i>"));
							objP.messageShow();
						} else {
							objP.messageHide();
						}
						//--TD--<
		 			}
					//--TD--> DE354:
					if(objTHIS.getServer().getJSXById(syncGroup.players[i].player.id) && objTHIS.getServer().getJSXById(syncGroup.players[i].player.id).getAttribute("position_control") == "1") {
						objTHIS.getServer().getJSXById(syncGroup.players[i].player.id).getDescendantOfName('cell_joystick').setEnabled(jsx3.gui.Form.STATEENABLED, true);
					}
					//--TD--<
				}
				//appLogger.info("btnPinHandler: pin cell end");
			}
			//MATRIX2.traceGroup(activeGroup_Cell);
			//MATRIX2.traceGroup(syncGroup);

			if(objPl.getAttribute("position_control") == "1") MATRIX2.setButtonInCellHeader(objPl, 'cell_joystick', false);
		}

		if(mx.ELog2.device == 'selected') { //if "Selected" filter
			mx.ELog2.setFilterValue('device', "selected");
		}
		return objTHIS.repaint();
	};

	/**
	 * unpin all cells
	 */
	MATRIX2.unpinAllCells = function() {
		if(!syncGroup || syncGroup === null || syncGroup === undefined || !syncGroup.players){
			return;
		}

		for(var i = 0; i < syncGroup.players.length; i++){
			var cell = jsx3.GO(syncGroup.players[i].player.id);
			if(cell.getDescendantOfName('cell_pin').getState() == jsx3.gui.ImageButton.STATE_ON){
				var pin = MATRIX2.btnPinHandler(cell.getDescendantOfName("cell_pin"));
			}
		}
	};

	/**
	 * get iframe object from tibco IFrame
	 * @param objIFrame   jsx3.gui.IFrame
	 * return iframe object
	 */
	MATRIX2.getIFrame = function(objIFrame) {

		if (!objIFrame)
			return null;

		if(jsx3.CLASS_LOADER.IE || jsx3.CLASS_LOADER.SAF) {
			// In IE and Safari use native Tibco function
			return objIFrame.getIFrame();
		}
		if(jsx3.CLASS_LOADER.FX) {
			// In Firefox get IFrame manually
			if (!objIFrame.getRendered())
				return null;
			return objIFrame.getRendered().firstChild.contentWindow;
		}
	};

	/**
	 *
	 * @param strObj
	 * @param objCell
	 * @returns {*}|null
	 */
	MATRIX2.getObjFromIFrame = function(strObj, objCell){
		//appLogger.info("getObjFromIFrame: START strObj="+strObj);

		var IFrame;

		switch (strObj) {
			case '_mplayer_':
				IFrame = mx.MATRIX2.getIFrame(objCell.getDescendantOfName('iframe_player'));
				return IFrame[strObj+objCell.getId()];

			case 'groupIFAPlayer':
				IFrame = mx.MATRIX2.getIFrame(mx.MATRIX2.getServer().getJSXByName('iframeAPlayer'));
				return IFrame[strObj];

			case 'groupIFGPlayer':
				IFrame = mx.MATRIX2.getIFrame(mx.MATRIX2.getServer().getJSXByName('iframeGPlayer'));
				return IFrame[strObj];

			case '_mplayer_SoundPlayer':
				IFrame = mx.MATRIX2.getIFrame(objCell.getDescendantOfName('iframe_sound_player'));
				return IFrame[strObj+objCell.getId()];

			/* unused logic
			case 'eLog_applet':
				IFrame = mx.MATRIX2.getIFrame(mx.MATRIX2.getServer().getJSXByName('iframe_elog'));
				return IFrame.document.getElementById('elog_client');
			*/

			case 'media_exporter':
				IFrame = mx.MATRIX2.getIFrame(mx.MATRIX2.getServer().getJSXByName('iframeMediaExport'));
				return IFrame.document.getElementById('exporter');
		}

		//appLogger.info("getObjFromIFrame: OK obj="+obj);
		return null;
	};

	MATRIX2.setSelectedGroup = function(objTHIS,objRemove,isPlay) {
        //if(window.jsDebug){ appLogger.info("MATRIX2.setSelectedGroup: select cell"); }
		if (!objTHIS)
		{
			return;
		}
		//appLogger.info("setSelectedGroup: START");
		//MATRIX2.traceGroup(activeGroup_Cell);
		//MATRIX2.traceGroup(syncGroup);

		var objPl = objTHIS.getName() == 'cell_blk' ? objTHIS : objTHIS.getAncestorOfName('cell_blk');
		if (!objPl)
		{
			return;
		}
		var objPin = objPl.getDescendantOfName('cell_pin');
		var objControls = mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls;
		var ptzDialog = mx.MATRIX2.getServer().getJSXByName("ptzDialog");

		var nPlayer = MATRIX2.getObjFromIFrame('_mplayer_', objPl);

		if(activeGroup_Cell == null) {
			activeGroup_Cell = MATRIX2.getObjFromIFrame('groupIFAPlayer', null);
		}

		if(syncGroup == null) {
			syncGroup = MATRIX2.getObjFromIFrame('groupIFGPlayer', null);
		}

		if(nPlayer===undefined || activeGroup_Cell===undefined || nPlayer==null || activeGroup_Cell==null || syncGroup==undefined || syncGroup==null){
			window.setTimeout(function(){ MATRIX2.setSelectedGroup(objTHIS,objRemove,isPlay); }, 50);
			return;
		}

		//is group already selected
		var allow = true;
		if(objControls.group!=null && objControls.group.isPlayerInGroup(nPlayer)){
			allow = false;
			//appLogger.info(setSelectedGroup: Deny twice select");
		}

		//if set flag for closing cell (now is obsolete)
		if(objPl.getAttribute("close_previous")=="true" && objRemove!=null){
			mx.MATRIX2.btnCellClose(objRemove);
			objPl.setAttribute("close_previous","false");
		}

		//deny if selecting already selected group
		if (!allow)
			return;

		//hide recorded window
		objControls.hideRecordDialog(mx.MATRIX2.getServer().getJSXByName('dialog_record').getDescendantOfName('header'));

		///////////////////////////////////////S613
		if (soundPlayerInstance && soundPlayerInstance.getParameter('cell_id')!=null) {
			var sButton = mx.MATRIX2.getServer().getJSXById(soundPlayerInstance.getParameter('cell_id')).getDescendantOfName('cell_sound');
			if(soundPlayerInstance.id){
				mx.MATRIX2.pauseSound(sButton);
			}

			if(objPl.getAttribute("assocAudioId")) {
				if(objPl.getAttribute("state")=="playing"){
					mx.MATRIX2.playSound(sButton);
				}
			}
		}
		///////////////////////////////////////
		// remove previous single cell selection and set cell to gray
		if((activeGroup_Cell.getGroupSize()-activeGroup_Cell.getNumOfAudioDevices())==1){
			var prevActiveCell = mx.MATRIX2.getServer().getJSXById(activeGroup_Cell.getPlayer(0).id);
			try {
				prevActiveCell.getDescendantOfName('cell_dev_name').setColor("5F696D");
				prevActiveCell.getDescendantOfName('cell_header').setBackground('background-image:url(./images/design1/gui_cell/cell_header_bg.gif);background-repeat:repeat-x;').repaint();
			} catch (e) {}
			activeGroup_Cell.removePlayer(activeGroup_Cell.getPlayer(0));
		}

		var temp_ts = parseInt(nPlayer.getCurrentTS());
		//if player allready in sync group
		if(objPin.getState() == jsx3.gui.ImageButton.STATE_ON){
            if(window.jsDebug){ appLogger.info("MATRIX2.setSelectedGroup: select syncGroup"); }

			//add Sync players to Active group and paint all syncGroup players cells to red
			for(var i=0; i<syncGroup.getGroupSize(); i++) {
				if(syncGroup.getPlayer(i).getParameter('DEVICE_TYPE')!="A") {
					mx.MATRIX2.getServer().getJSXById(syncGroup.getPlayer(i).id).getDescendantOfName('cell_dev_name').setColor("white");
					mx.MATRIX2.getServer().getJSXById(syncGroup.getPlayer(i).id).getDescendantOfName('cell_header').setBackground('background-image:url(./images/design1/gui_cell/cell_header_bg_blue.gif);background-repeat:repeat-x;').repaint();//cell_header_bg_green
				}
			}

			objControls.setGroup(syncGroup,false,true);

			//if sync group in archive
			if(objControls.group == syncGroup && objControls.group.contextType == 3){
				mx.TIMELINE.timeline.clearColorScale();
			}

			if(objPl.getAttribute("player_mode") == "0") {
				objControls.switch2live();
			}
			else {
				if(objPl.getAttribute("markA") && objPl.getAttribute("markA") != 'null'){
					objControls.switch2archive(objPl.getAttribute("markA"),objPl.getAttribute("markB"),true,diff,true);
				}
				else { // if event or plain archive
					objControls.switch2archive();
				}
				if (temp_ts) {
					objControls.setTime(temp_ts);
				}
			}

			if(ptzDialog.getVisibility() == jsx3.gui.Block.VISIBILITYVISIBLE) {
				ptzDialog.setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
			}
			// If player in sync group, disable joystick
			HWJoystick.setObj(null);

			//appLogger.info("setSelectedGroup: select syncGroup OK");
		}
		else { //if player in single cell
            if(window.jsDebug){ appLogger.info("MATRIX2.setSelectedGroup: select single cell"); }
			mx.MATRIX2.getServer().getJSXById(objPl.getId()).getDescendantOfName('cell_dev_name').setColor("white");
			mx.MATRIX2.getServer().getJSXById(objPl.getId()).getDescendantOfName('cell_header').setBackground('background-image:url(./images/design1/gui_cell/cell_header_bg_blue.gif);background-repeat:repeat-x;').repaint();

			//remove from Active and paint all syncGroup players cells to red
			for(var i=0; i<syncGroup.getGroupSize(); i++) {
				if(syncGroup.getPlayer(i).getParameter('DEVICE_TYPE')!="A"){
					//mx.MATRIX2.getServer().getJSXById(syncGroup.getPlayer(i).id).getDescendantOfName('cell_dev_name').setColor("white");
					mx.MATRIX2.getServer().getJSXById(syncGroup.getPlayer(i).id).getDescendantOfName('cell_dev_name').setColor("5F696D");
					mx.MATRIX2.getServer().getJSXById(syncGroup.getPlayer(i).id).getDescendantOfName('cell_header').setBackground('background-image:url(./images/design1/gui_cell/cell_header_bg.gif);background-repeat:repeat-x;').repaint();//cell_header_bg_red
				}
			}
			if(!activeGroup_Cell.isPlayerInGroup(nPlayer)){
				activeGroup_Cell.addPlayer(nPlayer);
			}

			objControls.setGroup(activeGroup_Cell,false,true);
			if (objPl.getAttribute("recording") == '1') {
				objControls.switch2live();
				objControls.startRecord(objPl.getAttribute("markA"));
			} else if(objPl.getAttribute("player_mode") == "0") {
				if(objControls.group.contextType != 2){
					objControls.switch2live();
				}
				else{
					objControls.play(true);
				}
			} else {
				if(objPl.getAttribute("markA") && objPl.getAttribute("markA") != 'null') {
                    if(window.jsDebug){ appLogger.info("MATRIX2.setSelectedGroup: markA archive switch"); }
					objControls.switch2archive(parseInt(objPl.getAttribute("markA")), parseInt(objPl.getAttribute("markB")));
				} else { // if event or plain archive
                    if(window.jsDebug){ appLogger.info("MATRIX2.setSelectedGroup: simple archive switch"); }
					objControls.switch2archive();
				}
				// set correct player time after switching to archive
				if (temp_ts) {
					if(jsDebug){ appLogger.info("SET SELECTED GROUP: temp_ts=" + temp_ts); }
					objControls.setTime(temp_ts);
				}
			}
			//if(window.jsDebug){ appLogger.info("MATRIX2.setSelectedGroup: objPl.getAttribute(position_control)="+objPl.getAttribute("position_control")); }
			var devOld = resourceTree.getObject(mx.PTZ.camera_id);
			if(devOld != null && devOld.attr("POSITIONCTL") != "none"){
				mx.PTZ.unlockDevice();
			}

			if(ptzDialog.getVisibility() == jsx3.gui.Block.VISIBILITYVISIBLE) {
				if( objPl.getAttribute("position_control") == "0") {
					ptzDialog.setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
				} else {
					mx.PTZ.load(objPl.getDescendantOfName("cell_joystick"));
				}
			}
			mx.PTZ.cell_id = objPl.getId();
			mx.PTZ.camera_id = objPl.getAttribute("objectId");

			if( objPl.getAttribute("position_control") == "1") {
				HWJoystick.setObj(objPl.getAttribute('objectId'));
			} else {
				HWJoystick.setObj(objPl.getAttribute(null));
			}

			//appLogger.info("setSelectedGroup: select single cell OK");
		}

		//if in eLog enabled "Selected" filter
		if(mx.ELog2.device == 'selected') {
			mx.ELog2.setFilterValue('device', "selected");
		}

		//MATRIX2.traceGroup(activeGroup_Cell);
		//MATRIX2.traceGroup(syncGroup);
		//appLogger.info("setSelectedGroup: END");
	};

	MATRIX2.launchAdminGUI = function() {
		mx.PTZ.unlockDevice();
		window.location.replace(location.protocol + "//" + location.host + resourceTree.getObject(51).attr('URL'));
	};

    MATRIX2.playSound = function(objThis,isExecute) { //execute command
		appLogger.info("playSound: START");

        mx.MATRIX2.setSelectedGroup(objThis, false, false);
		var objCell = objThis.getAncestorOfName("cell_blk");
		var objControls = mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls;

		var player = MATRIX2.getObjFromIFrame('_mplayer_', objCell);

		var sp = MATRIX2.getObjFromIFrame('_mplayer_SoundPlayer', objCell);

		if(!player || !sp){
			window.setTimeout(function(){ mx.MATRIX2.playSound(objThis); }, 50);
			return false;
		}

		//if player in active group allow sound from this player
		if (!objControls.group || !objControls.group.isPlayerInGroup(player)) {
			alert(__("This player not in active group!"));
			return;
		}

		//deny multisound
		var isMultisound = false;
		for(var i=0;i<objControls.group.players.length;i++){
			if(objControls.group.getPlayer(i)===soundPlayerInstance || objControls.group.getPlayer(i).getParameter('DEVICE_TYPE')=="A"){
				isMultisound = true;
			}
		}
		//MATRIX2.traceGroup(objControls.group);
		if(isMultisound){
			alert(__("Multiple sound devices playing denied!"));
			return;
		}

		if(!objControls.group.isPlayerInGroup(soundPlayerInstance)){
			soundPlayerInstance = sp;
			soundPlayerInstance.setParameter('cell_id',objCell.getId());
			objControls.group.addPlayer(soundPlayerInstance);
			//hack
			var command = objControls.group.getCommand();
			appLogger.info("playSound: group - command="+command.cmd+", status="+command.status);
			if(command.cmd==2 && command.status==1){
				//command.direction,this.curSpeed
				//objControls.group.players[objControls.group.getPlayerPos(soundPlayerInstance)].player.play(command.direction, objControls.curSpeed, objControls.group.currentTS);
				objControls.group.play(command.direction, objControls.curSpeed, objControls.group.getCurrentTS());
				appLogger.info("playSound: hack play");
			}
			//
			appLogger.info("playSound: player added to "+objControls.group.id+": sync="+syncGroup.id+", active="+activeGroup_Cell.id);

			if(objControls.group.id!=syncGroup.id && syncGroup.isPlayerInGroup(soundPlayerInstance)){
				syncGroup.removePlayer(soundPlayerInstance);
			}

			if(objControls.group.id!=activeGroup_Cell.id && activeGroup_Cell.isPlayerInGroup(soundPlayerInstance)){
				activeGroup_Cell.removePlayer(soundPlayerInstance);
			}
			//MATRIX2.traceGroup(objControls.group);
		}
		//MATRIX2.traceGroup(objControls.group);
		/*else{
			//hack
			appLogger.info("playSound: objControls.group.getCommand()="+objControls.group.getCommand());
			if(objControls.group.getCommand()==2){
				objControls.group.players[objControls.group.getPlayerPos(soundPlayerInstance)].player.play();
				appLogger.info("playSound: hack play");
			}
			//
		}*/

		objCell.setAttribute("state","playing");
		objThis.setImage("jsxuser:///images/design1/gui_cell/cell_audio_on.png");
		//objThis.setOverImage("jsxuser:///assets/sound32_over.gif");
		objThis.setEvent("mx.MATRIX2.pauseSound(this,true);", jsx3.gui.Interactive.EXECUTE);
		objThis.setTip(__("Disable sound"));
		objThis.repaint();

		//appLogger.info("playSound: syncGroup play ok");
		//MATRIX2.traceGroup(objControls.group);
		//appLogger.info("playSound: END");
	};

	MATRIX2.activeSoundCellId = null;

	MATRIX2.playBuildInSound = function(objThis) {
		appLogger.info("playBuiltInSound");
        mx.MATRIX2.setSelectedGroup(objThis, false, false);
		var objCell = objThis.getAncestorOfName("cell_blk");
		var objControls = mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls;

		var player = MATRIX2.getObjFromIFrame('_mplayer_', objCell);

		if(player==undefined || player==null){
			window.setTimeout(function(){ mx.MATRIX2.playBuildInSound(objThis); }, 50);
			return;
		}

        if (!objControls.group || !objControls.group.isPlayerInGroup(player)) {
			alert(__("This player not in active group!"));
			return;
		}

		//if player in active group allow sound from this player
        if(MATRIX2.activeSoundCellId != null){
            alert(__("Multiple sound devices playing denied!"));
            return;
        }

        objControls.group.setAudio(true, player.id);
        appLogger.info("MATRIX2.playBuildInSound: id="+player.id+", AUDIOOBJID="+player.getParameter('AUDIOOBJID'));

        objThis.setImage("jsxuser:///images/design1/gui_cell/cell_audio_on.png");
        objThis.setEvent("mx.MATRIX2.stopBuildInSound(this);", jsx3.gui.Interactive.EXECUTE);
        objThis.setTip(__("Disable sound"));
        objThis.repaint();

        /*if(MATRIX2.activeSoundCellId != null && MATRIX2.activeSoundCellId != objCell.getId()){
            var oldSoundCell = mx.MATRIX2.getServer().getJSXById(MATRIX2.activeSoundCellId);
            if(oldSoundCell && oldSoundCell.getDescendantOfName('cell_sound')){
                var soundButton = oldSoundCell.getDescendantOfName('cell_sound');
                soundButton.setImage("jsxuser:///images/design1/gui_cell/cell_audio_off.png");
                soundButton.setEvent("mx.MATRIX2.playBuildInSound(this);", jsx3.gui.Interactive.EXECUTE);
                soundButton.setTip(__("Enable sound"));
                soundButton.repaint();
            }
        }*/

        MATRIX2.activeSoundCellId = objCell.getId();
	};

	MATRIX2.stopBuildInSound = function(objThis) {
        mx.MATRIX2.setSelectedGroup(objThis, false, false);
		var objCell = objThis.getAncestorOfName("cell_blk");
		var objControls = mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls;

		var player = MATRIX2.getObjFromIFrame('_mplayer_', objCell);

		if(player==undefined || player==null){
			window.setTimeout(function(){ mx.MATRIX2.stopBuildInSound(objThis); }, 50);
			return;
		}

        if (!objControls.group || !objControls.group.isPlayerInGroup(player)) {
			alert(__("This player not in active group!"));
			return;
		}

		//if player in active group allow sound from this player
        objControls.group.setAudio(false, null);
        MATRIX2.activeSoundCellId = null;
        //appLogger.info("stopBuildInSound: id="+player.id);

        objThis.setImage("jsxuser:///images/design1/gui_cell/cell_audio_off.png");
        objThis.setEvent("mx.MATRIX2.playBuildInSound(this);", jsx3.gui.Interactive.EXECUTE);
        objThis.setTip(__("Enable sound"));
        objThis.repaint();
	};


	MATRIX2.traceGroup = function (objGroup){
		if(objGroup!=null){
			appLogger.info("objGroup="+objGroup.id+", contextType="+objGroup.contextType);
			if(objGroup.players!=null){
				for(var i=0;i<objGroup.players.length;i++){
					appLogger.info("player "+i+":"+objGroup.players[i].player.id+", context="+objGroup.players[i].player.contextType+", command.cmd="+objGroup.players[i].player.command.cmd+", command.status="+objGroup.players[i].player.command.status);
				}
			}
		}
	};

	MATRIX2.pauseSound = function(objThis,isExecute) {
		//appLogger.info("pauseSound: START");
		var objCell = objThis.getAncestorOfName("cell_blk");
		var objControls = mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls;
		var player = MATRIX2.getObjFromIFrame('_mplayer_', objCell);
		//appLogger.info("objControls.group.isPlayerInGroup(player)="+objControls.group.isPlayerInGroup(player));
		//appLogger.info("soundPlayerInstance="+soundPlayerInstance);
		//MATRIX2.traceGroup(objControls.group);
		if(objControls.group && objControls.group.isPlayerInGroup(player) && soundPlayerInstance!=null){
			objControls.group.removePlayer(soundPlayerInstance);
			soundPlayerInstance.stop();
			//alert("activeGroup_Cell pause ok");
		}
		//MATRIX2.traceGroup(objControls.group);
		objCell.setAttribute("state","pause");
		objThis.setImage("jsxuser:///images/design1/gui_cell/cell_audio_off.png");
		objThis.setEvent("mx.MATRIX2.playSound(this,true);", jsx3.gui.Interactive.EXECUTE);
		objThis.setTip(__("Enable sound"));
		objThis.repaint();
    };


	// cell_player.php?camera=0&name=IFGPlayer&width=50&height=50&initstate=Idle
	MATRIX2.registerSyncGroup = function() {
		if(jsx3.CLASS_LOADER.IE) { return; }
		if(jsx3.CLASS_LOADER.FX) {
				var newGroup = mx.MATRIX2.getServer().getJSXByName('iframeGPlayer').getRendered().firstChild.contentWindow.groupIFGPlayer;
				var newPlayer = mx.MATRIX2.getServer().getJSXByName('iframeGPlayer').getRendered().firstChild.contentWindow._mplayer_IFGPlayer;
		}
		if(newGroup==null || newPlayer==null) {
				window.setTimeout(function(){ mx.MATRIX2.registerSyncGroup(); }, 100);
		} else {
				//alert("Sync registered!    "+newGroup.id+"    "+newPlayer.id);
				//newGroup.addPlayer(newPlayer);
		}
	};

	MATRIX2.guiLogOff = function(message) {
		mx.PTZ.unlockDevice();
		window.location = MATRIX2.getServerURL() + '/sdi/login/logout.php?message=' + message + '&token=' + getToken();
	};

	MATRIX2.getServerURL = function(){
		if(window.jsServerPort != 80){
			return window.jsServerProto+"://"+window.jsServerName+":"+window.jsServerPort;
		} else{
			return window.jsServerProto+"://"+window.jsServerName;
		}
	};

	MATRIX2.clearTrail = function(objId)
	{
		var ge_frame = mx.MATRIX2.getServer().getJSXByName('ge_iframe');
		if (ge_frame)
		{
			var ge_iframe = mx.MATRIX2.getIFrame(ge_frame);
			if (ge_iframe)
			{
				var deviceData = ge_iframe['device_' + objId];
				if (deviceData && deviceData.placemark) {
					deviceData.line.getCoordinates().clear();
				}
			}
		}
	};

	MATRIX2.quickSwitch2archive = function(objCell, isQuick){
		var objControls = mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls;
		var nPlayer = MATRIX2.getObjFromIFrame('_mplayer_', objCell);

		if(nPlayer==undefined || nPlayer==null){
			window.setTimeout(function(){ MATRIX2.quickSwitch2archive(objCell); }, 50);
			return;
		}

		MATRIX2.clearTrail(nPlayer.devObjId);

		MATRIX2.setSelectedGroup(objCell.getDescendantOfName("cell_select"), false, false);

		//check recording before switching to archive mode
		//if(window.jsDebug){ appLogger.info("MATRIX2.quickSwitch2archive: objCell.getAttribute('recording')="+objCell.getAttribute('recording')); }
		if (objCell.getAttribute('recording') == 1) {
			alert(__("Finish recording operation first!"));
			return;
		}

		if(objControls.group && objControls.group.isPlayerInGroup(nPlayer)){
			isPlayInArchive=true;
			if(objCell.getAttribute("eventid")!=-1) { // if archive event
				var localStartTS = parseInt(objCell.getAttribute("ts_from"));
				var localEndTS = parseInt(objCell.getAttribute("ts_to"));
				var diff = parseInt(objCell.getAttribute("time_zone"))-0+parseInt(objCell.getAttribute("dst_from"));
				objControls.switch2archive(localStartTS,localEndTS,true,diff,true);
			}
			else{ // if simple archive
				objControls.switch2archive();
			}
			objCell.getDescendantOfName("cell_dev_state").setTip(__("Switch cell to Live")).repaint();

			if(objControls.canArchiveOnDemand()){
				MATRIX2.setButtonInCellHeader(objCell, 'cell_deliver', true);
			}
		}
	};

	MATRIX2.quickSwitch2live = function(objCell, isQuick){
		var objControls = mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls;
		var nPlayer = MATRIX2.getObjFromIFrame('_mplayer_', objCell);

		if(nPlayer==undefined || nPlayer==null){
			window.setTimeout(function(){ MATRIX2.quickSwitch2live(objCell); }, 50);
			return;
		}

		MATRIX2.clearTrail(nPlayer.devObjId);

		MATRIX2.setSelectedGroup(objCell.getDescendantOfName("cell_select"), false, false);

		if(objControls.group && objControls.group.isPlayerInGroup(nPlayer)){
			objControls.switch2live();
			objCell.getDescendantOfName("cell_dev_state").setTip(__("Switch cell to Archive")).repaint();
		}

		MATRIX2.setButtonInCellHeader(objCell, 'cell_deliver', false);
	};

	MATRIX2.setDialogForMAC = function(objDialog,isRepaint){
		//--needed for MAC scrollbars
		if(navigator.appVersion.indexOf("Mac")!=-1){
			objDialog.setBackgroundColor("-1",true);
			objDialog.setBorder("0px thin green");
			objDialog.getFirstChild().setBackgroundColor("-1",true);
			objDialog.getFirstChild().setBorder("0px thin green");
			objDialog.getLastChild().setBackgroundColor("-1",true);
			objDialog.getLastChild().setBorder("0px thin green");
			objDialog.getFirstChild().setCSSOverride("overflow: auto;");
			//objDialog.getLastChild().setCSSOverride("overflow: auto;");
			if(isRepaint){
				objDialog.repaint();
			}
		}
	};


	/**
	 * Set alert block flashing, set timeout to stop flashing
	 * @param  jsx3.gui.Block  alertBlock  block which must flash
	 */
	MATRIX2.setAlert = function(alertBlock) {
		var objCell = alertBlock.getAncestorOfName("cell_blk");
		var colSizes = objCell.getDescendantOfName("cell_header").getCols().split(",");
		objCell.getDescendantOfName("cell_header").setCols("*,20,"+colSizes[2]+",20", true);

		alertBlock.setBackground("background-image:url(./assets/eventlog/e20x20.gif); background-repeat:repeat-x;");
		alertBlock.setTip(__("Click to stop flashing"));
		alertBlock.repaint();

		var id = alertBlock.getId();
		// Check if such timeout exists and clear it
		if (MATRIX2.alertTimeouts[id]) {
			clearTimeout(MATRIX2.alertTimeouts[id]);
			delete MATRIX2.alertTimeouts[id];
		}
		MATRIX2.alertTimeouts[id] = setTimeout(function () { mx.MATRIX2.stopAlert(alertBlock) }, 60000);
	};

	/**
	 * Stop alert block flashing (function calls by click on block or on timeout)
	 * @param  alertBlock jsx3.gui.Block - block to stop flashing
	 */
	MATRIX2.stopAlert = function(alertBlock, objEVENT){
		alertBlock.setBackground("");
		alertBlock.setTip("");
		alertBlock.repaint();

		var objCell = alertBlock.getAncestorOfName("cell_blk");
		var colSizes = objCell.getDescendantOfName("cell_header").getCols().split(",");
		objCell.getDescendantOfName("cell_header").setCols("*,0,"+colSizes[2]+",20", true);

		var id = alertBlock.getId();
		// Check if such timeout exists and clear it
		if (MATRIX2.alertTimeouts[id]) {
			clearTimeout(MATRIX2.alertTimeouts[id]);
			delete MATRIX2.alertTimeouts[id];
		}

		if(objEVENT){
			objEVENT.cancelBubble();
		}
	};
	
	/*
		Add html5 audio sound to Matrix GUI	
	*/
	MATRIX2.addHTMLSound = function(id, path){
		$("#GUISounds").append('<audio id="' + id + '" src="' + path + '"></audio>');
	};
	
	/*
		Play html5 audio sound to Matrix GUI	
	*/
	MATRIX2.playHTMLSound = function(id){
		document.getElementById(id).play();
	};

	//set product name
	MATRIX2.setProductName = function(){
		//appLogger.info("Session setProductName: START");
		var systemInfo = MATRIX2.getSystemInfo();
		var edition_file = systemInfo.edition.split(' ').join('_');

		MATRIX2.getServer().getJSXByName("blockProductName").setText(
			'<table border="0" style="width:100%">' +
			'<tr>' +
			'	<td valign="middle" style="width:100%;padding-right:15px;">' +
			'		<div id="copyright_info">' +
						__("version") + ' ' + systemInfo.basever + ' / ' + systemInfo.os + '<br />&copy; 2007-2015 videoNEXT Federal, Inc.<br>All rights reserved worldwide' +
			'		</div>' +
			'	</td>' +
			'	<td style="padding-top: 0px;">' +
			'		<a href="#" onClick="$(\'#copyright_info\').toggle();"><img style="width:auto;height:55px;position:relative;z-index:100;border:none;" src="/sdi/global/img/logo_small-' + edition_file + '.png" title="' + systemInfo.name + '" border="0" /></a>' +
			'	</td>' +
			'</tr>' +
			'</table>'
			, true);
		//appLogger.info("SessionsetProductNamemonitor: OK");
	};

	// get system brand and additional info
	MATRIX2.getSystemInfo = function ()
	{
		var info = {};
		var jqxhr = $.ajax({
			url:  "/api/call.php",
			data: {
				"function": "getVersionControlInformation",
				 section: "info"
			},
			async:    false,
			cache:    false,
			dataType: "json"
		}).done(function(result){
			info = result.section.info;
		});

		var brandName = "STRATUS";
		var edition = info.edition ? info.edition : brandName;
		if(edition == ""){
			edition = info.brand;
		}
		var name = edition;

// CLARE_REPLACE_MATRIXJS_ID001_BEGIN
		name += " by videoNEXT";
// CLARE_REPLACE_MATRIXJS_ID001_END

		var ver = info.ver;
		var basever = ver.split('.');

		return {
			os:      info.os,
			sp:      info.level,
			version: info.ver,
			basever: basever[0] + "." + basever[1],
			name:    name,
			edition: edition
		};
	};

	MATRIX2.exportCanceled = false;

	MATRIX2.cancelExport = function(){
		var cancel = confirm(__("Do you want to cancel export?"));
		if(cancel){
			mx.MATRIX2.exportCanceled = true;

			var exporter = mx.MATRIX2.getObjFromIFrame('media_exporter');
			exporter.cancelExport();

			var progressBar = mx.MATRIX2.getServer().getJSXByName('progressBarMediaExport');
			progressBar.setCols("0%,*", true);
			progressBar.setDisplay(jsx3.gui.Block.DISPLAYNONE, true);

			mx.MATRIX2.getServer().getJSXByName('labelMediaExportProgress').setText("0/100 [%]", true);

			mx.MATRIX2.getServer().getJSXByName('cancelExport').setDisplay(parent.jsx3.gui.Block.DISPLAYNONE, true);
			window.setTimeout(function(){ showMediaExportControl(false); }, 100);
		}
	};

	// check if dialog moved out of visible area
	MATRIX2.checkDialogPosition = function(objDialog) {
		//if(window.jsDebug){ appLogger.info("MATRIX2.checkDialogPosition: objDialog="+objDialog); }
		if(objDialog){
			var diff = objDialog.getAbsolutePosition().T-objDialog.getParent().getAbsolutePosition().T;
			var parentHeight = objDialog.getParent().getAbsolutePosition().H;

			var parentLeftDiff = objDialog.getAbsolutePosition().L-objDialog.getParent().getAbsolutePosition().L;
			var parentRightDiff = objDialog.getAbsolutePosition().L-(objDialog.getParent().getAbsolutePosition().L+objDialog.getParent().getAbsolutePosition().W);

			var up_limit = 0;
            //limit elog dialog movement in archive mode for timeline visibility
			if(objDialog.getName() == 'eLog2dialog'/* && mx.ELog2.mode == 'archive'*/){
				up_limit = 30;
			}

			if(diff < up_limit //if moved across upper and
				|| (diff >= parentHeight-25) //lower visible boundaries
				|| parentLeftDiff < 0 //left visible boundaries
				|| parentRightDiff > -25 //right visible boundaries
			){
				objDialog.setTop(objDialog.getTop());
				objDialog.setLeft(objDialog.getLeft(), true);
                return true;
			}
		}
        return false;
		//appLogger.info("checkDialogPosition: OK");
	};


	/**
	 * Inverts blockTLButtonsImage, needed to provide support both of ltr and rtl layouts
	 */
	MATRIX2.invertSeparatorArrows = function(imgName){
		var img = mx.MATRIX2.getServer().getJSXByName(imgName);
		if (!img) return;

		if (img.getSrc() == 'images/design1/separator/separator_arrows_r.gif')
			img.setSrc('images/design1/separator/separator_arrows.gif');
		else
			img.setSrc('images/design1/separator/separator_arrows_r.gif');

		img.repaint();
	};

	/**
	 * Get identity value
	 * @param property_name     name of identity parameter, i.e. EVENTLOG_MAX_EVENT_LENGTH
	 */
	MATRIX2.getIdentityValue = function(property_name) {

		var initTime = new Date().getTime() / 1000;

		// Refresh data, if it was updated more than 5 minutes ago
		if (MATRIX2.identity.lastUpdated + 300 < initTime || !MATRIX2.identity[property_name]) {
			$.ajax({
				url: '/api/call.php',
				data: {
					'function':   'getIdentityAttributes'
				},
				async: false,
				cache: false,
				dataType: "json",
				success: function(data, status, request) {
					data = data['list'];

					// clear identity object and fill it with new data
					mx.MATRIX2.identity = { lastUpdated: initTime };
					for(name in data) if (data.hasOwnProperty(name)) {
						mx.MATRIX2.identity[name] = data[name];
					}
				}
			});
		}

		return MATRIX2.identity[property_name];
	};

	/**
	 * Get object parameter value
	 * @param obj     			object id
	 * @param property_name     name of parameter
	 */
	MATRIX2.getObjectAttribute = function(obj, property_name) {
		var value = null;

		$.ajax({
			url: '/api/call.php',
			data: {
				'function':   'getAttribute',
				'obj':   obj,
				'attribute':   property_name
			},
			async: false,
			cache: false,
			success: function(data, status, request) {
				value = data.value;
			}
		});

		return value;
	};


	/**
	 * Get current server time in UTC
	 */
	MATRIX2.getServerTime = function() {
		var servertime = null;
		$.ajax({
			url: '/api/call.php',
			data: {'function': 'getServerTime'},
			async: false,
			cache: false,
			success: function(data) {
				servertime = data["servertime"];
			},
			error: function() {
				//msg
			}
		});

		return servertime * 1000;
	};

	/**
		show message
	*/
	MATRIX2.showMessage = function(header, message, timeout){
		MATRIX2.hideMessage();

		mx.Dialog.createDialog(
			"gui_message",
			'&nbsp;' + header,
			{top: 0, left: '20px', width: '300px', 'text-align': 'center'},
			message + '<br/>'
		);

		if(timeout == undefined){
			timeout = 5;
		}

		if(window['gui_message_timer']){ clearTimeout(window['gui_message_timer']); }
		window['gui_message_timer'] = window.setTimeout(function(){
			if(window.jsDebug){ appLogger.info("MATRIX2.showMessage: hide on timeout"); }
			mx.MATRIX2.hideMessage();
		}, timeout*1000);
	};

	/**
		hide message
	*/
	MATRIX2.hideMessage = function(){
		if($('#gui_message').size() > 0){
			$('#gui_message').remove();
		}
	};


	MATRIX2.onExporterNewDataChunk = function(size, progress, error_string) {
		var progressBar = MATRIX2.getServer().getJSXByName('progressBarMediaExport');

		if (error_string != null)
		{
			progressBar.setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
			alert("An error occured: " + error_string);
			showMediaExportControl(false);
			return;
		}

		if (size == 0 && progress == 100) // we are done
		{
			progressBar.setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
			progressBar.setCols("0%,*", true);
			MATRIX2.getServer().getJSXByName('labelMediaExportProgress').setText("0/100 [%]", true);
			showMediaExportControl(false);
			MATRIX2.getServer().getJSXByName('cancelExport').setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
			MATRIX2.exportCanceled = false;

			var frameContent = mx.MATRIX2.getIFrame(mx.MATRIX2.getServer().getJSXByName('iframeMediaExport')).document;
			var vars = 'defaultView' in frameContent? frameContent.defaultView : frameContent.parentWindow;


			auditObj.callAddAuditRecord(14, null, {
				digestparams:[],
				params:{
					DEVICE: vars.dev,
					FROM: vars.start,
					TO: vars.end
				}
			});

		}
		else
		{
			if(MATRIX2.exportCanceled){
				return false;
			}

			var strCols = progress+"%,*";
			progressBar.setCols(strCols, true);
			MATRIX2.getServer().getJSXByName('labelMediaExportProgress').setText((progress+"/100 [%]"), true);
			if(MATRIX2.getServer().getJSXByName('cancelExport').getDisplay() != "") {
				MATRIX2.getServer().getJSXByName('cancelExport').setDisplay(jsx3.gui.Block.DISPLAYBLOCK, true);
			}
		}
	};

	MATRIX2.onExporterReady = function() {
		MATRIX2.getServer().getJSXByName('progressBarMediaExport').setDisplay(jsx3.gui.Block.DISPLAYBLOCK, true);
		MATRIX2.getServer().getJSXByName('labelMediaExportProgress').setText("0/100 [%]", true);
		showMediaExportControl(true);
	};

	MATRIX2.setDesignationMode = function(button) {
		var cell = button.getAncestorOfName('cell_blk');
		var playerFrame = mx.MATRIX2.getIFrame(cell.getDescendantOfName('iframe_player'));
		var player = mx.MATRIX2.getObjFromIFrame('_mplayer_', cell).playerImpl;

		this.cameraOnImageClick = this.cameraOnImageClick || function(width, height, x, y) {
			/*
			var primDiam = width / 25;
			player.layer.primitive['designateTarget'] = {
				type: 'ellipse',
				x: x - 10,
				y: y - 10,
				width: primDiam,
				height: primDiam,
				stroke: {width: 1, color: 0xFF00FF00}
				//fill: {color: 0xFFFFFFFF}
			};
			*/

			mx.GE.designation.onCameraClick(this.getObj(), width, height, x, y);
		};

		/**
		 * @type {MediaPlayer}
		 */
		var playerWrapper = playerFrame.playerWrapper;

		if (playerFrame.designationModeOn) {
			playerWrapper.unsubscribe("imageclick", this.cameraOnImageClick, "zoom");

			playerFrame.designationModeOn = false;
			player.layer.primitive = {};
			button.setTip('Designation mode (off)');
		} else {
			playerWrapper.subscribe("imageclick", this.cameraOnImageClick, "zoom");

			playerFrame.designationModeOn = true;
			player.layer.primitive = {};
			button.setTip('Designation mode (on)');
		}

		button.repaint();
	};

	MATRIX2.clearCurrentDesignationTargets = function(objId) {
		if(groupControls.group == null || groupControls.group == undefined){
			return;
		}

		var players = groupControls.group.players;
		for (var i = 0; i < players.length; i++) {
			var player = players[i].player;
			if (player.devObjId == objId) {
				player.playerImpl.layer.primitive = {};
			}
		}
	};

	MATRIX2.changeResolution = function(button) {
		var newValue = button.getValue() ? 0 : 1;
		var cell = button.getAncestorOfName("cell_blk");
		var player = MATRIX2.getObjFromIFrame('_mplayer_', cell);

		if(window.jsDebug){ appLogger.info("---------->MATRIX2.changeResolution: newValue="+newValue); }
		
        var timestamp = player.getCurrentTS();
		player.stop();
		player.setParameter('STREAMNUM', newValue);
		player.play(1, 1, timestamp);

		MATRIX2.updateResolutionButton(button, newValue);
        mx.TIMELINE.refreshTimelineContents();
		
		if(window.jsDebug){ appLogger.info("---------->MATRIX2.changeResolution: FINISHED, player.getParameter('STREAMNUM')="+player.getParameter('STREAMNUM')); }
	};

	MATRIX2.updateResolutionButton = function(button, value) {
		if (value == 1) {
			button.setImage('images/design1/gui_cell/stream_normal.png')
				.setTip(__('Normal resolution'));
		} else {
			button.setImage('images/design1/gui_cell/stream_low.png')
				.setTip(__('Low resolution'));
		}
		button.setValue(value).repaint();
	};

    MATRIX2.checkSystemClassification = function() {
        var sys = MATRIX2.getIdentityValue("SYSTEM_CLASSIFICATION");
        if (sys == 'public')
            return;

		var classificationHtml = '<div class="system_classification"> - ' + sys.toUpperCase() + ' - </div>';

		jsx3.GO("paneClassificationTop").setText(classificationHtml, true);
		jsx3.GO("paneClassificationBottom").setText(classificationHtml, true);
		jsx3.GO("layoutClassification").setRows("20,*,20", true);
    };
});
