jsx3.lang.Package.definePackage("mx.MAP", function (MAP)
{
	"use strict";

	/**
	 *
	 * @param {jsx3.gui.Block} objDest
	 * @param {string} params
	 */
	MAP.addMap = function (objDest, params)
	{
		var path = "components/map_cell.xml";

		var map_cell = mx.language.load_translate(objDest, path);
		map_cell.setName("map_cell");

		map_cell.setAttribute("onmouseover", "mx.MAP.onDndIn(this)");
		map_cell.setAttribute("onmouseout", "mx.MAP.onDndOut(this)");

		var map_dnd = map_cell.getDescendantOfName('map_dnd');
		map_dnd.setTip(__("Drop here"));

		objDest.removeAttribute("playerBlock");

		var src = "/sdi/map/map.php";
		if (params)
		{
			src += "?" + encodeURI(params);
		}

		var frame = map_cell.getDescendantOfName('map_iframe');
		frame.setScrolling(jsx3.gui.IFrame.SCROLLNO);
		frame.setSrc(src);

		objDest.repaint();
	};

	MAP.getMapFrame = function (objCell)
	{
		var map_iframe = objCell.getDescendantOfName('map_iframe');
		if (map_iframe)
		{
			var iframe = mx.MATRIX2.getIFrame(map_iframe);
			if (iframe && iframe.map)
			{
				return iframe;
			}
		}

		return false;
	};

	MAP.isMap = function ()
	{
		return !!mx.MATRIX2.getServer().getJSXByName('map_iframe');
	};

	/**
	 *
	 * @param objCell
	 * @param {number} objId
	 */
	MAP.panTo = function (objCell, objId)
	{
		var map_iframe = MAP.getMapFrame(objCell);
		if (!map_iframe)
		{
			appLogger.info("Error in 2D map panTo: no access to iframe");
			return;
		}

		var obj = resourceTree.getObject(objId);
		var lat = parseFloat(obj.attr("CAM_GEO_LAT"));
		var lng = parseFloat(obj.attr("CAM_GEO_LONG"));

		if (isNaN(lat) || isNaN(lng))
		{
			appLogger.info("Error in 2D map panTo: wrong coordinates");
			return;
		}

		var newPosition = {
			"lat": lat,
			"lng": lng,
			"zoomLevel": 17
		};

		map_iframe.map.setCurrentPosition(newPosition);
	};

	MAP.getCurrentPosition = function (objCell)
	{
		var map_iframe = MAP.getMapFrame(objCell);

		if (!map_iframe)
		{
			appLogger.info("Error in 2D map getCurrentPosition: no access to iframe");
			return;
		}

		return map_iframe.map.getCurrentPosition();
	};

	MAP.onDndIn = function (block)
	{
		if (!dragged)
		{
			return;
		}

		var map_cell = mx.MATRIX2.getServer().getJSXById(block.id);
		var map_dnd = map_cell.getDescendantOfName('map_dnd');
		map_dnd.setVisibility(jsx3.gui.Block.VISIBILITYVISIBLE, true);
	};

	MAP.onDndOut = function (block)
	{
		var map_cell = mx.MATRIX2.getServer().getJSXById(block.id);
		var map_dnd = map_cell.getDescendantOfName('map_dnd');
		map_dnd.setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
	};
});
