//------------------------------------------------
// Globals
//------------------------------------------------
	var isPlayInArchive = false;
	var quickSwitch2ArchiveInterval = 20*1000; // 20 sec
	var archiveBufferInterval = 30*24*60*60*1000; // 1 month

	var dragged = false;
	var dragged_splitter = false;
	var dragged_splitter_type = '';
	var glbLegacyNodename = "";
	var glbLegacyDevId = "";
	var ifr_count = 0;

	var sourceXMLDoc = new jsx3.xml.Document();
	sourceXMLDoc.setAsync(true);
	var xmlRequestTmeout = 20000; // milliseconds

	var splSubcontainer_1_2_min = 170; // Min cell size should be: (2 * splSubcontainer_1_2_min)+3; -> where "3" is the divider size

	var syncGroup = null;
	var activeGroup_Cell = null;

	var soundPlayerInstance = null;

	var api = new API();

//------------------------------------------------
// End Globals
//------------------------------------------------

jsx3.require("jsx3.app.Monitor");
jsx3.require("jsx3.util.Logger");
var appLogger = jsx3.util.Logger.getLogger("global");
appLogger.setLevel(jsx3.util.Logger.INFO);  //OFF, WARN, INFO, DEBUG, TRACE, ERROR, GLOBAL, FATAL
if(window.jsDebug){
	appLogger.info("Start logging at level " + appLogger.getLevel());
}

// URL's parameter random generator
function urlRand() {
	return jsx3.xml.CDF.getKey();
}

// Check if input parameter is Numeric
function IsNumeric(n){
	return Boolean(n*1 == n);
}

//------------------------
jsx3.require("jsx3.gui.Dialog");
jsx3.require("jsx3.gui.Splitter");
jsx3.require("jsx3.gui.TextBox");
jsx3.require("jsx3.gui.Select");
jsx3.require("jsx3.net.Request");
jsx3.require("jsx3.gui.Matrix");
jsx3.require("jsx3.gui.Tab");
jsx3.require("jsx3.gui.Event");

matrix2.loadResource('matrix2_js');
matrix2.loadResource('GroupControlClass_js');
matrix2.loadResource('elog2_js');
matrix2.loadResource('touring_js');
matrix2.loadResource('language_js');

window.setTimeout(function(){
	matrix2.loadResource("timeline_js");
}, 2000);

jsx3.gui.Matrix.SELECTION_BG = 'jsxuser:///images/design1/eLog2/eLog2_matrix_select_bg.png';

jsx3.gui.Form.DEFAULTDISABLEDCOLOR = "#878787";
jsx3.gui.Form.DEFAULTDISABLEDBACKGROUNDCOLOR = "#eeeeee";

jsx3.gui.Tab.ACTIVEBEVEL = '';
jsx3.gui.Tab.INACTIVEBEVEL = '';
jsx3.gui.Tab.DEFAULTBEVELIMAGE = '';
//disable tabs switch on mouseover
jsx3.gui.Tab.yg.mouseover = false;
jsx3.gui.Tab.yg.mouseout = false;

	function showElementsWithName(name){
		var elements = matrix2.getDOM().getAllByName(name);
		for (var i = 0; i < elements.length; i++){
			elements[i].setDisplay(jsx3.gui.Block.DISPLAYBLOCK, false);
			elements[i].getParent().repaint();
		}
	}

	function hideElementsWithName(name){
		var elements = matrix2.getDOM().getAllByName(name);
		for (var i = 0; i < elements.length; i++){
			elements[i].setDisplay(jsx3.gui.Block.DISPLAYNONE, false);
			elements[i].getParent().repaint();
		}
	}

	function onLoadMatrix() {
		AMQ
			// check for session close
			.fail(function(status){
				if (status == 401)
				{
					window.location.href = '/sdi/login/logout.php?token=' + getToken();
				}
			})
			// subscribe for session close
			.subscribe("topic://sessionClose_" + readCookie("PHPSESSID"), function(messageList){
				messageList.forEach(function(message){
					var response = JSON.parse(message);
					mx.MATRIX2.guiLogOff(response.reason);
				});
			});

		// Display blocking mask
		mx.MATRIX2.mask(__("LOADING..."));

		if(readCookie("language") == null){
			mx.MATRIX2.guiLogOff("COOKIE_SETTINGS_ERROR");
			return;
		}

		try {
			// Init resource tree and matrix
			mx.MATRIX2.init();

			mx.TIME.updateTimezones();

			mx.ELog2.elStart(jsx3.GO("blockElog2"));
			overloadSlyle();
			mx.OM.startHealthMonitor();
			toggleExpandCollapseLayoutPanel();

			//mx.HOTKEY.registerHotkeys();

			mx.language.translate();
			resourceTree.init(jsx3.GO("resource_wrapper"));
			mx.ELog2.applyFilters();

			mx.AR.addRecorderApplet();

			HWJoystick.init();

			mx.STATE.checkSystemState();

			LSC.init();
			// CIRRUS_REPLACE_LOGIC_JS_ID001_BEGIN
			mx.vMX.vmx_init();
			// CIRRUS_REPLACE_LOGIC_JS_ID001_END

            mx.TIMELINE.init();

			mx.TIME.updateTimezones();

			mx.PTZ.init();
			
			mx.ELog2.checkAnnouncedEvents();

			mx.MATRIX2.loaded = true;

		} catch (e) {
			appLogger.error("Error in onLoadMatrix! Stack trace:\n" + jsx3.lang.NativeError.wrap(e).printStackTrace());
		} finally {
			mx.MATRIX2.mask(false);
		}
	}

	//converts CDF into readable log format
	function prepareXMLforLogger(objXMLCDF){
		return objXMLCDF.toString().replace(/</g,"&lt;").replace(/>/g,"&gt;")
	}

	appLogger.times = {};
	/**
	 * Convenient way to calculate time periods
	 * Usage: appLogger.time('some id'); appLogger.timeEnd('some id')
	 * @param id  string representing time period, i.e. 'load configuration'
	 */
	appLogger.time = function(id) {
		if (!id)
			return;
		appLogger.times[id] = (new Date()).getTime();
	};

	appLogger.timeEnd = function(id) {
		if (!id || !appLogger.times[id] || !window.jsDebug)
			return;
		appLogger.info(id + ': ' + ((new Date()).getTime() - appLogger.times[id]) + 'ms');
	};
