/**
 * Intarnationalisation library class
 * Support internationalisation of text labels, images and tips in Matrix GUI
 */


jsx3.lang.Package.definePackage(
	"mx.language",                //the full package name
	function(language) {          //short package name, good to use in this file only.

	language.lang_direction = readCookie('lang_direction');
	language.code = readCookie("language");

	// List of translated layouts, so we dont need to do same translation twice
	language.translated = {};

	// list of handlers to translate each layout
	language.handlers = {
		"components/gui_cell.xml"      : 'translate_gui_cell',
		"components/url_cell.xml"      : 'translate_url_cell',
		"components/tour_cell.xml"     : 'translate_tour_cell',
		"components/tour_cell_vmx.xml" : 'translate_tour_cell',
		"components/ge_cell.xml"       : 'translate_ge_cell',
		"components/map_cell.xml"      : 'translate_map_cell',
		"components/cdm_cell.xml"      : 'translate_cdm_cell',
		"components/om_cell.xml"       : 'translate_om_cell'
	};

	/**
	 * Assign localisable tips and labels to buttons and other objects in main layout
	 */
	language.translate = function() {

		var server = mx.MATRIX2.getServer();

		var lang = '/' + language.code;

		// Layout block
		server.getJSXByName('buttonExpandDetails').setTip(__("Show details")).repaint();
		server.getJSXByName('buttonCollapseDetails').setTip(__("Hide details")).repaint();

		var name;
		var tips = {
			'image_spl_h'   : [__("Cell Split ( - )"), __("Horizontal split")],
			'image_spl_v'   : [__("Cell Split ( | )"), __("Vertical split")],
			'image_spl_c'   : [__("Cell Split (-|-)"), __("2x2 split")],
			'image_spl_3x2' : [__("Cell Split 3x2"),   __("3x2 split")],
			'image_spl_4x3' : [__("4x3(left-top-promoted) split"), __("4x3(left-top-promoted) split")],
			'image_tour'    : [__("Add a touring sequence of several cameras"), __("Touring control")],
			'url_control'   : [__("Add a website address"), __("URL control")],
			'image_map'     : [__("Add Map"),    __("Map control")],
			'image_cdm'     : [__("Add content download manager"),    __("Content download control")],
			'image_motion'  : [__("Add motion search tab"), __("Add motion search tab")]
		};

		// Layout buttons
		// Short and detailed layout view
		// for each button append appropriate tip
		for (name in tips)
		{
			var view = server.getJSXByName('blockButtonsWithDetails');
			view.getChild(name).setTip(tips[name][0]);
			view.getChild(name).getChild('label').setText(tips[name][1], false);
			view = server.getJSXByName('blockLayotButtons');
			view.getChild(name).setTip(tips[name][0]).repaint();
		}
		server.getJSXByName('blockButtonsWithDetails').getChild("image_elog2_detailed").setTip(__("Add and Engage Event Log here (drag to a cell or below bottom line of your screen)"));
		server.getJSXByName('blockButtonsWithDetails').getChild("image_elog2_detailed").getChild("label").setText(__("Event log"), false);
		server.getJSXByName('blockLayotButtons').getChild("image_elog2").setTip(__("Event log"));

		server.getJSXByName('blockButtonsWithDetails').repaint();
		server.getJSXByName('blockLayotButtons').repaint();

		// Controls block
		server.getJSXByName('controls_label_speed').setText(__("Speed:"), true);
		server.getJSXByName('label_timezone').setText(__("Timezone:"), true);

		// Various
		server.getJSXByName('imgAddNewTab').setTip(__("Add empty tab")).repaint();
		server.getJSXByName('imageSeparatorArrows').setTip(__("Hide resource bar")).repaint();
		server.getJSXByName('layout_label_image').setSrc("images/design1/layout" + lang + "/layout.png").repaint();
		server.getJSXByName('CONTROLSLabel').setSrc("images/design1/player_controls" + lang + "/controls.png").repaint();
		//server.getJSXByName('resources_label_image').setSrc("images/design1/resources" + lang + "/resources.png").repaint();
		server.getJSXByName('imageeLog2_caption').setSrc("images/design1/eLog2" + lang + "/eLog2_caption.png").repaint();

		// Image text into translation table
		__("RESOURCES");
		__("LAYOUT");
		__("CONTROLS");
		__("EVENT LOG");
		__("File");
		__("Admin");
		__("Close");

		// ELog2
		var elog = server.getJSXByName('eLog2dialog');
		server.getJSXByName('paneELog2').setTip(__("Event log"));
		//server.getJSXByName('imagebuttonPrev').setTip(__("Previous page"));
		//server.getJSXByName('imagebuttonNext').setTip(__("Next page"));
		server.getJSXByName('showELogFilters').setTip(__("Show filters"));
		server.getJSXByName('reloadELogFilters').setTip(__("Update event log"));
		server.getJSXByName('ExportELog').setTip(__("Export event log"));
		server.getJSXByName('HideELog2').setTip(__("Close event log"));
		//server.getJSXByName('event_actions_label').setText(__("Event actions:"), true);
		//server.getJSXByName('event_witnesses_label').setText(__("Event witnesses:"), true);
		elog.getDescendantOfName('checkboxMigration').setText(__("Migration"), true);
		elog.getDescendantOfName('lifespan_label').setText(__("Lifespan:"), true);
		elog.getDescendantOfName('priority_label').setText(__("Priority:"), true);
		elog.getDescendantOfName('buttonSave').setTip(__("Save changes")).setText(__("save"), true);
		elog.getDescendantOfName('buttonCancel').setTip(__("Cancel")).setText(__("cancel"), true);
		elog.getDescendantOfName('imagebutton').setTip(__("Close event dialog"));
		elog.getDescendantOfName('sysMessage').setTip(__("System message:"));
		elog.getDescendantOfName('userInstructions').setTip(__("User instructions:"));
		elog.getDescendantOfName('storagePriority').setTip(__("Storage priority"));
		elog.getDescendantOfName('eventPriority').setTip(__("Event priority"));
		elog.getDescendantOfName('buttonAckn').setText(__("acknowledge"), true);
		elog.getDescendantOfName('buttonClr').setText(__("clear"), true);
		elog.getDescendantOfName('deviceProperties').setText(__("Current properties:"), true);
		elog.getDescendantOfName('deviceControls').setText(__("Device:"), true);
		elog.getDescendantOfName('deviceActions').setText(__("Actions:"), true);
		if (jsx3.CLASS_LOADER.SAF) {
			elog.getDescendantOfName('screenshot').setCSSOverride('display: inline-table;');
			elog.getDescendantOfName('actions').setCSSOverride('display: inline-table;');
		}
		server.getJSXByName('tabEG').setAttribute("tabName", __("General")).setText(
			'<span style="height:16px; width:4px; position:relative; background-image:url(./images/design1/tabs/tab_bg_left_bright.png);background-repeat:no-repeat; border: 0px solid red;">&nbsp;</span><span style="height:16px; width:auto; position:relative; background-image:url(./images/design1/tabs/tab_bg_bright.png);background-repeat:repeat-x; color:#000000; border:0px solid green;\">&nbsp;&nbsp;'
			+ __("General")
			+ '&nbsp;&nbsp;</span><span style="height:16px; width:4px; position:relative; background-image:url(./images/design1/tabs/tab_bg_right_bright.png); background-repeat:no-repeat; border:0px solid blue;">&nbsp;</span>',
			true
		);
		server.getJSXByName('tabED').setAttribute("tabName", __("Details")).setText(
			'<span style="height:16px; width:4px; position:relative; background-image:url(./images/design1/tabs/tab_bg_left_bright.png);background-repeat:no-repeat; border: 0px solid red;">&nbsp;</span><span style="height:16px; width:auto; position:relative; background-image:url(./images/design1/tabs/tab_bg_bright.png);background-repeat:repeat-x; color:#000000; border:0px solid red;\">&nbsp;&nbsp;'
			+ __("Details")
			+ '&nbsp;&nbsp;</span><span style="height:16px; width:4px; position:relative; background-image:url(./images/design1/tabs/tab_bg_right_bright.png);background-repeat:no-repeat; border:0px solid red;">&nbsp;</span>',
			true
		);
		server.getJSXByName('tabES').setAttribute("tabName", __("Announce")).setText(
			'<span style="height:16px; width:4px; position:relative; background-image:url(./images/design1/tabs/tab_bg_left_bright.png);background-repeat:no-repeat; border: 0px solid red;">&nbsp;</span><span style="height:16px; width:auto; position:relative; background-image:url(./images/design1/tabs/tab_bg_bright.png);background-repeat:repeat-x; color:#000000; border:0px solid red;\">&nbsp;&nbsp;'
			+ __("Announce")
			+ '&nbsp;&nbsp;</span><span style="height:16px; width:4px; position:relative; background-image:url(./images/design1/tabs/tab_bg_right_bright.png);background-repeat:no-repeat; border:0px solid red;">&nbsp;</span>',
			true
		);
		server.getJSXByName('tabEC').setAttribute("tabName", __("Controls")).setText(
			'<span style="height:16px; width:4px; position:relative; background-image:url(./images/design1/tabs/tab_bg_left_bright.png);background-repeat:no-repeat; border: 0px solid red;">&nbsp;</span><span style="height:16px; width:auto; position:relative; background-image:url(./images/design1/tabs/tab_bg_bright.png);background-repeat:repeat-x; color:#000000; border:0px solid red;\">&nbsp;&nbsp;'
			+ __("Controls")
			+ '&nbsp;&nbsp;</span><span style="height:16px; width:4px; position:relative; background-image:url(./images/design1/tabs/tab_bg_right_bright.png);background-repeat:no-repeat; border:0px solid red;">&nbsp;</span>',
			true
		);
		server.getJSXByName('tabEA').setAttribute("tabName", __("Audit")).setText(
			'<span style="height:16px; width:4px; position:relative; background-image:url(./images/design1/tabs/tab_bg_left_bright.png);background-repeat:no-repeat; border: 0px solid red;">&nbsp;</span><span style="height:16px; width:auto; position:relative; background-image:url(./images/design1/tabs/tab_bg_bright.png);background-repeat:repeat-x; color:#000000; border:0px solid red;\">&nbsp;&nbsp;'
			+ __("Audit")
			+ '&nbsp;&nbsp;</span><span style="height:16px; width:4px; position:relative; background-image:url(./images/design1/tabs/tab_bg_right_bright.png);background-repeat:no-repeat; border:0px solid red;">&nbsp;</span>',
			true
		);

		server.getJSXByName('paneELogButtons').repaint();

		// Save record dialog
		var box = server.getJSXByName('dialog_record').getChild('content_box');
		box.getChild('header').getDescendantOfName('blockCaption').setText(__("ACTIVE RECORD"));
		box.getChild('header').getDescendantOfName('imagebutton').setTip(__("Close"));

		box.getChild('blockContent').getDescendantOfName('recordFrom').setText(__("From") + ":");
		box.getChild('blockContent').getDescendantOfName('recordTo').setText(__("To") + ":");
		box.getChild('blockContent').getDescendantOfName('buttonCE').setText(__("Create event"));
		box.getChild('blockContent').getDescendantOfName('buttonSA').setText(__("Save video clip"));

		// Audio record dialog
		box = server.getJSXByName('dialog_record_audio').getChild('content_box');
		box.getDescendantOfName('blockCaption').setText(__("AUDIO RECORD"));
		box.getDescendantOfName('imagebutton').setTip(__("Close"));
		box.getDescendantOfName('label_choose_input_device').setText(__("Choose input device:"));
		box.getDescendantOfName('buttonAR').setText(__("Start audio recording"));

		//PTZ dialog
		server.getJSXByName('ptzDialog').getDescendantOfName("cell_dev_name").setText(__("PTZ"), true);
		server.getJSXByName('ptzDialog').getDescendantOfName("cell_btn_close").setTip(__("Cell close"));

		// Main menu
		var menu = server.getJSXByName('menuconfblock');
		menu.getDescendantOfName('conf_menu_new').setText(__("New", "Main menu"), true);
		menu.getDescendantOfName('conf_menu_load').setText(__("Load", "Main menu"), true);
		menu.getDescendantOfName('conf_menu_save').setText(__("Save", "Main menu"), true);
		menu.getDescendantOfName('conf_menu_manage').setText(__("Manage", "Main menu"), true);
		menu.repaint();

		menu = server.getJSXByName('mainmenublock');
		menu.getDescendantOfName('confimagebutton').setImage('images/design1/top_menu' + lang + '/file.png');
		menu.getDescendantOfName('confimagebutton').setOverImage('images/design1/top_menu' + lang + '/file_hover.png');
		menu.getDescendantOfName('confimagebutton').setTip(__("File"));

		menu.getDescendantOfName('button_admin').setImage('images/design1/top_menu' + lang + '/admin.png');
		menu.getDescendantOfName('button_admin').setOverImage('images/design1/top_menu' + lang + '/admin_hover.png');
		menu.getDescendantOfName('button_admin').setTip(__("Open 'Admin GUI'"));

		menu.getDescendantOfName('logoff_button').setImage('images/design1/top_menu' + lang + '/close.png');
		menu.getDescendantOfName('logoff_button').setOverImage('images/design1/top_menu' + lang + '/close_hover.png');
		menu.getDescendantOfName('logoff_button').setTip(__("Logoff"));

		menu.repaint();

		// Change layout to rtl if nesessary
		if (language.lang_direction == 'rtl')
			language.rtl_direction();
	};


	/**
	 * Change text direction, panes layout etc. into rtl in main layout
	 */
	language.rtl_direction = function()
	{
		var server = mx.MATRIX2.getServer();

		// Main layout
		var control = server.getJSXByName('controlPane');
		var layout_separator = server.getJSXByName('block_layout_separator');
		var players = server.getJSXByName('players_pane');
		var main_layout = server.getJSXByName('mainLayout');

		main_layout.insertBefore(control, players);
		main_layout.insertBefore(players, layout_separator);
		main_layout.setCols("*,12,322", true);

		// Dialog windows
		server.getJSXByName('label_choose_action').setCSSOverride('right: 9px; left: auto;');

		server.getJSXByName('dialog_record_audio').getDescendantOfName('label_choose_input_device').setCSSOverride("right: 15px; left: auto;");
		server.getJSXByName('dialog_record_audio').getDescendantOfName('blockContent').setCSSOverride('direction: rtl;');

		$('#resource_tree_root').addClass('rtl');
		server.getJSXByName('tabbedpaneMain').setCSSOverride('text-align: right; direction: rtl;');
		jsx3.GO('imgAddNewTab').setCSSOverride('position: absolute; top: 0; left: 0');
		server.getJSXByName('resource_wrapper').setCSSOverride('direction: rtl;').setClassName('rtl');

		server.getJSXByName('layoutControls_wrapper').setCSSOverride('direction: rtl;');
		server.getJSXByName('buttonExpandDetails').setCSSOverride('left: 10px;');
		server.getJSXByName('buttonCollapseDetails').setCSSOverride('left: 10px;');
		var labels = server.getJSXByName('blockButtonsWithDetails').selectDescendants('[jsxname="label"]');
		for (var i = 0; i < labels.length; i++) {
			labels[i].setCSSOverride('left: 2px;');
		}

		server.getJSXByName('blockControls_wrapper').setCSSOverride('direction: rtl;');
		server.getJSXByName('block_speed').setCSSOverride('left: 10px;');
		server.getJSXByName('dialog_AE').setCSSOverride('direction: rtl;');

		// Player controls
		var controls = server.getJSXByName('player_controls');
		controls.setCSSOverride('direction: ltr;');
		controls.getDescendantOfName('speeds').setCSSOverride('left: 0px;');
		controls.getDescendantOfName('PlayerArchiveControls').setCSSOverride('left: 0px;');
		controls.getDescendantOfName('date').setCSSOverride('right: 15px; left: auto;');
		controls.getDescendantOfName('time').setCSSOverride('right: 15px; left: auto;');

		var tabs = server.getJSXByName('tabbedpaneMain').getChildren();
		var blocks = server.getJSXByName('tabbedpaneMain').selectDescendants('[jsxname*="block_main"]');
		for (i = 0; i < tabs.length; i++)
		{
			tabs[i].setCSSOverride('text-align: right; direction: ltr;');
			blocks[i].setCSSOverride('text-align: left; direction: ltr;');
		}

		// Separator arrows
		server.getJSXByName('blockTLButtonsImage').setSrc('images/design1/separator/separator_arrows_r.gif').repaint();
		server.getJSXByName('blockTLButtonsCommandImage').setSrc('images/design1/separator/separator_arrows_r.gif').repaint();
		server.getJSXByName('imageSeparatorArrows').setSrc('images/design1/separator/separator_arrows_r.gif');

		// layoutELogHeader
		server.getJSXByName('paneELog2').setCSSOverride('direction: rtl;');
		server.getJSXByName('paneELogButtons').setCSSOverride("direction: ltr;");

		/*server.getJSXByName('eLog2dialog').setCSSOverride('direction: rtl;');
		server.getJSXByName('eLog2dialog').getDescendantOfName('labels').setLeft(170);
		server.getJSXByName('eLog2dialog').getDescendantOfName('tabbedpane').setCSSOverride('text-align: right;');
		*/

		server.getJSXByName('pane_players_controls').repaint();

		language.rtl_menu();
		mx.MATRIX2.invertSeparatorArrows("blockTLButtonsImage");

		// Absolute positioned blocks
		server.getJSXByName('menuconfblock').setCSSOverride('right: 5px; left: auto;').repaint();

	};


	language.rtl_menu = function() {
		var menu = $('[label="pane_menu_timeline"]');
		menu.css('direction', 'rtl');
		menu.find('[label="mainmenublock"]').css('right', '0');
		menu.find('[label="blockSystemNameState"]')
			.css('right', '322px')
			.find('div')
			.css('text-align', 'left');

		menu.find('[label="blockTLButtons"]').css('right', '322px');
		menu.find('[label="block_timeline"]').css('left', '0');
	};

	/**
	 * Load translated xml layout or translate it if nesessary
	 * @param objDest object to load layout into;
	 * @param xml     name of xml file that we want to load
	 */
	language.load_translate = function(objDest, xml) {

		// Check if we translated this xml before
		if (language.translated[xml]) {
			return objDest.loadXML(language.translated[xml]);
		}

		// Else translate, store to cache and then load from cache
		if (xml in language.handlers) {
			var func_name = language.handlers[xml];
			var tmpObj = language[func_name](xml);
			language.translated[xml] = tmpObj.toXML();	// Save translated layout in cache
		}

		return objDest.loadXML(language.translated[xml]);
	};

	/**
	 * GUI cell:
	 * translate and change direction to rtl if nesessary, then store it in cache.
	 */
	language.translate_gui_cell = function(xml) {
		// Auxiliary invisible block, we load XML layout there, change labels, tips, text direction, and save it to cache.
		var translate_helper = mx.MATRIX2.getServer().getJSXByName('translation_helper');
		var tmpObj = translate_helper.loadAndCache(xml, false);

		// CIRRUS_REPLACE_MATRIX2_JS_ID003_BEGIN
		tmpObj.getDescendantOfName('cell_pin').setTip(__("Pin"));
		// CIRRUS_REPLACE_MATRIX2_JS_ID003_END

		tmpObj.getDescendantOfName("cell_dev_name").setTip(__("Device Name:"));
		tmpObj.getDescendantOfName("device_type_image").setTip(__("Device type (drag to move)"));
		tmpObj.getDescendantOfName("moving_cell_label").setText(__("Moving Cell"), true);
		tmpObj.getDescendantOfName('cell_joystick').setTip(__("Show PTZ control"));
		tmpObj.getDescendantOfName("cell_anl").setTip(__("Analytics On/Off"));
		tmpObj.getDescendantOfName("cell_jump").setTip(__("Full Screen in New Tab"));
		tmpObj.getDescendantOfName("cell_close").setTip(__("Cell close"));
		tmpObj.getDescendantOfName('cell_timezone').setTip(__("Switch to camera timezone"));
		tmpObj.getDescendantOfName('cell_sound').setTip(__("Enable sound"));
		tmpObj.getDescendantOfName('cell_stream_quality').setTip(__("Normal resolution"));

		if (language.lang_direction == 'rtl') {
			tmpObj.getDescendantOfName("cell_select").setCSSOverride("direction: rtl");
		}

		return tmpObj;
	};

	/**
	 * URL cell:
	 * translate and change direction to rtl if nesessary, then store it in cache.
	 */
	language.translate_url_cell = function() {

		var translate_helper = mx.MATRIX2.getServer().getJSXByName('translation_helper');
		var tmpObj = translate_helper.loadAndCache("components/url_cell.xml", false);

		tmpObj.getDescendantOfName("url_label").setText(__("URL"), true);
		tmpObj.getDescendantOfName("buttonConfig").setTip(__("Show URL config"));
		tmpObj.getDescendantOfName("buttonClose").setTip(__("Cell close"));
		tmpObj.getDescendantOfName("sec_label").setText(__("sec"), true);
		tmpObj.getDescendantOfName('checkboxRefresh').setText(
			"<input type='checkbox' name='checkboxRefresh' id='checkbox_url_refresh' /><label for='checkbox_url_refresh'>" + __("Refresh page every") + "</label>",
			true
		);

		// RTL direction
		if (language.lang_direction == 'rtl') {
			tmpObj.getDescendantOfName("blockRefresh").setCSSOverride('direction: rtl;').repaint();
			tmpObj.getDescendantOfName("pane_url").setCSSOverride('direction: rtl;').repaint();
		}

		return tmpObj;
	};

	/**
	 * Touring and Touring vmx cell:
	 * translate and change direction to rtl if nesessary, then store it in cache.
	 */
	language.translate_tour_cell = function(xml) {

		var translate_helper = mx.MATRIX2.getServer().getJSXByName('translation_helper');
		var tmpObj = translate_helper.loadAndCache(xml, false);

		tmpObj.getDescendantOfName('cell_tour_player').setText(
			'<table width="100%" height="100%"><tr><td align="center" valign="middle" style="font-size:12px;">'
			+ __("Drag and drop Device, Set of devices, or Role to the list on the right, to activate the touring.")
			+ "</td></tr></table>");

		/* i18n: 'sec' means "seconds" */
		tmpObj.getDescendantOfName('sec_label').setText(__("sec"));
		tmpObj.getDescendantOfName('delay_label').setText(__("Delay time:"));
		tmpObj.getDescendantOfName('mc2').setText(__("Name"));
		tmpObj.getDescendantOfName('cell_dev_name').setText(__("Touring control"));
		tmpObj.getDescendantOfName('cell_btn_tour').setTip(__("Touring"));
		tmpObj.getDescendantOfName('cell_btn_close').setTip(__("Cell close"));

		// RTL direction
		if (language.lang_direction == 'rtl') {
			tmpObj.getDescendantOfName('block_delay').setCSSOverride('direction: rtl');
			//tmpObj.getDescendantOfName('pane_list').setCSSOverride('direction: rtl');
		}

		return tmpObj;
	};

	/**
	 * Google Earth cell:
	 * translate and change direction to rtl if nesessary, then store it in cache.
	 */
	language.translate_ge_cell = function() {

		var translate_helper = mx.MATRIX2.getServer().getJSXByName('translation_helper');
		var tmpObj = translate_helper.loadAndCache("components/ge_cell.xml", false);

		tmpObj.getDescendantOfName("M3D_header").setText(__("Map 3D Plugin"), true);
		tmpObj.getDescendantOfName("m3d_status_ok").setTip(__("Map3D online"));
		tmpObj.getDescendantOfName("m3d_status_reconnect").setTip(__("Map3D waiting for connection"));
		tmpObj.getDescendantOfName("ge_find").setTip(__("Show/Hide Map3D Search Bar"));
		tmpObj.getDescendantOfName("find_label").setText(__("Find:"), true);
		tmpObj.getDescendantOfName("geSearchButton").setText(__("Go", "Search dialog button"), true);
		tmpObj.getDescendantOfName("ge_fixoncamera").setTip(__("Lock map view on selected camera"));
		tmpObj.getDescendantOfName("ge_targets").setTip(__("Open targets panel"));
		tmpObj.getDescendantOfName("ge_close").setTip(__("Cell close"));
		tmpObj.getDescendantOfName("dndm3d").setText(__("Drag & Drop Area"), true);

		// RTL direction
		if (language.lang_direction == 'rtl') {
			tmpObj.getDescendantOfName('geSearchBlock').setCSSOverride('direction: rtl');
		}

		return tmpObj;
	};

	language.translate_map_cell = function() {

		var translate_helper = mx.MATRIX2.getServer().getJSXByName('translation_helper');
		var tmpObj = translate_helper.loadAndCache("components/map_cell.xml", false);

		return tmpObj;
	};
	
	language.translate_cdm_cell = function() {

		var translate_helper = mx.MATRIX2.getServer().getJSXByName('translation_helper');
		var tmpObj = translate_helper.loadAndCache("components/cdm_cell.xml", false);

		return tmpObj;
	};

	language.translate_map_cell = function() {

		var translate_helper = mx.MATRIX2.getServer().getJSXByName('translation_helper');
		var tmpObj = translate_helper.loadAndCache("components/map_cell.xml", false);

		return tmpObj;
	};

	/**
	 * Object Manager cell:
	 * translate and change direction to rtl if nesessary, then store it in cache.
	 */
	language.translate_om_cell = function() {

		var translate_helper = mx.MATRIX2.getServer().getJSXByName('translation_helper');
		var tmpObj = translate_helper.loadAndCache("components/om_cell.xml", false);

		// If direction is rtl, remove ordinary header and show rtl header
		if (language.lang_direction == 'rtl') {
			tmpObj.getDescendantOfName('object_list').removeChild(tmpObj.getDescendantOfName('header'));
			tmpObj.getDescendantOfName('object_list').removeChild(tmpObj.getDescendantOfName('tmpl_rec'));
			tmpObj.getDescendantOfName('header_rtl').setName('header').setDisplay(jsx3.gui.Block.DISPLAYBLOCK);
			tmpObj.getDescendantOfName('tmpl_rec_rtl').setName('tmpl_rec');
			tmpObj.getDescendantOfName('om_cell').setCSSOverride('direction: rtl;');
		}

		var header = tmpObj.getDescendantOfName('header');

		header.getDescendantOfName('state').setText(__("State"));
		header.getDescendantOfName('objid').setText(__("Id", 'Object manager'));
		header.getDescendantOfName('text').setText(__("Description"));
		header.getDescendantOfName('location').setText(__("Location"));
		header.getDescendantOfName('type').setText(__("Type"));

		tmpObj.getDescendantOfName('cell_text').setText(__("Object Manager"));
		tmpObj.getDescendantOfName('btn_close').setTip(__("Cell close"));
		tmpObj.getDescendantOfName('label_properties').setText(__("Properties"));
		tmpObj.getDescendantOfName('label_methods').setText(__("Methods"));
		tmpObj.getDescendantOfName('name').setText(__("Name"));
		tmpObj.getDescendantOfName('value').setText(__("Value"));

		return tmpObj;
	};

	});
