//---------------------------------------------------------------------------------------------------------------
// This is the Hotkey Matrix GUI Class
//---------------------------------------------------------------------------------------------------------------
jsx3.lang.Package.definePackage("mx.HOTKEY", function(HOTKEY) {
	HOTKEY.registerHotkeys = function() {
        var jsxServer = mx.MATRIX2.getServer();
		//player
		jsxServer.registerHotKey(HOTKEY.changePlayerState, "P", true/*bShift*/, false/*bControl*/, false/*bAlt*/);
		jsxServer.registerHotKey(HOTKEY.changePlayerMode, "M", true, false, false);
		jsxServer.registerHotKey(HOTKEY.executeRecording, "R", true, false, false);
		jsxServer.registerHotKey(HOTKEY.saveSnapshot, "I", true, false, false);
		jsxServer.registerHotKey(HOTKEY.jumpLeft, "left", true, false, false);
		jsxServer.registerHotKey(HOTKEY.jumpRight, "right", true, false, false);
		jsxServer.registerHotKey(HOTKEY.increaseSpeed, "up", true, false, false);
		jsxServer.registerHotKey(HOTKEY.desreaseSpeed, "down", true, false, false);

		//gui
		jsxServer.registerHotKey(HOTKEY.calendarTimeline, "T", true, false, false);
		jsxServer.registerHotKey(HOTKEY.newConfiguration, "N", true, false, false);
		jsxServer.registerHotKey(HOTKEY.loadConfiguration, "L", true, false, false);
		jsxServer.registerHotKey(HOTKEY.saveConfiguration, "S", true, false, false);
		jsxServer.registerHotKey(HOTKEY.manageConfiguration, "D", true, false, false);
		jsxServer.registerHotKey(HOTKEY.findInTree, "F", true, false, false);
		jsxServer.registerHotKey(HOTKEY.focusOnTargets, "T", true, true, false);

        //ptz
        jsxServer.registerHotKey(HOTKEY.ptzZoomIn, jsx3.gui.Event.KEY_NPADD, false, false, false);
        jsxServer.registerHotKey(HOTKEY.ptzZoomOut, jsx3.gui.Event.KEY_NPSUB, false, false, false);
        jsxServer.registerHotKey(HOTKEY.ptzUp, "up", false, false, false);
        jsxServer.registerHotKey(HOTKEY.ptzDown, "down", false, false, false);
        jsxServer.registerHotKey(HOTKEY.ptzLeft, "left", false, false, false);
        jsxServer.registerHotKey(HOTKEY.ptzRight, "right", false, false, false);

        //prevent page reload on backspace
        jsxServer.registerHotKey(HOTKEY.checkRemoveFromInput, jsx3.gui.Event.KEY_BACKSPACE, false, false, false);
	};

    /*
    * add symbol to input field
    * */
    HOTKEY.checkAddToInput = function(letter) {
        var focused = $("input[type=text],textarea").filter(':focus');
        if(focused.size() > 0){
            focused.val(focused.val() + letter);
        }
    }

	/*
	* delete last symbol from text field
	* */
	HOTKEY.checkRemoveFromInput = function() {
        var focused = $("input[type=text],textarea").filter(':focus');
        if(focused.size() > 0 && !focused.attr("readonly") && !focused.prop("disabled")){
            focused.val(focused.val().substr(0, focused.val().length - 1));
        }
	};

	// live/archive
	HOTKEY.changePlayerMode = function() {
        HOTKEY.checkAddToInput("M");
		var objControls = mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls;
		if (objControls.group != null) {
			if (objControls.group.contextType == 3) {
				objControls.switch2live();
			}
			else {
				objControls.switch2archive();
			}
		}
	};

	// play/pause
	HOTKEY.changePlayerState = function() {
        HOTKEY.checkAddToInput("P");
		var objControls = mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls;
		if (objControls.group != null) {
			if (objControls.group.status == 0 || objControls.group.status == 3) {
				objControls.play();
			}
			else {
				objControls.pause();
			}
		}
	};

	// start/stop recording
	HOTKEY.executeRecording = function() {
        HOTKEY.checkAddToInput("R");
		var objControls = mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls;
		if (objControls.group != null) {
			var objCell = objControls.controlInstance.getServer().getJSXById(objControls.group.players[objControls.detectMainPlayerPos()].player.id);

			if (objCell.getAttribute('markA') && objCell.getAttribute('markA') != "") {
				objControls.stopRecord();
			}
			else {
				objControls.startRecord();
			}
		}
	};

	// save snapshot
	HOTKEY.saveSnapshot = function() {
        HOTKEY.checkAddToInput("I");
		var objControls = jsx3.GO('layoutControlComponent').controls;
		if (objControls.group != null) {
			objControls.saveImage();
		}
	};

	// jump left
	HOTKEY.jumpLeft = function() {
		var objControls = jsx3.GO('layoutControlComponent').controls;
		if (objControls.group != null) {
			if (objControls.group.contextType == 2) {
				mx.MATRIX2.quickSwitch2archive(jsx3.GO(objControls.group.getPlayer(0).id));
			}
			else {
                if(window.jsDebug){ appLogger.info("HOTKEY.jumpLeft: status="+objControls.group.status); }
				if (objControls.group.status == 0 || objControls.group.status == 3) {
					objControls.stepBack();
				}
				else {
					objControls.revert();
				}
			}
		}
	};

	// jump right
	HOTKEY.jumpRight = function() {
		var objControls = jsx3.GO('layoutControlComponent').controls;
		if (objControls.group != null) {
			if (objControls.group.contextType == 3) {
                if(window.jsDebug){ appLogger.info("HOTKEY.jumpRight: status="+objControls.group.status); }
				if (objControls.group.status == 0 || objControls.group.status == 3) {
                    objControls.stepForward();
				}
				else {
					objControls.catchUp();
				}
			}
		}
	};

	// increase speed
	HOTKEY.increaseSpeed = function() {
		var objControls = jsx3.GO('layoutControlComponent').controls;
		if (objControls.group != null) {
			if (objControls.group.contextType == 3) {
				if (objControls.curSpeed < 4) {
					var new_value = objControls.controlInstance.getDescendantOfName("slider_speed").getValue() + 20;
					if (new_value > 80) {
						new_value = 95;
					}
					objControls.controlInstance.getDescendantOfName("slider_speed").setValue(new_value, true);
					objControls.changeSpeed(new_value);
				}
			}
		}
	};

	// desrease speed
	HOTKEY.desreaseSpeed = function() {
		var objControls = mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls;
		if (objControls.group != null) {
			if (objControls.group.contextType == 3) {
				if (objControls.curSpeed > 0.25) {
					var new_value = objControls.controlInstance.getDescendantOfName("slider_speed").getValue() - 20;
					if (new_value < 20) {
						new_value = 5;
					}
					objControls.controlInstance.getDescendantOfName("slider_speed").setValue(new_value, true);
					objControls.changeSpeed(new_value);
				}
			}
		}
	};

	// show/hide timeline calendar
	HOTKEY.calendarTimeline = function() {
        HOTKEY.checkAddToInput("T");
        if(jsx3.GO('layoutControlComponent').controls.group){
		    mx.TIMELINE.onblockTLButtonsClick();
        }
	};

	// clear configuration
	HOTKEY.newConfiguration = function() {
        HOTKEY.checkAddToInput("N");
		mx.MATRIX2.clearMatrix();
	};

	// load configuration
	HOTKEY.loadConfiguration = function(e) {
        HOTKEY.checkAddToInput("L");
		LSC.loadDialog();
	};

	// save configuration
	HOTKEY.saveConfiguration = function() {
        HOTKEY.checkAddToInput("S");
		LSC.saveDialog();
	};

	// manage configuration
	HOTKEY.manageConfiguration = function() {
        HOTKEY.checkAddToInput("D");
		LSC.manageDialog();
	};

	// find in tree
	HOTKEY.findInTree = function() {
        HOTKEY.checkAddToInput("F");
		resourceTree.finder.show();
	};

	// ptz zoom in
	HOTKEY.ptzZoomIn = function() {
        var ptzD = jsx3.GO("ptzDialog");
        if(ptzD.getVisibility() == jsx3.gui.Block.VISIBILITYVISIBLE){
            mx.PTZ.execCommand(mx.PTZ.camera_id, "step", "zoom", "in");
        }
	};

	HOTKEY.focusOnTargets = function() {
		HOTKEY.checkAddToInput("T");
		debugger;
	};

	// ptz zoom out
	HOTKEY.ptzZoomOut = function() {
        var ptzD = jsx3.GO("ptzDialog");
        if(ptzD.getVisibility() == jsx3.gui.Block.VISIBILITYVISIBLE){
            mx.PTZ.execCommand(mx.PTZ.camera_id, "step", "zoom", "out");
        }
	};

	// ptz move up
	HOTKEY.ptzUp = function() {
        var ptzD = jsx3.GO("ptzDialog");
        if(ptzD.getVisibility() == jsx3.gui.Block.VISIBILITYVISIBLE){
            mx.PTZ.execCommand(mx.PTZ.camera_id, "step", "move", "up");
        }
	};

	// ptz move down
	HOTKEY.ptzDown = function() {
        var ptzD = jsx3.GO("ptzDialog");
        if(ptzD.getVisibility() == jsx3.gui.Block.VISIBILITYVISIBLE){
            mx.PTZ.execCommand(mx.PTZ.camera_id, "step", "move", "down");
        }
	};

	// ptz move left
	HOTKEY.ptzLeft = function() {
        var ptzD = jsx3.GO("ptzDialog");
        if(ptzD.getVisibility() == jsx3.gui.Block.VISIBILITYVISIBLE){
            mx.PTZ.execCommand(mx.PTZ.camera_id, "step", "move", "left");
        }
	};

	// ptz move right
	HOTKEY.ptzRight = function() {
        var ptzD = jsx3.GO("ptzDialog");
        if(ptzD.getVisibility() == jsx3.gui.Block.VISIBILITYVISIBLE){
            mx.PTZ.execCommand(mx.PTZ.camera_id, "step", "move", "right");
        }
	};
});


/**
 * jQuery hotkeys, works better than tibco registerHotKey function
 */
(function(jQuery){

	jQuery.hotkeys = {
		version: "0.8",

		specialKeys: {
			8: "backspace", 9: "tab", 13: "return", 16: "shift", 17: "ctrl", 18: "alt", 19: "pause",
			20: "capslock", 27: "esc", 32: "space", 33: "pageup", 34: "pagedown", 35: "end", 36: "home",
			37: "left", 38: "up", 39: "right", 40: "down", 45: "insert", 46: "del",
			96: "0", 97: "1", 98: "2", 99: "3", 100: "4", 101: "5", 102: "6", 103: "7",
			104: "8", 105: "9", 106: "*", 107: "+", 109: "-", 110: ".", 111 : "/",
			112: "f1", 113: "f2", 114: "f3", 115: "f4", 116: "f5", 117: "f6", 118: "f7", 119: "f8",
			120: "f9", 121: "f10", 122: "f11", 123: "f12", 144: "numlock", 145: "scroll", 191: "/", 224: "meta"
		},

		shiftNums: {
			"`": "~", "1": "!", "2": "@", "3": "#", "4": "$", "5": "%", "6": "^", "7": "&",
			"8": "*", "9": "(", "0": ")", "-": "_", "=": "+", ";": ": ", "'": "\"", ",": "<",
			".": ">",  "/": "?",  "\\": "|"
		}
	};

	function keyHandler( handleObj ) {
		// Only care when a possible input has been specified
		if ( typeof handleObj.data !== "string" ) {
			return;
		}

		var origHandler = handleObj.handler,
			keys = handleObj.data.toLowerCase().split(" ");

		handleObj.handler = function( event ) {
			// Don't fire in text-accepting inputs that we didn't directly bind to
			if ( this !== event.target && (/textarea|select/i.test( event.target.nodeName ) ||
				 event.target.type === "text") ) {
				return;
			}

			// Keypress represents characters, not special keys
			var special = event.type !== "keypress" && jQuery.hotkeys.specialKeys[ event.which ],
				character = String.fromCharCode( event.which ).toLowerCase(),
				key, modif = "", possible = {};

			// check combinations (alt|ctrl|shift+anything)
			if ( event.altKey && special !== "alt" ) {
				modif += "alt+";
			}

			if ( event.ctrlKey && special !== "ctrl" ) {
				modif += "ctrl+";
			}

			// TODO: Need to make sure this works consistently across platforms
			if ( event.metaKey && !event.ctrlKey && special !== "meta" ) {
				modif += "meta+";
			}

			if ( event.shiftKey && special !== "shift" ) {
				modif += "shift+";
			}

			if ( special ) {
				possible[ modif + special ] = true;

			} else {
				possible[ modif + character ] = true;
				possible[ modif + jQuery.hotkeys.shiftNums[ character ] ] = true;

				// "$" can be triggered as "Shift+4" or "Shift+$" or just "$"
				if ( modif === "shift+" ) {
					possible[ jQuery.hotkeys.shiftNums[ character ] ] = true;
				}
			}

			for ( var i = 0, l = keys.length; i < l; i++ ) {
				if ( possible[ keys[i] ] ) {
					return origHandler.apply( this, arguments );
				}
			}
		};
	}

	jQuery.each([ "keydown", "keyup", "keypress" ], function() {
		jQuery.event.special[ this ] = { add: keyHandler };
	});

})( jQuery );
