mx.GE.designation = {

	init: function(block) {
		parent.jsTargetingLiveStatus = null;

		var html =
			'<div id="ge_designation_panel" class="accordion">' +
				'<label><input type="checkbox" id="ge_designation_show_trails" checked> Show trails</label><br />' +
				'<label><input type="checkbox" id="ge_designation_show_ids" checked> Show ids</label><br />' +
				'<label style="display: none;"><input type="checkbox" id="ge_designation_auto_tracking"> Target auto tracking</label><br />' +

				'<label style="display: none;">Camera id:<select id="ge_designation_camera_follow_list" style="width: 70px; margin-left: 5px;" onchange="parent.jsTargetingCameraToFollowTarget=this.value;"><option value="none">none</option></select> to follow target</label><br />' +

				//'<label><span id="ge_designation_clear_scene" class="command">[clear scene]  </span></label>' +
				//'<label><span id="ge_designation_reset_archive" class="command">[reset archive]</span></label><br />' +

				'<span class="inline role tab_title">Users</span> ' +
				'<span id="ge_designation_users_self" class="command">[self]</span> ' +
				'<span id="ge_designation_users_all" class="command">[all]</span><br />' +

				'<ul id="ge_designation_users_list" style="display: none;">' +
				'</ul>' +

				'<span class="inline target tab_title tab_targets">Targets</span>' +
				'<span id="ge_designation_targets_new" class="command">[new]</span><br/> ' +
				'<select id="ge_designation_targets_list" size="15" style="display: none; width: 250px; margin-left: 20px;" onchange="mx.GE.designation.targetSelect(this.value);">' +
				'<br/>' +
			'</div>';
		block.setText(html).repaint();

		// If you dont want to manage viewpoints, comment next line
		mx.GE.viewPointsList.init('ge_designation_panel');
		this.addEventHandlers();
		this.setCameraFollowList();
		this.refreshUsersTargetsList();
	},

	addEventHandlers: function() {

		// Making accordion
		$("#ge_designation_panel").tabs('#ge_designation_panel > ul, #ge_designation_panel > select', {tabs: "span.tab_title", effect: 'slide', initialIndex: null});

		// Users list, managing targets visibility depending on users
		$('#ge_designation_users_list').on('click', 'input:checkbox', mx.GE.designation.updateTargetsVisibility.bind(this));
		$('#ge_designation_users_self').click(this.userSelectSelf.bind(this));
		$('#ge_designation_users_all').click(this.userSelectAll.bind(this));

		$('#ge_designation_targets_new').click(this.targetCreateNew.bind(this));

		$('#ge_designation_show_trails, #ge_designation_show_ids').click(mx.GE.designation.updateMapView.bind(this));
		$('#ge_designation_auto_tracking').click(mx.GE.designation.autoTrackingChange.bind(this));
	},

	userSelectSelf: function() {
		$('#ge_designation_users_list input:checkbox').prop("checked", false);
		//$('#ge_designation_users_list input[userid="' + resourceTree.user.obj + '"]').prop("checked", true);
		$('#ge_designation_users_list input[userid="' + parent.jsSessionId + '"]').prop("checked", true);
		//$('#ge_designation_users_list input[userid="session_Id_00"]').prop("checked", true);
		mx.GE.designation.updateTargetsVisibility();
	},

	userSelectAll: function() {
		$('#ge_designation_users_list input:checkbox').prop("checked", true);
		mx.GE.designation.updateTargetsVisibility();
	},

	targetSelect: function(tid) {
		parent.jsTargetingCurrentTargetId = tid;

		this.refreshUsersTargetsList();

		var iframe = this.getGeIframe();
		if(iframe && iframe.ge != null) {
			iframe.targetingTargetSelected(tid);
		}
	},

	clearGeScene: function() {
		//var conf = confirm("Do you want to clear current 3D scene content?")
		//if (conf == true) {
			parent.jsTargetingLiveStatus = null;
			this.refreshUsersTargetsList();

			var iframe = this.getGeIframe();
			if(iframe && iframe.ge != null) {
				iframe.targetingClearScene();
			}
		//}
	},

	delTargetsFromList: function(dList) {
		var json = parent.jsTargetingLiveStatus;

		var tr = json.targets;
		if (dList)
		{
			for (var i = 0; i < dList.length; i++)
			{
				delete tr[dList[i]];

				for (var key in json.users)
				{
					var user = json.users[key];
					for (var j = 0; j < user.targets.length; j++)
					{
						if (user.targets[j] == dList[i]) user.targets.splice(j, 1);
					}
				}
			}
		}

		//parent.appLogger.info('|--> delTargetsFromList: ' + JSON.stringify(json));

		this.repaintUsersTargetsList(json);
	},

	// This is callback function, it calls when users and targets info received from server and repaint m3d lists according to new data
	repaintUsersTargetsList: function(json) {
		var htmlUsers = '';
		var htmlTargets = '<option value="noneSelected" style="color:gray;">---------------- target select none ----------------</option>';

		this.users = json.users;
		this.targets = json.targets;

		for (var userid in json.users) {
			var user = json.users[userid];

			htmlUsers += '<li><label><input type="checkbox" userid="' + userid + '">' + user['name'] + '</li>';

			if (!$.isArray(user.targets))
				continue;

			// Add into list only those targets that belongs to user
			for (var i = 0; i < user.targets.length; i++) {
				var targetid = user.targets[i];

				var target = json.targets[targetid];

				if (!target)
					continue;

				var selected = (parent.jsTargetingCurrentTargetId == targetid) ? "selected" : "";

				var title = "[" + target.objid + "] " + target.name;
				if (user.name) title += ' (' + user.name + ')';

				htmlTargets += '<option value="' + targetid + '" data-userid="' + userid + '" ' + selected + '>' + title + '</option>';
			}
		}

		$('#ge_designation_users_list').html(htmlUsers);
		$('#ge_designation_targets_list').html(htmlTargets);

		// TODO: check this logic
		// this.userSelectAll();
	},

	setCameraFollowList: function()
	{
		var htmlFollow = '<option value="none" selected>none</option>';
        // TODO: check logic of next string
		var devices1 = resourceTree.getObjects({'cam_geo_calibration': 'yes'});
		var devices2 = resourceTree.getObjects({'cam_geo_calibration': 'dynamic'});

		var devices = $.merge(devices1, devices2);
		for(var i = 0; i < devices.length; i++)
		{
			var objG = resourceTree.getObject(devices[i]);

			if(objG.attr('POSITIONCTL') != "none" && objG.attr('DEVICETYPE') == "CAMERA")
			{
				var selected = (parent.jsTargetingCameraToFollowTarget == objG.obj) ? "selected" : "";
				htmlFollow += '<option value="' + objG.obj + '" ' + selected + '>' + objG.obj + ' (' + objG.name + ')' + '</option>';
			}
		}

		$('#ge_designation_camera_follow_list').html(htmlFollow);
	},

	/**
	 * Get array of visible target ids
	 */
	getVisibleTargets: function() {

		var targets = [];
		var self = this;

		$('#ge_designation_users_list input:checked').each(function() {
			$.merge(targets, self.users[$(this).attr('userid')].targets);
		});

		return targets;
	},

	// Set visibility of targets in list depending on currently checked users
	updateTargetsVisibility: function() {

		var targetsList = $('#ge_designation_targets_list li');
		var targets = this.getVisibleTargets();
		targetsList.hide();

		targetsList.filter(function() {
			return $.inArray($(this).attr('targetid'), targets) != -1;
		}).show();

		this.updateMapView();
	},

	/**
	 * Send request to server when need to get users info
	 */
	refreshUsersTargetsList: function() {
		// dummy method
		// TODO: retrieve users and targets info form server in json format

		var json = parent.jsTargetingLiveStatus;

		if (json === null)
		{
			json = {};
			json.users = {};
			json.users[parent.jsSessionId] = {};
			json.users[parent.jsSessionId].name = parent.jsUserName;
			json.users[parent.jsSessionId].userId = parent.jsUserId;
			json.users[parent.jsSessionId].targets = [];
			json.targets = {};

			parent.jsTargetingLiveStatus = json;
		}

		this.repaintUsersTargetsList(json);
	},

	// Function must update view of GE map depending on trails, ids and targets visibility options
	updateMapView: function() {
		var showTrails = $('#ge_designation_show_trails').prop("checked");
		var showIds    = $('#ge_designation_show_ids').prop("checked");
		parent.jsTargetingShowTrails = showTrails;
		parent.jsTargetingShowIds = showIds;

		// Array of target ids that we must show in map
		var targets = this.getVisibleTargets();

		// TODO: update view of GE map depending on options above

		var iframe = this.getGeIframe();
		if(iframe && iframe.ge != null) {
			iframe.targetingShowTargetsTrailsIds();
		}
	},

	autoTrackingChange: function()
	{
		parent.jsTargetingCurrentTargetId = "noneSelected";
		mx.GE.designation.targetSelect(parent.jsTargetingCurrentTargetId);
		var trgL = document.getElementById('ge_designation_targets_list');

		var selCf = document.getElementById('ge_designation_camera_follow_list');
		if(selCf.selectedIndex >0) {
			parent.jsTargetingAutoTrackingCameraId = selCf.options[selCf.selectedIndex].value;
		} else {
			for (var i=0; i<selCf.options.length; i++)
			{
				if (selCf.options[i].value != "none")
				{
					parent.jsTargetingAutoTrackingCameraId = selCf.options[i].value;
					break;
				}
			}
		}

		if(document.getElementById('ge_designation_auto_tracking').checked)
		{
			parent.jsTargetingAutoTracking = true;
			document.getElementById('ge_designation_camera_follow_list').disabled = true;

			trgL.selectedIndex = -1;
			trgL.disabled = true;
		} else {
			parent.jsTargetingAutoTracking = false;
			document.getElementById('ge_designation_camera_follow_list').disabled = false;
			trgL.disabled = false;
		}
	},

	/**
	 * Dummy callback from camera designation mode
	 *
	 * @param {number} objId
	 * @param {number} width
	 * @param {number} height
	 * @param {number} x
	 * @param {number} y
	 * @param {string} [vAnalyticsId]
	 */
	onCameraClick: function(objId, width, height, x, y, vAnalyticsId)
	{
		if (!parent.jsTargetingLiveMode)
		{
			return;
		}

		var iframe = this.getGeIframe();
		if (!iframe)
		{
			parent.appLogger.warn('Google Earth IFrame is not availabe!');
			return;
		}

		// get camera info
		var camera = resourceTree.getObject(objId);

		if (camera.attr('CAM_GEO_CALIBRATION') != 'no')
		{
			if (camera.attr('PTZ_FEEDBACK') == 'yes')
			{
				var usid = window.jsUserId + "_" + window.jsSessionId + "_" + objId + "_" + width + "_" + height + "_" + x + "_" + y + "_" + Math.round(Math.random() * 1000);
				Targeting.getCameraPtzAttributes(usid);
				return;
			}

			var gm = new iframe.GMap();
			var FOV_X = parseFloat(camera.attr('CAM_GEO_HFOV'));
			var FOV_Y = FOV_X * (height / width);

			var GEO_CALIBRATOR_CONFIG = JSON.parse(camera.attr('GEO_CALIBRATOR_CONFIG'));
			if (!GEO_CALIBRATOR_CONFIG[objId])
			{
				return;
			}
			var homography = GEO_CALIBRATOR_CONFIG[objId].H;

			var parameters = {
				fovX: FOV_X,
				fovY: FOV_Y,
				tiltAngel: parseFloat(camera.attr('CAM_GEO_TILT')),
				azimuthAngle: parseFloat(camera.attr('CAM_GEO_AZIMUTH')),
				latitude: parseFloat(camera.attr('CAM_GEO_LAT')),
				longitude: parseFloat(camera.attr('CAM_GEO_LONG')),
				height: parseFloat(camera.attr('CAM_GEO_ALT')), // height relative to ground
				resolution: {
					width: width,
					height: height
				},
				homography: homography
			};
			gm.setCameraParameters(parameters);

			gm.setParameters({
				requestToGE: false
			});

			gm.markTarget(parseFloat(x), parseFloat(y))
				.done(function(){
					var params = gm.getParameters();

					params.userId = parent.jsUserId;
					params.userName = parent.jsUserName;
					params.sessionId = parent.jsSessionId;
					params.objId = objId;

					params.camera.zoom = null;
					params.camera.focus = null;
					params.camera.rangeFinderValue = null;

					params.target.symbolDescr = "desc";
					params.target.type = null;
					params.target.speed = null;
					params.target.course = null;
					if(vAnalyticsId != undefined)
					{
						params.target.id = vAnalyticsId;
						params.target.symbolId = "SUGPES----";
						params.target.source = "vAnalytics";
					} else {
						params.target.id = parent.jsTargetingCurrentId;
						params.target.symbolId = "SUZP------";
						params.target.source = "vGeoRef";
					}

					params.target.altitude = 0;
					iframe.targetingTargetSet(params);
				});
		}
	},

	targetListUpdate: function(message)
	{
		if(parent.jsTargetingLiveMode)
		{
			var uId = message.getAttribute("userId");
			var uNm = message.getAttribute("userName");
			var sId = message.getAttribute("sessionId");
			var tId = message.getAttribute("targetId");
			var tSi = message.getAttribute("targetSymbolId");
			var tOi = message.getAttribute("objId");

			var type = message.getAttribute("type");

			if(type == "targetingUgsResponse")
			{
				uId = parent.jsUserId;
				uNm = "UGS";
				sId = "CustomSessionId001";
				tId = message.getAttribute("id");
				tSi = "SUGPESE---";

			} else if(type == "targetingRadarResponse") {
				uId = parent.jsUserId;
				uNm = "SpotterRF";
				sId = "CustomSessionId002";
				tId = message.getAttribute("id");
				tSi = "SUGPESR---";
			}

			var json = parent.jsTargetingLiveStatus;

			if (json.users[sId] === undefined) {
				json.users[sId] = {
					name: uNm,
					userId: uId,
					targets: [tId]
				};

				json.targets[tId] = {
					name: tId,
					icon: tSi,
					objid: tOi
				};
			} else {
				if(json.users[sId].targets.length == 0) {
					json.users[sId].targets.push(tId);
				} else {
					var iPass = false;
					for(var i=0; i<json.users[sId].targets.length; i++) {
						if(json.users[sId].targets[i] === tId) {
							iPass = true;
							break;
						}
					}
					if(!iPass) json.users[sId].targets.push(tId);
				}

				if(json.targets[tId] === undefined) json.targets[tId] = {};
				json.targets[tId].name = tId;
				json.targets[tId].icon = tSi;
				json.targets[tId].objid = tOi;
			}

			parent.jsTargetingLiveStatus = json;
			this.refreshUsersTargetsList();
		}
	},

	targetCreateNew: function() {
		var nd = (new Date()).getTime().toString();
		parent.jsTargetingCurrentId = nd.substring(nd.length-5, nd.length-1) + "_" + window.jsSessionId.substring(0, 4) + "_" + ("000000" + Math.round(Math.random() * 100000)).slice(-4);

		parent.appLogger.info('--New Target-- ' + parent.jsTargetingCurrentId);
	},

	getGeIframe: function() {
		var ge_frame = mx.MATRIX2.getServer().getJSXByName('ge_iframe');
		if(ge_frame && ge_frame != undefined){
			var iframe = mx.MATRIX2.getIFrame(ge_frame);
			if(iframe && iframe != undefined) {
				return iframe;
			} else {
				alert("frame - not found.");
				return false;
			}
		} else {
			alert("ge_iframe - not found.");
			return false;
		}
	},

	disableTargetsPanel: function() {
		var button = jsx3.GO("ge_targets");
		if (!button)
			return;

		mx.GE.toggleTargetsPanel(false);
		button.setEnabled(jsx3.gui.Form.STATEDISABLED, true);
	},

	enableTargetsPanel: function() {
		var button = jsx3.GO("ge_targets");
		if (!button)
			return;
		button.setEnabled(jsx3.gui.Form.STATEENABLED, true);
	},

	/**
	 * Archive mode in GE cell - view one event
	 * This callback is called when ELog in archive mode and user open one geo-referenced event
	 */
	showEventTrail: function(eventId) {
		// TODO: place code connected to viewing target trail for event with id eventId

		Targeting.targetArchSingleTrailRequest(eventId);

		this.disableTargetsPanel();
	},

	/**
	 * Callback is called when user closes event dialog in ELog
	 * @param eventId
	 */
	hideEventTrail: function(eventId) {
		// TODO: hide event trail. Note when closing event dialog doesn't affect ELog archive mode, so maybe we must call
		// mx.GE.designate.showArchiveTrails() or mx.ELog2.setTargetTrails() to show all trails after hiding current event trail

		var iframe = this.getGeIframe();
		if(iframe && iframe.ge != null) iframe.targetingClearTrails();
	},

	/**
	 * Turn on archive mode in GE cell
	 * Ids: array of ids of geo-referenced events
	 * startTS: start boundary of eventlog timeline selection (s)
	 * endTS: end boundary of eventlog timeline selection (s)
	 */
	showArchiveTrails: function(Ids, startTs, endTs) {
		// TODO: turn on archive mode in GE cell and show targets trails for selected period
		parent.jsTargetingLiveMode = false;
		mx.GE.designation.clearGeScene();

		if(Ids.length > 0) {
			Targeting.targetArchRequest(Ids, startTs, endTs);
		}

		this.disableTargetsPanel();
	},

	/**
	 * Turn off archive mode in GE cell
	 */
	hideArchiveTrails: function() {
		// TODO: turn off archive mode, hide all trails
		parent.jsTargetingLiveMode = true;
		mx.GE.designation.clearGeScene();

		this.targetCreateNew();
		this.enableTargetsPanel();
	}
};

/**
 * Separate module for view-points list
 */
mx.GE.viewPointsList = {
	listId: '#ge_designation_points_list',
	blockId: null,
	data: null,
	views_count: 0,

	init: function(blockId) {
		this.blockId = blockId;

		$('#' + this.blockId).append(
			'<span class="inline ge_point tab_title">View-points</span>' +
			'<span class="command" id="ge_designation_points_add">[add]</span>' +
			'<ul id="ge_designation_points_list" style="display: none;">' +
			'</ul>'
		);

		this.addEventListeners();
		this.refresh();
	},

	addEventListeners: function() {
		var self = this;

		$('#ge_designation_points_add').click(function() {
			self.create();
		});
		$(this.listId).on('click', '.drop_view_point', function() {
			self.drop($(this).data('pointid'));
		});

		$('#ge_designation_points_list').on('click', 'li span', function() {
			if ($(this).next('div:visible').size()) {
				return;
			}
			$('#ge_designation_points_list div:visible').slideUp();
			$(this).next().slideDown();

			var pointid = $(this).data('pointid');
			var iframe = mx.GE.designation.getGeIframe();
			var ge = iframe.ge;
			var gex = new iframe.GEarthExtensions(ge);
			gex.view.deserialize(self.data[pointid].data);
		});

		jQuery(document).bind('keydown', 'Alt+t',function (evt){
			$('#ge_designation_panel > span.tab_targets').click();
			$('#ge_designation_targets_list').focus();
			return false;
		});
	},

	/**
	 * Send request to server when need to get view-points info
	 */
	refresh: function() {
		var self = this;

		var api = new API();
		api.getObjectList({
			type: 'configuration',
			childObj: 'ge',
			roleid: resourceTree.getRole().obj
		})
			.done(function(response){
				self.data = response.list;

				self.repaint();
			});
	},

	repaint: function() {
		var html = '';
		var json = this.data;
		this.views_count = 0;

		for (var id in json) {
			html += '<li data-pointid="' + id + '">' +
				'<span data-pointid="' + id + '">' + json[id].name + '</span>' +
				'<div class="view_info" data-pointid="' + id + '">' +
					'owner: ' + json[id].owner + ' (' + json[id].userid + ')<br />' +
					'role: ' + json[id].rolename + ' (' + json[id].roleid + ')<br />' +
					'protected: ' + (json[id]['protected'] ? 'yes' : 'no') + '<br />' +
					//'<span class="command drop_view_point" data-pointid="' + id + '">[delete]</span>' +
				'</div>' +
			'</li>';

			this.views_count++;
		}

		$('#ge_designation_points_list').html(html);
	},

	create: function() {
		var iframe = mx.GE.designation.getGeIframe();
		var ge = iframe.ge;
		var gex = new iframe.GEarthExtensions(ge);
		var self = this;

		var api = new API();
		api.addObject({
			type: 'configuration',
			attributes: JSON.stringify({
				NAME: 'View ' + (self.views_count + 1),
				PROTECTED: 1,
				SUBTYPE: 'ge',
				ROLEID: resourceTree.getRole().obj,
				USERID: resourceTree.getUser().obj,
				ROLENAME: resourceTree.getRole().name,
				OWNER: resourceTree.getUser().name,
				DATA: gex.view.serialize()
			})
		})
			.done(function(response){
				self.refresh();
			});
	},

	drop: function(obj) {
		var self = this;

		var api = new API();
		api.deleteObject({
			objList: JSON.stringify([obj])
		})
			.done(function(response){
				self.refresh();
			});
	}

};
