//---------------------------------------------------------------------------------------------------------------
// Google Earth Class
//---------------------------------------------------------------------------------------------------------------
jsx3.lang.Package.definePackage("mx.GE", function(GE) {

	GE.addGE = function(objDest) {
		if (!mx.MATRIX2.checkCellsLimit(mx.MATRIX2.map3dCellWeight, true)) {
			return null;
		}
		var path = "components/ge_cell.xml";

		var tmpObj = mx.language.load_translate(objDest, path);
		tmpObj.setName("ge_cell");

		objDest.removeAttribute("playerBlock");
		objDest.repaint();

		mx.MATRIX2.getServer().getJSXByName('ge_iframe').setScrolling(jsx3.gui.IFrame.SCROLLNO);
		mx.MATRIX2.getServer().getJSXByName('ge_iframe').setSrc("/sdi/ge/ge_view.php");

		// ruler tool
		objDest.getDescendantOfName('buttonRulerAct').setText(__("Activate")).setTip(__("Activate ruler tool")).setEvent("mx.GE.toggleRuler()", jsx3.gui.Interactive.EXECUTE).repaint();

		var selectRulerUnits = objDest.getDescendantOfName('selectRulerUnits');
		var defaultKey = jsx3.xml.CDF.getKey();
		var unitsXML = '<data jsxid="jsxroot">' +
		'<record jsxid="' + defaultKey + '" jsxtext="' + __("meters") + '" />' +
		'<record jsxid="' + jsx3.xml.CDF.getKey() + '" jsxtext="' + __("miles") + '" />' +
		'</data>';
		selectRulerUnits.resetCacheData();
		selectRulerUnits.setXMLString(unitsXML).setValue(defaultKey);
		selectRulerUnits.setEvent("mx.GE.checkRulerUnits()", jsx3.gui.Interactive.SELECT)
		selectRulerUnits.getParent().repaint();

		// zoom tool
		objDest.getDescendantOfName('buttonZoomAct').setText(__("Activate")).setTip(__("Activate zoom tool")).setEvent("mx.GE.toggleZoom()", jsx3.gui.Interactive.EXECUTE).repaint();

		// locations
		var blockLocationType = objDest.getDescendantOfName('blockLocationType');
		var locTypeSelectHtml = '<select id="location_type" style="width:100%">' +
			'<option value="point">' + __("Point") + '</option>' +
			'<option value="line">' + __("Line") + '</option>' +
		'</select>';
		blockLocationType.setText(locTypeSelectHtml).repaint();

		objDest.getDescendantOfName('ge_locations').setEvent("mx.GE.toggleLocations()", jsx3.gui.Interactive.EXECUTE);

		objDest.getDescendantOfName('buttonAddLocation').setEvent("mx.GE.waitForLocationPoint('add')", jsx3.gui.Interactive.EXECUTE);
		objDest.getDescendantOfName('buttonEditLocation').setEvent("mx.GE.waitForLocationPoint('edit')", jsx3.gui.Interactive.EXECUTE);
		objDest.getDescendantOfName('buttonEditLocation').setEnabled(jsx3.gui.Form.STATEDISABLED, true);
		objDest.getDescendantOfName('buttonDeleteLocation').setEvent("mx.GE.deleteLocation()", jsx3.gui.Interactive.EXECUTE);
		objDest.getDescendantOfName('buttonDeleteLocation').setEnabled(jsx3.gui.Form.STATEDISABLED, true);

		objDest.getDescendantOfName('showBuildings').setEvent("mx.GE.toggleEngineLayers('buildings', intCHECKED)", jsx3.gui.Interactive.TOGGLE);
		objDest.getDescendantOfName('showRoads').setEvent("mx.GE.toggleEngineLayers('roads', intCHECKED)", jsx3.gui.Interactive.TOGGLE);
		objDest.getDescendantOfName('showBorders').setEvent("mx.GE.toggleEngineLayers('borders', intCHECKED)", jsx3.gui.Interactive.TOGGLE);
		objDest.getDescendantOfName('showTrees').setEvent("mx.GE.toggleEngineLayers('trees', intCHECKED)", jsx3.gui.Interactive.TOGGLE);

		hideElementsWithName('image_ge');
		this.designation.init(objDest.getDescendantOfName('designate_block'));

		this.loadLocations();

		return tmpObj;
	};

	GE.toggleRuler = function() {
		if(!this.checkGEPresence()){
			return false;
		}

		var iframe = mx.MATRIX2.getIFrame(jsx3.GO('ge_iframe'));

		if(iframe.ruler){
			iframe.ruler = false;
			mx.MATRIX2.getServer().getJSXByName('buttonRulerAct').setText(__("Activate")).setTip(__("Activate ruler")).repaint();
			iframe.removeRuler();
		}
		else{
			iframe.ruler = true;
			mx.MATRIX2.getServer().getJSXByName('buttonRulerAct').setText(__("Reset")).setTip(__("Clear ruler")).repaint();
		}

		return true;
	};

	GE.checkRulerUnits = function() {
		if(!this.checkGEPresence()){
			return false;
		}

		var iframe = mx.MATRIX2.getIFrame(jsx3.GO('ge_iframe'));
		var units = jsx3.GO('selectRulerUnits').getText();

		if(units == __("meters")){
			iframe.ruler_units = "meters";
		}
		else{
			iframe.ruler_units = "miles";
		}

		iframe.calcRuler();

		return true;
	};

	GE.toggleZoom = function() {
		if(!this.checkGEPresence()){
			return false;
		}

		var iframe = mx.MATRIX2.getIFrame(jsx3.GO('ge_iframe'));

		if(iframe.zoom){
			iframe.zoom = false;
			mx.MATRIX2.getServer().getJSXByName('buttonZoomAct').setText(__("Activate")).setTip(__("Activate zoom tool")).repaint();
			iframe.removeZoom();
		}
		else{
			iframe.zoom = true;
			mx.MATRIX2.getServer().getJSXByName('buttonZoomAct').setText(__("Reset")).setTip(__("Clear zoom tool")).repaint();
		}

		return true;
	};

	GE.checkGEPresence = function(){
		var ge_frame = mx.MATRIX2.getServer().getJSXByName('ge_iframe');

		if(ge_frame && ge_frame != undefined){
            var iframe = mx.MATRIX2.getIFrame(ge_frame);
            if (iframe && iframe.isExist && iframe.google && !iframe.google.loader.LoadFailure){
                return iframe;
            }
		}

		return false;
	};

	GE.isGE = function()
	{
		return !!mx.MATRIX2.getServer().getJSXByName('ge_iframe');
	};

	GE.setNewEvent = function(obj_id, event_id) {
		var ge_frame = mx.MATRIX2.getServer().getJSXByName('ge_iframe');
		if(ge_frame && ge_frame != undefined){
            var iframe = mx.MATRIX2.getIFrame(ge_frame);
            if(iframe && iframe.google && !iframe.google.loader.LoadFailure){
                iframe.setNewEvent(obj_id, event_id);
            }
		}
	};

	GE.acknowledgeEvent = function(obj_id, event_id) {
		if (typeof mx.MATRIX2.getIFrame(mx.MATRIX2.getServer().getJSXByName('ge_iframe')).acknowledgeEventReceived != "function")
		{
			window.console && window.console.error("THIS SHOULD NOT HAPPEN!");
			return;
		}

		mx.MATRIX2.getIFrame(mx.MATRIX2.getServer().getJSXByName('ge_iframe')).acknowledgeEventReceived(obj_id, event_id);
	};

	GE.get3dCollectionId = function() {
		var strAPI = "get_cid.php";
		var cid = new jsx3.xml.Document().load(strAPI, 1000);
		if (cid.selectSingleNode("//STATUS").getAttribute("VALUE") == "OK") {
			return cid.selectSingleNode("//COLLECTION_ID").getAttribute("VALUE");
		} else {
			return false;
		}
	};

	GE.searchBarStatus = false; //false - hidden, true - shown
	GE.showHideSearchBar = function(bObj) {
		var layout = bObj.getAncestorOfName("ge_cell").getDescendantOfName("geSearchBlock").getParent();
		if (this.searchBarStatus) {
			layout.setCols("*,20,0,25,115", true);
			this.searchBarStatus = false;
		}
		else {
			layout.setCols("*,20,250,25,115", true);
			this.searchBarStatus = true;
		}
	};

	GE.geSearchGoButton = function(bObj) {
		var location = bObj.getParent().getParent().getDescendantOfName("geSearchTextbox").getValue();

		mx.MATRIX2.getIFrame(mx.MATRIX2.getServer().getJSXByName('ge_iframe')).searchLocation(location);
	};

	GE.lockDeviceOnMap = function(objId) {
		var ge_cell = mx.MATRIX2.getServer().getJSXByName('ge_iframe').getAncestorOfName("ge_cell");
		var fix_button = ge_cell.getDescendantOfName("ge_fixoncamera");
		var m3d_header = ge_cell.getDescendantOfName("M3D_header");

		var self = this;

		if (this.lockedDeviceId != null && !objId) {
			//unlock device
			this.lockedDeviceId = null;

            jsx3.GO("select3DModel").setEnabled(jsx3.gui.Form.STATEENABLED, true);
            jsx3.GO("select3DLayer").setEnabled(jsx3.gui.Form.STATEENABLED, true);

			fix_button.setImage("jsxuser:///images/design1/m3d/m3d_lock_cur_cam.png");
			fix_button.setTip(__("Lock map view on selected device"));
			fix_button.setAttribute("fixed_objid", "");
			m3d_header.setText(__("Map 3D Plugin"), true);
		}
		else {
			objId = objId || resourceTree.getSelectedId();
			//lock device
			if (objId) {
				var device = resourceTree.getObject(objId);
				if(window.jsDebug){ appLogger.info("GE.lockDeviceOnMap: objId="+objId+", devicetype="+device.attr("DEVICETYPE")+", device.attr(cam_geo_lat)="+device.attr("CAM_GEO_LAT")); }
				if (device.attr("CAM_GEO_CALIBRATION") != "no" && device.attr("CAM_GEO_LAT") && device.attr("CAM_GEO_LONG")) {
					var ge_frame = mx.MATRIX2.getIFrame(mx.MATRIX2.getServer().getJSXByName('ge_iframe'));
					if (ge_frame == null || ge_frame == undefined || ge_frame.ge == null) {
						window.setTimeout(function() {
							self.lockDeviceOnMap(objId);
						}, 250);
						return;
					}

					this.lockedDeviceId = objId;
					fix_button.setImage("jsxuser:///images/design1/m3d/m3d_lock_cur_cam_locked.png");
					fix_button.setTip(__("Unlock map view"));
					fix_button.setAttribute("fixed_objid", objId);

					var udid;
					if (device.attr("UDID") && device.attr("UDID") != "")
						udid = device.attr("UDID");
					else
						udid = objId;

					/* i18n: %1 is a camera id */
					m3d_header.setText(Gettext.strargs(__("Map 3D Plugin [locked on %1]"), [udid]), true);

					ge_frame.lockViewOnDevice(this.lockedDeviceId);

                    jsx3.GO("select3DModel").setEnabled(jsx3.gui.Form.STATEDISABLED, true);
                    jsx3.GO("select3DLayer").setEnabled(jsx3.gui.Form.STATEDISABLED, true);
				}
				else {
					//if nothing selected
					this.lockedDeviceId = null;

                    jsx3.GO("select3DModel").setEnabled(jsx3.gui.Form.STATEENABLED, true);
                    jsx3.GO("select3DLayer").setEnabled(jsx3.gui.Form.STATEENABLED, true);

					fix_button.setImage("jsxuser:///images/design1/m3d/m3d_lock_cur_cam.png");
					fix_button.setTip(__("Lock map view on selected device"));
					fix_button.setAttribute("fixed_objid", "");

					m3d_header.setText(__("Map 3D Plugin"), true);
					if (device.attr("CAM_GEO_CALIBRATION") == "no" || device.attr("CAM_GEO_LAT") == null || device.attr("CAM_GEO_LONG") == null) {
						alert(__("Device should be geo-calibrated first!"));
					}
				}
			}
			else {
				//if nothing selected
				this.lockedDeviceId = null;

                jsx3.GO("select3DModel").setEnabled(jsx3.gui.Form.STATEENABLED, true);
                jsx3.GO("select3DLayer").setEnabled(jsx3.gui.Form.STATEENABLED, true);

				fix_button.setImage("jsxuser:///images/design1/m3d/m3d_lock_cur_cam.png");
				fix_button.setTip(__("Lock map view on selected device"));
				fix_button.setAttribute("fixed_objid", "");
				m3d_header.setText(__("Map 3D Plugin"), true);
				alert(__("No camera selected!"));
			}
		}

		fix_button.repaint();
	};

	GE.lockedDeviceId = null;

	GE.callPTZmove = function(player, x, y) {
		mx.PTZ.clickOnScreen(player, x, y);
	};

	GE.callPTZmoveAbs = function(objId, Pdegree, Tdegree) {
		mx.PTZ.moveAbs(objId, Pdegree, Tdegree);
	};

	GE.showCameras = function(id, isMultiple) {
		if(window.jsDebug){ appLogger.info("GE.showCameras: id=" + id + ", isMultiple=" + isMultiple); }

        var m3dFrame = mx.MATRIX2.getServer().getJSXByName('ge_iframe');
        if(m3dFrame){
            var map3d = mx.MATRIX2.getIFrame(m3dFrame);
            var map3Dtab = m3dFrame.getAncestorOfType("jsx3.gui.Tab");

            if(window.jsDebug){ appLogger.info("GE.showCameras: mx.CT.currentTab="+mx.CT.currentTab+", map3Dtab="+map3Dtab); }

            if(mx.CT.currentTab != map3Dtab){
                mx.CT.onTabSelect(map3Dtab)
            }

            if(map3d.is3DMapLoaded()){
                map3d.lockViewOnDevice(id, isMultiple);
            }
            else{
                alert(__("Map 3D should be loaded first!"))
            }
        }
	};

    /*
     set layer select
     */
    GE.setLayerSelect = function(arr_models, model_id) {
        var max_layers = 0;

		var i;
        for(i = 0; i < arr_models.length; i++){
            if(arr_models[i].layers.length > max_layers){
                max_layers = arr_models[i].layers.length;
            }
        }

		var strSelectLayers = "";
        if(model_id){
            var layers = [];
            for(i = 0; i < arr_models.length; i++){
                if(arr_models[i].obj == model_id){
                    layers = arr_models[i].layers;
                }
            }
            strSelectLayers = '<data jsxid="jsxroot">';
            strSelectLayers += '<record jsxid="0" jsxtext="'+__("All layers")+'"/>';

            for (var j = 1; j <= layers.length; j++) {
                for (i = 0; i < layers.length; i++) {
                    if (layers[i].attributes.NUMBER == j) {
                        strSelectLayers += '<record jsxid="' + j + '" jsxtext="' + j + '. ' + layers[i].attributes.NAME + '"/>';
                    }
                }
            }

            strSelectLayers += '</data>';
        }
        else{
            strSelectLayers = '<data jsxid="jsxroot">';
            strSelectLayers += '<record jsxid="0" jsxtext="'+__("All layers")+'"/>';
            for(i = 1; i <= max_layers; i++){
                strSelectLayers += '<record jsxid="' + i + '" jsxtext="Layer ' + i + '"/>';
            }
            strSelectLayers += '</data>';
        }

        var selectLayerDoc = new jsx3.xml.CDF.Document.newDocument();
		selectLayerDoc.loadXML(strSelectLayers);

        mx.MATRIX2.getServer().Cache.setDocument('M3D_LAYERS', selectLayerDoc);

        jsx3.GO("select3DLayer").setXMLId('M3D_LAYERS').setValue(0);
		jsx3.GO("select3DLayer").repaint();
    };

    /*
     set models select
     */
    GE.setModelSelect = function(arr_models) {
        var strSelectModels = '<data jsxid="jsxroot">';
        strSelectModels += '<record jsxid="0" jsxtext="All 3D models" jsxexecute="mx.GE.changeModelLayer()"/>';
        for(var i = 0; i < arr_models.length; i++){
            strSelectModels += '<record jsxid="' + arr_models[i].obj + '" jsxtext="' + arr_models[i].attributes.NAME + '"/>';
        }
        strSelectModels += '</data>';

        var selectModelDoc = new jsx3.xml.CDF.Document.newDocument();
		selectModelDoc.loadXML(strSelectModels);

        mx.MATRIX2.getServer().Cache.setDocument('M3D_MODELS', selectModelDoc);

        jsx3.GO("select3DModel").setXMLId('M3D_MODELS').setValue(0);
		jsx3.GO("select3DModel").repaint();

		this.setLayerSelect(arr_models);
    };

    /*
     call ge changeModelLayer in iframe
     */
    GE.changeModel = function() {
        var new_model = jsx3.GO("select3DModel").getValue();
        var arr_models = mx.MATRIX2.getIFrame(mx.MATRIX2.getServer().getJSXByName('ge_iframe')).obj_3d_models_list;

		this.setLayerSelect(arr_models, new_model==0?null:new_model);

		mx.MATRIX2.getIFrame(mx.MATRIX2.getServer().getJSXByName('ge_iframe')).changeModelLayer(parseInt(new_model), 0, true);
	};

    /*
     call ge changeModelLayer in iframe
     */
    GE.changeLayer = function() {
        var new_model = jsx3.GO("select3DModel").getValue();
        var new_layer = jsx3.GO("select3DLayer").getValue();
		mx.MATRIX2.getIFrame(mx.MATRIX2.getServer().getJSXByName('ge_iframe')).changeModelLayer(parseInt(new_model, 10), parseInt(new_layer, 10), false);
	};

	/*
		show/hide 3D tweak panel
	*/
	GE.showHide3DTweak = function() {
		var ge_tweak = jsx3.GO("ge_tweak");
		var state = ge_tweak.getAttribute("state");
		var layout = jsx3.GO("layout3DTweak");
		if(state == "closed" || state == undefined){
			layout.setCols("*,150,0,0", true);
			ge_tweak.setAttribute("state", "opened");
		}
		else if(state == "opened"){
			layout.setCols("*,0,0,0", true);
			ge_tweak.setAttribute("state", "closed");
		}

		if($.browser.safari){
			layout.repaint();
		}
	};

	/*
		show/hide locations panel
	*/
	GE.toggleLocations = function() {
		var ge_locations_block = jsx3.GO("ge_locations_block");
		var state = ge_locations_block.getAttribute("state");
		var layout = jsx3.GO("layout3DTweak");
		if(state == "closed" || state == undefined){
			this.runFilterLocationMonitor();
			layout.setCols("*,0,0,155", true);
			ge_locations_block.setAttribute("state", "opened");
		}
		else if(state == "opened"){
			if(window['ge_location_filter']){ clearTimeout(window['ge_location_filter']); }
			layout.setCols("*,0,0,0", true);
			ge_locations_block.setAttribute("state", "closed");
		}
	};

	/*
		enable/disable map interfaces
	*/
	GE.toggleTargetsPanel = function(toOpen) {
		var button = jsx3.GO("ge_targets");
		var state = button.getAttribute("state");
		var layout = jsx3.GO("layout3DTweak");

		if (toOpen == undefined) {
			toOpen = !(state == 'opened');
		} else {
			toOpen = Boolean(toOpen);
		}

		if (toOpen) {
			layout.setCols("*,0,300,0", true);
			button.setAttribute("state", "opened");
			button.setImage("jsxuser:///images/design1/m3d/m3d_interfaces_on.png");
			button.setTip(__("Close targets panel"));
		}
		else {
			layout.setCols("*,0,0,0", true);
			button.setAttribute("state", "closed");
			button.setImage("jsxuser:///images/design1/m3d/m3d_interfaces_off.png");
			button.setTip(__("Open targets panel"));
		}

		var ge_frame = mx.MATRIX2.getServer().getJSXByName('ge_iframe');
		if(ge_frame && ge_frame != undefined){
			var iframe = mx.MATRIX2.getIFrame(ge_frame);
			if(iframe && iframe != undefined && !iframe.google.loader.LoadFailure){
				iframe.geTargetingSwitchLiveArchive(state);
			}
		}
		button.repaint();
	};

    /*
     change vertical view
     */
    GE.changeVerticalAngle = function(value) {
        var ge_frame = mx.MATRIX2.getServer().getJSXByName('ge_iframe');
        if(ge_frame && ge_frame != undefined){
            var iframe = mx.MATRIX2.getIFrame(ge_frame);
            if(iframe && iframe != undefined && !iframe.google.loader.LoadFailure){
                iframe.change_view(null, null, null, null, value);
            }
        }
	};

    /*
     show cell alert
     */
    GE.showCellAlert = function() {
        var ge_cell = mx.MATRIX2.getServer().getJSXByName('ge_cell');
        var alertBlock = ge_cell.getDescendantOfName("ge_alert");
        if(alertBlock.getBackground() != "background-image:url(./assets/eventlog/e20x20.gif); background-repeat:repeat-x;"){
            alertBlock.setBackground("background-image:url(./assets/eventlog/e20x20.gif); background-repeat:repeat-x;");
		    alertBlock.setTip(__("Click to show alerting device"));
		    alertBlock.repaint();
        }
	};

    /*
     hide cell alert
     */
    GE.hideCellAlert = function() {
        var ge_cell = mx.MATRIX2.getServer().getJSXByName('ge_cell');
        var alertBlock = ge_cell.getDescendantOfName("ge_alert");
        alertBlock.setBackground("");
		alertBlock.setTip("");
		alertBlock.repaint();
	};

    /*
     go to alert
     */
    GE.gotoAlert = function() {
        var ge_frame = mx.MATRIX2.getServer().getJSXByName('ge_iframe');
        if(ge_frame && ge_frame != undefined){
            var iframe = mx.MATRIX2.getIFrame(ge_frame);
            if(iframe && iframe != undefined && !iframe.google.loader.LoadFailure){
                iframe.gotoNextAlert();
            }
        }
	};


	GE.locations = false;
	GE.newLocationId = null;
	GE.lastLocationFilter = "";
	GE.locationPoints = [];
	GE.locationMaxPoints = 50;
	/*
     load locations
     */
	GE.loadLocations = function() {
		var ge_cell = mx.MATRIX2.getServer().getJSXByName('ge_cell');

		var self = this;

		api.getObjectList({
			type: 'location',
			roleid: resourceTree.role.obj,
			withAttributes: true
		})
			.fail(function(code, message){
				alert(__("Error on locations get: ") + message);
			})
			.done(function(response){
				self.locations = response.list;
				self.filterLocations();

				self.showLocations();
				self.newLocationId = null;
			});
	};

	/*
     get location data
     */
	GE.getLocationData = function(objId) {
		for (var i = 0; i < this.locations.length; i++) {
			var record = this.locations[i];
			if(record.obj == objId){
				return record;
			}
		}
		return null;
	};

	/*
     filter locations
     */
	GE.filterLocations = function() {
		var ge_cell = mx.MATRIX2.getServer().getJSXByName('ge_cell');

		var filter = ge_cell.getDescendantOfName('textboxLocationsFilter').getValue();

		var blockLocationList = ge_cell.getDescendantOfName('blockLocationList');
		var locListHtml = '';

		for (var i = 0; i < this.locations.length; i++) {
			var record = this.locations[i];
			if(filter == "" || record.NAME.indexOf(filter) != -1){
				var locationCurState = $('input:checkbox[name=location_item][objid=' + record.obj + ']');
				var checked = "";
				if(this.newLocationId == record.obj || (locationCurState && locationCurState.is(":checked"))){
					checked = 'checked="checked "';
				}
				locListHtml+= '<input type="checkbox" ' + checked + 'name="location_item" loc_name="' + record.NAME + '" objid="' + record.obj + '" onclick="mx.GE.onLocationSetChange()"/>'  + record.NAME + '<br />';
			}
		}

		blockLocationList.setText(locListHtml).repaint();
	};

	/*
     filter location monitor
     */
	GE.runFilterLocationMonitor = function() {
		var ge_cell = jsx3.GO("ge_cell");

		if(ge_cell == null){
			return;
		}

		var filter = ge_cell.getDescendantOfName('textboxLocationsFilter').getValue();
		if(this.lastLocationFilter != filter){
			this.lastLocationFilter = filter;
			this.filterLocations();
		}

		if(window['ge_location_filter']){ clearTimeout(window['ge_location_filter']); }
		var self = this;
		window['ge_location_filter'] = window.setTimeout(function() { self.runFilterLocationMonitor(); }, 1500);
	};

	/*
     on location set change
     */
	GE.onLocationSetChange = function() {
		this.showLocations();
	};

	/*
     show location
     */
	GE.showLocations = function() {
		var ge_cell = mx.MATRIX2.getServer().getJSXByName('ge_cell');
		var frame = this.checkGEPresence();

		if(!frame){
			return;
		}

		frame.clearLocations();
		var selLocations = $('input:checkbox[name=location_item]:checked');
		for(var i = 0; i< selLocations.length; i++){
			var objid = selLocations[i].getAttribute("objid")
			var record = this.getLocationData(objid);
			if(record != null){
				var jsonObjPoints = $.parseJSON(record.LOC_DATA);
				var jsonObjView = $.parseJSON(record.VIEW_DATA);

				var location = {};
				location.obj = record.obj;
				location.name = record.NAME;
				location.type = record.LOC_TYPE;
				location.data = jsonObjPoints;
				location.view = jsonObjView;

				frame.addLocation(location);
			}
		}

		if(selLocations.length > 0){
			frame.showLocations();
		}

		if(selLocations.length == 1){
			ge_cell.getDescendantOfName('buttonEditLocation').setEnabled(jsx3.gui.Form.STATEENABLED, true);
			ge_cell.getDescendantOfName('buttonDeleteLocation').setEnabled(jsx3.gui.Form.STATEENABLED, true);
		}
		else{
			ge_cell.getDescendantOfName('buttonEditLocation').setEnabled(jsx3.gui.Form.STATEDISABLED, true);
			ge_cell.getDescendantOfName('buttonDeleteLocation').setEnabled(jsx3.gui.Form.STATEDISABLED, true);
		}

		ge_cell.getDescendantOfName('textboxNewName').setEnabled(jsx3.gui.Form.STATEENABLED, true);
	};

	/*
     wait for location point
     */
	GE.waitForLocationPoint = function(action) {
		var frame = this.checkGEPresence();
		if(!frame){
			alert(__("Google Earth not found!"));
			return;
		}

		var ge_cell = jsx3.GO('ge_cell');
		var textboxNewName = ge_cell.getDescendantOfName('textboxNewName');
		if(action == "add"){
			if(textboxNewName.getValue() == ""){
				alert(__("Input location name first"));
				return;
			}
		}

		ge_cell.setAttribute("location_action", action);

		frame.location_need_callback = true;

		this.showLocationMask(__("Click on map to add point(s)"));
	};

	/*
     on location callback
     */
	GE.onLocationCallback = function(geodata, pointCounter){
		var ge_cell = jsx3.GO('ge_cell');
		var value = $("#location_type").val();

		this.locationPoints.push(geodata);

		if(value == 'point'){
			this.saveLocation(ge_cell.getAttribute("location_action"));
		}
		else if(value == 'line'){
			if(this.locationPoints.length == this.locationMaxPoints){
				alert(__("Maximum points reached!"));
				this.locationFinalizeLine();
				return false;
			}

			ge_cell.getDescendantOfName('buttons_block').hideMask();
			ge_cell.getDescendantOfName('buttonAddLocation').setText(__("Save line"), true).setEvent("mx.GE.locationFinalizeLine()", jsx3.gui.Interactive.EXECUTE);

			ge_cell.getDescendantOfName('buttonEditLocation').setEnabled(jsx3.gui.Form.STATEDISABLED, true);
			ge_cell.getDescendantOfName('buttonDeleteLocation').setEnabled(jsx3.gui.Form.STATEDISABLED, true);

			ge_cell.getDescendantOfName('textboxNewName').setEnabled(jsx3.gui.Form.STATEDISABLED, true);

			var frame = this.checkGEPresence();
			frame.addLocationLinePoint(geodata);
		}

		return true;
	};

	/*
     finalize location line
     */
	GE.locationFinalizeLine = function(){
		var ge_cell = jsx3.GO('ge_cell');
		ge_cell.getDescendantOfName('buttonAddLocation').setText(__("Add new"), true).setEvent("mx.GE.waitForLocationPoint('add')", jsx3.gui.Interactive.EXECUTE);
		this.saveLocation(ge_cell.getAttribute("location_action"));
	};

	/*
     show location mask
     */
	GE.showLocationMask = function(text) {
		var ge_cell = jsx3.GO('ge_cell');
		ge_cell.getDescendantOfName('buttons_block').showMask(text);
		var htmlMaskStyle = ge_cell.getDescendantOfName('buttons_block').getLastChild().getRendered().style;
		htmlMaskStyle.padding = "40px 5px 5px 5px";
		htmlMaskStyle.width = ge_cell.getDescendantOfName('buttons_block').getRendered().style.width;
		htmlMaskStyle.height = ge_cell.getDescendantOfName('buttons_block').getRendered().style.height;

		$("#location_type").attr("disabled", "disabled");
	};

	/*
     remove location mask
     */
	GE.removeLocationMask = function() {
		var ge_cell = jsx3.GO('ge_cell');
		ge_cell.getDescendantOfName('buttons_block').hideMask();
	};

	/*
     save location
     */
	GE.saveLocation = function(action) {
		var ge_cell = mx.MATRIX2.getServer().getJSXByName('ge_cell');
		var frame = this.checkGEPresence();
		var viewData = frame.get_view_data();

		var name;
		var locationType;

		if(action == "add"){
			name = ge_cell.getDescendantOfName('textboxNewName').getValue();
			locationType = $("#location_type").val();
		}
		else if(action == "edit"){
			var selLocation = $('input:checkbox[name=location_item]:checked');
			var objid = selLocation[0].objid;
			var record = this.getLocationData(objid);
			name = record.NAME;
			locationType = record.LOC_TYPE;
		}

		var attributes = {
			"NAME": name,
			"LOC_DATA": JSON.stringify(this.locationPoints),
			"LOC_ROLEID": resourceTree.role.obj,
			"LOC_TYPE": locationType,
			"VIEW_DATA": JSON.stringify(viewData)
		};

		var self = this;

		if(action == "add"){
			api.addObject({
				type: "location",
				attributes: JSON.stringify(attributes)
			})
				.always(function(){
					self.removeLocationMask();
					$("#location_type").removeAttr("disabled");

					if(frame.location_placemark){
						frame.ge.getFeatures().removeChild(frame.location_placemark);
						frame.location_placemark = null;
					}
					frame.location_need_callback = false;
				})
				.fail(function(code, message){
					alert(__("Save location error: ") + message);
				})
				.done(function(response){
					ge_cell.getDescendantOfName('textboxNewName').setValue("");
					self.newLocationId = response.obj;
					self.locationPoints = [];
					self.loadLocations();
				});
		} else
		if(action == "edit"){
			api.setAttributes({
				obj: objid,
				attributes: JSON.stringify(attributes)
			})
				.always(function(){
					self.removeLocationMask();
					$("#location_type").removeAttr("disabled");

					if(frame.location_placemark){
						frame.ge.getFeatures().removeChild(frame.location_placemark);
						frame.location_placemark = null;
					}
					frame.location_need_callback = false;
				})
				.fail(function(code, message){
					alert(__("Save location error: ") + message);
				})
				.done(function(response){
					ge_cell.getDescendantOfName('textboxNewName').setValue("");
					self.locationPoints = [];
					self.loadLocations();
				});
		}
	};

	/*
     delete location
     */
	GE.deleteLocation = function() {
		var ge_cell = mx.MATRIX2.getServer().getJSXByName('ge_cell');
		var selLocation = $('input:checkbox[name=location_item]:checked');
		var objid = selLocation[0].objid;

		if(window.jsDebug){ appLogger.info("GE.deleteLocation: objid=" + objid); }

		this.showLocationMask(__("Deleting location"));

		var self = this;

		api.deleteObject({
			objList: JSON.stringify([objid])
		})
			.fail(function(code, message){
				alert(__("Delete location error: ") + message);
			})
			.done(function(response){
				var frame = self.checkGEPresence();
				frame.clearLocations();
				self.loadLocations();
			})
			.always(function(){
				ge_cell.getDescendantOfName('buttons_block').hideMask();
			});
	};

	/*
		enable/disable engine layers
	*/
	GE.toggleEngineLayers = function(layerType, layerState) {
		var frame = GE.checkGEPresence();
		if(frame){
			frame.toggleEngineLayers(layerType, layerState);
		}
	};

	GE.hideEngineLayersTweak = function(){
		var ge_cell = mx.MATRIX2.getServer().getJSXByName('ge_cell');
		ge_cell.getDescendantOfName('textAdditionalLayers').setDisplay(jsx3.gui.Block.DISPLAYNONE, true);

		ge_cell.getDescendantOfName('showBuildings').setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
		ge_cell.getDescendantOfName('showRoads').setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
		ge_cell.getDescendantOfName('showBorders').setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
		ge_cell.getDescendantOfName('showTrees').setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
	};
});
