//---------------------------------------------------------------------------------------------------------------
// Event Log Class
//---------------------------------------------------------------------------------------------------------------
jsx3.lang.Package.definePackage("mx.ELog2", function(ELog2) {

	ELog2.elDefaultContainer = null;
	ELog2.hidden = true;

	ELog2.dictSources = {
		1: {label: __("MD", "ELog event source"), descr: __("Motion Detector", "ELog event source")},
		2: {label: __("CMD", "ELog event source"), descr: __("Camera Motion Detector", "ELog event source")},
		3: {label: __("Sensor"), descr: __("Sensor")},
		4: {label: __("User"), descr: __("User")},
		5: {label: __("ACS"), descr: __("Access Control System")},
		6: {label: __("Analytics"), descr: __("Analytics")}
	};

	// Event Priorities dictionary, getPriorities() method fills this array by values from DB
	ELog2.dictPriority = {};

	ELog2.timeline = null;

	ELog2.timelineScale = 'hour';
	ELog2.archiveInterval = 4 * 3600;

	ELog2.eLogNoter = {};

	// CIRRUS_REPLACE_ELOG2_JS_ID001_BEGIN
	ELog2.minSize = 75; //H - 75
	ELog2.maxSize = 100; //K - 100
	ELog2.MaxQueueSize = 40; //X or Q
	// CIRRUS_REPLACE_ELOG2_JS_ID001_END
	ELog2.notificationsPeriod = 5000; //mls

	ELog2.needAckColor = "#f3503f";
	ELog2.ackColor = "#F7F87D";
	ELog2.clearedColor = "#f0f0f0";

	ELog2.needAckFontColor = "#000000";
	ELog2.ackFontColor = "#000000";
	ELog2.clearedFontColor = "#000000";

	ELog2.InfoColor = "#FFFFFF";
	ELog2.InfoFontColor = "#000000";

	ELog2.ELogDOMCurWidth = 0;
	ELog2.ELogDOMMinWidth = 750;

	ELog2.ELogDOMTempEvents = [];

	ELog2.callFinished = true;
	ELog2.monitorTime = 0;
	ELog2.monitorPeriod = 5000;

	ELog2.enableNotifFinished = true;

	ELog2.started = false;

	ELog2.enabled = true;
	ELog2.appletEnabled = true;

	ELog2.migrationAllowed = 0;
	ELog2.migrationMonitorPeriod = 60 * 1000;

	/* Elog filters */
	ELog2.mode = 'live'; // live | archive, current mode of ELog
	ELog2.state = 'all'; // all | not_acknowledged | not_cleared | cleared
	ELog2.device = 'full'; // full | filtered | selected

	ELog2.tag = 0;
	ELog2.tagOnFlag = false;
	ELog2.eventType = 1;
	ELog2.objids = '';
	ELog2.priority = 1;
	ELog2.message = '';
	ELog2.startTs = 0;
	ELog2.endTs = 0;
	ELog2.pageNum = 0;
	ELog2.pageSize = 100;
	ELog2.includeWitnesses = true;

	ELog2.dropstarted = false;

	ELog2.lookupLifespanObjId = null;
	ELog2.lookupLifespanId = null;

	ELog2.screenshotsStart = 0;

	ELog2.witnessesAllData = [];

	ELog2.lowerAreaSize = 280; //px

	ELog2.lastEventId = 0;

	ELog2.announceRoleUsers = [];

	ELog2.notificationMonitor = function () {
		//register self
		if (window['monitor_var']) {
			clearTimeout(window['monitor_var']);
		}
		window['monitor_var'] = window.setTimeout(function() {
			ELog2.notificationMonitor();
		}, ELog2.monitorPeriod);

		//restart checkNotifications
		if (!ELog2.callFinished && ((new Date()).getTime() - ELog2.monitorTime) >= ELog2.monitorPeriod) {
			ELog2.setELogVisualState(1);
			if (window['notif_var']) {
				clearTimeout(window['notif_var']);
			}
			window['notif_var'] = window.setTimeout(function() {
				ELog2.checkNotifications(true);
			}, 10);
			if (window.jsDebug) {
				appLogger.info("notificationMonitor: CHECK OK : NOTIFICATION RESTARTED");
			}
		}

		//restart enableNotifications
		/*if(!ELog2.enableNotifFinished){
		 ELog2.setELogVisualState(1);
		 //window['enbl_notif_var'] = window.setTimeout(function() { ELog2.enableNotifFinished=false; ELog2.eLogNoter.enableNotifications(true); ELog2.enableNotifFinished=true; }, 10);
		 appLogger.info("notificationMonitor: CHECK OK : ENABLE NOTIFICATION RESTARTED");
		 }*/
	};

	ELog2.migrationMonitor = function() {
		// CIRRUS_REPLACE_ELOG2_JS_ID006_BEGIN
		var XMLDoc = new jsx3.xml.Document().load("elog_migration.xml", xmlRequestTmeout);
		//if doc exists
		if (XMLDoc) {
			//check migration status
			var migrationNode = XMLDoc.selectSingleNode("//data/elog_migration");
			if (migrationNode) {
				ELog2.migrationAllowed = parseInt(migrationNode.getValue());
			}
			//appLogger.info("ELog2.migrationAllowed = "+ELog2.migrationAllowed);
		}
		// CIRRUS_REPLACE_ELOG2_JS_ID006_END
		//ELog2.checkStorageStatus();

		if (window['migrationMonitor_var']) {
			clearTimeout(window['migrationMonitor_var']);
		}
		window['migrationMonitor_var'] = window.setTimeout(function() {
			ELog2.migrationMonitor();
		}, ELog2.migrationMonitorPeriod);
	};

	ELog2.getPriorities = function() {
		api.getEventPriorities()
			.fail(function(code, message){
				appLogger.error('Error initializing priorities dictionary: ' + message);
			})
			.done(function(response){
				var list = response.list;
				ELog2.dictPriority = {};
				for (var i = 0; i < list.length; i++) {
					var pr = list[i];
					ELog2.dictPriority[pr.eventpriority] = pr;
				}
			});
	};

	ELog2.checkStorageStatus = function() {
		var XMLDoc = new jsx3.xml.Document().load("/sm/status.xml", xmlRequestTmeout);
		//if doc exists
		if (XMLDoc) {
			//check storage status
			var storageStatusNode = XMLDoc.selectSingleNode("//data/status");
			if (storageStatusNode) {
				var sysStateBlock = mx.MATRIX2.getServer().getJSXByName("blockSystemState");
				if (storageStatusNode.getValue() == "STOPPED") {
					sysStateBlock.setText("[ SYSTEM STOPPED ]", true);
					mx.TIMELINE.hideTimeLine('gn');
					mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls.isArchiveModeEnabled = false;
				} else if (storageStatusNode.getValue() == "NO-ARCHIVE") {
					sysStateBlock.setText("[ NO ARCHIVE ]", true);
					mx.TIMELINE.hideTimeLine('gn');
					mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls.isArchiveModeEnabled = false;
				} else if (storageStatusNode.getValue() == "ARCHIVING") {
					sysStateBlock.setText("", true);
					mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls.isArchiveModeEnabled = true;
				}
			}
		}
	};

	ELog2.elSetDefaultContainer = function(objBlock) {
		ELog2.elDefaultContainer = objBlock;
	};

	ELog2.elGetDefaultContainer = function() {
		return ELog2.elDefaultContainer;
	};

	//set eLog2 default container
	ELog2.elStart = function(objBlock) {
		if(window.jsDebug){ appLogger.info("ELog2.elStart: objBlock="+objBlock); }

        if(mx.MATRIX2.getServer().Cache.getDocument('TIME_timezones') == null){
            window.setTimeout(function(){ ELog2.elStart(objBlock); }, 50);
            return;
        }

		if (!objBlock) {
			alert(__("Couldn't start EventLog!"));
			return;
		}

		ELog2.elSetDefaultContainer(objBlock);
		ELog2.elDefaultContainer.loadAndCache('components/eLog2.xml', true);
		ELog2.getPriorities();

		mx.MATRIX2.getServer().getCache().setDocument("CACHE_EVENTSLIST", jsx3.xml.CDF.Document.newDocument());
		ELog2.elDefaultContainer.setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);

		// set modes
		var strModes =
			'<data jsxid="jsxroot">' +
				'<record jsxid="1" jsxtext="' + __("Live", "Eventlog mode") + '" />' +
				'<record jsxid="2" jsxtext="' + __("Archive", "Eventlog mode") + '" />' +
				'<record jsxid="3" jsxtext="' + __("Announces", "Eventlog mode") + '" />' +
			'</data>';
		var modesDoc = jsx3.xml.CDF.Document.newDocument();
		modesDoc.loadXML(strModes);
		mx.MATRIX2.getServer().Cache.setDocument('Elog2_ModesDocument', modesDoc);

		var selectMode = jsx3.GO("eLog2Root").getDescendantOfName('elModeSelector');
		selectMode.setEvent("mx.ELog2.setMode()", jsx3.gui.Interactive.SELECT);
		selectMode.setXMLId('Elog2_ModesDocument').setValue(1);
		selectMode.repaint();


		ELog2.initApplet();
		ELog2.setupELogDialog();

		ELog2.elLoadToPane('pane_elogsmall');
		ELog2.elHide();

		ELog2.migrationMonitor();

		ELog2.notificationMonitor();

		//if popups enabled start notification
		if (resourceTree.getObject({'popup_video': 1})) {
			ELog2.migrationMonitor();
			ELog2.checkNotifications(true);
		}

		ELog2.servicelookupEventState();

		ELog2.subscribeAnnouncedEvents();
	};

	//load eLog2 to pane
	ELog2.elLoadToPane = function(strBlockName) {
		//appLogger.info("elLoadToPane START :"+strBlockName);
		var block = mx.MATRIX2.getServer().getJSXByName(strBlockName);
		//appLogger.info("elLoadToPane: "+block.getAttribute("eLog2Block"));
		if (block.getAttribute("eLog2Block") == "0" || block.getAttribute("eLog2Block") === undefined) {
			if (block != null) {
				mx.ELog2.elDrop(block);
			}

			if (strBlockName == 'pane_elogsmall') {
				var splitter = block.getParent();
				splitter.setSubcontainer2Min(ELog2.lowerAreaSize);
				splitter.setSubcontainer1Pct("75%", true);

				//mx.MATRIX2.afterSplitterResize(splitter);
				splitter.doEvent(jsx3.gui.Interactive.DROP, {});
				mx.vMX.onLayoutResize();
				block.setAttribute("eLog2Block", "1");
			}
		}
		ELog2.hidden = false;
		//appLogger.info("elLoadToPane OK: ELog2.hidden="+ELog2.hidden);
	};

	//load eLog2 after click on eLog2 button
	ELog2.elRestoreOnClick = function() {
        mx.MATRIX2.clearDestinationBlock(jsx3.GO('pane_elogsmall'));
        mx.ELog2.elLoadToPane('pane_elogsmall');
	};

	//drop eLog2 to block
	ELog2.elDrop = function(objBlock) {
		if (!mx.MATRIX2.checkCellsLimit(mx.MATRIX2.elogCellWeight, true)) {
			return null;
		}

		//appLogger.info("elDrop START :"+objBlock);
		var eLog2 = jsx3.GO("eLog2Root");

		if (eLog2.getParent().getName() == 'pane_elogsmall') { // if eLog2 in lower panel
			var splitter = eLog2.getParent().getParent();
			splitter.setSubcontainer2Min(15);
			splitter.setSubcontainer1Pct("98%", true);
			splitter.doEvent(jsx3.gui.Interactive.DROP, {});
		}

		eLog2.getParent().setAttribute("eLog2Block", "0");

		if (ELog2.ELogDOMTempEvents.length == 0) {
			var eLog2_container = document.getElementById("eLog2_container");
			for (var i = 0; i < eLog2_container.childNodes.length; i++) {
				ELog2.ELogDOMTempEvents[i] = eLog2_container.childNodes[i].cloneNode(true);
			}
		}

		objBlock.adoptChild(eLog2);
		objBlock.setAttribute("eLog2Block", "1");

		ELog2.addDOMEventLogHeader();
		for (i = 0; i < ELog2.ELogDOMTempEvents.length; i++) {
			var eLog2_new_container = document.getElementById("eLog2_container");

			eLog2_new_container.appendChild(ELog2.ELogDOMTempEvents[i]);
			//eLog2_new_container.insertBefore(ELog2.ELogDOMTempEvents[i], eLog2_new_container.firstChild);
		}
		ELog2.ELogDOMTempEvents = [];

		if (eLog2.getParent().getName() == 'blockElog2') {
			eLog2.setVisibility(jsx3.gui.Block.VISIBILITYVISIBLE, true);
		}

		jsx3.GO('eLog2Root').subscribe(jsx3.gui.Interactive.AFTER_RESIZE_VIEW, function() {mx.ELog2.toggleFilters(false);});

		ELog2.checkSize();

		ELog2.showHideELogInLayout(false);

		ELog2.hidden = false;

		ELog2.initTimeline();

		ELog2.startELog();
		//appLogger.info("elDrop OK: ELog2.hidden="+ELog2.hidden);
	};

	ELog2.checkSize = function() {
		//appLogger.info("checkSize: START");
		var elog2Root = mx.MATRIX2.getServer().getJSXByName('eLog2Root');
		if (!elog2Root)
		{
			return;
		}

		ELog2.ELogDOMCurWidth = elog2Root.getAbsolutePosition().W;

		if (ELog2.ELogDOMCurWidth <= ELog2.ELogDOMMinWidth) {
			mx.MATRIX2.getServer().getJSXByName('blockLRoot').setWidth(ELog2.ELogDOMMinWidth, true);
		} else {
			mx.MATRIX2.getServer().getJSXByName('blockLRoot').setWidth("100%", true);
		}
		//appLogger.info("checkSize: OK");
	};

	//move eLog2 to default container
	ELog2.elHide = function() {
		if(window.jsDebug){ appLogger.info("ELog2.elHide: START"); }
		var eLog2 = jsx3.GO("eLog2Root");
		var parentBlock = eLog2.getParent();

		if (ELog2.elDefaultContainer != null) {
			ELog2.closeDialog();
			parentBlock.removeAttribute("eLog2Block");
			parentBlock.setAttribute("playerBlock", "0");
			if (parentBlock.getName() == 'pane_elogsmall') {
				var splitter = parentBlock.getParent();
				splitter.setSubcontainer2Min(15);
				splitter.setSubcontainer1Pct("98%", true);
				//mx.MATRIX2.afterSplitterResize(splitter, null)
				splitter.doEvent(jsx3.gui.Interactive.DROP, {});
				mx.vMX.onLayoutResize();
				//parentBlock.removeAttribute("playerBlock");
				parentBlock.setAttribute("eLog2Block", "0");
			}

			var eLog2_container = document.getElementById("eLog2_container");
			if(eLog2_container.childNodes){
				for (var i = 0; i < eLog2_container.childNodes.length; i++) {
					ELog2.ELogDOMTempEvents[i] = eLog2_container.childNodes[i].cloneNode(true);
				}
			}

			ELog2.elDefaultContainer.adoptChild(eLog2);
			ELog2.elDefaultContainer.setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
			ELog2.showHideELogInLayout(true);
			ELog2.hidden = true;

			//if popups disabled stop notification
			if (!resourceTree.getObject({'popup_video': true})) {
				ELog2.stopELog();
			}
			mx.MATRIX2.checkCellsLimit(mx.MATRIX2.elogCellWeight, false);

			$('#elog_calendar').remove();
		}
		//appLogger.info("elHide OK");
	};

	ELog2.showHideELogInLayout = function(isShow) {
		var rows = mx.MATRIX2.getServer().getJSXByName('layoutControl').getRows().split(",");
		var image_elog2 = mx.MATRIX2.getServer().getJSXByName('image_elog2');
		var image_elog2_detailed = mx.MATRIX2.getServer().getJSXByName('image_elog2_detailed');

		if(window.jsDebug){ appLogger.info("ELog2.showHideELogInLayout: isShow="+isShow); }
		//do not show/hide allready hidden settings
		if ((isShow && image_elog2_detailed.getDisplay() == jsx3.gui.Block.DISPLAYBLOCK) || (!isShow && image_elog2_detailed.getDisplay() == jsx3.gui.Block.DISPLAYNONE)) {
			return;
		}

		//show
		if (isShow) {
			image_elog2.setDisplay(jsx3.gui.Block.DISPLAYBLOCK, true);
			image_elog2_detailed.setDisplay(jsx3.gui.Block.DISPLAYBLOCK, true);
			var newHeight = parseInt(rows[1], 10) + 20;
		} else { //hide
			image_elog2.setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
			image_elog2_detailed.setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
			var newHeight = parseInt(rows[1], 10) - 20;
		}

		mx.MATRIX2.getServer().getJSXByName('layoutControl').setRows(rows[0] + "," + newHeight + "," + rows[2] + "," + rows[3], !toggle_LayoutPanel);
	};

	//a simple utility function which fills the record with appropriate UTC and local times
	ELog2.loadUTCLOCALTimes = function(objRecord) {
		//get the UTCTIME and convert it appopriately to every form
		var localOffset = (new Date()).getTimezoneOffset() * 60;

		var utcTimeWhen = objRecord.getAttribute("UTCTIME_WHEN");
		objRecord.setAttribute("LOCALTIME_WHEN", utcTimeWhen*1000 - localOffset);
		objRecord.setAttribute("UTC_WHEN", mx.TIME.timestamp2date(utcTimeWhen * 1000));
		objRecord.setAttribute("LOCAL_WHEN", mx.TIME.timestamp2date(utcTimeWhen * 1000));

		var utcTimeFrom = objRecord.getAttribute("UTCTIME_FROM");
		objRecord.setAttribute("LOCALTIME_FROM", utcTimeFrom*1000 - localOffset);
		objRecord.setAttribute("UTC_FROM", mx.TIME.timestamp2date(utcTimeFrom * 1000));
		objRecord.setAttribute("LOCAL_FROM", mx.TIME.timestamp2date(utcTimeFrom * 1000));

		var utcTimeTo = objRecord.getAttribute("UTCTIME_TO");
		objRecord.setAttribute("LOCALTIME_TO", utcTimeTo*1000 - localOffset);
		objRecord.setAttribute("UTC_TO", mx.TIME.timestamp2date(utcTimeTo * 1000));
		objRecord.setAttribute("LOCAL_TO", mx.TIME.timestamp2date(utcTimeTo * 1000));
	};

	/**
	 *
	 * @param arrObjIds
	 * @returns {String}
	 */
	ELog2.getWitnessesInfo = function(arrObjIds) {
		//appLogger.info("getWitnessesInfo: START");
		var message = {};

		message = {
			objids: arrObjIds,
			properties: ["NAME", "health", "TYPE", "SUBTYPE", "state"],
			methods: "true"
		};

		return ELog2.eLogNoter.getObjects(message);
	};

	ELog2.showObjMenu = function (objMatrix, strRECORDID, objEVENT, witMenu) {
		var matrixDoc = objMatrix.getXML();
		var node = matrixDoc.selectSingleNode("//record[@jsxid='" + strRECORDID + "']");
		if (node != null) {
			var objId = node.getAttribute("objid");
			witMenu = witMenu || mx.MATRIX2.getServer().getJSXByName("witnessActions");

			var labelAL = witMenu.getDescendantOfName("labelAL");
			/* i18n: %1 is an object name */
			labelAL.setText(Gettext.strargs(__("Actions list for %1:"), [node.getAttribute('jsxtext')]));

			var witBlock = witMenu.getDescendantOfName("paneWB");
			var witDoc = mx.MATRIX2.getServer().Cache.getDocument('witness_actions_' + objId);
			var witMethods = witDoc.selectNodes("//record");
			witBlock.removeChildren();

			var width = witMethods.size() < 5 ? "99%" : "94%";
			for (var i = 0; i < witMethods.size(); i++) {
				var button = new jsx3.gui.Button("button" + i, 0, i * 25, width, witMethods.get(i).getAttribute("jsxtext"));
				button.setHeight(20);
				button.setRelativePosition(jsx3.gui.Block.ABSOLUTE);
				button.setEnabled(jsx3.gui.Form.STATEENABLED);
				button.setBackgroundColor("#FFFFFF");
				button.setBorder("1px solid black");
				button.setEvent(witMethods.get(i).getAttribute("jsxexecute"), jsx3.gui.Interactive.EXECUTE);
				witBlock.setChild(button);
				//appLogger.info("method"+witMethods.get(i));
			}
			witMenu.setVisibility(jsx3.gui.Block.VISIBILITYVISIBLE, false);
			witMenu.repaint();
		}
	};

	ELog2.checkWitnesses = function(strWitnesses, strEventId, strObjId, isEADAAllowed) {
		if (window.jsDebug) {
			appLogger.info("ELog2.checkWitnesses START: " + strWitnesses + ", strEventId=" + strEventId + ", strObjId=" + strObjId);
		}

		var eLog2 = jsx3.GO("eLog2Root");

		var witnesses = [];
		if (strWitnesses) {
			witnesses = strWitnesses.toString().split(' ');
		}
		// if not found self inside witnesses
		if ($.inArray(strObjId, witnesses) == -1 || witnesses.length == 0) {
			witnesses.unshift(strObjId);
		}

		//appLogger.info("strWitnesses = "+strWitnesses+", witnesses.length = "+witnesses.length+", inArray="+$.inArray(witnesses, strObjId));
		var strWitnessesInfo = ELog2.getWitnessesInfo(witnesses);
		var witnessesInfo = $.parseJSON(strWitnessesInfo);
		if(window.jsDebug){ appLogger.info("ELog2.checkWitnesses: strWitnessesInfo = " + strWitnessesInfo);}

		if (witnessesInfo.status != "OK") {
			//status error
			appLogger.info("witnessesInfo.status=" + witnessesInfo.status + " :" + witnessesInfo.MSG);
			return '';
		}

		var cdfWitnesses = '';
		var witnessesMethodsAllObjects = witnessesInfo.objects;

		// Find main object in witnessesMethodsAllObjects and move it to first place
		for (var i = 0; i < witnessesMethodsAllObjects.length; i++) {
			if (witnessesMethodsAllObjects[i].objid == strObjId) {
				var temp = witnessesMethodsAllObjects[i];
				witnessesMethodsAllObjects.splice(i, 1);
				witnessesMethodsAllObjects.unshift(temp);
				break;
			}
		}

		ELog2.witnessesAllData = witnessesMethodsAllObjects;

		for (i = 0; i < witnessesMethodsAllObjects.length; i++) {

			var witnessesObject = witnessesMethodsAllObjects[i];
			if (!witnessesObject)
				continue;

			//check state
			var state = mx.OM.checkDeviceState(witnessesObject.properties, false);
			var strImage = "";
			if (state == 2) {
				strImage = "images/design1/eLog2/eLog2_witness_status_ok.png";
			}
			else if (state == 1) {
				strImage = "images/design1/eLog2/eLog2_witness_status_notok.png";
			}

			var strActions = '<data jsxid="jsxroot">';
			// if device has no methods or EADA not allowed
			if (witnessesObject.methods.length == 0 || !isEADAAllowed) {
				for (var t = 0; t < witnessesObject.properties.length; t++) {
					if (witnessesObject.properties[t].name == "NAME") {
						var selfDeviceName = witnessesObject.properties[t].value;
						break;
					}
				}
				selfDeviceName = selfDeviceName.replace(/"/g, '&quot;');
				selfDeviceName = selfDeviceName.replace(/&/g, '&amp;');
				cdfWitnesses += '<record jsxid="' + jsx3.xml.CDF.getKey() + '" jsxtext="' + unescape(selfDeviceName) + '" jsxdisabled="1" objid="' + witnessesObject.objid + '" jsximage="' + strImage + '"/>';
			}
			else { // if device has methods
				for (var k = 0; k < witnessesObject.methods.length; k++) { // methods
					if (k == 0) { // if first time
						var deviceName = "Device";
						for (t = 0; t < witnessesObject.properties.length; t++) {
							if (witnessesObject.properties[t].name == "NAME") {
								deviceName = witnessesObject.properties[t].value;
								break;
							}
						}
					}
					strActions += '<record jsxid="' + jsx3.xml.CDF.getKey() + '" jsxtext="' + unescape(witnessesObject.methods[k].displayname) + '" jsxexecute="mx.ELog2.callEADA(' + witnessesObject.objid + ',\'' + witnessesObject.methods[k].name + '\',\'' + strEventId + '\');"/>';
				}
				deviceName = deviceName.replace(/"/g, '&quot;');
				deviceName = deviceName.replace(/&/g, '&amp;');
				cdfWitnesses += '<record jsxid="' + jsx3.xml.CDF.getKey() + '" jsxtext="' + unescape(deviceName) + '" objid="' + witnessesObject.objid + '" jsximage="' + strImage + '"/>';
			}
			strActions += '</data>';
			var actionsDoc = new jsx3.xml.CDF.Document.newDocument();
			actionsDoc.loadXML(strActions);
			mx.MATRIX2.getServer().Cache.setDocument('witness_actions_' + witnessesObject.objid, actionsDoc);
		}

		return '<data jsxid="jsxroot">' + cdfWitnesses + '</data>';
		//appLogger.info("checkWitnesses: OK");
	};

	/*
		depricated
	*/
	ELog2.showWitnessMethods = function (objButton, objEVENT) {
		mx.ELog2.showObjMenu(objButton.emGetSession().matrix, objButton.emGetSession().recordId, objEVENT);
	};

	ELog2.callEADA = function (objId, callName, eventId) {
		if(window.jsDebug){ appLogger.info("ELog2.callEADA: objId="+objId+", callName="+callName+", eventId="+eventId); }
		// if elog2 opened or elog2 closed and vMX APC dialog opened
		var eventNode = document.getElementById("event_" + eventId) || mx.vMX.CURRENT_EVENT;

		//check credentials
		if (!resourceTree.cred(eventNode.getAttribute('OBJID'), 'e')) {
			alert(__("You dont have credentials for ACTION!"));
			return;
		}

		var	name = 'eada';
		var parameters = {
			eventid: parseInt(eventNode.getAttribute("EVENTID")),
			priority: parseInt(eventNode.getAttribute("PRIORITY")),
			lifespan: parseInt(eventNode.getAttribute("LIFESPAN"))
		};
		var properties = {};
		var actions = [{
			name: callName,
			domain: "skm.om",
			parameters: {
				objid: parseInt(objId)
			}
		}];

		ELog2.eLogNoter.submitAction(name, parameters, properties, actions)
			.fail(function(code, message){
				var error = ELog2.checkEADAError(message);
				alert("callEADA: " + error);
			})
			.done(function(){
				mx.MATRIX2.getServer().getJSXByName("vMXWitnessActions").setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
				if (jsx3.GO("eventInfoDialog")) {
					mx.vMX.getEventInfo(jsx3.GO("eventInfoDialog").getAttribute("eventId"));
				}
			});
	};

	/**
	 *
	 * @param objId
	 * @param eventType
	 * @param message
	 * @param migration
	 * @param utc_from
	 * @param utc_to
	 * @param utc_when
	 * @param witnesses
	 * @returns {Deferred}
	 */
	ELog2.createNewEvent = function (objId, eventType, message, migration, utc_from, utc_to, utc_when, witnesses) {
		var deferred = $.Deferred();

		var name = 'create';
		var parameters = {};
		parameters.objid = objId;
		parameters.source = 4; //User
		if (eventType) {
			parameters.eventtype = eventType;
		}
		if (message) {
			parameters.msg = message;
		}
		if (utc_from) {
			parameters.from = Math.round(utc_from / 1000);
		}
		if (utc_to) {
			parameters.to = Math.round(utc_to / 1000);
		}
		if (utc_when) {
			parameters.when = Math.round(utc_when / 1000);
		}
		if (witnesses) {
			parameters.witnesses = witnesses;
		}

		var properties = {};
		if (!migration) {
			migration = 0;
		}
		properties.MIGRATE = migration;

		ELog2.eLogNoter.submitAction(name, parameters, properties)
			.fail(function(code, message){
				var error = ELog2.checkEADAError(message);
				alert("createNewEvent: " + error);
				deferred.reject();
			})
			.done(function(response){
				deferred.resolve();
			});

		return deferred.promise();
	};

	/**
	 *
	 * @param {string} strJSON
	 * @returns {boolean}
	 */
	ELog2.checkEADAError = function(strJSON) {
		//appLogger.info("checkEADAError: strJSON="+strJSON);
		var responseObj = $.parseJSON(strJSON);

		var error = false;
		for (var i = 0; i < responseObj.response.length; i++) {
			//appLogger.info("callEADA: responseObj["+i+"].response.name="+responseObj.response[i].name);
			if (responseObj.response[i].name == "STATUS" && responseObj.response[i].value == "ERROR") {
				error = true;
			}
			if (error && responseObj.response[i].name == "MSG") {
				error = responseObj.response[i].value;
			}
		}
		return error;
	};

	//set priority picture to event record
	ELog2.checkEventPriority = function(strPriority) {
		var priority = ELog2.dictPriority[strPriority];

		return '<span style="background-color: ' + priority.colorcode + ';">' + priority.name.slice(0,1) + '</span>';
	};

	//create filters
	ELog2.createDefaultFilters = function () {
		//appLogger.info("createFilters: START");

		ELog2.state = 'all';
		ELog2.device = 'full';
		ELog2.includeWitnesses = false;
		ELog2.message = '';
		ELog2.pageSize = ELog2.maxSize;

		ELog2.applyFilters();

		//create GUI filters
		var eLog2 = jsx3.GO("eLog2Root");
		var selectLifespan = eLog2.getDescendantOfName('storagePriority');
		var selectPriority = eLog2.getDescendantOfName('eventPriority');

		var strLifespans =
			'<data jsxid="jsxroot">' +
				'<record jsxid="1" jsxtext="' + __("Short", "Lifespan selector") + '"/>' +
				'<record jsxid="2" jsxtext="' + __("Moderate", "Lifespan selector") + '"/>' +
				'<record jsxid="3" jsxtext="' + __("Intermediate", "Lifespan selector") + '"/>' +
				'<record jsxid="4" jsxtext="' + __("Long", "Lifespan selector") + '"/>' +
				'<record jsxid="5" jsxtext="' + __("Extended", "Lifespan selector") + '"/>' +
				'<record jsxid="6" jsxtext="' + __("Automatic", "Lifespan selector") + '"/>' +
				'</data>';

		var strPriority =
			'<data jsxid="jsxroot">' +
				'<record jsxid="1" jsxtext="' + __("Low", "Event priority") + '" />' +
				'<record jsxid="2" jsxtext="' + __("Normal", "Event priority") + '" />' +
				'<record jsxid="3" jsxtext="' + __("High", "Event priority") + '" />' +
				'<record jsxid="4" jsxtext="' + __("Critical", "Event priority") + '" />' +
			'</data>';

		var lifespansDoc = jsx3.xml.CDF.Document.newDocument();
		lifespansDoc.loadXML(strLifespans);

		var priorityDoc = jsx3.xml.CDF.Document.newDocument();
		priorityDoc.loadXML(strPriority);

		mx.MATRIX2.getServer().Cache.setDocument('Elog2_LifespansDocument', lifespansDoc);
		mx.MATRIX2.getServer().Cache.setDocument('Elog2_PriorityDocument', priorityDoc);

		selectLifespan.setEvent("mx.ELog2.enableSaveOperation(this);", jsx3.gui.Interactive.SELECT);
		selectPriority.setEvent("mx.ELog2.enableSaveOperation(this); mx.ELog2.updateLifespanByPriority();", jsx3.gui.Interactive.SELECT);

		selectLifespan.setXMLId('Elog2_LifespansDocument').setValue(1);
		selectLifespan.repaint()
		selectPriority.setXMLId('Elog2_PriorityDocument').setValue(1);
		selectPriority.repaint()

		//appLogger.info("createDefaultFilters: OK");
	};

	ELog2.toggleFilters = function(isShow) {

		if (isShow == undefined) {
			// Check if filter dialog is visible
			isShow = $('#elog_filters').length == 0;
		}

		if (!isShow) {
			$('#elog_filters').remove();
			return;
		}

		// Create priority filter
		var strPriority = '';
		$.each(ELog2.dictPriority, function(i, v) {
			strPriority += '<option value="' + v.eventpriority + '">' + v.name + '</option>'
		});
		strPriority = '<select id="elog_priority">' + strPriority + '</select>';

		mx.Dialog.createDialog(
			'elog_filters',
			__("Filters"),
			{},
			'<form onsubmit="return false;">' +
			'<div class="line">' +
				__("State:") +
				' <select id="elog_state">' +
					'<option value="all">'              + __("ALL INFO & ALERTS", "Filter state") + '</option>' +
					'<option value="not_cleared">'      + __("ALERTS: Not Cleared", "Filter state") + '</option>' +
					'<option value="not_acknowledged">' + __("ALERTS: Not Acknowledged", "Filter state") + '</option>' +
					'<option value="cleared">'          + __("ALERTS: Cleared", "Filter state") + '</option>' +
				'</select>' +
			'</div><div class="line">' +
				__("Device:") +
				' <select id="elog_device">' +
					'<option value="full">'     + __("Full", "Filter device") + '</option>' +
					'<option value="filtered">' + __("Filtered", "Filter device") + '</option>' +
					'<option value="selected">' + __("Selected", "Filter device") + '</option>' +
				'</select> ' +
			'</div><div class="line">' +
				__("Priority:") + ' ' + strPriority +
			'</div><div class="line">' +
				__("Search:") + ' <input type="text" id="elog_message">' +
			'</div>' +
			'</form>',
			jsx3.GO('eLog2Root').getId()
		);

		// Set current values of filters and onchange handlers
		$('#elog_state').val(mx.ELog2.state).change(function() {
			ELog2.setFilterValue('state', this.value);
		});
		$('#elog_device').val(mx.ELog2.device).change(function() {
			ELog2.setFilterValue('device', this.value);
		});
		$('#elog_priority').val(mx.ELog2.priority).change(function() {
			ELog2.setFilterValue('priority', this.value);
		});
		$('#elog_message').val(mx.ELog2.message).change(function() {
			ELog2.setFilterValue('message', this.value);
		});
        // Webkit browsers fix - cannot gain focus on input due to strange Tibco behaviour
        $('#elog_message').click(function(ev) {ev.stopPropagation();});

		/*
		$('#elog_witnesses').prop('checked', !!ELog2.includeWitnesses).click(function() {
			mx.ELog2.includeWitnesses = !!this.checked;
			mx.ELog2.applyFilters();
		});
		*/
	};

	ELog2.setFilterValue = function(key, value) {
		ELog2[key] = value;
		if (ELog2.mode == 'archive') {
			// If elog in archive mode, we must recalculate archive interval first
			ELog2.setArchiveInterval(ELog2.startTs, true);
		} else {
			ELog2.applyFilters();
		}
	};

	ELog2.setAppletFilters = function() {
		try {
			if (window.jsDebug) {
				appLogger.info("ELog2.setAppletFilters:<br>tag=" + ELog2.tag + "<br>tagOnFlag=" + ELog2.tagOnFlag + "<br>eventType=" + ELog2.eventType + "<br>priority=0" + "<br>objids=" + ELog2.objids + "<br>message=" + ELog2.message + "<br>startTs=" + ELog2.startTs + "<br>endTs=" + ELog2.endTs + "<br>pageNum=" + ELog2.pageNum + "<br>pageSize=" + ELog2.pageSize);
			}
			ELog2.eLogNoter.setEventFilter(ELog2.tag, ELog2.tagOnFlag, ELog2.eventType, ELog2.priority, ELog2.objids, ELog2.message, ELog2.startTs, ELog2.endTs, ELog2.pageNum, ELog2.pageSize);
		}
		catch (e) {
			window.setTimeout(function() {
				ELog2.setAppletFilters();
			}, 100);
		}
	};

	ELog2.calculateFilters = function() {
		// Device filter
		ELog2.objids = ELog2.getObjList();

		// State filter
		switch (ELog2.state) {
			case 'all':
				ELog2.eventType = 777;
				ELog2.tag = 0;
				ELog2.tagOnFlag = false;
			break;
			case 'not_cleared':
				ELog2.eventType = 1;
				ELog2.tag = 8;
				ELog2.tagOnFlag = false;
			break;
			case 'not_acknowledged':
				ELog2.eventType = 1;
				ELog2.tag = 4;
				ELog2.tagOnFlag = false;
			break;
			case 'cleared':
				ELog2.eventType = 1;
				ELog2.tag = 8;
				ELog2.tagOnFlag = true;
		}
	};

	/**
	 *  Refresh eventlog
	 */
	ELog2.refreshEvents = function () {
		if(ELog2.mode == "announces"){
			ELog2.setMode();
		}
		else{
			ELog2.applyFilters();
		}
	};

	//filter events
	ELog2.applyFilters = function () {
		//appLogger.info("applyFilters: START");

		ELog2.setELogVisualState(1);

		ELog2.calculateFilters();

		var newDoc = jsx3.xml.CDF.Document.newDocument();
		mx.MATRIX2.getServer().getCache().setDocument("CACHE_EVENTSLIST", newDoc);

		ELog2.setAppletFilters();
		mx.ELog2.updateFiltersButton();

		if (window['notif_var']) {
			clearTimeout(window['notif_var']);
		}
		window['notif_var'] = window.setTimeout(function() {
			ELog2.checkNotifications(true);
		}, ELog2.notificationsPeriod);
		//appLogger.info("applyFilters: ELOG2_FILTER="+ELOG2_FILTER);
	};

    /**
     * Update filters icon to represent current state of filter
     *
     * Filter considered empty when:
     * State: ALL INFO & ALERTS
     * Device: FULL
     * Priority: Low
     * Search: <empty>
     *
     * Other states of filter are considered active
     */
	ELog2.updateFiltersButton = function() {
		var button = jsx3.GO('showELogFilters');

		// if filter is not empty
		if (ELog2.state != 'all' || ELog2.device != 'full' || ELog2.priority != 1 || ELog2.message) {
			button.setImage('images/design1/eLog2/filter_active.png');
			button.setTip(__("Show filters (filters are active)"));
		} else {
			button.setImage('images/design1/eLog2/filter.png');
			button.setTip(__("Show filters (filters are empty)"));
		}
		button.repaint();
	};

	/**
	 * Get object list depending on current ELog2.device filter and ELog2.includeWitnesses
	 */
	ELog2.getObjList = function(){
		if(window.jsDebug){ appLogger.info("ELog2.getObjList: device filter: " + ELog2.device); }

		var objIdList = [];
		var i;

		switch (ELog2.device) {
			case 'full':
				objIdList = resourceTree.getObjects({'cred': 'v'});
			break;
			case 'filtered':
				objIdList = resourceTree.getObjects({'add_into_filter': 1, 'cred': 'v'});
			break;
			case 'selected':
				var group = null;
				if(activeGroup_Cell!=null && activeGroup_Cell.getGroupSize()){
					group = activeGroup_Cell;
				}
				else if(syncGroup!=null && syncGroup.getGroupSize()){
					group = syncGroup;
				}

				if(group!=null) {
					for(i=0; i<group.getGroupSize(); i++) {
						if(group.getPlayer(i).getParameter('DEVICE_TYPE') == "A")
							continue;

						var tmpId = mx.MATRIX2.getServer().getJSXById(group.getPlayer(i).id).getAttribute("objectId");
						if (resourceTree.cred(tmpId, 'v')) {
							objIdList.push(tmpId);
						}
					}
				}
			break;
		}

		//include witnesses
		if (ELog2.includeWitnesses) {
			$.each(objIdList, function(ind, v) {

				var obj = resourceTree.getObject(v);
				if (!obj.attr("ASSOCIATE"))
					return;
				$.merge(objIdList, obj.attr("ASSOCIATE").split(", "));

			});
		}
		arrayUnique(objIdList);

		if(window.jsDebug){ appLogger.info("ELog2.getObjList: objIdList OK, list =" + objIdList.join(' ')); }

		if (!objIdList || objIdList.length == 0) {
			return "-1";
		} else {
			return objIdList.join(' ');
		}
	};

	ELog2.elM2DEventAckn = function(elFlObjectID) {
		var elFc = false;
		var activeTab = mx.CT.getActiveTab();
		var objDesc = activeTab.getDescendantsOfType("jsx3.gui.Block", false);
		for (var k = 0; k < objDesc.length; k++) {
			var objPlayer = mx.MATRIX2.getServer().getJSXById(objDesc[k].getId());
			if (objPlayer.getAttribute("objectId") == elFlObjectID.toString()) {
				var objCellAlert = objPlayer.getDescendantOfName('cell_alert');
				objCellAlert.setBackground("background-image:none");
				objCellAlert.setAttribute("elAcknowledged", "yes");
				objCellAlert.repaint();
				elFc = true;
			}
		}

		if (!elFc) {
			//-- Getting Camera Name
			var isEmptyCell = false;

			var tmpName = resourceTree.getObject(elFlObjectID).name;
			for (k = 0; k < objDesc.length; k++) {
				var objPlayer = mx.MATRIX2.getServer().getJSXById(objDesc[k].getId());
				if (objPlayer.getAttribute("playerBlock") == "0" && !objPlayer.getAttribute("eLog2Block")) {
					mx.MATRIX2.createCell(elFlObjectID, tmpName, objPlayer, false);
					isEmptyCell = true;
					break;
				}
			}
			if (!isEmptyCell) {
				//alert(__("No empty cells in the Matrix layout!\nPlease add cell and repeat operation."));
			}
		}
	};

	// functional migration from previous ELog
	ELog2.checkPopupNotification = function(objRecord, isMultiple) {
		//if(window.jsDebug){ appLogger.info("ELog2.checkPopupNotification: objRecord="+objRecord+", isMultiple="+isMultiple); }
		// var t1 = (new Date).getTime();
		var objIDs = [];
		var overrides = [];

		// if multiple notifications
		if (isMultiple) {
			objIDs = objRecord;
		}
		else { //if one notification
			objIds[0] = {
				objId: objRecord.getAttribute('OBJID'),
				eventid: parseInt(objRecord.getAttribute('EVENTID')),
				message: objRecord.getAttribute('MESSAGE'),
				eventtype: objRecord.getAttribute('EVENTTYPE')
			};
		}

		//check alerts and popups
		for (var i = 0; i<objIDs.length; i++) {
			var objId = objIDs[i].objId;

			if (!objId)
				continue;

			var elDevMainNode = resourceTree.getObject(objId);
			var elDevPopupSettings = false;
			var elDevPopupOverrideSettings = false;
			var elDevHeaderAlert;
			var alertAudio = false;

            //if(window.jsDebug){ appLogger.info("ELog2.checkPopupNotification: elDevMainNode.type="+elDevMainNode.type+", objId="+objId); }
			// we need to find camera in associated devices or witnesses
			if (elDevMainNode && elDevMainNode.settings) {
				elDevPopupSettings = elDevMainNode.settings.popup_video;
				elDevPopupOverrideSettings = elDevMainNode.settings.popup_override;
				if(elDevMainNode.type != "camera" && elDevMainNode.attr("ASSOCIATE") != null){
					elDevHeaderAlert = elDevMainNode.settings.alert_header;
					// search for cameras in associated devices
					elDevMainNode =
					resourceTree.getObject({
						'obj': elDevMainNode.attr("ASSOCIATE").split(","),
						'type': 'camera'
					})
						|| // or in witnesses
					resourceTree.getObject({
						'obj': objIDs[i].witnesses.split(" "),
						'type': 'camera'
					});

					//if(window.jsDebug){ appLogger.info("ELog2.checkPopupNotification: ACS elDevMainNode="+elDevMainNode+", objId="+objId); }

					if (elDevMainNode) {
						elDevPopupSettings = resourceTree.getObject(objId).settings.popup_video;
						elDevPopupOverrideSettings = resourceTree.getObject(objId).settings.popup_override;
						objId = elDevMainNode.obj;
					}
				}
				else{
					elDevHeaderAlert = elDevMainNode.settings.alert_header;
				}
			}

			//if(window.jsDebug){ appLogger.info("ELog2.checkPopupNotification: elDevMainNode="+elDevMainNode); }

			if (!elDevMainNode || elDevMainNode.type != "camera")
				continue;

            //if(window.jsDebug){ appLogger.info("ELog2.checkPopupNotification: objId="+objId); }
			// List of blocks in current tab
			var objDesc = mx.CT.getActiveTab().getDescendantsOfType("jsx3.gui.Block", false);
			var objPlayer;
			//try to find needed video cell in current tab
			objIDs[i].isalerted = false;
			for (var k = 0; k < objDesc.length; k++) {
				objPlayer = mx.MATRIX2.getServer().getJSXById(objDesc[k].getId());
				//appLogger.info("checkPopupNotification: check update: objPlayer="+objPlayer+", "+objPlayer.getAttribute("objectId")+" == "+objId);
				if (objPlayer.getAttribute("objectId") == objId) {
					//elFc = true;
					objIDs[i].isalerted = true;

					//appLogger.info("checkPopupNotification: update exists: objId="+objId);
					// Alert on cell header
					if (elDevHeaderAlert) {
						mx.MATRIX2.setAlert(objPlayer.getDescendantOfName('cell_alert'));
					}
					objPlayer.setAttribute("cell_age_utc", (new Date()).getTime().toString());
					break;
				}
			}


			if (!objIDs[i].isalerted) {
				//appLogger.info("checkPopupNotification: cell not exists with objId="+objId);
				// popup_video
				if (elDevPopupSettings) {
					var puVideo = false;
					var puVideoFc = false;
					for (k = 0; k < objDesc.length; k++) {
						objPlayer = mx.MATRIX2.getServer().getJSXById(objDesc[k].getId());

						// Finding the oldest cell - for popup override if needed.
						if (objPlayer.getAttribute("cell_age_utc")) {
							if (!puVideoFc) {
								var puVideoPlayer = objPlayer;
								var puVideoAge = objPlayer.getAttribute("cell_age_utc");
								puVideoFc = true;
							} else {
								if (puVideoAge > objPlayer.getAttribute("cell_age_utc")) {
									puVideoPlayer = objPlayer;
									puVideoAge = objPlayer.getAttribute("cell_age_utc");
								}
							}
						}

						//popup
						if (objPlayer.getAttribute("playerBlock") == "0" && mx.CT.getActiveTab().getAttribute("wallid") == null && !objPlayer.getAttribute("eLog2Block")) {
							// Alert on cell header
							mx.MATRIX2.createCell(objId, elDevMainNode.name, objPlayer, elDevHeaderAlert);
							puVideo = true;
							break;
						}
					}

					// popup_overrides_populated
					if (!puVideo && elDevPopupOverrideSettings && puVideoPlayer !== undefined && !puVideoPlayer.getParent().getAttribute("eLog2Block")) {
						//create override objects
						puVideoPlayer.setAttribute("cell_age_utc", (new Date()).getTime().toString());
						overrides.push({
							'id': puVideoPlayer.getParent().getId(),
							'objId': objId,
							'text': elDevMainNode.name,
							'alrt': elDevHeaderAlert
						});
					}
				}
			}

			// sound
			if (elDevMainNode.settings.alert_audio) {
				alertAudio = true;
			}

			// m2d
			if (elDevMainNode.settings.alert_2d && mx.MATRIX2.getServer().getJSXByName('m2d_iframe') != null) {
				mx.MATRIX2.getIFrame(mx.MATRIX2.getServer().getJSXByName('m2d_iframe')).js_to_flash(objId * 1);
			}

			// VE(3D)
			if (elDevMainNode.settings.alert_3d && mx.MATRIX2.getServer().getJSXByName('ge_block') != null) {
				mx.GE.setNewEvent(objId, objIDs[i].eventid);
			}
		}

		//clear cells for override
		for (i = 0; i < overrides.length; i++) {
			mx.MATRIX2.clearDestinationBlock(mx.MATRIX2.getServer().getJSXById(overrides[i].id));
			mx.MATRIX2.createCell(overrides[i].objId, overrides[i].text, mx.MATRIX2.getServer().getJSXById(overrides[i].id), overrides[i].alrt);
		}

		if(alertAudio){
			mx.MATRIX2.playHTMLSound("notify");
		}
		// var t2 = (new Date).getTime();
		//appLogger.info("checkPopupNotification: OK - "+(t2-t1)+"mls");
	};

	//check event due to current filters
	ELog2.isNewEventAllowed = function (objEvent) {
		//appLogger.info("isNewEventAllowed : START");

		//if device not in filter
		if (ELog2.objids.indexOf(objEvent.objId) == -1) {
			var objidNode = resourceTree.getObject(objEvent.objId) || resourceTree.getObject({'obj': objEvent.witnesses});
			if (!objidNode)
				return false;
		}

		if (ELog2.state != 'all' && objEvent.eventtype == 0) { //if alerts mode but new event has informational type
			return false;
			//appLogger.info("isNewEventAllowed : "+objEvent.id+" denied due to state filter 1 - tags: "+objEvent.tags.toString());
		}
		if (ELog2.state == 'not_cleared' && objEvent.tags.indexOf(8) != -1) { //if event cleared
			return false;
		}
			//appLogger.info("isNewEventAllowed : "+objEvent.id+" denied due to state filter 2 - tags: "+objEvent.tags.toString());
		if (ELog2.state == 'not_acknowledged' && (objEvent.tags.indexOf(4) != -1 || objEvent.tags.indexOf(8) != -1)) { //if event acknowledged
			return false;
			//appLogger.info("isNewEventAllowed : "+objEvent.id+" denied due to state filter 3 - tags: "+objEvent.tags.toString());
		}
		if (ELog2.state == 'cleared' && objEvent.tags.indexOf(8) == -1) { //if event not cleared
			return false;
			//appLogger.info("isNewEventAllowed : "+objEvent.id+" denied due to state filter 4 - tags: "+objEvent.tags.toString());
		}

		return true;
	};

	/**
	 * handles when an event reported from the client eLog applet
	 * @param {boolean} callWS
	 */
	ELog2.checkNotifications = function (callWS) {
		//if(window.jsDebug){ appLogger.info("ELog2.checkNotifications: callWS="+callWS); }

		if(ELog2.mode == "announces"){
			return;
		}

		ELog2.callFinished = false;

		if(!mx || !mx.MATRIX2 || !mx.MATRIX2.getServer){
            if(window.jsDebug){ appLogger.info("ELog2.checkNotifications: mx.MATRIX2 not found"); }
			ELog2.setELogVisualState(2);
			window['notif_var'] = window.setTimeout(function() {
				ELog2.checkNotifications(callWS);
			}, ELog2.notificationsPeriod);
		    ELog2.callFinished = true;
		    ELog2.monitorTime = (new Date()).getTime();
			return;
		}

		try {
			var strResponse = ELog2.eLogNoter.getEvents(callWS);
			var objResponse = $.parseJSON(strResponse);
		} catch (e) {
			if(window.jsDebug){ appLogger.info("ELog2.checkNotifications: problem with ELogNoter answer, wait for next query: "+e.description); }
		}

		//if(window.jsDebug){ appLogger.info("ELog2.checkNotifications: ELog2.eLogNoter.getEvents(" + callWS + ") response: " + strResponse); }
		//if(window.jsDebug){ appLogger.info("ELog2.checkNotifications: strResponse = " + strResponse); }

		var eventsResponse = mx.MATRIX2.getServer().getCache().getDocument("CACHE_EVENTSLIST");
		var m3dBlock = mx.MATRIX2.getServer().getJSXByName('players_pane').getDescendantOfName('ge_cell');
		var newEvent = null;
		var notifIds = [];
		//if status normal
		if (objResponse && objResponse.Status != null && objResponse.Status != 3) {
			if (objResponse.Events.length > 0) {
				if (window.jsDebug) {
					appLogger.info("ELog2.checkNotifications: Events:" + objResponse.Events.length + ", JSON string: \n" + strResponse);
				}
			}
			if (callWS) {
				ELog2.setELogVisualState(0);
				ELog2.clearELog();
				if (ELog2.objids == -1) {
					$('#eLog2_container').html('<tr><td colspan="8" style="text-align: center">' + __("No devices matching current device filter") + '</td></tr>');
				}
			}

			for (var i = 0; i < objResponse.Events.length; i++) {
				newEvent = objResponse.Events[i];

				// if event allowed by current filters
				var eventExists = document.getElementById("event_" + newEvent.id);
				if (ELog2.isNewEventAllowed(newEvent) && (newEvent.cachestate != 'S' || objResponse.CompleteSet)) {

					//if allowed by mode filter
					if (eventExists || (callWS && ELog2.mode != 'announces') || (ELog2.mode == 'live' && parseInt(newEvent.id) > parseInt(ELog2.lastEventId))) {
						if(window.jsDebug){ appLogger.info("ELog2.checkNotifications: allowed event data:" + ELog2.mode + "," + eventExists + "," + callWS + "," + newEvent.id + "," + ELog2.lastEventId); }

						var newRecord = ELog2.event2CDFRecord(newEvent, eventsResponse.createNode(jsx3.xml.Entity.TYPEELEMENT, "record"));
						if (!newRecord) {
							continue;
						}

						var notif_objid = newRecord.getAttribute("NOTIFICATION_OBJID");
						// if notification has tag 10(pop-up)
						if (newRecord.getAttribute('TAG').search(/10/) != -1 && !callWS && notif_objid != null) {
							//append object for notifications
							notifIds.push({
								objId: notif_objid,
								eventid: newEvent.id,
								message: newEvent.msg,
								eventtype: newEvent.eventtype,
								witnesses: newRecord.getAttribute("WITNESSES")
							});
						}

						//check map3D acknowledge notification
						if (m3dBlock && newRecord.getAttribute('TAG').search(/4/) != -1) {
							mx.GE.acknowledgeEvent(newEvent.objId, newEvent.id);
						}

						var size = document.getElementById("eLog2_container").childNodes.length;

						if (eventExists) {
							ELog2.updateDOMEvent(newRecord);
						}
						else if (size < ELog2.maxSize) {
							ELog2.addDOMEvent(newRecord);
						}
						else if (size >= ELog2.maxSize) {
							ELog2.removeDOMEvent();
							ELog2.addDOMEvent(newRecord);
							//check if acknowledged, show missed notification
						}

						if(ELog2.lastEventId < newEvent.id || callWS){
							ELog2.lastEventId = newEvent.id;
						}
					}
					else if ((ELog2.mode == 'archive' && !eventExists)) { //allow popups in archive mode for not existent events
						// if notification has tag 10(pop-up)
						if (newEvent.tags.toString().search(/10/) != -1) {
							//append object for notifications
							notifIds.push({
								objId: newEvent.objId,
								eventid: newEvent.id,
								message: newEvent.msg,
								eventtype: newEvent.eventtype
							});
						}
					}
				}
				else { //if not allowed by current filter
					if (eventExists) {
						ELog2.removeDOMEvent(eventExists);
						var eLog2 = jsx3.GO("eLog2Root");
						var dialog = eLog2.getDescendantOfName('eLog2dialog');
						if (dialog.getAttribute("eventId") && dialog.getAttribute("eventId") == newEvent.id) {
							dialog.setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
						}
					}
				}
			}

            //if(window.jsDebug){ appLogger.info("ELog2.checkNotifications: notifIds.length="+notifIds.length); }
			if (notifIds.length && mx.MATRIX2.loaded) {
				window.setTimeout(function() {
					ELog2.checkPopupNotification(notifIds, true);
				}, 10);
			}

			if (window['notif_var']) {
				clearTimeout(window['notif_var']);
			}
			window['notif_var'] = window.setTimeout(function() {
				ELog2.checkNotifications(false);
			}, ELog2.notificationsPeriod);
		} else { //if status abnormal
            //if(window.jsDebug){ appLogger.info("ELog2.checkNotifications: abnormal status = "+objResponse.Status); }
			window['notif_var'] = window.setTimeout(function() {
				ELog2.checkNotifications(true);
			}, ELog2.notificationsPeriod);
		}

        //visualize eventlog status
        if(objResponse && objResponse.Status != null && objResponse.Status == 2){
            ELog2.setELogVisualState(0);
        }
        else{
            ELog2.setELogVisualState(2);
        }

		if(m3dBlock){
			ELog2.setTargetTrails();
		}
		ELog2.callFinished = true;
		ELog2.monitorTime = (new Date()).getTime();
		//appLogger.info("checkNotifications: OK, objids="+ELog2.objids);
	};

	/**
	 *  Transform event object to CDF-record
	 */
	ELog2.event2CDFRecord = function(objEvent, newRecord) {
		newRecord.setAttribute("jsxid", jsx3.CDF.getKey());
		newRecord.setAttribute("EVENTID", objEvent.id);
		newRecord.setAttribute("OBJID", objEvent.objId);
		newRecord.setAttribute("SRC", objEvent.sourceId);
		newRecord.setAttribute("PRIORITY", objEvent.priority);
		newRecord.setAttribute("LIFESPAN", objEvent.lifespan);
		newRecord.setAttribute("MESSAGE", objEvent.msg);

		newRecord.NOTE = (objEvent.note ? objEvent.note : "[]");

		newRecord.setAttribute("EVENTTYPE", objEvent.eventtype);
		newRecord.setAttribute("TAG", objEvent.tags);
		newRecord.setAttribute("BGCOLOR", objEvent.bgcolor);

		//check properties
		newRecord.setAttribute("MIGRATE", "null");
		for (var j = 0; j < objEvent.properties.length; j++) {
			if (objEvent.properties[j].name == "MIGRATE") {
				newRecord.setAttribute("MIGRATE", objEvent.properties[j].value);
			}

			if (objEvent.properties[j].name == "gisref") {
				newRecord.setAttribute("GISREF", objEvent.properties[j].value);
			}

			if (objEvent.properties[j].name == "CLOUD_LOCATION") {
				newRecord.setAttribute("CLOUD_LOCATION", objEvent.properties[j].value);
			}
		}

		newRecord.setAttribute("UTCTIME_WHEN", objEvent.utc.when);
		newRecord.setAttribute("UTCTIME_FROM", objEvent.utc.from);
		newRecord.setAttribute("UTCTIME_TO", objEvent.utc.to);
		newRecord.setAttribute("UTCTIME_UPDATED", objEvent.utc.updated);
		newRecord.setAttribute("OBJ_OBJID", objEvent.obj.objid);
		newRecord.setAttribute("OBJ_NAME", objEvent.obj.name);
		newRecord.setAttribute("OBJ_OTYPE", objEvent.obj.type);
		newRecord.setAttribute("OBJ_SUBTYPE", objEvent.obj.subtype);
		newRecord.setAttribute("OBJ_TIMEZONE", objEvent.obj.TimeZone);
		newRecord.setAttribute("STATE", objEvent.state);

		newRecord.setAttribute("ANNOUNCEDBY", objEvent.announcedby);

		//check witnesses
		var witnesses = "";
		if (objEvent.witnesses && objEvent.witnesses.length > 0) {
			for (j = 0; j < objEvent.witnesses.length; j++) {
				witnesses += objEvent.witnesses[j].objid;
				if ((objEvent.witnesses.length - 1) != j) {
					witnesses += " ";
				}
			}
		}
		newRecord.setAttribute("WITNESSES", witnesses);

		//add additional attributes
		newRecord.setAttribute("SRC_DESC", ELog2.dictSources[objEvent.sourceId].label);

		var devNode = resourceTree.getObject(objEvent.objId);

		//check suitable devices in witnesses
		if(!devNode){
			devNode = ELog2.witnessIntoMainDev(witnesses.split(" "));
			if(!devNode){
				return false;
			}
		}
		var udidstr = '';
		if (typeof(devNode.udid) == 'undefined' || devNode.udid == '' || !devNode.udid){
			udidstr = '#' + objEvent.objId;
		}else{
			udidstr = '[' + devNode.udid + ']';
		}

		newRecord.setAttribute("OBJ_OBJID_DESC", udidstr + " " + objEvent.obj.name);

		newRecord.setAttribute("NOTIFICATION_OBJID", devNode.obj);

		newRecord.setAttribute("selection", "");

		ELog2.loadUTCLOCALTimes(newRecord);

		ELog2.checkTags(newRecord, false);

		return newRecord;
	};

	//allow save
	ELog2.enableSaveOperation = function(objChangedElement) {
		var eLog2 = jsx3.GO("eLog2Root");
		var dialog = eLog2.getDescendantOfName('eLog2dialog');
		dialog.getDescendantOfName('buttonSave').setEnabled(jsx3.gui.Form.STATEENABLED, true);
		dialog.getDescendantOfName('buttonCancel').setEnabled(jsx3.gui.Form.STATEENABLED, true);

		objChangedElement.setAttribute("ischangedbyuser", "true");
	};

	//deny save
	ELog2.disableSaveOperation = function() {
		var eLog2 = jsx3.GO("eLog2Root");
		var dialog = eLog2.getDescendantOfName('eLog2dialog');
		dialog.getDescendantOfName('buttonSave').setEnabled(jsx3.gui.Form.STATEDISABLED, true);
		dialog.getDescendantOfName('buttonCancel').setEnabled(jsx3.gui.Form.STATEDISABLED, true);
	};

	//show event in dialog
	ELog2.showRow = function(objRecordBlock) {
		//deny elog window for Guest user
		if (resourceTree.getRole().name.search(__("Guest Role")) != -1) {
			return false;
		}

		//appLogger.info("showRow: START objRecordBlock="+objRecordBlock);
		var dialog = mx.MATRIX2.getServer().getJSXByName('eLog2dialog');
        //if(window.jsDebug){ appLogger.info("ELog2.showRow2: devNode.obj="+devNode.obj); }
		dialog.setAttribute("eventId", objRecordBlock.getAttribute('EVENTID'));
		dialog.setAttribute("utc_from", objRecordBlock.getAttribute('UTC_FROM'));
		dialog.setAttribute("utctime_from", objRecordBlock.getAttribute('UTCTIME_FROM'));
		dialog.setAttribute("utctime_to", objRecordBlock.getAttribute('UTCTIME_TO'));
		dialog.setAttribute("utc_to", objRecordBlock.getAttribute('UTC_TO'));
		dialog.setAttribute("t_zone", objRecordBlock.getAttribute('OBJ_T_ZONE'));
		dialog.setAttribute("gisref", objRecordBlock.getAttribute('GISREF'));

		ELog2.disableSaveOperation();

		var captionText = __("Event ID: ") + objRecordBlock.getAttribute("EVENTID") + " / Device: " + objRecordBlock.getAttribute("OBJ_OBJID_DESC");
		dialog.getDescendantOfName('blockCaption').setText(captionText, true);

		//set current selection
		$('#eLog2_container tr').each(function() { this.firstChild.innerHTML = ''; });
		objRecordBlock.firstChild.innerHTML = ">";

		//check witnesses
		var EADA = false;
		if (objRecordBlock.getAttribute("TAG").search(/6/) != -1) {
			EADA = true;
		}
		var strWitnesses = ELog2.checkWitnesses(objRecordBlock.getAttribute("WITNESSES"), objRecordBlock.getAttribute("EVENTID"), objRecordBlock.getAttribute("OBJID"), EADA);

		/*
			Tab General
		*/

		dialog.getDescendantOfName('tabEG').setEvent("mx.ELog2.onEventDialogTabChange(this)", jsx3.gui.Interactive.SHOW);
		dialog.getDescendantOfName('tabEG').doShow();
		//set screenshot
		var screenshot = dialog.getDescendantOfName('imageScreenshot');
		var screenshot_id = null;

		//find device node
		var devNode = resourceTree.getObject(objRecordBlock.getAttribute("OBJID"));
		//if(window.jsDebug){ appLogger.info("ELog2.showRow: devNode="+devNode+", objid="+objRecordBlock.getAttribute("OBJID")); }
		//check suitable devices in witnesses
		if(!devNode){
			devNode = ELog2.witnessIntoMainDev(objRecordBlock.getAttribute("WITNESSES").split(" "));
			if(!devNode){
				return;
			}
		}

		//if device is camera
		if (devNode.type == "camera") {
			screenshot_id = objRecordBlock.getAttribute("OBJID");
		}
		else {
			if(objRecordBlock.getAttribute("WITNESSES")){
				var witness = resourceTree.getObject({
					'obj': objRecordBlock.getAttribute("WITNESSES").split(" "),
					'type': 'camera'
				});
				if (witness) {
					screenshot_id = witness.obj;
				}
			}
		}

		if (screenshot_id != null) {
			//set picture for camera
			var mainScreenshotSrc = mx.MATRIX2.getServerURL() + "/storage/snapshot?objid=" + screenshot_id + "&ts=" + objRecordBlock.getAttribute('UTCTIME_WHEN') + "&downscale";
			if(objRecordBlock.getAttribute("SRC") == 6){
				mainScreenshotSrc+= "&vae_snapshot=alarm";
			}
			screenshot.setSrc(mainScreenshotSrc);
			dialog.getDescendantOfName('buttonOIT').setEnabled(jsx3.gui.Form.STATEENABLED, true);
		}
		else {
			//set pictures for non-camera devices
			var noncamera_src = '';
			if (devNode.type == "door") {
				noncamera_src = 'events_door.png';
			}
			else if (devNode.type == "sensor") {
				noncamera_src = 'events_sensor.png';
			}
			else if (devNode.type == "relay") {
				noncamera_src = 'events_relay.png';
			}
			screenshot.setSrc('jsxuser:///images/design1/eLog2/' + noncamera_src);
			dialog.getDescendantOfName('buttonOIT').setEnabled(jsx3.gui.Form.STATEDISABLED, true);
		}

		screenshot.setClassName("loadingIndication");

		screenshot.getParent().setText(__("Event ID: ") + objRecordBlock.getAttribute("EVENTID"), false);
		screenshot.getParent().repaint();

		dialog.setAttribute("objId", devNode.obj);

		dialog.getDescendantOfName('priorityReadOnly').setText("<b>" + __("Priority") + "</b>: " + ELog2.dictPriority[objRecordBlock.getAttribute('PRIORITY')].name, true);
		dialog.getDescendantOfName('time').setText("<b>" + __("Time") + "</b>: " + mx.TIME.timestamp2date(objRecordBlock.getAttribute("utctime_when") * 1000), true);
		dialog.getDescendantOfName('duration').setText("<b>" + __("Duration") + "</b>: " + mx.TIME.formatUTCDate(objRecordBlock.getAttribute("utctime_to") * 1000 - objRecordBlock.getAttribute("utctime_from") * 1000, "HH?:II:SS"), true);
		dialog.getDescendantOfName('textareaSystemMessage').setValue(objRecordBlock.getAttribute('MESSAGE'), true);

		var instructions = __("No instructions");
		var CDF_eventstate = mx.MATRIX2.getServer().Cache.getDocument("CDF_eventstate");
		if(CDF_eventstate){
			var stateNode = CDF_eventstate.selectSingleNode("//record/record[@name='eventstate' and @value='" + objRecordBlock.getAttribute('STATE') + "']");
			if(stateNode){
				var rec = stateNode.getParent().selectSingleNode("record[@name='userdirective']");
				if(rec){
					instructions = rec.getAttribute("value");
				}
			}
			else{
				ELog2.servicelookupEventState();
			}
		}
		else{
			ELog2.servicelookupEventState();
		}
		dialog.getDescendantOfName('textareaUserInstructions').setValue(instructions, true);

		dialog.getDescendantOfName('buttonOIT').setEvent("mx.ELog2.openWitnessesLayout('" + objRecordBlock.getAttribute("WITNESSES") + " " + objRecordBlock.getAttribute("OBJID") + "', " + objRecordBlock.getAttribute('EVENTID') + ", true);", jsx3.gui.Interactive.EXECUTE);

        //if(window.jsDebug){ appLogger.info("ELog2.ShowRow: objRecordBlock.getAttribute(needAcknowlegement)="+objRecordBlock.getAttribute("needAcknowlegement")); }
		if (objRecordBlock.getAttribute("needAcknowlegement") != null && objRecordBlock.getAttribute("needAcknowlegement") != "null" && objRecordBlock.getAttribute("needAcknowlegement") != "") {
			dialog.getDescendantOfName('buttonAckn').setEnabled(jsx3.gui.Form.STATEENABLED, true);
			dialog.getDescendantOfName('buttonAckn').setEvent("mx.ELog2.selectAction('Acknowledge'," + objRecordBlock.getAttribute('EVENTID') + ");", jsx3.gui.Interactive.EXECUTE);
		}
		else {
			dialog.getDescendantOfName('buttonAckn').setEnabled(jsx3.gui.Form.STATEDISABLED, true);
		}

        //if(window.jsDebug){ appLogger.info("ELog2.ShowRow: objRecordBlock.getAttribute(needClr)="+objRecordBlock.getAttribute("needClr")); }
		if (objRecordBlock.getAttribute("needClr") != null && objRecordBlock.getAttribute("needClr") != "null" && objRecordBlock.getAttribute("needClr") != "") {
			dialog.getDescendantOfName('buttonClr').setEnabled(jsx3.gui.Form.STATEENABLED, true);
			dialog.getDescendantOfName('buttonClr').setEvent("mx.ELog2.selectAction('Clear'," + objRecordBlock.getAttribute('EVENTID') + ");", jsx3.gui.Interactive.EXECUTE);
		}
		else {
			dialog.getDescendantOfName('buttonClr').setEnabled(jsx3.gui.Form.STATEDISABLED, true);
		}

        //if(window.jsDebug){ appLogger.info("ELog2.ShowRow: get object="+resourceTree.getObject(objRecordBlock.getAttribute("OBJID"))); }
		if(!resourceTree.getObject(objRecordBlock.getAttribute("OBJID"))){
			dialog.getDescendantOfName('buttonAckn').setEnabled(jsx3.gui.Form.STATEDISABLED, true);
			dialog.getDescendantOfName('buttonClr').setEnabled(jsx3.gui.Form.STATEDISABLED, true);

			dialog.getDescendantOfName('eventPriority').setEnabled(jsx3.gui.Form.STATEDISABLED, true);
			dialog.getDescendantOfName('textareaUserMessage').setEnabled(jsx3.gui.Form.STATEDISABLED, true);
			dialog.getDescendantOfName('storagePriority').setEnabled(jsx3.gui.Form.STATEDISABLED, true);
		}

		/*
			Tab Details
		*/
		dialog.getDescendantOfName('tabED').setEvent("mx.ELog2.onEventDialogTabChange(this)", jsx3.gui.Interactive.SHOW);
		dialog.getDescendantOfName('eventPriority').setValue(objRecordBlock.getAttribute('PRIORITY'));
		dialog.getDescendantOfName('eventPriority').setEvent('mx.ELog2.updateLifespanByPriority();', jsx3.gui.Interactive.CHANGE);

		//if(window.jsDebug){appLogger.info("ELog2.ShowRow: lifespan="+objRecordBlock.getAttribute('LIFESPAN'))}
		ELog2.lookupLifespanObjId = objRecordBlock.getAttribute("OBJID");
		dialog.getDescendantOfName('storagePriority').resetCacheData();
		if (objRecordBlock.getAttribute('LIFESPAN') != '0') {
			//dialog.getDescendantOfName('storagePriority').setValue(objRecordBlock.getAttribute('LIFESPAN'));
			ELog2.lookupLifespanId = objRecordBlock.getAttribute('LIFESPAN');
			mx.ELog2.servicelookupEventLifespan();
		}
		else {
			dialog.getDescendantOfName('storagePriority').setValue(__("Pending removal"));
			dialog.getDescendantOfName('storagePriority').getParent().repaint();
		}

		//if(window.jsDebug){ appLogger.info("ELog2.ShowRow: objRecordBlock.getAttribute(needUpd)="+objRecordBlock.getAttribute("needUpd")); }
		if (objRecordBlock.getAttribute("needUpd") != null && objRecordBlock.getAttribute("needUpd") != "null" && objRecordBlock.getAttribute("needUpd") != "") {
			dialog.getDescendantOfName('eventPriority').setEnabled(jsx3.gui.Form.STATEENABLED, true);
			dialog.getDescendantOfName('storagePriority').setEnabled(jsx3.gui.Form.STATEENABLED, true);
		}
		else {
			dialog.getDescendantOfName('eventPriority').setEnabled(jsx3.gui.Form.STATEDISABLED, true);
			dialog.getDescendantOfName('storagePriority').setEnabled(jsx3.gui.Form.STATEDISABLED, true);
		}

		//check migration
		var migrate = objRecordBlock.getAttribute("MIGRATE");
		var migrationDisabled = '';
		var migrationChecked = '';

		if (migrate != null && migrate != "null") {
			if (migrate == '0') {

			} else if (migrate == '1') {
				migrationChecked = 'checked="checked"';
			} else if (migrate == '2') {
				migrationChecked = 'checked="checked"';
				migrationDisabled = 'disabled="disabled"';
			}
		}

		//if migration not allowed by server
		if (ELog2.migrationAllowed == 0) {
			migrationDisabled = 'disabled="disabled"';
		}

		dialog.getDescendantOfName('checkboxMigration').setText(
			'<input type="checkbox" name="checkboxMigration" id="checkbox_elog2_migration" onclick="mx.ELog2.enableSaveOperation(mx.MATRIX2.getServer().getJSXByName(\'eLog2dialog\').getDescendantOfName(\'checkboxMigration\'))" ' + migrationChecked + ' ' + migrationDisabled + '>' +
				'<label for="checkbox_elog2_migration">' + __("migration") + '</label>'
		, true);

		dialog.getDescendantOfName('eventPriority').removeAttribute("ischangedbyuser");
		dialog.getDescendantOfName('storagePriority').removeAttribute("ischangedbyuser");
		dialog.getDescendantOfName('textareaUserMessage').removeAttribute("ischangedbyuser");
		dialog.getDescendantOfName('checkboxMigration').removeAttribute("ischangedbyuser");

		dialog.getDescendantOfName('buttonSave').setEvent("mx.ELog2.submitAction('Update'," + objRecordBlock.getAttribute('EVENTID') + "); mx.ELog2.closeDialog();", jsx3.gui.Interactive.EXECUTE);
		dialog.getDescendantOfName('buttonCancel').setEvent("mx.ELog2.closeDialog();", jsx3.gui.Interactive.EXECUTE);

		var noScreenshots = dialog.getDescendantOfName('noScreenshots');
		var selectDeviceScreens = dialog.getDescendantOfName('selectDeviceScreens');
		if (screenshot_id != null) {
			selectDeviceScreens.resetXmlCacheData();
			selectDeviceScreens.setXMLString(strWitnesses);
			selectDeviceScreens.setEnabled(jsx3.gui.Form.STATEENABLED);
			//remove non-camera devices
			var selectScreensNodes = selectDeviceScreens.getXML().selectNodes("//record");
			for (var i = 0; i < selectScreensNodes.size(); i++){
				var treeObject = resourceTree.getObject(selectScreensNodes.get(i).getAttribute("objid"))
				if(treeObject && treeObject.type != 'camera'){
					selectDeviceScreens.deleteRecord(selectScreensNodes.get(i).getAttribute("jsxid"), false);
				}
			}

			if (selectDeviceScreens.getXML().selectSingleNode("//record[@objid='" + devNode.obj + "']")) {
				selectDeviceScreens.setValue(selectDeviceScreens.getXML().selectSingleNode("//record[@objid='" + devNode.obj + "']").getAttribute("jsxid"));
				selectDeviceScreens.repaint();
			}
			selectDeviceScreens.setEvent("mx.ELog2.showScreenshots(mx.ELog2.screenshotsStart);", jsx3.gui.Interactive.SELECT);

			dialog.getDescendantOfName('prevScreenshots').setTip(__("Previous")).setEvent("mx.ELog2.showScreenshots('prev');", jsx3.gui.Interactive.EXECUTE);
			dialog.getDescendantOfName('nextScreenshots').setTip(__("Next")).setEvent("mx.ELog2.showScreenshots('next');", jsx3.gui.Interactive.EXECUTE);
			ELog2.showScreenshots(0);
			noScreenshots.setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
		}
		else{
			//disable screenshots
			ELog2.hideScreenshots();
			dialog.getDescendantOfName('prevScreenshots').setImage("jsxuser:///images/design1/eLog2/eLog2_page_prev_disabled.png").setTip(__("No screenshots available")).repaint();
			dialog.getDescendantOfName('nextScreenshots').setImage("jsxuser:///images/design1/eLog2/eLog2_page_next_disabled.png").setTip(__("No screenshots available")).repaint();
			selectDeviceScreens.setValue(__("No video device"));
			selectDeviceScreens.setEnabled(jsx3.gui.Form.STATEDISABLED, true);
			noScreenshots.setDisplay(jsx3.gui.Block.DISPLAYBLOCK, true);
		}

		/*
			Tab Announce
		*/
		dialog.getDescendantOfName('tabES').setEvent("mx.ELog2.onEventDialogTabChange(this)", jsx3.gui.Interactive.SHOW);
		dialog.getDescendantOfName('userMessage').setText(__("Note") + ":", false);
		dialog.getDescendantOfName('newEventNote').setValue("", true).setEvent("mx.ELog2.newNoteChange();", jsx3.gui.Interactive.JSXKEYUP);
		dialog.getDescendantOfName('buttonAddNote')
			.setTip(__("Add note"))
			.setEnabled(jsx3.gui.Form.STATEDISABLED, true)
			.setEvent("mx.ELog2.onEventDialogAddNote();", jsx3.gui.Interactive.EXECUTE);
		dialog.getDescendantOfName('buttonAnnounce')
			.setTip(__("Fill event note to announce"))
			.setEnabled(jsx3.gui.Form.STATEDISABLED, true)
			.setEvent("mx.ELog2.announceEvent();", jsx3.gui.Interactive.EXECUTE);

		dialog.getDescendantOfName('textareaUserMessage').setValue(ELog2.objToNoteText($.parseJSON($(objRecordBlock).data('NOTE'))));

		var strAnnounceTargets =
			'<data jsxid="jsxroot">' +
				'<record jsxid="1" jsxtext="' + __("To all users in", "Event announce") + ' \'' + resourceTree.role.name + '\'" />' +
				'<record jsxid="2" jsxtext="' + __("To individual users", "Event announce") + '" />' +
			'</data>';

		var evtAnnounceDoc = jsx3.xml.CDF.Document.newDocument();
		evtAnnounceDoc.loadXML(strAnnounceTargets);

		mx.MATRIX2.getServer().Cache.setDocument('Elog2_EvtAnnounceDocument', evtAnnounceDoc);

		var announceTarget = dialog.getDescendantOfName('announceTarget');
		announceTarget.setEvent("mx.ELog2.onAnnounceTargetChange(strRECORDID)", jsx3.gui.Interactive.SELECT);
		announceTarget.setXMLId('Elog2_EvtAnnounceDocument').setValue(1);
		announceTarget.repaint();

		var usersList = dialog.getDescendantOfName('usersList');
		usersList.setValue("", true).setEnabled(jsx3.gui.Form.STATEDISABLED, true);

		var announcedBy = dialog.getDescendantOfName('labelAnnouncedBy');
		if(objRecordBlock.getAttribute("ANNOUNCEDBY") != null && objRecordBlock.getAttribute("ANNOUNCEDBY") != "null"){
			var announcedByText = __("Announced by ") + objRecordBlock.getAttribute("ANNOUNCEDBY")
			announcedBy.setText(announcedByText);
			ELog2.markAnnouncedEventAsRead(dialog.getAttribute("eventId"));
		}
		else{
			announcedBy.setText("");
		}

		ELog2.getAnnounceRoleUsers();

		/*
			Tab Controls
		*/
		dialog.getDescendantOfName('tabEC').setEvent("mx.ELog2.onEventDialogTabChange(this)", jsx3.gui.Interactive.SHOW);
		var selectDeviceControls = dialog.getDescendantOfName('selectDeviceControls');
		selectDeviceControls.resetXmlCacheData();
		selectDeviceControls.setXMLString(strWitnesses);
		var selectedControlId = null;
		var selectControlsNodes = selectDeviceControls.getXML().selectNodes("//record");
		for (var i = 0; i < selectControlsNodes.size(); i++){
			var treeObject = resourceTree.getObject(selectControlsNodes.get(i).getAttribute("objid"))
			if(treeObject && treeObject.otype != 'X' && treeObject.type != 'relay'){
				selectDeviceControls.deleteRecord(selectControlsNodes.get(i).getAttribute("jsxid"), false);
			}
			else if(selectedControlId == null){
				selectedControlId = selectControlsNodes.get(i).getAttribute("jsxid");
			}
		}

		if(selectedControlId != null){
			selectDeviceControls.setValue(selectedControlId);
			selectDeviceControls.repaint()
			selectDeviceControls.setEvent("mx.ELog2.onSelectControlsDevice();", jsx3.gui.Interactive.SELECT);
			ELog2.onSelectControlsDevice();
		}
		else{
			selectDeviceControls.resetXmlCacheData();
			selectDeviceControls.setXMLString(
				'<data jsxid="jsxroot">' +
					'<record jsxid="0" jsxtext="' + __("No devices") + '"/>' +
				'</data>'
			);
			dialog.getDescendantOfName('deviceActionsButtons').setText(__("No actions"), true).removeChildren();
			dialog.getDescendantOfName('currentProperties').setText(__("No properties"), true);
		}

		// CIRRUS_REPLACE_ELOG2_JS_ID007_BEGIN
		// CIRRUS_REPLACE_ELOG2_JS_ID007_END

		dialog.getDescendantOfName('tabEA').setEvent("mx.ELog2.onEventDialogTabChange(this)", jsx3.gui.Interactive.SHOW);
		dialog.getDescendantOfName('tabEA').setEvent("mx.ELog2.fillAudit(" + objRecordBlock.getAttribute('EVENTID') + ");", jsx3.gui.Interactive.EXECUTE);

		auditObj.callAddAuditRecord(17, objRecordBlock.getAttribute('EVENTID'), {
            digestparams:[objRecordBlock.getAttribute('EVENTID')],
            params:{}
        });

		dialog.setDisplay(jsx3.gui.Block.DISPLAYBLOCK, true);
		dialog.setVisibility(jsx3.gui.Block.VISIBILITYVISIBLE, true);


		if (ELog2.mode === 'archive' && objRecordBlock.getAttribute('GISREF')) {
			mx.GE.designation.showEventTrail(objRecordBlock.getAttribute('EVENTID'));
		}
		//appLogger.info("showRow: OK");
	};

	ELog2.onEventDialogTabChange = function(objTab){
		var tabpane = mx.MATRIX2.getServer().getJSXByName('tabbedpaneElog');
		var tabs = tabpane.getChildren();

		for(var i = 0; i < tabs.length; i++) {
			var caption = "";
			var name = tabs[i].getAttribute("tabName");
			if(tabs[i] != objTab){
				caption+= '<span style="height:16px; width:4px; position:relative; background-image:url(./images/design1/tabs/tab_bg_left.png);background-repeat:no-repeat; border: 0px solid red;">&nbsp;</span>'
				+ '<span style="height:16px; width:auto; position:relative; background-image:url(./images/design1/tabs/tab_bg.png);background-repeat:repeat-x; color:#000000; border:0px solid green;\">&nbsp;&nbsp;'+name+'&nbsp;&nbsp;</span>'
				+ '<span style="height:16px; width:4px; position:relative; background-image:url(./images/design1/tabs/tab_bg_right.png); background-repeat:no-repeat; border:0px solid blue;">&nbsp;</span>';
			}
			else{
				caption+= '<span style="height:16px; width:4px; position:relative; background-image:url(./images/design1/tabs/tab_bg_left_bright.png);background-repeat:no-repeat; border: 0px solid red;">&nbsp;</span>'
				+ '<span style="height:16px; width:auto; position:relative; background-image:url(./images/design1/tabs/tab_bg_bright.png);background-repeat:repeat-x; color:#000000; border:0px solid green;\">&nbsp;&nbsp;'+name+'&nbsp;&nbsp;</span>'
				+ '<span style="height:16px; width:4px; position:relative; background-image:url(./images/design1/tabs/tab_bg_right_bright.png); background-repeat:no-repeat; border:0px solid blue;">&nbsp;</span>';
			}
			tabs[i].setText(caption, true);
		}
	};

	/**
	 *  transform object note data to event note field
	 */
	ELog2.objToNoteText = function(objNote){
		var noteText = "";
		for(var i = 0; i < objNote.length; i++){
			noteText+= ELog2.getNoteRowText(objNote[i]);
		}
		return noteText;
	};

	/**
	 *  get note row text
	 */
	ELog2.getNoteRowText = function(objNote){
		return objNote.user + ":" + objNote.note + ".\n";
	};

	/**
	 *  add new note to main note field
	 */
	ELog2.onEventDialogAddNote = function(){
		var dialog = mx.MATRIX2.getServer().getJSXByName('eLog2dialog');
		var newNote = dialog.getDescendantOfName('newEventNote');
		var noteField = dialog.getDescendantOfName('textareaUserMessage');

		var newMsg = newNote.getValue();
		if(newMsg == ""){
			return;
		}

		var eventRecord = document.getElementById("event_" + dialog.getAttribute("eventId"));
		var noteObj = $.parseJSON($(eventRecord).data("NOTE"));

		var newNoteObj = {
			user: jsUserName,
			note: newNote.getValue()
		};

		noteField.setValue(noteField.getValue() + ELog2.getNoteRowText(newNoteObj));

		noteObj.push(newNoteObj);
		$(eventRecord).data("NOTE", JSON.stringify(noteObj));
	};

	/**
	 *  check add note button state during new note field change
	 */
	ELog2.newNoteChange = function(){
		var dialog = mx.MATRIX2.getServer().getJSXByName('eLog2dialog');
		var newNote = dialog.getDescendantOfName('newEventNote');
		var addNoteButton = dialog.getDescendantOfName('buttonAddNote');
		var buttonAnnounce = dialog.getDescendantOfName('buttonAnnounce');
		if(newNote.getValue() == ""){
			addNoteButton.setEnabled(jsx3.gui.Form.STATEDISABLED, true);
			buttonAnnounce.setTip(__("Fill event note to announce")).setEnabled(jsx3.gui.Form.STATEDISABLED, true);
		}
		else{
			addNoteButton.setEnabled(jsx3.gui.Form.STATEENABLED, true);
			buttonAnnounce.setTip(__("Announce event with current role users")).setEnabled(jsx3.gui.Form.STATEENABLED, true);
		}
	};

	/**
	 *  on event announce target change
	 */
	ELog2.onAnnounceTargetChange = function(strRECORDID){
		var dialog = mx.MATRIX2.getServer().getJSXByName('eLog2dialog');
		var usersList = dialog.getDescendantOfName('usersList');

		if(strRECORDID == 2){
			usersList.setEnabled(jsx3.gui.Form.STATEENABLED, true);

			var autocompleteList = [];
			for(var i = 0; i < ELog2.announceRoleUsers.user.length; i++){
				autocompleteList.push(ELog2.announceRoleUsers.user[i].name);
			}

			var usersListInput = usersList.getRendered();

			function doSplit(val) {
				return val.split( /,\s*/ );
			}
			function extractLast(term) {
				return doSplit(term).pop();
			}

			$(usersListInput).bind( "keydown", function( event ) {
				if ( event.keyCode === $.ui.keyCode.TAB &&
					$( this ).autocomplete( "instance" ).menu.active ) {
					event.preventDefault();
				}
			})
			.autocomplete({
				minLength: 0,
				source: function( request, response ) {
					// delegate back to autocomplete, but extract the last term
					response( $.ui.autocomplete.filter(autocompleteList, extractLast( request.term )) );
				},
				focus: function() {
					// prevent value inserted on focus
					return false;
				},
				select: function( event, ui ) {
					var terms = doSplit(this.value);
					// remove the current input
					terms.pop();
					// add the selected item
					terms.push( ui.item.value );
					// add placeholder to get the comma-and-space at the end
					terms.push( "" );
					this.value = terms.join( ", " );
					return false;
				}
			});
		}
		else{
			usersList.setValue("").setEnabled(jsx3.gui.Form.STATEDISABLED, true);
		}
	};

	/*
		select controls device
	*/
	ELog2.onSelectControlsDevice = function(){
		var dialog = jsx3.GO('eLog2dialog');
		var node = dialog.getDescendantOfName('selectDeviceControls').getXML().selectSingleNode("//record[@jsxid='" + dialog.getDescendantOfName('selectDeviceControls').getValue() + "']");
		var objid = node.getAttribute("objid");
		for (i = 0; i < ELog2.witnessesAllData.length; i++) {
			var witnessesObject = ELog2.witnessesAllData[i];
			if (!witnessesObject || witnessesObject.objid != objid)
				continue;

			var properties = "";
			for (var p = 0; p < witnessesObject.properties.length; p++) {
				properties+= witnessesObject.properties[p].name + " = " + witnessesObject.properties[p].value + "<br />";
			}
			if(properties == ""){
				properties = __("No properties");
			}
			dialog.getDescendantOfName('currentProperties').setText(properties, true);

			dialog.getDescendantOfName('deviceActionsButtons').setText("", true).removeChildren();
			for (var m = 0; m < witnessesObject.methods.length; m++) { // methods
				var methodButton = new jsx3.gui.Button("method_button" + m, 0, 0, "100%", __(unescape(witnessesObject.methods[m].displayname)));
				methodButton.setRelativePosition(jsx3.gui.Block.RELATIVE);
				methodButton.setBackgroundColor("#FFFFFF");
				methodButton.setMargin("0 4 0 0");
				methodButton.setPadding(2);
				methodButton.setWidth("90%");
				methodButton.setHeight(20);
				methodButton.setBorder("1px solid gray");
				methodButton.setTip(__(unescape(witnessesObject.methods[m].displayname)));
				methodButton.setEvent("mx.OM.invokeObjectMethod("+witnessesObject.objid+",'"+witnessesObject.methods[m].name+"');"+
					"mx.ELog2.callEADA(" + witnessesObject.objid + ",'" + witnessesObject.methods[m].name + "','" + dialog.getAttribute('eventId') + "');", jsx3.gui.Interactive.EXECUTE);
				dialog.getDescendantOfName('deviceActionsButtons').setChild(methodButton);
			}
			if(witnessesObject.methods.length == 0){
				dialog.getDescendantOfName('deviceActionsButtons').setText(__("No actions"), true)
			}
			dialog.getDescendantOfName('deviceActionsButtons').repaint();
		}
	};

	/*
		hide screenshots
	*/
	ELog2.hideScreenshots = function(){
		var dialog = mx.MATRIX2.getServer().getJSXByName('eLog2dialog');
		for(var i = 0; i < 5; i++){
			dialog.getDescendantOfName("screenTime" + (i+1)).setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
			dialog.getDescendantOfName("screen" + (i+1)).setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
		}
	};

	/*
		show event screenshots
	*/
	ELog2.showScreenshots = function(from){
		var dialog = mx.MATRIX2.getServer().getJSXByName('eLog2dialog');
		var time_from = parseInt(dialog.getAttribute("utctime_from"));
		var time_to = parseInt(dialog.getAttribute("utctime_to"));

		var selectDeviceScreens = dialog.getDescendantOfName('selectDeviceScreens');
		var objId = dialog.getAttribute("objId");
		if (selectDeviceScreens.getValue() && selectDeviceScreens.getXML().selectSingleNode("//record[@jsxid='" + selectDeviceScreens.getValue() + "']")) {
			objId = selectDeviceScreens.getXML().selectSingleNode("//record[@jsxid='" + selectDeviceScreens.getValue() + "']").getAttribute("objid");
		}

		if(from == 0){
			ELog2.screenshotsStart = from;
		}
		else if(from == 'prev'){
			ELog2.screenshotsStart-= 5;
		}
		else if(from == 'next'){
			ELog2.screenshotsStart+= 5;
		}

		if(window.jsDebug){ appLogger.info("ELog2.showScreenshots: pr="+(time_from + ELog2.screenshotsStart*5 - 5*5)+", time_from="+time_from) }
		if(window.jsDebug){ appLogger.info("ELog2.showScreenshots: nt="+(time_from + ELog2.screenshotsStart*5 + 5*5)+", time_to="+time_to) }

		if(time_from + ELog2.screenshotsStart*5 - 5*5 < time_from){
			dialog.getDescendantOfName("prevScreenshots").setImage("jsxuser:///images/design1/eLog2/eLog2_page_prev_disabled.png").setTip(__("Event boundary reached")).setEnabled(jsx3.gui.Form.STATEDISABLED, true);
		}
		else{
			dialog.getDescendantOfName("prevScreenshots").setImage("jsxuser:///images/design1/eLog2/eLog2_page_prev.png").setTip(__("Previous")).setEnabled(jsx3.gui.Form.STATEENABLED, true);
		}

		if(time_from + ELog2.screenshotsStart*5 + 5*5 > time_to){
			dialog.getDescendantOfName("nextScreenshots").setImage("jsxuser:///images/design1/eLog2/eLog2_page_next_disabled.png").setTip(__("Event boundary reached")).setEnabled(jsx3.gui.Form.STATEDISABLED, true);
		}
		else{
			dialog.getDescendantOfName("nextScreenshots").setImage("jsxuser:///images/design1/eLog2/eLog2_page_next.png").setTip(__("Next")).setEnabled(jsx3.gui.Form.STATEENABLED, true);
		}


		for(var i = 0; i < 5; i++){
			var screenTime = time_from + (ELog2.screenshotsStart + i)*5;
			if(screenTime <= time_to){
				dialog.getDescendantOfName("screenTime" + (i+1)).setText(mx.TIME.timestamp2date(screenTime * 1000, 'HH:II:SS'), true).setBackgroundColor("#000000").setDisplay(jsx3.gui.Block.DISPLAYBLOCK, true);
				if(jsx3.CLASS_LOADER.IE) {
					dialog.getDescendantOfName("screenTime" + (i+1)).setCSSOverride("filter:progid:DXImageTransform.Microsoft.Alpha(opacity=50)");
				}
				else{
					dialog.getDescendantOfName("screenTime" + (i+1)).setCSSOverride("opacity:0.5)");
				}
				dialog.getDescendantOfName("screen" + (i+1)).setClassName("loadingIndication").setSrc(mx.MATRIX2.getServerURL() +
				"/storage/snapshot?objid=" + objId +
				"&ts=" + screenTime + "&downscale" + "&key="+urlRand()).setDisplay(jsx3.gui.Block.DISPLAYBLOCK, true).repaint();

			}
			else{
				dialog.getDescendantOfName("screenTime" + (i+1)).setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
				dialog.getDescendantOfName("screen" + (i+1)).setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
			}
		}
	};

	/*
		open event witnesses in separate tab
	*/
	ELog2.openWitnessesLayout = function(strWitnesses, curEventId, isForEventTab){
		var tab = isForEventTab?mx.CT.getTabByName(__("Event")):null;
		if(tab == null){
			tab = mx.CT.createNewTab();
		}
		if(tab == null){
			return;
		}

		if(isForEventTab){
			mx.CT.clearTab(tab);
			//rename tab
			tab.setAttribute("initText", __("Event"));
			mx.CT.setTabDesignSelected(tab);
		}

		if(window.jsDebug){ appLogger.info("Elog2.openWitnessesLayout: strWitnesses="+strWitnesses); }

		var witnesses = strWitnesses.split(" ");
		arrayUnique(witnesses);
		var cameraWitnesses = resourceTree.getObjects({'type': 'camera', 'obj': witnesses});
		var amount = cameraWitnesses.length;
		var objDest = tab.getFirstChild();

		if(amount == 2){
			mx.MATRIX2.addSplitter(objDest, jsx3.gui.Splitter.ORIENTATIONH);
		}
		else if(amount > 2 && amount < 5){
			mx.MATRIX2.addSplitterCrest(objDest);
		}
		else if(amount >= 5 && amount < 7){
			mx.MATRIX2.addSplitter_3x2(objDest);
		}
		else if(amount >= 7){
			mx.MATRIX2.addSplitter_4x3(objDest);
			if(amount > 9){
				mx.MATRIX2.showMessage(__("Event log"), __("Too many witnesses. First 9 shown."));
			}
		}

		tab.doShow();

		//unpin all pinned cameras
		mx.MATRIX2.unpinAllCells();

		var event_ts_from = null;
		var event_ts_to = null;
		var eLogEventElement = document.getElementById("event_" + curEventId);
		var dialog = mx.MATRIX2.getServer().getJSXByName('eLog2dialog');
		if(eLogEventElement){
			event_ts_from = eLogEventElement.getAttribute("UTCTIME_FROM")*1000;
			event_ts_to = eLogEventElement.getAttribute("UTCTIME_TO")*1000;
		}
		else if(dialog.getAttribute("eventId") == curEventId){
			event_ts_from = dialog.getAttribute("utctime_from")*1000;
			event_ts_to = dialog.getAttribute("utctime_to")*1000;
		}

		if(event_ts_from == null){
			if(window.jsDebug){ appLogger.info("Elog2.openWitnessesLayout: no event data" ); }
			return false;
		}

		var blocks = tab.getDescendantsOfType("jsx3.gui.Block", false);
		if(window.jsDebug){ appLogger.info("Elog2.openWitnessesLayout: amount="+cameraWitnesses.length ); }

		var pinned = [];
		for(var i = 0; i < cameraWitnesses.length; i++){
			if(window.jsDebug){ appLogger.info("Elog2.openWitnessesLayout: witness="+cameraWitnesses[i]); }
			for(var k = 0; k < blocks.length; k++) {
				var block = jsx3.GO(blocks[k].getId());
				//popup
				if (block.getAttribute("playerBlock") == "0") {
					// emulate event cell drop
					var newCell = mx.MATRIX2.createCell(cameraWitnesses[i], Gettext.strargs(__("Event ID: %1"), [curEventId]), block, false, event_ts_from, event_ts_to, true, false, true);
					isPlayInArchive = true;
					if(cameraWitnesses.length == 1){
						mx.MATRIX2.setSelectedGroup(newCell.getDescendantOfName("cell_select"), null, true);
					}
					else{
						pinned.push(newCell.getDescendantOfName("cell_pin"));
					}
					break;
				}
			}
		}

		//pin cells if needed
		for(var i = 0; i < pinned.length; i++){
			var pin = mx.MATRIX2.btnPinHandler(pinned[i]);
		}

		ELog2.checkWitnessesLayoutPlay();
	};

	ELog2.checkWitnessesLayoutPlay = function(){
		var controls = mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls;
		if(controls.group != null){
			mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls.play(true);
			clearTimeout(window["checkWitnessesLayoutPlay"]);
		}
		else{
			window["checkWitnessesLayoutPlay"] = window.setTimeout(function(){
				mx.ELog2.checkWitnessesLayoutPlay()
			}, 1000);
		}
	};

	//check tags of event
	ELog2.checkTags = function(objRecord, isStartLoad) {
		//appLogger.info("checkTags: START:"+objTags.join(","));
		if (objRecord.getAttribute('TAG') == null)
			return;

		var objTags = objRecord.getAttribute('TAG').split(' ');
		if (objTags.length == 1) {
			objTags = objRecord.getAttribute('TAG').split(',');
		}

		var eLog2 = jsx3.GO("eLog2Root");
		var dialog = eLog2.getDescendantOfName('eLog2dialog');

		for (var i = 0; i < objTags.length; i++) {
			//appLogger.info("checkTags: objTags["+i+"]:"+objTags[i]);
			//convert string to integer
			if (typeof(objTags[i]) == 'string') {
				objTags[i] = parseInt(objTags[i]);
			}
			//choose tag
			switch (objTags[i]) {
				case 1: // if need announcement confirmation
					if (!isStartLoad) {
						//ELog2.submitAction("Announce",objRecord.getAttribute('EVENTID'));
					}
					break;
				case 2: // if need supervisor attention
					//TODO set information tag
					break;
				case 3: // if requers acknowledgment
					objRecord.setAttribute("needAcknowlegement", "true");
					break;
				case 4: // if Acknowleged
					objRecord.removeAttribute("needAcknowlegement");
					if (dialog.getVisibility() == jsx3.gui.Block.VISIBILITYVISIBLE && dialog.getAttribute("eventId") == objRecord.getAttribute("EVENTID")) {
						dialog.getDescendantOfName('buttonAckn').setEnabled(jsx3.gui.Form.STATEDISABLED, true);
						if (objTags.indexOf(7) != -1) {
							dialog.getDescendantOfName('buttonClr').setEnabled(jsx3.gui.Form.STATEENABLED, true);
						}
					}

					objRecord.setAttribute("Acknowleged", "true");

					if (ELog2.state == 'not_acknowledged') {
						ELog2.removeDOMEvent(document.getElementById("event_" + objRecord.getAttribute("EVENTID")));
					}

					break;
				case 5: // if Updatable
					objRecord.setAttribute("needUpd", "true");
					break;
				case 6: // if EADA
					objRecord.setAttribute("EADA", "true");
					//TODO show EADA controls
					break;
				case 7: // if Clearable
					objRecord.setAttribute("needClr", "true");
					break;
				case 8: // if Cleared
					objRecord.removeAttribute("needClr");
					if (dialog.getVisibility() == jsx3.gui.Block.VISIBILITYVISIBLE && dialog.getAttribute("eventId") == objRecord.getAttribute("EVENTID")) {
						dialog.getDescendantOfName('buttonClr').setEnabled(jsx3.gui.Form.STATEDISABLED, true);
					}

					objRecord.setAttribute("Cleared", "true");
					objRecord.removeAttribute("Acknowleged");

					if (ELog2.state != 'cleared' && ELog2.state != 'all' && document.getElementById("event_" + objRecord.getAttribute("EVENTID"))) {
						ELog2.removeDOMEvent(document.getElementById("event_" + objRecord.getAttribute("EVENTID")));
						if (dialog.getAttribute("eventId") == objRecord.getAttribute("EVENTID")) {
							dialog.setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
						}
					}
					break;
				case 9: // if Final state
					//objRecord.removeAttribute("needUpd");
					break;
				case 10: // popup allowed
					//TODO nothing
					break;
				case 11: // paint in ackn color
					objRecord.setAttribute("cirrus_color", "true");
					break;
				default:
				//TODO set information tag
			}
		}

        if (objRecord.getAttribute('TAG').search(/5/) == -1){
            objRecord.removeAttribute("needUpd");
        }
		//appLogger.info("checkTags: OK:"+objRecord);
	};

	ELog2.selectAction = function(strActionName, eventId) {
		ELog2.submitAction(strActionName, eventId);
	};

	//send event action to client eLog applet
	ELog2.submitAction = function(action, eventId, objId) {
		//appLogger.info("submitAction: START:"+action+", eventId="+eventId);
		//var eventNode = document.getElementById("event_" + eventId);
		var dialog = jsx3.GO("eLog2Root").getDescendantOfName('eLog2dialog');

		if(objId === undefined){
			objId = dialog.getAttribute("objId");
		}

		var eventBlock = document.getElementById("event_" + eventId);
		objId = eventBlock.getAttribute("OBJID");

		//check credentials
		if (!resourceTree.cred(objId, 'e')) { //for ACSG events
			alert(__("You don't have credentials for UPDATE!"));
			return;
		}

		var name = "";
		var parameters = {
			eventid: parseInt(eventId)
		};
		var properties = {};

		switch (action) {
			case "Announce":
				name = 'announce';
			break;
			case "Acknowledge":
				name = 'ack';
			break;
			case "Clear":
				name = 'clear';
			break;
			case "Update":
				name = 'update';
				if (!document.getElementById('checkbox_elog2_migration').disabled) {
					if (dialog.getDescendantOfName('checkboxMigration').getAttribute("ischangedbyuser")) {
						properties.MIGRATE = document.getElementById('checkbox_elog2_migration').checked ? 1 : 0;
					}
				}
				ELog2.disableSaveOperation();
			break;
			default:
				// Unknown action, do nothing
				return;
		}

		if ($.inArray(action, ["Clear", "Update", "Acknowledge"]) != -1) {
			if (dialog.getDescendantOfName('eventPriority').getAttribute("ischangedbyuser")) {
				parameters.priority = parseInt(dialog.getDescendantOfName('eventPriority').getValue());
			}
		}

		if (dialog.getDescendantOfName('storagePriority').getAttribute("ischangedbyuser")) {
			parameters.lifespan = parseInt(dialog.getDescendantOfName('storagePriority').getValue());
		}
		if (dialog.getDescendantOfName('textareaUserMessage').getAttribute("ischangedbyuser")) {
			parameters.note = dialog.getDescendantOfName('textareaUserMessage').getValue();
		}

		ELog2.eLogNoter.submitAction(name, parameters, properties)
			.fail(function(code, message){
				var error = ELog2.checkEADAError(message);
				alert("submitAction: " + error);
			});
	};

	/**
	 * if changed status of eLog2 applet
	 *
	 * @deprecated
	 * @param intStatus
	 */
	// TODO: remove this method
	ELog2.OnStatusChange = function(intStatus) {
		appLogger.info("OnStatusChange: intStatus=" + intStatus);
		/*0 - disconnected
		 1 - invalid
		 2 - normal*/
		if (intStatus == 0) {
			ELog2.onDisconnect("Applet status changed to 0");
		} else if (intStatus == 1) {
			ELog2.onInvalid();
		} else if (intStatus == 2) {
			ELog2.onConnect();
		}
	};

	ELog2.setELogVisualState = function(intELogState) {
		//appLogger.info("setELogVisualState: intELogState="+intELogState);
		var eLog2 = jsx3.GO("eLog2Root");

		// index of element correspond to intELogState
		var states = ['imageeLog2', 'imageeLog2_busy', 'imageeLog2_invalid', 'imageeLog2_off'];

		// If status changed, redraw state pictures and enable/disable filters
		if (eLog2.getDescendantOfName(states[intELogState]).getDisplay() == jsx3.gui.Block.DISPLAYNONE) {
			for (var i = 0; i < 4; i++) {
				if (i == intELogState)
					eLog2.getDescendantOfName(states[i]).setDisplay(jsx3.gui.Block.DISPLAYBLOCK, true);
				else
					eLog2.getDescendantOfName(states[i]).setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
			}

			//set eLog2 filters
			var filtersButton = eLog2.getDescendantOfName('showELogFilters');
			if (intELogState == 1) { // if busy deny change
				filtersButton.setEnabled(jsx3.gui.Form.STATEDISABLED, true);
			} else {
				filtersButton.setEnabled(jsx3.gui.Form.STATEENABLED, true);
			}
		}

		//appLogger.info("setELogVisualState: OK");
	};

	ELog2.initApplet = function() {
		window.ELog2eLogNoter
			.init("#elog_client")
			.done(function(){
				ELog2.eLogNoter = window.ELog2eLogNoter;

				mx.OM.initAppletOK();

				ELog2.createDefaultFilters();

				if (window['migrationMonitor_var']) {
					clearTimeout(window['migrationMonitor_var']);
				}
				window['migrationMonitor_var'] = window.setTimeout(function() {
					ELog2.migrationMonitor();
				}, ELog2.migrationMonitorPeriod);

				ELog2.started = true;
				appLogger.info("ELog2.initApplet: OK");
			});
	};

	//if witness droped to matix
	ELog2.onEventWitnessDrop = function(objSource, objDest, strId) {
		//appLogger.info("onEventWitnessDrop: START: objSource="+objSource+", objDest="+objDest+", strId="+strId);
		var eLog2 = jsx3.GO("eLog2Root");
		var dialog = eLog2.getDescendantOfName('eLog2dialog');
		var eventId = dialog.getAttribute("eventId");
		var objIdMain = dialog.getAttribute("objId");
		var utc_from = dialog.getAttribute("utctime_from") * 1000;
		var utc_to = dialog.getAttribute("utctime_to") * 1000;
		var t_zone = dialog.getAttribute("t_zone");
		var objDev;
		var videoSource = __("originator");

		if (objSource.getName() == 'screenshot') {
			objDev = resourceTree.getObject(objIdMain);
		} else {
			var witnessesDoc = dialog.getDescendantOfName('matrixWitnesses').getXML();
			var objId = witnessesDoc.selectSingleNode("//record[@jsxid='" + strId + "']").getAttribute("objid");
			objDev = resourceTree.getObject(objId);
			videoSource = __("witness")
		}

		if(window.jsDebug){ appLogger.info("ELog2.onEventWitnessDrop: objIdMain="+objIdMain+", objDev="+objDev); }
		if (objDev) {
			mx.MATRIX2.clearDestinationBlock(objDest);
			if (objDev.type == "camera") {
                if(window.jsDebug){ appLogger.info("ELog2.onEventWitnessDrop: create cell"); }
				var newCell = mx.MATRIX2.createCell(objDev.obj, __("Event ID: ") + eventId, objDest, false, utc_from, utc_to);
				newCell.setAttribute("time_zone", t_zone);
		    	isPlayInArchive = true;
                if(window.jsDebug){ appLogger.info("ELog2.onEventWitnessDrop: select cell"); }
			    mx.MATRIX2.setSelectedGroup(objDest.getDescendantOfName("cell_select"), null, true);

				auditObj.callAddAuditRecord(23, eventId, {
					digestparams:[eventId, videoSource],
					params:{
						DEVICE: objDev.obj
					}
				});
			}
			else {
				mx.OM.createOMCell(objDest, objDev);
			}
		}
		else {
			/* i18n: %1 is an object id */
			alert(Gettext.strargs(__("No device %1 in resource tree! Try to update device list."), [objId]));
		}

		ELog2.dropstarted = false;
		//appLogger.info("onEventWitnessDrop: OK");
	};

	// on eLog2 dialog close
	ELog2.closeDialog = function() {
		//appLogger.info("closeDialog: START");
		var eLog2 = jsx3.GO("eLog2Root");
		var dialog = eLog2.getDescendantOfName('eLog2dialog');

		if (dialog.getDisplay() == jsx3.gui.Block.DISPLAYNONE)
			return;

		if (dialog.getDescendantOfName('buttonSave').getEnabled() == jsx3.gui.Form.STATEENABLED) {
			var ask = confirm(__("Do you want to exit without saving changes?"));
			if (ask) {
				$('#eLog2_container tr').each(function() { this.firstChild.innerHTML = ''; });
				ELog2.disableSaveOperation();
				dialog.setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
				//hide block for Safari support
				dialog.setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
			}
            else{
                return;
            }
		}
		else {
			$('#eLog2_container tr').each(function() { this.firstChild.innerHTML = ''; });
			ELog2.disableSaveOperation();
			dialog.setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
			//hide block for Safari support
			dialog.setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
		}
		dialog.getDescendantOfName("buttonAckn").setEnabled(jsx3.gui.Form.STATEDISABLED, true);
		dialog.getDescendantOfName("buttonClr").setEnabled(jsx3.gui.Form.STATEDISABLED, true);

		ELog2.lookupLifespanObjId = null;
		ELog2.lookupLifespanId = null;

		if (ELog2.mode === 'archive' && dialog.getAttribute('gisref') === 'gisref') {
			mx.GE.designation.hideEventTrail(dialog.getAttribute('eventId'));
		}

		//appLogger.info("closeDialog: OK");
	};

	ELog2.addDOMEventLogHeader = function () {
		$('#eLog2_header').html(
			'<tr>' +
				'<th style="width: 20px"></th>' +
				'<th style="width: 20px"></th>' +
				'<th style="width: 30px">' + __("Pr") + '</th>' +
				'<th style="width: 90px">' + __("ID") + '</th>' +
				'<th style="width: 140px">' + __("Time") + '</th>' +
				'<th style="width: 170px">' + __("Device") + '</th>' +
				'<th style="width: 70px">' + __("Source") + '</th>' +
				'<th style="width: 300px">' + __("System Message") + '</th>' +
				'<th style="width: 200px">' + __("User note") + '</th>' +
			'</tr>'
		);
	};

	ELog2.addDOMEvent = function (eventRecord, isWebService) {
		var play_event_icon = 'eLog2_play_event.png';
		var play_event_tip = __("Play event in tab")
		if(eventRecord.getAttribute("CLOUD_LOCATION")){
			play_event_icon = 'eLog2_play_event_cloud.png';
			play_event_tip = __("Play cloud event in tab")
		}

		var tr = $(
			'<tr>' +
				'<td></td>' +
				'<td><img style="cursor:pointer;width:15px;height:15px" title="' + play_event_tip + '" src="/TibcoGI/JSXAPPS/mx/images/design1/eLog2/' + play_event_icon + '" onclick="mx.ELog2.openWitnessesLayout(\'' + eventRecord.getAttribute("OBJID") + ' ' + eventRecord.getAttribute("WITNESSES") + '\', \'' + eventRecord.getAttribute("EVENTID") + '\', true)"/></td>' +
				'<td class="priority">' + ELog2.checkEventPriority(eventRecord.getAttribute("PRIORITY")) + '</td>' +
				'<td>' +  eventRecord.getAttribute("EVENTID") + '</td>' +
				'<td>' +  eventRecord.getAttribute("LOCAL_WHEN") + '</td>' +
				'<td>' +  eventRecord.getAttribute("OBJ_OBJID_DESC") + '</td>' +
				'<td>' +  eventRecord.getAttribute("SRC_DESC") + '</td>' +
				'<td>' + ($('<div/>').text(eventRecord.getAttribute("MESSAGE")).html() || ' ') + '</td>' +
				'<td>' + (ELog2.objToNoteText($.parseJSON(eventRecord.NOTE)) || ' ') + '</td>' +
			'</tr>'
		);

		tr.attr({
			id: "event_" + eventRecord.getAttribute("EVENTID"),
			type: "eventRoot",
			EVENTID: "" + eventRecord.getAttribute("EVENTID"),
			OBJID: "" + eventRecord.getAttribute("OBJID"),
			TAG: "" + eventRecord.getAttribute("TAG"),
			WITNESSES: "" + eventRecord.getAttribute("WITNESSES"),
			PRIORITY: "" + eventRecord.getAttribute("PRIORITY"),
			LIFESPAN: "" + eventRecord.getAttribute("LIFESPAN"),
			EVENTTYPE: "" + eventRecord.getAttribute("EVENTTYPE"),
			UTC_FROM: "" + eventRecord.getAttribute("UTC_FROM"),
			UTC_TO: "" + eventRecord.getAttribute("UTC_TO"),
			UTC_WHEN: "" + eventRecord.getAttribute("UTC_WHEN"),
			LOCAL_WHEN: "" + eventRecord.getAttribute("LOCAL_WHEN"),
			UTCTIME_WHEN: "" + eventRecord.getAttribute("UTCTIME_WHEN"),
			UTCTIME_FROM: "" + eventRecord.getAttribute("UTCTIME_FROM"),
			UTCTIME_TO: "" + eventRecord.getAttribute("UTCTIME_TO"),
			OBJ_T_ZONE: "" + eventRecord.getAttribute("OBJ_T_ZONE"),
			OBJ_OBJID_DESC: "" + eventRecord.getAttribute("OBJ_OBJID_DESC"),
			SRC: "" + eventRecord.getAttribute("SRC"),
			SRC_DESC: "" + eventRecord.getAttribute("SRC_DESC"),
			STATE: "" + eventRecord.getAttribute("STATE"),
			ANNOUNCEDBY: "" + eventRecord.getAttribute("ANNOUNCEDBY"),
			MESSAGE: "" + eventRecord.getAttribute("MESSAGE"),
			MIGRATE: "" + eventRecord.getAttribute("MIGRATE"),
			needAcknowlegement: "" + eventRecord.getAttribute("needAcknowlegement"),
			needUpd: "" + eventRecord.getAttribute("needUpd"),
			needClr: "" + eventRecord.getAttribute("needClr"),
			Acknowleged: "" + eventRecord.getAttribute("Acknowleged"),
			Cleared: "" + eventRecord.getAttribute("Cleared"),
			EADA: "" + eventRecord.getAttribute("EADA"),
			BGCOLOR: "" + eventRecord.getAttribute("BGCOLOR"),
			GISREF: "" + eventRecord.getAttribute("GISREF")
		}).data(
			"NOTE", eventRecord.NOTE
		).css({
			'color': ELog2.getRowFontColor(eventRecord),
			'background-color': eventRecord.getAttribute("BGCOLOR") ? ('#' + eventRecord.getAttribute("BGCOLOR")) : ELog2.getRowBGColor(eventRecord)
		}).dblclick(function() { mx.ELog2.showRow(this) });

		tr.prependTo($('#eLog2_container'));
	};

	ELog2.updateDOMEvent = function (eventRecord) {
		//appLogger.info("updateDOMEvent: eventRecord="+eventRecord);
		var eventHTMLBlock = document.getElementById("event_" + eventRecord.getAttribute("EVENTID"));

		var need_dlg_update = false;

		var tags = [];
		if (eventRecord.getAttribute('TAG') != null) {
			tags = eventRecord.getAttribute('TAG').split(' ');
			if (tags.length == 1) {
				tags = eventRecord.getAttribute('TAG').split(',');
			}
		}

		if (eventHTMLBlock.getAttribute("OBJID") != eventRecord.getAttribute("OBJID")) {
			eventHTMLBlock.setAttribute("OBJID", eventRecord.getAttribute("OBJID"));
			need_dlg_update = true;
		}

		if (eventHTMLBlock.getAttribute("WITNESSES") != eventRecord.getAttribute("WITNESSES")) {
			eventHTMLBlock.setAttribute("WITNESSES", eventRecord.getAttribute("WITNESSES"));
			need_dlg_update = true;
		}

		if (eventHTMLBlock.getAttribute("PRIORITY") != eventRecord.getAttribute("PRIORITY")) {
			eventHTMLBlock.setAttribute("PRIORITY", eventRecord.getAttribute("PRIORITY"));
			need_dlg_update = true;
		}

		if (eventHTMLBlock.getAttribute("LIFESPAN") != eventRecord.getAttribute("LIFESPAN")) {
			eventHTMLBlock.setAttribute("LIFESPAN", eventRecord.getAttribute("LIFESPAN"));
			need_dlg_update = true;
		}

		if (eventHTMLBlock.getAttribute("EVENTTYPE") != eventRecord.getAttribute("EVENTTYPE")) {
			eventHTMLBlock.setAttribute("EVENTTYPE", eventRecord.getAttribute("EVENTTYPE"));
			need_dlg_update = true;
		}

		if (eventHTMLBlock.getAttribute("MIGRATE") != eventRecord.getAttribute("MIGRATE")) {
			eventHTMLBlock.setAttribute("MIGRATE", eventRecord.getAttribute("MIGRATE"));
			need_dlg_update = true;
		}

		if ($(eventHTMLBlock).data("NOTE") != eventRecord.NOTE) {
			$(eventHTMLBlock).data("NOTE", eventRecord.NOTE);
			need_dlg_update = true;
		}

		if (eventHTMLBlock.getAttribute("STATE") != eventRecord.getAttribute("STATE")) {
			eventHTMLBlock.setAttribute("STATE", eventRecord.getAttribute("STATE"));
			need_dlg_update = true;
		}

		if (eventHTMLBlock.getAttribute("ANNOUNCEDBY") != eventRecord.getAttribute("ANNOUNCEDBY")) {
			eventHTMLBlock.setAttribute("ANNOUNCEDBY", eventRecord.getAttribute("ANNOUNCEDBY"));
			need_dlg_update = true;
		}

		eventHTMLBlock.setAttribute("UTCTIME_FROM", eventRecord.getAttribute("UTCTIME_FROM"));
		eventHTMLBlock.setAttribute("UTCTIME_TO", eventRecord.getAttribute("UTCTIME_TO"));
		eventHTMLBlock.setAttribute("UTC_FROM", eventRecord.getAttribute("UTC_FROM"));
		eventHTMLBlock.setAttribute("UTC_TO", eventRecord.getAttribute("UTC_TO"));
		eventHTMLBlock.setAttribute("BGCOLOR", eventRecord.getAttribute("BGCOLOR"));

		if (eventHTMLBlock.getAttribute("TAG") != eventRecord.getAttribute("TAG")) {
			eventHTMLBlock.setAttribute("TAG", eventRecord.getAttribute("TAG"));
			need_dlg_update = true;
		}

		eventHTMLBlock.setAttribute("needAcknowlegement", eventRecord.getAttribute("needAcknowlegement"));
		if (eventHTMLBlock.getAttribute('TAG').search(/5/) == -1){
			eventHTMLBlock.setAttribute("needUpd", "");
		}
		else {
			eventHTMLBlock.setAttribute("needUpd", eventRecord.getAttribute("needUpd"));
		}
		eventHTMLBlock.setAttribute("needClr", eventRecord.getAttribute("needClr"));

		eventHTMLBlock.setAttribute("Acknowleged", eventRecord.getAttribute("Acknowleged"));
		eventHTMLBlock.setAttribute("Cleared", eventRecord.getAttribute("Cleared"));
		eventHTMLBlock.setAttribute("EADA", eventRecord.getAttribute("EADA"));

		eventHTMLBlock.style.backgroundColor = (eventRecord.getAttribute("BGCOLOR") != null && eventRecord.getAttribute("BGCOLOR") != "") ? ('#' + eventRecord.getAttribute("BGCOLOR")) : ELog2.getRowBGColor(eventRecord);
		eventHTMLBlock.style.color = ELog2.getRowFontColor(eventRecord);

		var childBlock = eventHTMLBlock.firstChild;
		var iterator = 0;
		while (childBlock) {
			switch (iterator) {
				case 0: /**/
					break;
				case 1: /**/
					break;
				case 2: childBlock.innerHTML = ELog2.checkEventPriority(eventRecord.getAttribute("PRIORITY"));
					break;
				case 3: /**/
					break;
				case 4: /**/
					break;
				case 5: /**/
					break;
				case 6:
					break;
				case 7: childBlock.innerHTML = eventRecord.getAttribute("MESSAGE");
					break;
				case 8: childBlock.innerHTML = ELog2.objToNoteText($.parseJSON(eventRecord.NOTE));
					break;
			}
			childBlock = childBlock.nextSibling;
			iterator++;
		}

		if (need_dlg_update) {
			var dialog = jsx3.GO("eLog2Root").getDescendantOfName('eLog2dialog');
			if (dialog.getVisibility() == jsx3.gui.Block.VISIBILITYVISIBLE) {
				//appLogger.info("dialog visible");
				if (dialog.getAttribute("eventId") && dialog.getAttribute("eventId") == eventRecord.getAttribute("EVENTID")) {
					//appLogger.info("equal eventid");
					ELog2.showRow(eventHTMLBlock);
				}
			}
		}
	};

	//delete DOM child
	ELog2.removeDOMEvent = function (objChild) {
		//appLogger.info("removeDOMEvent: objChild="+objChild);
		var eLog2_container = document.getElementById("eLog2_container");
		if (objChild) { // remove child
			eLog2_container.removeChild(objChild);
		}
		else { //remove last
			eLog2_container.removeChild(eLog2_container.lastChild);
		}

		//if minimal size reached
		var size = document.getElementById("eLog2_container").childNodes.length;
		if (size == ELog2.minSize) {
			ELog2.elGetEvents("removeDOMEvent minimum size");
		}
		//appLogger.info("removeDOMEvent: OK");
	};

	ELog2.getRowBGColor = function(objRecord) {
		var strBG = "";
		if (objRecord.getAttribute("EVENTTYPE") == "0") {
			strBG = ELog2.InfoColor;
		} else if (objRecord.getAttribute("Cleared") == "true") {
			strBG = ELog2.clearedColor;
		} else if (objRecord.getAttribute("Acknowleged") == "true") {
			strBG = ELog2.ackColor;
		} else if (objRecord.getAttribute("needAcknowlegement") == "true") {
			strBG = ELog2.needAckColor;
		} else if (objRecord.getAttribute("cirrus_color") == "true") {
			strBG = ELog2.needAckColor;
			//odd event
			/*
			 if(ELog2.evenOdd){
			 strBG = "#F0F0F0";
			 ELog2.evenOdd = false;
			 }
			 else{
			 strBG = "#FFFFFF";
			 ELog2.evenOdd = true;
			 }*/
		}

		return strBG;
	};

	ELog2.getRowFontColor = function(objRecord) {
		//appLogger.info("getRowFontColor: "+objRecord);
		var strFont = "";
		if (objRecord.getAttribute("Cleared") == "true") {
			strFont = ELog2.clearedFontColor;
		} else if (objRecord.getAttribute("Acknowleged") == "true") {
			strFont = ELog2.ackFontColor;
		} else if (objRecord.getAttribute("needAcknowlegement") == "true") {
			strFont = ELog2.needAckFontColor;
		}

		return strFont;
	};

	ELog2.clearELog = function() {
		$('#eLog2_container').html('');
	};

	ELog2.setupELogDialog = function() {
		ELog2.disableSaveOperation();
		var eLog2 = jsx3.GO("eLog2Root");
		var dialog = eLog2.getDescendantOfName('eLog2dialog');
		var headerBox = dialog.getDescendantOfName("header");
		headerBox.setCursor("move");
		headerBox.setCanMove(jsx3.Boolean.TRUE);
		mx.Dialog._enableMouseTracking(headerBox);
		dialog.setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
	};

	ELog2.stopELog = function() {
		//appLogger.info("stopELog: START");
		if (ELog2.eLogNoter) {
			if (window['monitor_var']) {
				clearTimeout(window['monitor_var']);
			}
			if (window['notif_var']) {
				clearTimeout(window['notif_var']);
			}
			if (window['enbl_notif_var']) {
				clearTimeout(window['enbl_notif_var']);
			}
			if (window['migrationMonitor_var']) {
				clearTimeout(window['migrationMonitor_var']);
			}
			//appLogger.info("stopELog: MONITORING STOPED");
			ELog2.enabled = false;
			ELog2.appletEnabled = false;
			if(window.jsDebug){ appLogger.info("ELog2.stopELog: NOTIFICATIONS STOPED"); }
		}
		else {
			if (window['stop_var']) {
				clearTimeout(window['stop_var']);
			}
			window['stop_var'] = window.setTimeout(function() {
				ELog2.stopELog();
			}, 10);
			if(window.jsDebug){ appLogger.info("ELog2.stopELog: IMPOSSIBLE TO STOP, TRYING AGAIN..."); }
		}
	};

	ELog2.startELog = function() {
		//appLogger.info("startELog: START");
		if (ELog2.eLogNoter) {
			ELog2.notificationMonitor();
			ELog2.migrationMonitor();
            if(window.jsDebug){ appLogger.info("ELog2.startELog: MONITORING STARTED"); }

			if (window['notif_var']) {
				clearTimeout(window['notif_var']);
			}
			window['notif_var'] = window.setTimeout(function() {
				ELog2.checkNotifications(true);
			}, ELog2.notificationsPeriod);

			ELog2.appletEnabled = true;
			if(window.jsDebug){ appLogger.info("ELog2.startELog: NOTIFICATIONS STARTED"); }
		}
		else {
			if (window['stop_var']) {
				clearTimeout(window['stop_var']);
			}
			window['stop_var'] = window.setTimeout(function() {
				ELog2.startELog();
			}, 100);
			if(window.jsDebug){ appLogger.info("ELog2.startELog: IMPOSSIBLE TO START, TRYING AGAIN..."); }
		}
	};

	ELog2.showELogExport = function() {
		var exportParams = "role=" + resourceTree.role.obj;
		
		if(ELog2.mode == "archive"){
			exportParams+= "&start_time=" + ELog2.startTs*1000 +
				"&end_time=" + ELog2.endTs*1000;
		}
		
		if(ELog2.message != ""){
			exportParams+= "&msg=" + ELog2.message;
		}
		
		if(ELog2.state != "all"){
			exportParams+= "&event_type=1";
		}
		
		if(ELog2.state != "all"){
			var eState = 0;
			switch (ELog2.state) {
				case 'not_cleared':
					eState = '!8';
				break;
				case 'not_acknowledged':
					eState = '!4';
				break;
				case 'cleared':
					eState = 8;
			}
			exportParams+= "&event_state=" + eState;
		}
		
		window.open("/sdi/eventexport/?" + exportParams, "EXPORT", "width=300,height=310,toolbar=no,scrollbars=no,location=no,status=no,resizable=no");
	};

	jsx3.lang.Package.definePackage(
		"mx.ELog2", //the full name of the package to create
		function(service) {          //name the argument of this function
			//call this method to begin the service call (eg.service.callget_dataset();)
			service.servicelookupEventLifespan = function() {
				//return;

				var objService = matrix2.loadResource("lookupEventLifespan_xml");
				objService.setOperation("get_dataset");

				//subscribe
				objService.subscribe(jsx3.net.Service.ON_SUCCESS, service.servicelookupEventLifespanSuccess);
				objService.subscribe(jsx3.net.Service.ON_ERROR, service.servicelookupEventLifespanError);
				objService.subscribe(jsx3.net.Service.ON_INVALID, service.servicelookupEventLifespanInvalid);

				//PERFORMANCE ENHANCEMENT: uncomment the following line of code to use XSLT to convert the server response to CDF (refer to the API docs for jsx3.net.Service.compile for implementation details)
				//objService.compile();

				//call the service
				objService.setEndpointURL(mx.MATRIX2.getServerURL()+"/axis2/services/LookupService");
				objService.doCall();
			};

			service.servicelookupEventLifespanSuccess = function(objEvent) {
				//var responseXML = objEvent.target.getInboundDocument();
				ELog2.setEventLifespanLikeTimeInterval();
			};

			service.servicelookupEventLifespanError = function(objEvent) {
				var myStatus = objEvent.target.getRequest().getStatus();
				//objEvent.target.getServer().alert("Error","The service call failed. The HTTP Status code is: " + myStatus);
				//alert("Error");
			};

			service.servicelookupEventLifespanInvalid = function(objEvent) {
				//objEvent.target.getServer().alert("Invalid","The following message node just failed validation:\n\n" + objEvent.message);
				//alert("Invalid");
			};

		}
	);

	jsx3.lang.Package.definePackage(
		"mx.ELog2", //the full name of the package to create
		function(service) {          //name the argument of this function
			//call this method to begin the service call (eg.service.callget_dataset();)
			service.servicelookupEventState = function() {
				var objService = matrix2.loadResource("lookupEventState_xml");
				objService.setOperation("get_dataset");

				//subscribe
				objService.subscribe(jsx3.net.Service.ON_SUCCESS, service.servicelookupEventStateSuccess);
				objService.subscribe(jsx3.net.Service.ON_ERROR, service.servicelookupEventStateError);
				objService.subscribe(jsx3.net.Service.ON_INVALID, service.servicelookupEventStateInvalid);

				//PERFORMANCE ENHANCEMENT: uncomment the following line of code to use XSLT to convert the server response to CDF (refer to the API docs for jsx3.net.Service.compile for implementation details)
				//objService.compile();

				//call the service
				objService.setEndpointURL(mx.MATRIX2.getServerURL()+"/axis2/services/LookupService");
				objService.doCall();
			};

			service.servicelookupEventStateSuccess = function(objEvent) {
				//var responseXML = objEvent.target.getInboundDocument();
			};

			service.servicelookupEventStateError = function(objEvent) {
				var myStatus = objEvent.target.getRequest().getStatus();
				//objEvent.target.getServer().alert("Error","The service call failed. The HTTP Status code is: " + myStatus);
				//alert("Error");
			};

			service.servicelookupEventStateInvalid = function(objEvent) {
				//objEvent.target.getServer().alert("Invalid","The following message node just failed validation:\n\n" + objEvent.message);
				//alert("Invalid");
			};

		}
	);

	ELog2.setEventLifespanLikeTimeInterval = function() {
		var CDF_eventlifespan = mx.MATRIX2.getServer().getCache().getDocument("CDF_eventlifespan");

		//alert("ok0:"+CDF_eventlifespan);
		if(window.jsDebug){ appLogger.info("ELog2.setEventLifespanLikeTimeInterval: "+prepareXMLforLogger(CDF_eventlifespan.getRootNode()));}

		var lifespanNodes = CDF_eventlifespan.getRootNode().selectNodes("//record[@name='eventpriority']");

		//alert("ok0.1:"+lifespanNodes);

		var str = '<data jsxid="jsxroot">';
		for (var i = 0; i < lifespanNodes.size(); i++) {
			var hours = lifespanNodes.get(i).getParent().selectSingleNode(".//record[@name='preserverhours']").getAttribute('value');
			str += '<record jsxid="' + lifespanNodes.get(i).getAttribute('value') + '" jsxtext="' + ELog2.translateHoursIntoReadableFormat(hours) + '" eventlifespan="' + lifespanNodes.get(i).getAttribute('value') + '" preserverhours="' + hours + '"/>';
		}
		str += '</data>';

		//var CDF_eventlifespanfordialog = new jsx3.xml.CDF.Document().loadXML(str);
		//mx.MATRIX2.getServer().getCache().setDocument("CDF_eventlifespan", CDF_eventlifespanfordialog);

		//alert("ok1:"+str);

		var dialog = mx.MATRIX2.getServer().getJSXByName('eLog2dialog');
		var select = dialog.getDescendantOfName('storagePriority');
		select.setEnabled(jsx3.gui.Form.STATEDISABLED, true);
		select.resetCacheData();
		var docSelect = select.setXMLString(str);

		ELog2.updateLifespanByPriority();
		select.getParent().repaint();
	};

	ELog2.translateHoursIntoReadableFormat = function(hours){
		//if(window.jsDebug){ appLogger.info("ELog2.translateHoursIntoReadableFormat: hours="+hours); }
		var str = '';
		hours = parseInt(hours, 10);

		var years = Math.floor(hours/8640);
		if(years > 0)
			str+= years + ' yr(s) ';

		var months = Math.floor((hours-years*8640)/720);
		if(months == 1){
			str+= months + ' month ';
		}
		else if(months > 1){
			str+= months + ' mon(s) ';
		}

		var days = Math.floor((hours-years*8640-months*720)/24);
		if(days > 0)
			str+= days + ' day(s) ';

		if(hours == -1){
			str = 'content-dependent';
		}else if(hours == -2){
			str = 'space-limited';
		}else if(hours > 24){
			var h_hours = hours-years*8640-months*720-days*24;
			if(h_hours > 0){
				str+= h_hours + ' hr(s)';
			}
		}
		else{
			str = hours+' hr(s)';
		}
		//if(window.jsDebug){ appLogger.info("ELog2.translateHoursIntoReadableFormat: str="+str); }
		return str;
	};

	ELog2.updateLifespanByPriority = function(){
		var dialog = mx.MATRIX2.getServer().getJSXByName('eLog2dialog');
		//alert(dialog.getDescendantOfName('eventPriority').getXML().getRootNode());
		var select = dialog.getDescendantOfName('storagePriority');
		select.setValue(dialog.getDescendantOfName('eventPriority').getValue());
		select.getParent().repaint();
	};


	/**
	 * Serialize Elog to store its settings in configuration
	 */
	ELog2.serialize = function() {
		appLogger.time('ELog.serialize');

		var data = {
			mode: ELog2.mode,
			device: ELog2.device,
			state: ELog2.state,
			message: ELog2.message,
			witnesses: ELog2.includeWitnesses,

			startTs: ELog2.startTs,
			endTs: ELog2.endTs,
			scale: ELog2.timelineScale,
			interval: ELog2.archiveInterval
		};

		appLogger.timeEnd('ELog.serialize');
		return data;
	};

	/**
	 * Unserialize Elog settings and apply them
	 * @param data
	 */
	ELog2.unserialize = function(data) {

		appLogger.time('ELog.unserialize');

		ELog2.mode = data.mode;
		ELog2.startTs = data.startTs;
		ELog2.endTs = data.endTs;
		ELog2.timelineScale = data.scale;
		ELog2.archiveInterval = data.interval;
		ELog2.device = data.device;
		ELog2.state = data.state;
		ELog2.includeWitnesses = data.witnesses;
		ELog2.message = data.message;

		ELog2.applyFilters();

		appLogger.timeEnd('ELog.unserialize');
	};

	/**
		find suitable witness for event without permittions for device main device
	**/
	ELog2.witnessIntoMainDev = function(witnesses){
		var devNode = null;
		if(witnesses.length > 0){
			//try to find camera
			for (j = 0; j < witnesses.length; j++) {
				devNode = resourceTree.getObject(witnesses[j]);
				if(devNode && devNode.attr("DEVICETYPE") == "CAMERA"){
					break;
				}
			}

			//try to find any device if no cameras present
			if(!devNode){
				for (j = 0; j < witnesses.length; j++) {
					devNode = resourceTree.getObject(witnesses[j]);
					if(devNode){
						break;
					}
				}
			}
		}
		return devNode;
	};


	ELog2.initTimeline = function() {

		jsx3.GO('ELogTimelineBlock').setText(
			'<table width="100%" id="ELogTimelineControls" style="visibility: visible; white-space: nowrap"><tr>' +
				'<td width="150">' +
					__('Scale: ') +
					'<select id="ELogScale">' +
						'<option value="min" seconds="300">5 min</option>' +
						'<option value="hour" seconds="14400" selected="selected">4 hours</option>' +
						'<option value="day" seconds="86400">1 day</option>' +
					'</select>' +
					'<button id="elog_toggle_calendar">C</button>' +
				'</td>' +
				'<td style="min-width: 200px"><div id="ELogTimeline" style="height: 30px; visibility: hidden"></div></td>' +
				'<td width="70">' +
					'<button id="ELog_prev_page" title="' + __('Previous page') + '">&laquo;</button>' +
					'<button id="ELog_next_page" title="' + __('Next page') + '">&raquo;</button>' +
				'</td>' +
				'<td width="160" style="text-align: left">' +
					'<span style="font-size: 10px" id="ELog_start_time"></span><br>' +
					'<span style="font-size: 10px" id="ELog_end_time"></span>' +
				'</td>' +
			'</tr></table>', true
		);

		ELog2.timeline = new TimeLine({
			id: "#ELogTimeline",
			variableName: "mx.ELog2.timeline",
			isDebug: false,
			oneLine: true
		});

		$('#ELogScale').val(mx.ELog2.timelineScale);
		$('#ELogScale').change(function() {
			mx.ELog2.archiveInterval = $(this).find('option:selected').attr('seconds');
			mx.ELog2.timelineScale = this.value;
			mx.ELog2.timeline.setParameters({scale:{granularity: this.value}});
			ELog2.setArchiveInterval(mx.ELog2.startTs, true);
		});
		$('#ELog_prev_page').click(function() {
			ELog2.setArchiveInterval(mx.ELog2.startTs, false);
		});
		$('#ELog_next_page').click(function() {
			ELog2.setArchiveInterval(mx.ELog2.endTs, true);
		});

		$('#elog_toggle_calendar').click(function() {
			if ($('#elog_calendar').length) {
				$('#elog_calendar').remove();
			} else {

				$('body').append('<div id="elog_calendar" style="position: absolute; top: ' + ($(this).offset().top + 25) + 'px; left: ' + ($(this).offset().left + 20) + 'px; z-index: 100;"></div>');
				$('#elog_calendar').jCal({
					day: new Date(),
					days: 1,
					showMonths: 1,
					monthSelect: false,
					callback: function (day) {
						ELog2.setArchiveInterval(new Date(day.getFullYear(), day.getMonth(), day.getDate(), 12).getTime() / 1000, true);
						$('#elog_calendar').remove();
					}
				});
			}
		});

		ELog2.timeline.init();

		ELog2.timeline.onLoad = function() {
            mx.ELog2.timeline.setParameters({
	            selection: {fixed: true, sticky: mx.ELog2.timeline.SELECTION_STICKY_TO_VIEW},
	            scale: {granularity: ELog2.timelineScale},
	            dateFormat: mx.MATRIX2.getIdentityValue("NLS_LONG_DATE_FORMAT")
            });
			mx.ELog2.timeline.setTime((new Date()).getTime(), false);

            mx.ELog2.timeline.onDebug = function(message, type){ appLogger.info("TIMELINE.onDebug: "+message) };

			mx.ELog2.timeline.onGetData = function(itimeLine, istartTime, ifinishTime, igranularity ){
                if(window.jsDebug){ appLogger.info("mx.ELog2.timeline.onGetData: istartTime = " + istartTime + ", ifinishTime = " + ifinishTime) }
                if(istartTime > 0 && ifinishTime > 0){
				    mx.TIMELINE.getEventsStatistics(istartTime/1000, ifinishTime/1000, igranularity);
                }
			};

			mx.ELog2.timeline.onSelectionChange = function(line, beginTime, endTime) {
				if (line == 'up' && mx.ELog2.mode == 'archive' && beginTime != null) {
					if(mx.ELog2.timelineAutoSelection){
						mx.ELog2.timelineAutoSelection = false;
						return;
					}
					mx.ELog2.setArchiveInterval(beginTime / 1000, false);
				}
			};

            //if(window.jsDebug){ appLogger.info("ELog2.timeline.onLoad: mx.ELog2.mode="+mx.ELog2.mode)}
			if (mx.ELog2.mode != 'archive') {
				$('#ELogTimelineControls, #ELogTimeline').css('visibility', 'hidden');
			} else {
				mx.ELog2.setMode('archive', mx.ELog2.startTs);
			}
		};
	};

	/**
	 * Set Elog mode
	 * @param mode    'live' || archive || 'announced'
	 */
	ELog2.setMode = function(mode, tStart) {
		if (mode) {
			ELog2.mode = mode;
		} else {
			var selector = jsx3.GO("elModeSelector");
			ELog2.mode = $(selector.getRendered()).find('option[value="'+selector.getValue()+'"]').text().toLowerCase();
		}

		if(jsDebug){ appLogger.info("ELog2.setMode: newMode=" + ELog2.mode); }

		ELog2.clearELog();

		var filtersButton = jsx3.GO("eLog2Root").getDescendantOfName('showELogFilters');

		if (ELog2.mode == 'announces') {
			$('#ELogTimelineControls, #ELogTimeline').css('visibility', 'hidden');

			filtersButton.setDisplay(jsx3.gui.Block.DISPLAYNONE, true);

			ELog2.setELogVisualState(1);
			api.getAnnounceEventList()
				.fail(function(code, message){
					ELog2.setELogVisualState(2);
				})
				.done(function(response){
					mx.ELog2.addAnnouncedEvents(response.list);
					ELog2.setELogVisualState(0);
				});
		} else if (ELog2.mode == 'archive') {
			filtersButton.setDisplay(jsx3.gui.Block.DISPLAYBLOCK, true);
			$('#ELogTimelineControls, #ELogTimeline').css('visibility', 'visible');
			if (tStart && tStart != 0) {
				ELog2.setArchiveInterval(tStart, true);
			} else {
				var serverTime = mx.MATRIX2.getServerTime();
				ELog2.setArchiveInterval(serverTime / 1000, false);
			}
		} else {
			filtersButton.setDisplay(jsx3.gui.Block.DISPLAYBLOCK, true);
			ELog2.pageNum = 0;
			ELog2.startTs = 0;
			ELog2.endTs = 0;

			$('#ELogTimelineControls, #ELogTimeline').css('visibility', 'hidden');
			ELog2.applyFilters();

			if(jsx3.GO("ge_cell")){
				mx.GE.designation.hideArchiveTrails();
			}
		}
	};

	/**
	 *
	 * @param tStart      start timestamp
	 * @param toFuture    bool
	 */
	ELog2.setArchiveInterval = function(tStart, toFuture) {
		if (tStart == 0){
			return;
		}
		if (toFuture == undefined) {
			toFuture = true;
		}

		ELog2.calculateFilters();

		$.ajax({
			async: false,
			data: {
				'function': 'getEventsInterval',
				'start': tStart,
				'interval': ELog2.archiveInterval,
				'toFuture': toFuture,
				'count': 100,
				'filter': JSON.stringify({
					'obj': (ELog2.device == 'full' ? [] : ELog2.objids.split(' ')),
					'tag': ELog2.tag,
					'tagOnFlag': ELog2.tagOnFlag
				})
			},
			success: function(data) {
				if (data.error && data.error != "") {
					appLogger.error("Error in getEventsInterval API call: " + data.error);
					return;
				}
				ELog2.startTs = data.start;
				ELog2.endTs = data.end;
				ELog2.applyFilters();

				var startTS = ELog2.startTs * 1000 + (new Date()).getTimezoneOffset()*60*1000 + mx.TIME.currentTimezoneOffset;
				var endTS = ELog2.endTs * 1000 + (new Date()).getTimezoneOffset()*60*1000 + mx.TIME.currentTimezoneOffset;

				if(window.jsDebug){ appLogger.error("setArchiveInterval: ELog2.startTs=" + ELog2.startTs + ", ELog2.endTs=" + ELog2.endTs + ", startTS=" + startTS + ", endTS=" + endTS); }

				ELog2.timeline.setTime((startTS + endTS) / 2, false);
				ELog2.timelineAutoSelection = true;
				ELog2.timeline.setSelection(startTS, endTS, false);

				$('#ELog_start_time').html(__("From:") + mx.TIME.timestamp2date(ELog2.startTs * 1000));
				$('#ELog_end_time').html(__("To:") + "&nbsp;&nbsp;&nbsp;&nbsp;" + mx.TIME.timestamp2date(ELog2.endTs * 1000));

				ELog2.adjustScaleFilter();
			},
			error: function() {
				//msg
			}
		});
	};

	ELog2.timelineAutoSelection = false;

	ELog2.adjustScaleFilter = function() {

		function getFormattedInterval(interval) {
			var result = '';

			if (interval > 3600) {
				result += Math.floor(interval / 3600) + ' ' + __('hour') + ' ';
				interval %= 3600;
			}
			if (interval > 60) {
				result += Math.floor(interval / 60) + ' ' + __('min') + ' ';
				interval %= 60;
			}
			if (interval) {
				result += interval + ' ' + __('sec');
			}

			return result;
		}


		var interval = ELog2.endTs - ELog2.startTs;
		$('#ELogScale option[value="custom"]').remove();
		if (interval != ELog2.archiveInterval) {
			$('#ELogScale').prepend('<option disabled seconds="' + interval + '" value="custom">' + getFormattedInterval(interval) + '</option>').val('custom');
		} else {
			$('#ELogScale').val(mx.ELog2.timelineScale);
		}

	};

	ELog2.fillAudit = function(eventId){
		var auditContainer = mx.MATRIX2.getServer().getJSXByName("tabEA").getDescendantOfName("pane").getRendered();
		$(auditContainer).html('');
		auditObj.create($(auditContainer), mx.MATRIX2.getIdentityValue("NLS_LONG_DATE_FORMAT"), 25, true)
			.done(function(){
				auditObj.objid = eventId;
				auditObj.from = null;
				auditObj.to = null;
				auditObj.categories = [16];
				auditObj.callGetAuditRecords();
			});
	};

	ELog2.setTargetTrails = function() {
		if (ELog2.mode != 'archive' || ELog2.startTs == 0)
			return;

		// Check if function is called with same selection as before to avoid too frequent calling of GE
		if (ELog2.setTargetTrails.startTs === ELog2.startTs && ELog2.setTargetTrails.endTs === ELog2.endTs)
			return;

		ELog2.setTargetTrails.startTs = ELog2.startTs;
		ELog2.setTargetTrails.endTs = ELog2.endTs;

		var Ids = [];
		// If ELog in archive state get geo-referenced events and pass them to geo module
		$('#eLog2_container tr[GISREF="gisref"]').each(function() {
			Ids.push(this.getAttribute('EVENTID'));
		});

		mx.GE.designation.showArchiveTrails(Ids, ELog2.startTs, ELog2.endTs);
	};

	/**
	 * check is event still exists in DB
	 * @param eventid      event id
	 */
	ELog2.isEventExists = function(eventid) {
		var isExists = false;
		$.ajax({
			async: false,
			cache: false,
			data: {
				'function': 'isEventExists',
				'eventid': eventid
			},
			success: function(data) {
				if (data.error && data.error != "") {
					appLogger.error("Error in isEventExists API call: " + data.error);
					return;
				}
				isExists = data.exists;
			},
			error: function() {
				appLogger.error("Network error in isEventExists API call");
			}
		});

		return isExists;
	};


	/**
	 *  announce event
	 */
	ELog2.announceEvent = function(){
		var dialog = mx.MATRIX2.getServer().getJSXByName('eLog2dialog');
		var eventId = dialog.getAttribute("eventId");
		var note = dialog.getDescendantOfName('newEventNote').getValue();

		var announceTarget = dialog.getDescendantOfName('announceTarget');

		if(announceTarget.getValue() == 1){ // to role
			var roleId = resourceTree.role.obj;

			api.announceEventToRole({
				eventid: eventId,
				roleid: roleId,
				note: note
			})
			.fail(function(code, message){
				appLogger.error("Error in announceEvent API call: " + "[" + code + "]" + message);
			})
			.done(function(){
				mx.MATRIX2.showMessage(__("Event log"), __("Event") + " " + eventId + " " + __("announced") + " to '" + resourceTree.role.name + "'!");
			});
		}
		else if(announceTarget.getValue() == 2){ // to individual users
			var usersList = dialog.getDescendantOfName('usersList');
			var usersListInputed = usersList.getValue().split(",");
			var usersToSend = [];

			// filter users
			for(var i = 0; i < usersListInputed.length; i++){
				for(var j = 0; j < ELog2.announceRoleUsers.user.length; j++){
					// if user exists and not in list
					if(usersListInputed[i].trim() == ELog2.announceRoleUsers.user[j].name && $.inArray(ELog2.announceRoleUsers.user[j].obj, usersToSend) == -1){
						usersToSend.push(parseInt(ELog2.announceRoleUsers.user[j].obj));
					}
				}
			}

			api.announceEventToUser({
				eventid: parseInt(eventId),
				useridList: JSON.stringify(usersToSend),
				note: note
			})
			.fail(function(code, message){
				appLogger.error("Error in announceEvent API call: " + "[" + code + "]" + message);
			})
			.done(function(){
				mx.MATRIX2.showMessage(__("Event log"), __("Event") + " " + eventId + " " + __("announced") + " to list of users!");
			});
		}
	};

	/**
	 *  mark announced event as read
	 */
	ELog2.markAnnouncedEventAsRead = function(eventid){
		api.markAnnounceEventAsRead({
			eventList: JSON.stringify([eventid])
			})
			.fail(function(code, message){
				appLogger.error("Error in markAnnounceEventAsRead API call: " + "[" + code + "]" + message);
			});
	};

	/**
	 *  get users for event announce
	 */
	ELog2.getAnnounceRoleUsers = function(){
		$.ajax({
			url: '/api/call.php',
			data: {
				'function': 'getAnnounceRoleUserList'
			},
			async: true,
			cache: false,
			dataType: "json",
			success: function(data, status, request) {
				mx.ELog2.announceRoleUsers = data['list'];
			}
		});
	};

	/**
	 *  add announced events to GUI
	 */
	ELog2.addAnnouncedEvents = function(events){
		var cacheDoc = mx.MATRIX2.getServer().getCache().getDocument("CACHE_EVENTSLIST");
		events.forEach(function(event, index){
			var newRecord = ELog2.event2CDFRecord(event, cacheDoc.createNode(jsx3.xml.Entity.TYPEELEMENT, "record"));
			if (!newRecord) {
				return;
			}
			ELog2.addDOMEvent(newRecord);
		});
	};

	/**
	 *  check announced events
	 */
	ELog2.checkAnnouncedEvents = function(){
		api.countAnnouncedEvents()
			.done(function(data){
				if(data.error == ""){
					if(parseInt(data.amount) > 0){
						mx.ELog2.showAnnounceNotification(data.amount);
					}
				}
				else{
					appLogger.error("Error in countAnnouncedEvents API call: " + data.error);
				}
			});
	};

	/**
	 *  show announce notification
	 */
	ELog2.showAnnounceNotification = function(amount, eventData){
		var html = "";

		if(eventData){
			var imURL = resourceTree.getSnapshotHref(eventData.objId, eventData.utc.when);
			var obj = resourceTree.getObject(eventData.objId);
			var udid = obj.udid || eventData.objId;
			html+= '[' + udid + '] ' + obj.name;
			html+= '<br /><img id="announce_img" width="100%" src="' + imURL + '">';
			html+= '<br />' + $('<div/>').text(eventData.noteLast).html();
			html+= '<br />' + __("Announced by ") + eventData.announcedby;
		}

		if(parseInt(amount) > 1 || (eventData == null && parseInt(amount) > 0)){
			if(eventData != null){
				html+= '<br /><br />';
			}

			html+= amount + __(" more event announces waiting review");
			html+= '<br /><button id="announce_review_button">' + __("Review announced events") + '</button>';
		}

		mx.Dialog.createDialog(
			"gui_event_announce",
			'&nbsp;' + __("Announce"),
			{top: 200, left: '10px', width: '300px', 'text-align': 'center'},
			html + '<br/>'
		);

		$("#announce_review_button").on("click", function(){
			mx.ELog2.showAnnouncedEvents();
			mx.ELog2.closeAnnounceNotification();
		});

		$("#announce_img").on("click", function(){
			mx.ELog2.openWitnessesLayout("" + eventData.objId, eventData.id, true);
			mx.ELog2.markAnnouncedEventAsRead(eventData.id);
		});

		//play sound notification
		mx.MATRIX2.getServer().getJSXByName("sound_dive").play();
	};

	/**
	 *  close announce notification
	 */
	ELog2.closeAnnounceNotification = function(){
		if($('#gui_event_announce').size() > 0){
			$('#gui_event_announce').remove();
		}
	};

	/**
	 *  show announced events
	 */
	ELog2.showAnnouncedEvents = function(){
		var tabName = __("Announces");
		var tab = mx.CT.getTabByName(tabName);
		if(tab == null || !mx.CT.isVisibleTab(tab)){
			tab = mx.CT.createNewTab(tabName);
			if(tab == null){
				// no available tabs
				return;
			}
		}

		if(tab.getDescendantOfName('eLog2Root')){
			mx.CT.onTabSelect(tab);
		}
		else{
			ELog2.elDrop(tab.getFirstChild());
		}

		var modeSelector = jsx3.GO("elModeSelector");
		if(modeSelector.getValue() != 3){
			window.setTimeout(function(){
				modeSelector.setValue(3);
				mx.ELog2.setMode();
			}, 100);
		}
	};

	/**
	 *  subscribe announced events
	 */
	ELog2.subscribeAnnouncedEvents = function(){
		AMQ.subscribe("topic://event.announce." + readCookie("PHPSESSID"), function(messageList){
			var amount = 0;
			var api = new API(false);
			api.countAnnouncedEvents()
				.done(function(data){
					if(data.error == ""){
						amount = parseInt(data.amount);
					}
				});

			messageList.forEach(function(message){
				var response = JSON.parse(message);
				if (response.announce.add)
				{
					var announce = response.announce.add;
					var eventInfo = null;
					api.getEventInfo({
							eventId: announce.eventid
						})
						.done(function(data){
							if(data.error == ""){
								eventInfo = data.event;
								eventInfo.noteLast = announce.note;
							}
						});

					mx.ELog2.showAnnounceNotification(amount, eventInfo);

					if(mx.ELog2.mode == "announces" && eventInfo != null){
						var eventExists = document.getElementById("event_" + announce.eventid);
						var eventsDoc = mx.MATRIX2.getServer().getCache().getDocument("CACHE_EVENTSLIST");
						var newRecord = mx.ELog2.event2CDFRecord(eventInfo, eventsDoc.createNode(jsx3.xml.Entity.TYPEELEMENT, "record"));
						if(eventExists){
							mx.ELog2.updateDOMEvent(newRecord);
						}
						else{
							mx.ELog2.addDOMEvent(newRecord);
						}
					}
				}
				if (response.announce.remove)
				{
					var announce = response.announce.remove;
					var eventExists = document.getElementById("event_" + announce.eventid);

					if(mx.ELog2.mode == "announces" && eventExists){
						mx.ELog2.removeDOMEvent(eventExists);
					}
				}
			});
		});
	};

	/**
	 *  unsubscribe announced events
	 */
	ELog2.unsubscribeAnnouncedEvents = function(){
		AMQ.unsubscribe("topic://event.announce." + readCookie("PHPSESSID"));
	};
});
