jsx3.lang.Package.definePackage(
	"mx.Dialog",
	function(Dialog) {
		
		Dialog.minWidth = 32;
		Dialog.minHeight = 32;
		
		Dialog.IMAGES = {
			'close'     : 'images/design1/dialog/close.png',
			'create'    : 'images/design1/dialog/create.png'
		};
		
		Dialog._dlgMap = {
			'event' : "dialog_AE"
		};

		Dialog.setupDialog = function(block, position, caption) {
			block.setDisplay(jsx3.gui.Block.DISPLAYBLOCK, true);
			block.setVisibility(jsx3.gui.Block.VISIBILITYVISIBLE, true);
			var contentBox = block.getChild("content_box");
			contentBox.removeChildren();
			if (position) {
				Dialog.move(block, position, true);
			}
			if (caption) {
				Dialog._addCaptionBar(contentBox, caption);
			}
			var content = new jsx3.gui.Block("content", 0, 30, position.W - 15, position.H - 47);
			content.setRelativePosition(jsx3.gui.Block.ABSOLUTE);
			contentBox.setChild(content);
			block.repaint();
			return content;
		};

		Dialog.setup = function(strType, objParams) {
			var container = Dialog._getContainer(strType);
			if(container) {
				container.setDisplay(jsx3.gui.Block.DISPLAYBLOCK, true);
				container.setVisibility(jsx3.gui.Block.VISIBILITYVISIBLE, true);
				Dialog["setup" + strType.replace(/^(\w)/, function(m,g){return g.toUpperCase()})] (container, objParams);
				return container;
			}
			return null;
		};
		
		Dialog.close = function(vntDialog) {
			if(typeof(vntDialog) == "string")
				var container = Dialog._getContainer(vntDialog);
			else if(vntDialog instanceof jsx3.gui.Block && vntDialog.getName().search(/dialog_/) > -1)
				container = vntDialog;
			else if(vntDialog instanceof jsx3.gui.ImageButton && vntDialog.getName() == "close")
				container = vntDialog.getParent().getParent();
			
			if(container) {
				container.setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
				container.setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
			}
		};


		/**
		 * Create dialog block on pure html and css and return link to its contents
		 */
		Dialog.createDialog = function(id, caption, css, content, parent) {

			content = content || '';

			if (!id)
				return null;
			if ($('#' + id).length) {
				$('#' + id).remove();
			}

			parent = parent ? $('#' + parent) : $('body');
			parent.append(
				'<div class="dialog" id="' + id + '">' +
					'<div class="header">' +
						caption +
						'<div class="close"></div>' +
					'</div>' +
					'<div class="content">' + content + '</div>' +
				'</div>'
			);
			$('#' + id).css(css);
			// Hack for IE: no support for box-shadow
			if ($.browser.msie) {
				$('#' + id).append(
					'<div class="left"></div>' +
					'<div class="right"></div>' +
					'<div class="top"></div>' +
					'<div class="bottom" style="z-index: -1;"></div>' + // IE7 hack for dropdown lists
					'<div class="top_left"></div>' +
					'<div class="top_right"></div>' +
					'<div class="bottom_left"></div>' +
					'<div class="bottom_right"></div>'
				);
			}

			// Close button
			$('#' + id + ' div.close').click(function() {$('#' + id).remove();});

			return $('#' + id + ' div.content');
		};


		// Create draggable dialog in layout panel
		Dialog.createLayoutDialog = function(id, caption, css, content, parent) {

			if (!id)
				return null;
			if ($('#' + id).length) {
				$('#' + id).remove();
			}

			var clip = {'L': 0, 'W':332, 'T': 0, 'H':$('body').height()};
			css.left = '5px';

			// Process RTL direction
			if (mx.language.lang_direction == 'rtl') {
				clip.L = jsx3.GO('controlPane').getAbsolutePosition().L;
				clip.W = $('body').width();
				delete css.left;
				css.right = '5px';
			}

			Dialog.createDialog(id, caption, css, content, parent);

			// Draggable

			$('#' + id).addClass('drag').drag(function( ev, dd ) {
				var width = $(dd.target).width();
				var height = $(dd.target).height();

				var top = dd.offsetY < clip.T ? clip.T : dd.offsetY;
				top = (top + height > clip.H) ? clip.H - height : top;

				var left = dd.offsetX < clip.L ? clip.L : dd.offsetX;
				left = (left + width > clip.W) ? clip.W - width : left;

				$( this ).css({
					left: left,
					top: top
				});
			},{ handle:"div.header" });

			return $('#' + id + ' div.content');
		};
		
		
		Dialog.getActiveDialog = function(strType) {
			var container = mx.MATRIX2.getServer().getJSXByName(Dialog._dlgMap[strType]);
			return container && container.getVisibility() == jsx3.gui.Block.VISIBILITYVISIBLE ? container : null;
		};
		
		Dialog._getContainer = function(strType) {          
			return mx.MATRIX2.getServer().getJSXByName(Dialog._dlgMap[strType]);
		};
		
		/**
		 * Move/resize dialog container
		 */
		Dialog.move = function(target, pos, bUpdateView) {
		
			if (pos.W >= Dialog.minWidth && pos.W != target.getWidth())
				var bUpdateW = true;
			if (pos.H >= Dialog.minHeight && pos.H != target.getHeight())
				var bUpdateH = true;
			
			if(pos.L >= 0) target.setLeft(pos.L, pos.T>=0||bUpdateW||bUpdateH?false:bUpdateView);
			if(pos.T >= 0) target.setTop(pos.T, bUpdateW||bUpdateH?false:bUpdateView);
			
			if(bUpdateW) {
				target.getChild("top").setWidth(pos.W - 29);
				target.getChild("top_right").setLeft(pos.W - 14);
				target.getChild("bottom").setWidth(pos.W - 29);
				target.getChild("bottom_right").setLeft(pos.W - 14)
				target.getChild("content_box").setWidth(pos.W - 16);
				target.getChild("right").setLeft(pos.W - 9);
				target.setWidth(pos.W, bUpdateH?false:bUpdateView);
			}

			if(bUpdateH) {
				target.getChild("left").setHeight(pos.H - 30);
				target.getChild("right").setHeight(pos.H - 28);
				target.getChild("content_box").setHeight(pos.H - 17);
				target.getChild("bottom_left").setTop(pos.H - 15);
				target.getChild("bottom_right").setTop(pos.H - 14);
				target.getChild("bottom").setTop(pos.H - 8);
				target.setHeight(pos.H, bUpdateView);
			}
		};
		
		
		Dialog._enableMouseTracking = function(header) {
		
			// Must override default handlers for 'mousedown' and 'mouseup'
			header.doBeginMove = function(objEvent, objGUI) {
				if (objEvent.leftButton()) {
					jsx3.gui.Interactive.prototype.doBeginMove.call(this, objEvent, this.getParent().getParent().getRendered());
					jsx3.gui.Event.subscribe(jsx3.gui.Event.MOUSEUP,this,"doEndMove");
                    jsx3.gui.Event.subscribe(jsx3.gui.Event.MOUSEMOVE,this,"doMove");
					objEvent.cancelAll();

					//hide opened Selects components
					var selects = this.getParent().getDescendantsOfType("jsx3.gui.Select", false);
					for(var i=0; i<selects.length; i++) {
						selects[i].hide();
					}
				}
			};

			header.doMove = function(objEvent) {
                if(mx.MATRIX2.checkDialogPosition(this.getParent().getParent())){
                    this.doEvent(jsx3.gui.Interactive.JSXMOUSEUP, {objEVENT:objEvent});
                }
			};

			header.doEndMove = function(objEvt) {
				var objEvent = objEvt.event;
				var objGUI = this.getParent().getParent().getRendered(objEvent);
				if (objEvent.leftButton() || ($.browser.msie && objEvent.zB().button)) {
					jsx3.gui.Event.unsubscribe(jsx3.gui.Event.MOUSEUP,this,"doEndMove");
                    jsx3.gui.Event.unsubscribe(jsx3.gui.Event.MOUSEMOVE,this,"doMove");
					//jsx3.gui.Interactive.prototype.doEndMove.call(this, objEvent, objGUI);
					this.setEvent("mx.MATRIX2.checkDialogPosition(this.getParent().getParent());", jsx3.gui.Interactive.AFTER_MOVE);
					this.doEvent(jsx3.gui.Interactive.AFTER_MOVE, {objEVENT:objEvent});
				} else {
					this._ebMouseUp(objEvent, objGUI);
				}
			};
		};
		
		Dialog._addCaptionBar = function(contentBox, text) {
			var content = new jsx3.gui.Block("content", 8, 5, contentBox.getWidth() - 16, 10, text);
			content.setRelativePosition(jsx3.gui.Block.ABSOLUTE);
			content.setFontWeight("bolder");
			content.setFontName("Verdana,Sans-Serif").setFontSize(12);
			content.setCursor("move");
			content.setTextAlign("left");
			content.setCanMove(jsx3.Boolean.TRUE);
			Dialog._enableMouseTracking(content);
			contentBox.setChild(content);

			var close = new jsx3.gui.ImageButton("close", contentBox.getWidth() - 16, 6, 10, 11);
			close.setRelativePosition(jsx3.gui.Block.ABSOLUTE);
			close.setImage(Dialog.IMAGES['close']);
			close.setTip(__("Close", "Dialog close button tooltip"));
			close.setEvent("mx.Dialog.close(this);", jsx3.gui.Interactive.EXECUTE);
			contentBox.setChild(close);
		};
		
		
		Dialog.setupEvent = function(target, params) {

			target.setAttribute("type", "event");

			var contentBox = target.getChild("content_box");
			contentBox.removeChildren();

			Dialog.move(target, {'L': 5, 'T': 60, 'W':315, 'H':210}, true);
			Dialog._addCaptionBar(contentBox, __("CREATE EVENT"));

			var container = new jsx3.gui.Block("container", 15, 20, 270, 170);
			container.setRelativePosition(jsx3.gui.Block.ABSOLUTE);
			contentBox.setChild(container);

			var style = "font: 11px Verdana,Sans-Serif; white-space: nowrap; display: inline-block; top: 15px;";

			var eventType = new jsx3.gui.Block("event_type", 0, 0, 250, 12, "<b>" + __("Event type", "Event setup") + "</b>");
			eventType.setRelativePosition(jsx3.gui.Block.RELATIVE);
			eventType.setCSSOverride(style + "top: 5px;");
			container.setChild(eventType);

			var eventMenu = new jsx3.gui.NativeSelect('event_menu', 0, 20, 250, 20, __("-Select type-"));
			eventMenu.setRelativePosition(jsx3.gui.Block.RELATIVE);
			eventMenu.setCSSOverride(style + "top: 12px;");
			eventMenu.setXMLString(
				'<data jsxid="jsxroot">' +
					'<record jsxid="0" jsxtext="' + __("Informational", "Event type") + '"/>' +
					'<record jsxid="1" jsxtext="' + __("Alert", "Event type") + '"/>' +
				'</data>'
			);
			container.setChild(eventMenu);
			
			/* i18n: 'from' means "from which time" */
			var eventFrom = new jsx3.gui.Block("event_from", 25, 42, 100, 14, "<b>" + __("From:", "Event setup") + "</b>");
			eventFrom.setRelativePosition(jsx3.gui.Block.RELATIVE);
			eventFrom.setCSSOverride(style);
			container.setChild(eventFrom);

			var eventFromTS = new jsx3.gui.Block("event_from_ts", 128, 42, 150, 14, params ? params['startts'] : "");
			eventFromTS.setRelativePosition(jsx3.gui.Block.RELATIVE);
			eventFromTS.setCSSOverride(style);
			container.setChild(eventFromTS);

			/* i18n: 'to' means "to which time" */
			var eventTo = new jsx3.gui.Block("event_to", 8, 62, 100, 14, "<b>" + __("To:", "Event setup") + "</b>");
			eventTo.setRelativePosition(jsx3.gui.Block.RELATIVE);
			eventTo.setCSSOverride(style);
			container.setChild(eventTo);

			var eventToTS = new jsx3.gui.Block("event_to_ts", 128, 94, 150, 14, params ? params['endts'] : "");
			eventToTS.setRelativePosition(jsx3.gui.Block.RELATIVE);
			eventToTS.setCSSOverride(style);
			container.setChild(eventToTS);

			var eventMsg = new jsx3.gui.Block("event_msg", 8, 110, 200, 14, "<b>" + __("Message Text:", "Event setup") + "</b>");
			eventMsg.setRelativePosition(jsx3.gui.Block.RELATIVE);
			eventMsg.setCSSOverride(style + "top: 20px;");
			container.setChild(eventMsg);

			var eventText = new jsx3.gui.TextBox('event_text', 8, 127, 200, 42, "", jsx3.gui.TextBox.TYPETEXTAREA);
			eventText.setRelativePosition(jsx3.gui.Block.RELATIVE);
			eventText.setCSSOverride(style + "top: 23px;");
			container.setChild(eventText);

			var eventCheckBox = new jsx3.gui.Block("event_mgr", 15, 170, 130, 20,
				'<input type="checkbox" name="event_mgr" id="checkbox_event_mgr" disabled="disabled" />' +
				'<label for="checkbox_event_mgr"><b>' + __("Migrate", "Event setup") + '</b></label>'
			);
			eventCheckBox.setRelativePosition(jsx3.gui.Block.ABSOLUTE);
			eventCheckBox.setTip(__("Migration status", "Event setup"));
			eventCheckBox.setCSSOverride('width: auto;');
			contentBox.setChild(eventCheckBox);
			
			var eventButton = new jsx3.gui.ImageButton("event_button", 280, 170, 16, 16);
			eventButton.setRelativePosition(jsx3.gui.Block.ABSOLUTE);
			eventButton.setImage(Dialog.IMAGES['create']);
			eventButton.setTip(__("Create", "Event setup create button"));
			if(params) eventButton.setEvent(params["oncreate"], jsx3.gui.Interactive.EXECUTE);
			contentBox.setChild(eventButton);

			contentBox.repaint();
			
			// CIRRUS_REPLACE_DIALOG_JS_ID004_BEGIN
			document.getElementById('checkbox_event_mgr').disabled = false;
			// CIRRUS_REPLACE_DIALOG_JS_ID004_END
		};
	}
);