//---------------------------------------------------------------------------------------------------------------
// Custom Tab Class
//---------------------------------------------------------------------------------------------------------------
jsx3.lang.Package.definePackage(
	"mx.CT",                //the full package name
	function(CT) {          //short package name, good to use in this file only.
		//is Safari limit to 1
// CIRRUS_REPLACE_CT_JS_ID002_BEGIN
		CT.numOfTabs = 10;
// CIRRUS_REPLACE_CT_JS_ID002_END
		CT.currentTab = null;

		CT.wallTab = null;        // Single wall tab per application

		CT.isControlPanelOpened = function(){
			var cp = mx.MATRIX2.getServer().getJSXByName('mainLayout').getDescendantOfName('controlPane');
			// If controls pane closed
			return cp.getAbsolutePosition().W > 0;
		};

		CT.mainLayoutChange = function(){
			var ml = mx.MATRIX2.getServer().getJSXByName('mainLayout');
			var img = mx.MATRIX2.getServer().getJSXByName('imageSeparatorArrows');

			// If controls pane closed
			if (ml.getDescendantOfName('controlPane').getAbsolutePosition().W > 0) {
				img.setTip(__("Show Resourse bar"));
				readCookie('lang_direction') == 'rtl'
					? ml.setCols("*,12,0", true)
					: ml.setCols("0,12,*", true);

				$('#conf_dialog div.close').trigger("click");

				$('#resource_tree_root').hide();
			} else {
				img.setTip(__("Hide resource bar"));
				readCookie('lang_direction') == 'rtl'
					? ml.setCols("*,12,322", true)
					: ml.setCols("322,12,*", true);
				showLayoutControls();
				$('#resource_tree_root').show();
			}
			mx.MATRIX2.invertSeparatorArrows('imageSeparatorArrows');

			//mx.MATRIX2.splitterResize(mx.MATRIX2.getServer().getJSXByName('players_pane'), null);
			mx.MATRIX2.getServer().getJSXByName('players_pane').doEvent(jsx3.gui.Interactive.DROP, {});
			mx.vMX.onLayoutResize();
			if(jsx3.CLASS_LOADER.FX){
				//mx.MATRIX2.splitterResize(mx.MATRIX2.getServer().getJSXByName('players_pane'), null);
				mx.MATRIX2.getServer().getJSXByName('players_pane').doEvent(jsx3.gui.Interactive.DROP, {});
			}
		};

		CT.cellInTab = function(objThis){
			var tab = CT.createNewTab();
			var objCell = objThis.getAncestorOfName("cell_blk");
			if(tab!=null){
				//check player mode(live/archive)
				var objectId = objCell.getAttribute('objectId');
				var objDest = tab.getFirstChild();
				var objName = resourceTree.getObject(objectId).name;
				tab.doShow();

				var newCell = null;
				//if live
				if(objCell.getAttribute("player_mode")== "0"){
					newCell = mx.MATRIX2.createCell(objectId, objName, objDest, false);
					//appLogger.info("cellInTab: TO LIVE");
				}else if(objCell.getAttribute("player_mode")== "1") {//if archive

					//if simple archive video
					if(objCell.getAttribute("eventid")=="-1"){
						//appLogger.info("cellInTab: TO ARCHIVE");
						newCell = mx.MATRIX2.createCell(objectId, objName, objDest, false, null, null, true);
						newCell.setAttribute("player_mode","1");
					}
					else if(objCell.getAttribute("eventid")!="-1") {//if event
						//appLogger.info("cellInTab: EVENT");
						var curEventId = objCell.getAttribute("eventid");
						var event_ts_from = objCell.getAttribute("event_ts_from");
						var event_ts_to = objCell.getAttribute("event_ts_to");

						// emulate event cell drop
						/* i18n: %1 is an event id */
						newCell = mx.MATRIX2.createCell(objectId, Gettext.strargs(__("Event ID: %1"), [curEventId]), objDest, false, event_ts_from, event_ts_to);
						isPlayInArchive = true;

					}

					newCell.setAttribute("close_previous","false");
					newCell.setAttribute("time_zone", objCell.getAttribute("time_zone"));
					newCell.setAttribute("dst_from",  "0");
					newCell.setAttribute("dst_to",    "0");
				}
				//select new cell
				window.setTimeout(function(){ mx.MATRIX2.setSelectedGroup(newCell.getDescendantOfName("cell_select"),null,false); }, 10);
			}
		};

		CT.removeTab = function(objTab, event) {
			//appLogger.info("removeTab: objTab="+objTab);

			// Prevent Tibco click handler, which sets removed tab active
			if (event = event || window.event) {
				event.stopPropagation ? event.stopPropagation() : (event.cancelBubble=true);
			}

			var tabpane = mx.MATRIX2.getServer().getJSXByName('tabbedpaneMain');
			var tabs = tabpane.getChildren();

			if(objTab==null){
				var childToRemove = tabs[tabpane.getSelectedIndex()];
			}else if(typeof(objTab)=="number"){
				childToRemove = tabs[objTab];
			}else{
				childToRemove = objTab;
			}

			CT.clearTab(childToRemove);

			childToRemove.setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
			childToRemove.setText(mx.CT.getTabIndex(childToRemove) + 1, true);
			childToRemove.removeAttribute("wallid");
			childToRemove.removeAttribute("curType");
			
			var defaultInitText = CT.getTabIndex(childToRemove).toString() + 1;
			if(childToRemove.getAttribute("initText") != defaultInitText){
				childToRemove.setAttribute("initText", defaultInitText);
			}

			if(CT.getActiveTab() == childToRemove) {
				for(var i = 0; i < CT.numOfTabs; i++){
					if(tabs[i].getDisplay() == "" && tabs[i].getAttribute("curType") != 'vmx'){
						tabs[i].doShow();
						CT.onTabSelect(tabs[i], i);
						break;
					}
				}
			}
			else{
				CT.updateCloseButtons();
			}

			checkMotionSearchIcon();

			//appLogger.info("removeTab: OK");
		};

		CT.clearTab = function(childToRemove){
			//hide eLog, if tab has it
			if(childToRemove.getDescendantOfName('eLog2Root')){
				mx.ELog2.elHide();
			}
			
			//hide CDM, if tab has it
			if(childToRemove.getDescendantOfName('cdm_cell')){
				mx.CDM.btnCellClose(childToRemove.getDescendantOfName('cdm_cell').getDescendantOfName('cell_btn_close'));
			}

			//remove tourings
			while(childToRemove.getFirstChild().getDescendantOfName("cell_blk")
				 && childToRemove.getFirstChild().getDescendantOfName("cell_blk").getParent().getAttribute("tourBlock")
				 && childToRemove.getFirstChild().getDescendantOfName("cell_blk").getParent().getAttribute("tourBlock")=="1"){
				mx.TOUR.btnTourClose(childToRemove.getFirstChild().getDescendantOfName("cell_blk").getDescendantOfName("cell_btn_close"));
			}

			//up-pin cells
			var frames = childToRemove.getFirstChild().getDescendantsOfType("jsx3.gui.IFrame", false);
			if(frames){
				for(var framesCount = 0; framesCount < frames.length; framesCount++) {
					var cellObj = frames[framesCount].getAncestorOfName('cell_blk');

					// if frame in pined player
					if(cellObj != null && cellObj.getName() == 'cell_blk' && !cellObj.getParent().getAttribute("tourBlock")){
						//if cell pined, unpin it
						/*if(cellObj.getDescendantOfName("cell_pin").getState() == jsx3.gui.ImageButton.STATE_ON){
							mx.MATRIX2.btnPinHandler(cellObj.getDescendantOfName("cell_pin"));
						}*/

						//remove all deleting players from groups
						var player = mx.MATRIX2.getObjFromIFrame('_mplayer_', cellObj);
						var sp = mx.MATRIX2.getObjFromIFrame('_mplayer_SoundPlayer', cellObj);

						if(activeGroup_Cell != null){
							if(activeGroup_Cell.isPlayerInGroup(player)){
								activeGroup_Cell.removePlayer(player);
							}
							if(activeGroup_Cell.isPlayerInGroup(sp)){
								activeGroup_Cell.removePlayer(sp);
							}

							//if last frame and group is empty
							if(activeGroup_Cell.players.length == 0 && framesCount == (frames.length-1)){
								mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls.unsetGroup();
							}
						}
						mx.MATRIX2.btnCellClose(cellObj.getDescendantOfName("cell_close"));
					}

					// Must correctly close ge cell
					if (frames[framesCount].getName() == 'ge_iframe') {
						var cellObj = frames[framesCount].getAncestorOfName('ge_cell');
						mx.MATRIX2.btnCellClose(cellObj.getDescendantOfName('ge_close'));
					}
				}
			}

			if (childToRemove.getAttribute('curType') == 'motion') {
				childToRemove.getFirstChild().removeAttribute('motionSearch');
				var cellId = childToRemove.getFirstChild().getFirstChild().getId();
				$('#' + cellId).data('model').blur();
				$('#' + cellId).data('model').removeObj();
			}

			childToRemove.getFirstChild().removeChildren();
			childToRemove.getFirstChild().setAttribute("playerBlock", "0");
			childToRemove.setAttribute("activeRecording", "");
		};

		CT.initTabs = function(){
			var firstTab = mx.MATRIX2.getServer().getJSXByName('tabbedpaneMain').getChildren()[0];
			firstTab.setPadding("0 0 0 0");
			firstTab.setAttribute("currentActive","true");
			firstTab.setAttribute("activeRecording","");
			firstTab.setAttribute("initText", "1");
			firstTab.setAttribute("curType","general");

			CT.currentTab = firstTab;
			CT.setTabDesignSelected(firstTab);

			CT.updateCloseButtons();
		};

		CT.setTabDesignSelected = function(objTab) {
			if(window.jsDebug){ appLogger.info("CT.setTabDesignSelected: "+objTab); }

			var id = mx.CT.getTabIndex(objTab);
			objTab.setAttribute("rec_img_id", "rec_img_"+id);

			var caption = CT.cutTabName(objTab.getAttribute("initText"));

			var text =
			'<span class="active_left">&nbsp;</span>' +
				'<span class="active_caption" id="tab_drag_' + id + '">';

			if(objTab.getAttribute("activeRecording") != "") {
				text+='<image id="'+objTab.getAttribute('rec_img_id')+'" src="images/design1/tabs/tab_record.png" width="13" height="10" title="' + __("Active recording") + '" border="0">';
			}
			else {
				text+='<image id="'+objTab.getAttribute('rec_img_id')+'" src="images/design1/tabs/tab_record.png" width="0" height="0" title="' + __("Active recording") + '" border="0">';
			}

			text+='<span class="caption_text" title="'+__("Double-click to edit name, drag to RESOURCE panel to save")+'">' + $('<span>').text(caption.name).html() + '</span>';

			if(objTab.getAttribute("curType")!="vmx"){
				text+='<image id="closeTab' + id + '" src="images/design1/tabs/tab_close.png" width="9" height="9">';
			}

			text +=
				'</span>' +
			'<span class="active_right">&nbsp;</span>';

			objTab.setText(text, true);

			// For all tabs except  vMX, ability to rename
			if (objTab.getAttribute("curType")!="vmx" && objTab.getAttribute("curType")!="motion") {
				$("#" + objTab.getId()).dblclick(mx.CT.renameInit);
			}

			VIEWS.setDNDintoViewForTab(id);

			//appLogger.info("objTab.getAttribute(curType)="+objTab.getAttribute("curType"));
			//fix Safari applets  in tabs
			var tabContainer = objTab.getFirstChild();
			//if(jsx3.CLASS_LOADER.SAF/* && objTab.getAttribute("curType") != "vmx"*/){
				tabContainer.setWidth(tabContainer.getAbsolutePosition().W, true);
				tabContainer.setHeight(tabContainer.getAbsolutePosition().H, true);
			//}
			if(objTab.getAttribute("curType") == "vmx"){
				tabContainer.setDisplay(jsx3.gui.Block.DISPLAYBLOCK, true);
			}
			window.setTimeout(function(){
				try {
					//mx.MATRIX2.splitterResize(objTab);
					objTab.doEvent(jsx3.gui.Interactive.DROP, {objSOURCE:"", strDRAGID:""});
				}
				catch (e)
				{
					window.console && window.console.error(e.message);
				}
			}, 50);

			CT.updateCloseButtons();
		};

		CT.setTabDesignDeselected = function(objTab){
			if(window.jsDebug){ appLogger.info("CT.setTabDesignDeselected: "+objTab); }
			var id = mx.CT.getTabIndex(objTab);

			var caption = CT.cutTabName(objTab.getAttribute("initText"));

			var text =
			'<span class="left">&nbsp;</span>' +
				'<span class="caption" id="tab_drag_' + id + '">';

			if(objTab.getAttribute("activeRecording") != ""){
				text += '<image src="images/design1/tabs/tab_record.png" width="13" height="10" title="' + __("Active recording") + '" border="0">';
			}

			// $('<span>').text( string ).html() - analogue of htmlspecialchars in PHP
			text += '<span class="caption_text" title="'+__("Click to activate")+'">' + $('<span>').text(caption.name).html() + '</span>';

			if(objTab.getAttribute("curType") != "vmx"){
				text += '<image id="closeTab' + id + '" src="images/design1/tabs/tab_close.png" width="9" height="9">';
			}

			text +=
				'</span>' +
			'<span class="right">&nbsp;</span>';

			objTab.setText(text, true);
			$("#" + objTab.getId()).unbind('dblclick');

			//appLogger.info("objTab.getAttribute(curType)="+objTab.getAttribute("curType"));
			//fix Safari applets in tabs
			var tabContainer = objTab.getFirstChild();
			//if(jsx3.CLASS_LOADER.SAF){
				tabContainer.setWidth(1, true);
				tabContainer.setHeight(1, true);
			//}
			if(objTab.getAttribute("curType") == "vmx"){
				tabContainer.setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
			}
			CT.updateCloseButtons();
		};

		/**
		 * Cut name of tab to 15 symbols to prevent too wide tabs
		 * @return object
		 *   .name - name of tab, cut to 15 symbols if nesessary,
		 *   .tip - tip of tab, contains full name if tab name was cut, and contains '' if tab name remain the same
		 */
		CT.cutTabName = function(tabName) {

			if (tabName === undefined)
				return {'name': '', 'tip': ''};

			// prevent incorrect load from old configurations
			tabName = tabName.replace(/&nbsp;/g, '');
			if (tabName.length > 15)
				return {'name': tabName.substr(0, 15) + '...', 'tip': tabName };
			else
				return {'name': tabName, 'tip': ''};
		};

		CT.onTabSelect = function(objTab, id) {
			if(window.jsDebug){ appLogger.info("CT.onTabSelect: START - "+objTab+", "+id); }

			if (!objTab || objTab.getDisplay() == 'none' || objTab.getAttribute("currentActive")=="true")
				return true;

			$('#input_tab_rename').remove();

			var tabpane = mx.MATRIX2.getServer().getJSXByName('tabbedpaneMain');
			var tabs = tabpane.getChildren();

			mx.CT.currentTab = objTab;

			//DE1951
			if(jsx3.CLASS_LOADER.SAF && objTab.getDisplay()==jsx3.gui.Block.DISPLAYNONE){
				for(var i=0; i < CT.numOfTabs;i++){
					if(tabs[i].getAttribute("currentActive")){
						window.setTimeout(function() { tabs[i].doShow(); }, 0);
						break;
					}
				}
				return;
			}

			//set last active to unactive
			for(i=0; i < CT.numOfTabs; i++){
				//appLogger.info("onTabSelect: tabs[i]="+tabs[i]+", currentActive="+tabs[i].getAttribute("currentActive"));
				if(tabs[i].getAttribute("currentActive")){
					tabs[i].removeAttribute("currentActive");
					CT.setTabDesignDeselected(tabs[i], "onTabSelect");

					if (tabs[i].getAttribute('curType') == 'motion') {
						if (tabs[i].getFirstChild().getFirstChild()) {
							var cellId = tabs[i].getFirstChild().getFirstChild().getId();
							$('#' + cellId).data('model').blur();
						}
					}

					break;
				}
			}
			// set new active
			objTab.setAttribute("currentActive","true");
			CT.setTabDesignSelected(objTab, "onTabSelect");
			tabpane.setSelectedIndex(objTab, true);

			// DE3336
			// New hack for vMX: if not a vMX tab selected - hide all existing vMX tabs
			//
			// BEGIN_HACK
			if (objTab.getAttribute("curType") != "vmx") {
				for(i=0; i < CT.numOfTabs; i++) {
					if(tabs[i].getAttribute("curType") == "vmx") {
						var tabContainer = tabs[i].getFirstChild();
						tabContainer.setDisplay(jsx3.gui.Block.DISPLAYNONE, true);
					}
				}
			}
			// HACK_ENDS

			if (objTab.getAttribute('curType') == 'motion') {
				if (objTab.getFirstChild().getFirstChild()) {
					var cellId = objTab.getFirstChild().getFirstChild().getId();
					$('#' + cellId).data('model').focus();
				}
			}

			//appLogger.info("onTabSelect: OK");
		};

		CT.createNewTab = function(strText, strType, index) {
			var tabpane = mx.MATRIX2.getServer().getJSXByName('tabbedpaneMain');
			var tabs = tabpane.getChildren();

			if(strType == "vmx" && CT.wallTab != null) {
				return CT.wallTab;
			}

			for(var i = index || 0; i < CT.numOfTabs; i++) {
				if(tabs[i].getDisplay() == "none") {
					tabs[i].setPadding("0 0 0 0");
					tabs[i].getFirstChild().setBorder("solid 2px #E4E4E4");
					tabs[i].setDisplay(jsx3.gui.Block.DISPLAYBLOCK, true);

					var tabNumber = i + 1;

					if(strText){ tabs[i].setAttribute("initText", strText.replace(/&nbsp;/g, '')); }
					else{ tabs[i].setAttribute("initText",tabNumber.toString()); }

					if(strType != null){ tabs[i].setAttribute("curType",strType);	}
					else{ tabs[i].setAttribute("curType","general"); }

					tabs[i].setAttribute("activeRecording","");

					if(strType != "vmx"){
						var shown = tabs[i].doShow();
						CT.onTabSelect(tabs[i], "createNewTab" + tabNumber);
					}
					else{
						CT.setTabDesignDeselected(tabs[i], "createNewTab"+tabNumber);
						CT.wallTab = tabs[i];

						var menuBlock = new jsx3.gui.Block("wall_menu_block", 0, 0, "100%", "30");
						menuBlock.setRelativePosition(jsx3.gui.Block.ABSOLUTE);
						menuBlock.setBackgroundColor("rgb(228, 228, 228)");
						menuBlock.setCanDrop(jsx3.Boolean.TRUE);
						menuBlock.setEvent("1", jsx3.gui.Interactive.DROP);
						tabs[i].getContentChild().setEvent("mx.vMX.showHideMask(false);jsx3.gui.Interactive.hideSpy();", jsx3.gui.Interactive.DROP);
						tabs[i].getContentChild().setChild(menuBlock);
					}

					if (strType == 'motion') {
						checkMotionSearchIcon();
					}

					VIEWS.setDNDintoViewForTab(i);

					//appLogger.info("createNewTab: OK - "+tabs[i]);
					return tabs[i];
				}
			}
			//appLogger.info("createNewTab: OK - block not found");
// CIRRUS_REPLACE_CT_JS_ID001_BEGIN
			mx.MATRIX2.showMessage(__("Layout"), __("Maximum number of allowed tabs reached.\nDelete an existing tab(s), to create new one."));
// CIRRUS_REPLACE_CT_JS_ID001_END
			return null;
		};

		/**
		 * Function creates input field to rename active tab.
		 */
		CT.renameInit = function(event) {

			var $tab = $("#" + mx.CT.currentTab.getId() + ' span.caption_text');
			var text = mx.CT.currentTab.getAttribute("initText");
			text = text.replace(/&nbsp;/g, '');

			$("#" + mx.CT.currentTab.getId()).unbind('dblclick');
			$tab.html(
				'<input type="text" id="input_tab_rename" value="" />&nbsp;'
			);

			var $input = $('#input_tab_rename');
			$input.attr('value', text);
			$input.focus();
			$input.keydown(mx.CT.renameKeypress);
			$input.click(mx.CT.renameKeypress);

		};

		/**
		 * If user press Enter in tab rename input field, it assigns new name to a tab, Esc - cancel renaming
		 */
		CT.renameKeypress = function(event) {

			if (event.keyCode == 13) {			// Enter

				this.value = $.trim(this.value.replace(/&nbsp;/g, ''));
				if (this.value != '') {
					mx.CT.currentTab.setAttribute("initText", this.value);
				}
				mx.CT.setTabDesignSelected(mx.CT.currentTab);
				$('#input_tab_rename').remove();
			} else if (event.keyCode == 27) {	// Esc
				mx.CT.setTabDesignSelected(mx.CT.currentTab);
				$('#input_tab_rename').remove();
			}
			// dont want Tibco to capture this event
			event.stopPropagation ? event.stopPropagation() : (event.cancelBubble=true)
		};

		/**
		 * Return tab index in tabpane
		 */
		CT.getTabIndex = function(tab) {
			var tabpane = mx.MATRIX2.getServer().getJSXByName('tabbedpaneMain');
			var tabs = tabpane.getChildren();

			for(var i=0; i<tabs.length; i++) {
				if(tabs[i] == tab)
					return i;
			}
		};
		
		/**
		 *  Is tab visible
		 */
		CT.isVisibleTab = function(tab){
			if(tab.getDisplay() == "none"){
				return false;				
			}
			else{
				return true;
			}			
		};

		/**
		 * Return tab by name
		 */
		CT.getTabByName = function(name) {
			var tabpane = mx.MATRIX2.getServer().getJSXByName('tabbedpaneMain');
			var tabs = tabpane.getChildren();

			for(var i=0; i<tabs.length; i++) {
				if(tabs[i].getAttribute("initText") == name)
					return tabs[i];
			}
			return null;
		};

		/**
		 * Set tab name
		 */
		CT.setTabName = function(tabId, newName, selected) {
			var tabpane = mx.MATRIX2.getServer().getJSXByName('tabbedpaneMain');
			var tabs = tabpane.getChildren();
			var tab = null;
			for(var i = 0; i < tabs.length; i++) {
				if(tabs[i]._jsxid == tabId){
					tab = tabs[i];
					break;
				}
			}

			if(tab == null){
				return false;
			}

			tabs[i].setAttribute("initText", newName);
			if(selected){
				CT.setTabDesignSelected(tab);
			}
			else{
				CT.setTabDesignDeselected(tab);
			}

			return true;
		};

		/**
		 * Update close buttons
		 */
		CT.updateCloseButtons = function() {
			var tabpane = mx.MATRIX2.getServer().getJSXByName('tabbedpaneMain');
			var tabs = tabpane.getChildren();

			var amountOfAddedTabs = 0;
			var lastTabId = null;

			for(var i = 0; i < tabs.length; i++) {
				if(tabs[i].getDisplay() == "" && tabs[i].getAttribute("curType") != "vmx"){
					lastTabId = i;
					amountOfAddedTabs++;
				}
			}

			if(amountOfAddedTabs == 1){
				var closeButton = $("#closeTab" + lastTabId);
				closeButton.attr("title", __("Clear tab"));
				var tab = tabs[lastTabId];
				closeButton.off().on('click', {tabtoremove: tab}, function(event){
					mx.CT.clearTab(event.data.tabtoremove);
				});
			}
			else{
				for(var i = 0; i < tabs.length; i++) {
					if(tabs[i].getDisplay() == "" && tabs[i].getAttribute("curType") != "vmx"){
						var closeButton = $("#closeTab" + i);
						closeButton.attr("title", __("Close tab"));
						var tab = tabs[i];
						closeButton.off().on('click', {tabtoremove: tab}, function(event){
							mx.CT.removeTab(event.data.tabtoremove, event);
						});
					}
				}
			}
		};

		CT.getActiveTab = function(){
			var tabpane = mx.MATRIX2.getServer().getJSXByName('tabbedpaneMain');
			var tabs = tabpane.getChildren();
			return tabs[tabpane.getSelectedIndex()];
		};

		CT.isActiveTabVMX = function(){
			return CT.getActiveTab().getAttribute("curType") == 'vmx';
		};

 		CT.addRecDeviceToTab = function(objTab, objCell){
			if(objTab){
				var objId = objCell.getAttribute("objectId");
				objTab.setAttribute("activeRecording",objTab.getAttribute("activeRecording")+"_"+objId);

				var img = document.getElementById(objTab.getAttribute("rec_img_id"));
				if(img){
					img.style.width="13px";
					img.style.height="10px";
				}
			}
		};

		CT.removeRecDeviceFromTab = function(objTab, objCell) {
			if(objTab && objTab.getAttribute("activeRecording")){
				var objId = objCell.getAttribute("objectId");
				objTab.setAttribute("activeRecording",objTab.getAttribute("activeRecording").replace(new RegExp("_"+objId,'g'), ""));

				if(objTab.getAttribute("activeRecording")==""){
					var img = document.getElementById(objTab.getAttribute("rec_img_id"));
					if(img){
						img.style.width="0px";
						img.style.height="0px";
					}
				}
			}
 		};
});
