jsx3.lang.Package.definePackage("mx.CDM", function(CDM) {

	CDM.requests = [];

	CDM.privateRequests = [];

	CDM.updateTimer = null;
	CDM.updatePeriod = 60*1000;

	CDM.dragObjId = null;

	CDM.curTab = 0;
	
	/**
	 *
	 * @param objDest  block to add content download manager cell
	 */
	CDM.addCell = function(objDest) {
		mx.MATRIX2.clearDestinationBlock(objDest);

		objDest.removeAttribute("playerBlock");
		mx.language.load_translate(objDest, "components/cdm_cell.xml");

		var strContents =
			'<data jsxid="jsxroot">' +
				'<record jsxid="1" jsxtext="' + __("User content", "Content download manager") + '" />' +
				'<record jsxid="2" jsxtext="' + __("Role content", "Content download manager") + '" />' +
			'</data>';
		var contentTypesDoc = jsx3.xml.CDF.Document.newDocument();
		contentTypesDoc.loadXML(strContents);
		mx.MATRIX2.getServer().Cache.setDocument('CDM_ContentTypesDocument', contentTypesDoc);

		var contentVisibility = objDest.getDescendantOfName("contentVisibility");
		contentVisibility.setEvent("mx.CDM.onChangeContentVisibility(this)", jsx3.gui.Interactive.SELECT);
		contentVisibility.setXMLId('CDM_ContentTypesDocument').setValue(1);
		contentVisibility.repaint();

		var strPeriods =
			'<data jsxid="jsxroot">' +
				'<record jsxid="8" jsxtext="' + __("8 hrs", "Content download manager") + '" />' +
				'<record jsxid="24" jsxtext="' + __("24 hrs", "Content download manager") + '" />' +
				'<record jsxid="120" jsxtext="' + __("5 days", "Content download manager") + '" />' +
			'</data>';
		var periodsDoc = jsx3.xml.CDF.Document.newDocument();
		periodsDoc.loadXML(strPeriods);
		mx.MATRIX2.getServer().Cache.setDocument('CDM_periodsDocument', periodsDoc);

		var periods = objDest.getDescendantOfName("contentPeriod");
		periods.setEvent("mx.CDM.onChangePeriod(this)", jsx3.gui.Interactive.SELECT);
		periods.setXMLId('CDM_periodsDocument').setValue(8);
		periods.repaint();
		
		objDest.repaint();

		var tabsHtml = 
			'<div class="tabs">' +
				'<span class="queued">' + __("Queued") + '</span>' +
				'<span class="inprogress">' + __("In-progress") + '</span>' +
				'<span class="completed">'  + __("Completed")  + '</span>' +
			'</div>' +
			'<div id="cdm_panes" class="panes">' +
				'<div class="queued_requests_pane" mode="queued">' +
					'<br />' +
					'<div class="cdm_queued_buttons_container">' +
						'<button id="cancelAllImplicit">' + __("Cancel all auto requests") + '</button>&nbsp;' +
						'<button id="cancelAll">' + __("Cancel all jobs") + '</button>&nbsp;' +
					'</div>' +
					'<div class="cdm_border_table">' +
						'<table class="cdm_table">' +
							'<tbody class="queued_requests"></tbody>' +
						'</table>' +
					'</div>' +
				'</div>' +
				'<div class="inprogress_requests_pane" mode="inprogress">' +
					'<div class="cdm_border_table">' +
						'<table class="cdm_table">' +
							'<tbody class="inprogress_requests"></tbody>' +
						'</table>' +
					'</div>' +
				'</div>' +
				'<div class="completed_requests_pane" mode="completed">' +
					'<div class="cdm_border_table">' +
						'<table class="cdm_table">' +
							'<tbody class="completed_requests"></tbody>' +
						'</table>' +
					'</div>' +
				'</div>'
			'</div>';

		$('.cdm_content').html(tabsHtml);

		hideElementsWithName('image_cdm');

		CDM.setEvents();

		CDM.runUpdateTimer();
	};

	CDM.setEvents = function(){
		// tabs
		$('.cdm_content').find("div.tabs").tabs("div.panes > div", {
			tabs: 'span',
			onClick: function(event, tabIndex) {
				if(mx.CDM.curTab != tabIndex){
					mx.CDM.curTab = tabIndex;
					mx.CDM.runUpdateTimer();
				}
			}
		});
		$(".inprogress").trigger("click");
	
		// content
		$('.cdm_content').on('click', '.pause', function() {
			var rId = $(this).parents('tr.delivery_request').data('requestid');
			mx.CDM.getRequestById(rId).pause();
		}).on('click', '.resume', function() {
			var rId = $(this).parents('tr.delivery_request').data('requestid');
			mx.CDM.getRequestById(rId).resume();
		}).on('click', '.cancel', function() {
			var rId = $(this).parents('tr.delivery_request').data('requestid');
			mx.CDM.getRequestById(rId).cancel();
		}).on('click', '.play', function() {
			var rId = $(this).parents('tr.delivery_request').data('requestid');
			var request = mx.CDM.getRequestById(rId);
			mx.CDM.openInTab(request);
		}).on('click', '.resubmit', function() {
			var rId = $(this).parents('tr.delivery_request').data('requestid');
			var request = mx.CDM.getRequestById(rId);
			mx.CDM.addDownloadJob(request.data.objid, request.data.startTs*1000, Math.floor((request.data.endTs - request.data.startTs)/60), request.data.private, request.data.streamNum);
			mx.CDM.runUpdateTimer();
		}).on("dragstart", "tr.drag", function() {
			dragged = true;
			var tr = $(this);

			var clone = $("<div>" + __("Download request") + " " + tr.data("requestid") + "</div>");
			clone.data("requestid", tr.data("requestid"));

			return clone
				.css({'opacity': '.75', 'position': 'absolute', 'z-index': 6000, 'border': 'none', 'zoom':1})
				.appendTo($('body'));
		})
		.on("drag", "tr.drag", function(ev, dd) {
			$(dd.proxy).css({
				top: ev.pageY + 10,
				left: ev.pageX + 10
			});

			CDM.dragObjId = $(dd.proxy).data('requestid');
		})
		.on("dragend", ".completed_requests tr.drag", function( ev, dd ) {
			// Get all .drop visible divs: lower part and currently active tab
			var lowerBlocks = $('#' + jsx3.GO('pane_elogsmall').getId())
				.find('.drop').addBack();

			var block = $('#' + mx.CT.getActiveTab().getFirstChild().getId())
				.find('.drop').addBack()
				.add(lowerBlocks)
				.filter(':not(:has(div.drop))')
				.filter(':not(:has(span.drop))')
				.filter(function() {
					return contains(this, [ev.pageX, ev.pageY])
				});

			var request = CDM.getRequestById(CDM.dragObjId);

			$(dd.proxy).remove();
			CDM.dragObjId = null;
			dragged = false;

			if (!block.length || matrix2.getJSXById(block[0].id).getDescendantOfName("cdm_cell"))
				return;
			block = block[0];

			mx.CDM.dropInContainer(matrix2.getJSXById(block.id), request);
		});
		
		//buttons
		$('#cancelAllImplicit').on('click', function() {
			mx.CDM.cancelImplicitRequests();
		});
		
		$('#cancelAll').on('click', function() {
			mx.CDM.cancelAllRequests();
		});
	};

	CDM.getRequestById = function(requestId) {
		for (var i = 0; i < CDM.requests.length; i++) {
			if (CDM.requests[i].data.requestid == requestId)
				return CDM.requests[i];
		}
	};

	CDM.toggleSettings = function(objButton){
		var objT = objButton.getAncestorOfName("cdm_cell");
		if(objButton.getAttribute("settingsOpen") == "true") {
			objButton.setAttribute("settingsOpen", "false").setTip(__("Show settings")).repaint();
			objT.getDescendantOfName('layout_cdm').setCols("*,0", true);
		} else {
			objButton.setAttribute("settingsOpen", "true").setTip(__("Hide settings")).repaint();
			objT.getDescendantOfName('layout_cdm').setCols("*,150", true);
		}
		window.setTimeout(function(){ mx.MATRIX2.splitterResize(objT); }, 50);
	};

	CDM.btnCellClose = function(objButton) {
		var objT = objButton.getAncestorOfName("cdm_cell");
		objT.getParent().setAttribute("playerBlock", "0");
		objT.getParent().removeChildren();

		showElementsWithName('image_cdm');
	};

	CDM.onChangeContentVisibility = function(objSelect) {
		var newValue = objSelect.getValue();
		CDM.runUpdateTimer();
	};

	CDM.onChangePeriod = function(objSelect) {
		var newValue = objSelect.getValue();
		CDM.runUpdateTimer();
	};

	CDM.showDownloadJobDialogFromHeader = function(objButton) {
		var objCell = objButton.getAncestorOfName("cell_blk");

		var nPlayer = mx.MATRIX2.getObjFromIFrame('_mplayer_', objCell);
		if(!nPlayer){
			mx.MATRIX2.showMessage("Content download", "Player not initialized yet!");
			return;
		}

		var ts = parseInt(nPlayer.getCurrentTS(), 10);
		if(!ts){
			mx.MATRIX2.showMessage("Content download", "Player not initialized yet.");
			return;
		}

		var objId = objCell.getAttribute("objectId");
		var streamNum = parseInt(nPlayer.getParameter('STREAMNUM'));
		
		CDM.showDownloadJobDialog(objId, ts, streamNum);
	};

	CDM.showDownloadJobDialog = function(objId, timestamp, streamNum) {
		var camera = resourceTree.getObject(objId);

		var name = camera.udid || camera.name;
		var location = (camera.location != "" ? " - " + camera.location : "");

		var content = name + location + "<br>" +
			'From:<br>' +
			'<input type="text" id="avatarDownloadJobStart" value=""><br>' +
			'Duration(min):<br>' +
			'<select id="avatarDownloadJobDuration">' +
				'<option value="5" selected="selected">5 min</option>' +
				'<option value="15">15 min</option>' +
				'<option value="30">30 min</option>' +
				'<option value="60">1 hr</option>' +
				'<option value="90">1 hr 30 min</option>' +
			'</select>' +
			'<button id="avatarDownloadJobButtonAdd">Add</button>';

		mx.Dialog.createLayoutDialog(
			'avatar_download_content_job',
			__("ADD CONTENT DOWNLOAD JOB"),
			{'top': '70px', 'width':'312px', 'height':'auto'},
			content
		);

		$('#avatar_download_content_job div.close')
			.unbind('click')
			.click(function() {mx.CDM.closeDownloadJobDialog();});

		CDM.setDateTimePicker(timestamp);

		$('#avatarDownloadJobButtonAdd').on("click", function(){
			var input = $('#avatarDownloadJobStart');
			var datetimepicker = input.data('xdsoft_datetimepicker');
			datetimepicker.data('xdsoft_datetime').setCurrentTime(input.val());
			datetimepicker.trigger('changedatetime.xdsoft');

			var time = $(this).data("time");
			if(time){
				var ts = parseInt(time) - (new Date()).getTimezoneOffset()*60*1000 - mx.TIME.currentTimezoneOffset;
				mx.CDM.addDownloadJob(objId, ts, $("#avatarDownloadJobDuration").val(), false, streamNum);
				mx.CDM.closeDownloadJobDialog();
				mx.TIMELINE.refreshTimelineContents();
			}	
		});
		
		var dialog = $("#avatar_download_content_job");
		dialog.data("changed", false);
		$('#avatarDownloadJobDuration, #avatarDownloadJobStart').on("change", function(){
			dialog.data("changed", true);
		});
	};

	CDM.closeDownloadJobDialog = function() {
		var dialog = $("#avatar_download_content_job");
		dialog.data("changed", false);
		dialog.remove();
	};

	CDM.addDownloadJob = function(objId, startTs, duration, isPrivate, streamNum) {
		CDM.addRequest(objId, startTs, startTs + duration*60*1000, isPrivate, streamNum);
	};

	CDM.setDateTimePicker = function(timestamp) {
		var strDateTime = mx.TIME.timestamp2date(timestamp, "YYYY/MM/DD HH:II");

		var options = {
			parentID: $('body'),
			left: 15,
			validateOnBlur: true,
			mask: true,
			value: strDateTime,
			lazyInit: false,
			allowBlank: false,
			monthChangeSpinner: false,
			minDate: '1970/01/01',
			onChangeDateTime: function (curtime, $input) {
				if(curtime){
					$('#avatarDownloadJobButtonAdd').data("time", curtime.getTime());
				}
			},
			onShow: function(current_time,$input){
				if(jsx3.CLASS_LOADER.IE){
					$('.xdsoft_datetimepicker.xdsoft_.xdsoft_noselect').attr("tabindex", -1).focus();
				}
			}
		};

		// create calendar
		$('#avatarDownloadJobStart').datetimepicker(options);
	};

	CDM.openInTab = function(request){
		var tab = mx.CT.createNewTab();
		if(tab == null){
			return;
		}

		mx.CT.clearTab(tab);
		mx.CT.setTabDesignSelected(tab);

		tab.doShow();

		CDM.dropInContainer(tab.getFirstChild(), request);
	};

	CDM.dropInContainer = function(objDest, request){
		var objName = resourceTree.getObject(request.data.objid).name;

		var startTs = request.data.startTs * 1000;
		var endTs = request.data.endTs * 1000;

		var newCell = mx.MATRIX2.createCell(request.data.objid, objName, objDest, false, startTs, endTs, false, false, false, request.data.streamNum);
		newCell.setAttribute("markA", "" + startTs);
		newCell.setAttribute("markB", "" + endTs);

		isPlayInArchive = true;
		mx.MATRIX2.setSelectedGroup(newCell.getDescendantOfName("cell_select"), null, true);
	};
	
	/*
		check is timetamp allready in AOD requestes
	*/
	CDM.isAODAlreadyDownloading = function(timestamp, streamNum) {
		var ts = timestamp/1000;
		var avatarRequestStatuses = ['NOT CONFIRMED', 'QUEUED', 'PROCESSING', 'COMPLETED'];
		
		for(var i = 0; i < mx.CDM.requests.length; i++) {
			var req = mx.CDM.requests[i].data;
			//if(window.jsDebug){ appLogger.info("---------->CDM.isAODAlreadyDownloading: req.status=" + req.status + ", req.streamNum=" + req.streamNum + ", streamNum=" + streamNum); }
			if(req.streamNum != streamNum || $.inArray(req.status, avatarRequestStatuses) == -1){
				continue;
			}

			//if(window.jsDebug){ appLogger.info("---------->CDM.isAODAlreadyDownloading: req.startTs=" + req.startTs + ", req.endTs=" + req.endTs + ", ts="+ts); }
			if(req.startTs < ts && ts < req.endTs){
				if(window.jsDebug){ appLogger.info("---------->CDM.isAODAlreadyDownloading: EXIST"); }
				return true;
			}
		}

		if(window.jsDebug){ appLogger.info("---------->CDM.isAODAlreadyDownloading: NOT EXIST"); }
		return false;
	};

	/**
	 *  clear CDM content
	 */
	CDM.clearContent = function() {
		var header = '<tr>' +
			'<th class="header">' + __("ID") + '</th> ' +	
			'<th class="header">' + __("Device name") + '</th> ' +	
			'<th class="header">' + __("From") + '</th> ' +
			'<th class="header">' + __("Duration, min") + '</th> ' +
			'<th class="header">' + __("Type") + '</th> ' +
			'<th class="header">' + __("Resolution") + '</th> ' +
			'<th class="header">' + __("Status") + '</th> ' +
			'<th class="header">' + __("Actions") + '</th> ' +
		'</tr>';
		$('.queued_requests').html(header);
		$('.inprogress_requests').html(header);
		$('.completed_requests').html(header);
	};

	/**
	 *  repaint all requests
	 */
	CDM.repaintRequests = function() {
		var counterQ = 0;
		var counterI = 0;
		var counterC = 0;
		for(var i = 0; i < mx.CDM.requests.length; i++){
			var req = mx.CDM.requests[mx.CDM.requests.length - 1 - i];
			if(req.data.status == "QUEUED"){
				mx.CDM.requests[mx.CDM.requests.length - 1 - i].addHtml($('.queued_requests'));
				counterQ++;
			}
			else if(req.data.status == "PROCESSING"){
				mx.CDM.requests[mx.CDM.requests.length - 1 - i].addHtml($('.inprogress_requests'));
				counterI++;
			}
			else if(!req.data.private && $.inArray(req.data.status, ['COMPLETED', 'CANCELED', 'FAILED']) != -1){
				mx.CDM.requests[mx.CDM.requests.length - 1 - i].addHtml($('.completed_requests'));
				counterC++;
			}
		}
			
		$(".queued").text(__("Queued") + "(" + counterQ + ")");
		$(".inprogress").text(__("In-progress") + "(" + counterI + ")");
			
		if(counterQ == 0){
			$('.queued_requests').html('<tr><td class="cdm_no_data">' + __("No queued requests") + "</td></tr>"); 
		}
		if(counterI == 0){
			$('.inprogress_requests').html('<tr><td class="cdm_no_data">' + __("No in-progress requests") + "</td></tr>");
		}
		if(counterC == 0){
			$('.completed_requests').html('<tr><td class="cdm_no_data">' +  __("No completed requests") + "</td></tr>");
		}
	};

	/**
	 *  run update timer
	 */
	CDM.runUpdateTimer = function() {
		CDM.updateRequests();

		clearTimeout(CDM.updateTimer);
		CDM.updateTimer = setTimeout(function () {
			mx.CDM.runUpdateTimer();
		}, CDM.updatePeriod);
	};

	/**
	 *  update all requests
	 */
	CDM.updateRequests = function() {
		CDM.getRequests();
		CDM.clearContent();
		CDM.repaintRequests();
	};
	
	/**
	 *  cancel all implicit requests
	 */
	CDM.cancelImplicitRequests = function() {
		$('#cancelAllImplicit').prop("disabled", true);
		for(var i = 0; i < mx.CDM.requests.length; i++){
			// cancel only actual requests
			if(mx.CDM.requests[i].data.private && $.inArray(mx.CDM.requests[i].data.status, ['QUEUED', 'PROCESSING', 'PAUSED']) != -1){
				mx.CDM.requests[i].cancel();
			}
		}
		$('#cancelAllImplicit').prop("disabled", false);
	};
	
	/**
	 *  cancel all requests
	 */
	CDM.cancelAllRequests = function() {
		$('#cancelAll').prop("disabled", true);
		for(var i = 0; i < mx.CDM.requests.length; i++){
			// cancel only actual requests
			if($.inArray(mx.CDM.requests[i].data.status, ['QUEUED', 'PROCESSING', 'PAUSED']) != -1){
				mx.CDM.requests[i].cancel();
			}
		}
		$('#cancelAll').prop("disabled", false);
	};

	/**
	 *  get all requests
	 */
	CDM.getRequests = function() {
		var period = parseInt(jsx3.GO("contentPeriod").getValue());
		var visibility = parseInt(jsx3.GO("contentVisibility").getValue());
		var filterId = (visibility == 1 ? jsUserId : resourceTree.role.obj);
		$.ajax('/cxf/services/aod/get', {
			context: this,
			async: false,
			data: {
				created_from: Math.round((new Date()).getTime() / 1000) - period*60*60,
				userid: filterId
			},
			success: function(data) {
				var list = [];
				var requests = (data.requests ? data.requests : []);
				for (var i = 0; i < requests.length; i++) {
					list.push(new CDM.DeliveryRequest(requests[i]));
				}
				mx.CDM.requests = list;
			}
		});
	};

	/**
	 *  get request
	 */
	CDM.getRequest = function(id) {
		var request = null;
		$.ajax('/cxf/services/aod/get', {
			context: this,
			async: false,
			data: {
				requestid: id
			},
			success: function(data) {
				request = data.requests[0];
			}
		});
		return request;
	};

	/**
	 *  add content request
	 */
	CDM.addRequest = function(objId, start, end, isPrivate, streamNum, callback) {
		if(window.jsDebug){ appLogger.info("---------->CDM.addRequest: objId="+objId+", start="+start+", end="+end+", isPrivate="+isPrivate+", streamNum="+streamNum); }
		var done = false;
		if(!callback){
			callback = function() {};
		}
/*		
		$.ajax({
			url: '/cxf/services/storagestat/getMissedChunks',
			context: this,
			data: {
				objid: objId,
				start: Math.round(start / 1000),
				end: Math.round(end / 1000)
			},
			dataType:'json',
			async: false,
			success: function(data) {
				if (!data.missedChunks){
					var err = (data.error ? data.error : "");
					mx.MATRIX2.showMessage("Content download", "Request failed! [getMissedChunks]: " + err);
					return;
				}
				else if(parseInt(data.missedChunks.value, 10) == 0){
					if(!isPrivate){
						mx.MATRIX2.showMessage("Content download", "Content already present!");
					}
					return;
				}
*/
				var request = new CDM.DeliveryRequest(objId, Math.round(start / 1000), Math.round(end / 1000), isPrivate, streamNum, callback);
				done = request.submit();
				if(done){
					if(isPrivate) {
						CDM.privateRequests.push(request);
					}
					else {
						CDM.requests.push(request);
					}
				}
/*			}
		});
*/	
		return done;
	};

	CDM.DeliveryRequest = function(data, startTs, endTs, isPrivate, streamNum, onComplete) {
		// data example:
		// {"avatarid":101,"createdTs":1335359059098,"endTs":1335356338,"nodeid":100,"objid":104,"requestid":1,"startTs":1335356000,"status":"QUEUED","userid":0}

		if ($.isPlainObject(data)) {
			this.data = data;
		} else {
			this.data = {
				requestid: 'req' + Math.random()*100,
				status: 'NOT CONFIRMED',
				objid: data,
				startTs: startTs,
				endTs: endTs,
				streamNum: streamNum,
				isPrivate: isPrivate
			};
			this.onComplete = onComplete;
		}
	};

	CDM.DeliveryRequest.prototype = {
		/**
		 *  request statuses
		 */
		status: ['NOT CONFIRMED', 'QUEUED', 'PROCESSING', 'COMPLETED', 'CANCELED', 'PAUSED', 'FAILED'],

		/**
		 *  add html block for request
		 */
		addHtml: function(container){
			var obj =  resourceTree.getObject(this.data.objid);
			if(obj){
				container.append(this.getHTML()); 
			}
		},

		getHTML: function() {
			return '<tr class="delivery_request drag" data-requestid="' + this.data.requestid + '">' +
						'<td class="reqid">' + this.data.requestid + '</td> ' +	
						'<td class="device">' + resourceTree.getObject(this.data.objid).name + '</td> ' +	
						'<td class="from">' + mx.TIME.timestamp2date(this.data.startTs*1000) + '</td> ' +
						'<td class="length">' + parseInt((this.data.endTs - this.data.startTs)/60) + '</td> ' +
						'<td class="type">' + (this.data.private ? __("Auto") : __("User")) + '</td> ' +
						'<td class="resolution">' + (this.data.streamNum == 1 ? __('Normal') : __('Low')) + '</td> ' +
						'<td class="status">' + (this.data.status == "COMPLETED" ? this.getReadyPercent() + "%" : this.data.status) + '</td> ' +
						'<td class="commands">' + this.getCommandsHTML() + '</td> ' +
					'</tr>';
		},

		getReadyPercent: function(){
			var percent = 0;

			if(this.data.size && this.data.downloaded){
				percent = Math.floor(this.data.downloaded*100/this.data.size);
			}

			return percent;

		},

		getCommandsHTML: function() {
			var commands = {
				'pause' : '<button class="pause">pause</button>',
				'resume': '<button class="resume">resume</button>',
				'play': '<a class="play"><img src="/TibcoGI/JSXAPPS/mx/images/design1/eLog2/eLog2_play_event.png" title="'+__("Play in tab")+'" /></a>',
				'cancel': '<button class="cancel">cancel</button>',
				'resubmit': '<button class="resubmit">resubmit</button>'
			};

			switch (this.data.status) {
				case 'NOT CONFIRMED':
					//return commands['submit'] + commands['delete'];
				case 'QUEUED':
				case 'PROCESSING':
					return commands['pause'] + commands['cancel'];
				case 'PAUSED':
					return commands['resume'] + commands['cancel'];
				case 'COMPLETED':
					return commands['play'];
				case 'FAILED':
					return commands['resubmit'];
				default:
					return '';
			}
		},

		repaint: function() {
			var block = $('.delivery_request[data-requestid="' + this.data.requestid + '"]');
			if(block){
				block.replaceWith(this.getHTML());
			}
		},

		checkCompleted: function() {
			if (this.data.status == 'COMPLETED' && this.onComplete) {
				this.onComplete.apply();
				this.onComplete = null;
			}
		},

		submit: function() {
			var self = this;
			var done = false;

			$.ajax('/cxf/services/aod/submit', {
				context: this,
				data: {
					objid: this.data.objid,
					start: this.data.startTs,
					end: this.data.endTs,
					streamNum: this.data.streamNum,
					isPrivate: this.data.isPrivate
				},
				dataType: 'json',
				async: false,
				success: function(data) {
					if(data.error != ""){
						mx.MATRIX2.showMessage("Content download", "Command submit failed! " + data.error);
						return;
					}

					self.data = data.requests[0];
					done = true;
				}
			});

			return done;
		},

		pause: function() {
			var self = this;
			$.ajax('/cxf/services/aod/pause', {
				cache: false,
				async: false,
				data: {requestid: this.data.requestid},
				success: function(data) {
					if(data.error != ""){
						mx.MATRIX2.showMessage("Content download", "Command pause failed! " + data.error);
						return;
					}

					self.data.status = "PAUSED";
					self.repaint();
				}
			});
		},

		resume: function() {
			var self = this;
			$.ajax('/cxf/services/aod/resume', {
				cache: false,
				async: false,
				data: {requestid: this.data.requestid},
				success: function(data) {
					if(data.error != ""){
						mx.MATRIX2.showMessage("Content download", "Command resume failed! " + data.error);
						return;
					}

					self.data.status = "QUEUED";
					self.repaint();
				}
			});
		},

		cancel: function() {
			var self = this;
			$.ajax('/cxf/services/aod/cancel', {
				cache: false,
				async: false,
				data: {requestid: this.data.requestid},
				success: function(data) {
					if(data.error != ""){
						mx.MATRIX2.showMessage("Content download", "Command cancel failed! " + data.error);
						return;
					}

					self.data.status = "CANCELED";
					self.repaint();
				}
			});
		}
	};
});
