
(function() {
	"use strict";

	window.AvatarCell = function(block, avatar) {
		this.block = block;
		this.jBlock = $('#' + block.getId());
		this.avatar = avatar;
	};

	window.AvatarCell.prototype = {

		render: function() {
			
			this.block.setText(
				'<div class="cell_header" name="avatar_cell" objid="' + this.avatar.obj + '" style="padding:0px;">' +
					'<span class="cell_title">' + this.avatar.name + " " + __("panel") + '</span>' +
					'<div style="float: right; margin-top: -2px;">' +
						'<div class="button close"></div>' +
					'</div>' +
				'</div>' +
				'<iframe scrolling="yes" frameborder="0" src=" /sdi/avatar/panel_2.php?obj=' + this.avatar.obj + '&noheader" style="width:100%; height:100%;"></iframe>',
				true
			);
			this.addCallbacks();
		},

		close: function() {
			this.jBlock.die()
				.unbind()
				.removeData('model');
			this.block.setText('', true);
		},

		onDragOver: function() {
			if (dragged) {
				this.jBlock.find('iframe').css('visibility', 'hidden');
			}
		},

		onDragOut: function() {
			if (dragged) {
				this.jBlock.find('iframe').css('visibility', 'visible');
			}
		},

		addCallbacks: function() {
			var self = this;

			this.jBlock.data('model', this)
				.on('click', '.button.close', function() {self.close();})
				.mouseenter(function() {self.onDragOver()})
				.mouseleave(function() {self.onDragOut()});
		}
	}
})();
