//---------------------------------------------------------------------------------------------------------------
// Audio Recorder Class
//---------------------------------------------------------------------------------------------------------------
jsx3.lang.Package.definePackage(
    "mx.AR",                //the full package name
    function(AR) {          //short package name, good to use in this file only.

	AR.audioRecorderApplet = null;
	AR.nomixers = true;

    AR.addRecorderApplet = function(){
		AR.audioRecorderApplet = new AudioRecorder();
		AR.audioRecorderApplet.init("body")
			.fail(function(){

			})
			.done(function(){
				if(window.jsDebug){ appLogger.info("AR.addRecorderApplet: OK"); }

				this.subscribe("error", function(message){
					AR.stopAudioRecord();
					alert("Audio recorder error: " + message);
					appLogger.info("onAudioRecorderError: " + message);
				}, "audioRecorder");

				this.subscribe("timeout", function(){
					AR.stopAudioRecord();
				}, "audioRecorder");

				AR.getMixers();
				AR.setupAudioRecordDialog();
			});
    };

    AR.setupAudioRecordDialog = function(){
		var dialog = jsx3.GO("dialog_record_audio");
		var headerBox = dialog.getDescendantOfName("header");
		headerBox.setCursor("move");
		headerBox.setCanMove(jsx3.Boolean.TRUE);

		mx.Dialog._enableMouseTracking(headerBox);

		dialog.getDescendantOfName("selectAudioMicDevice").setXMLId("CDF_MIXERS").repaint();

		dialog.getDescendantOfName("buttonAR").setAttribute("onmousedown", "mx.AR.startAudioRecord();");
		dialog.getDescendantOfName("buttonAR").setAttribute("onmouseup", "mx.AR.stopAudioRecord();");
		dialog.getDescendantOfName("buttonAR").setText(__("Push to talk"), true);

		dialog.setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
    };

    AR.closeAudioRecordDialog = function(){
		if (AR.audioRecorderApplet != null)
		{
			AR.stopAudioRecord();
		}
		jsx3.GO("dialog_record_audio").setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
	};

    AR.showAudioRecordDialog = function(){
		jsx3.GO("dialog_record_audio").setVisibility(jsx3.gui.Block.VISIBILITYVISIBLE, true);
    };

	AR.getAudioObjId = function(device){
		if (device && device.attr("ASSOCIATE") && device.attr("AUDIO_TWO_WAY") == "on") {
			//appLogger.info("getAudioObjId: 1-"+mainDevNode.getAttribute("assoc"));
			// Find audio 2way device between associated devices
			var audio = resourceTree.getObject({
				'obj':           device.attr("ASSOCIATE").split(/,\s*/),
				'type':          'audio',
				'audio_two_way': 'on'
			});
			if (audio)
			{
				return audio.obj;
			}
		}

		return null;
	};

    AR.isTwoWayAudioSupported = function(){
		var objControls = jsx3.GO('layoutControlComponent').controls;
		if (objControls != null && objControls.group != null) {
			var curGroup = objControls.group;
			var main = objControls.getNonAudioMainPlayerPos();

			var objId = curGroup.players[main].player.devObjId;
			var device = resourceTree.getObject(objId);

			return AR.getAudioObjId(device) && !AR.nomixers;
		} else {
			return false;
		}
    };

    AR.startAudioRecord = function(){
		if (!AR.audioRecorderApplet.isConfigured()) {
			alert(__("Audio recorder not configured yet!"));
		} else {
			//media access
			var objControls = mx.MATRIX2.getServer().getJSXByName('layoutControlComponent').controls;
			var objId = objControls.group.players[objControls.getNonAudioMainPlayerPos()].player.devObjId;
			var device = resourceTree.getObject(objId);

			var url = "/api/authmng.php?return=mediastreamauth&streamtype=live&objid=" + AR.getAudioObjId(device);
			var XMLDoc = new jsx3.xml.Document().load(url, xmlRequestTmeout);
			var authNode = XMLDoc.selectSingleNode("//AUTHORIZATION");

			//max record length
			var audioRecordLength = 24 * 60 * 60; //sec
			//http://SERVER_IP/api/authmng.php?return=mediastreamauth&streamtype=live&objid=103
			AR.audioRecorderApplet.startRecording(unescape(authNode.getAttribute("URL")) + "&authorizationid=" + authNode.getAttribute("ID"), audioRecordLength);
			//AR.startAudioTiming(audioRecordLength, audioRecordLength);

			var button = jsx3.GO("dialog_record_audio").getDescendantOfName("buttonAR");
			button.setBackgroundColor("#FF0000");
			button.setText(__("Release to stop"), true);
			//button.setEvent("mx.AR.stopAudioRecord();", jsx3.gui.Interactive.EXECUTE);
		}
    };

    AR.stopAudioRecord = function(){
		if (!AR.audioRecorderApplet.isConfigured()) {
			//alert("Audio recorder not configured yet!");
		} else {
			AR.audioRecorderApplet.stopRecording();

			var indicator = jsx3.GO("dialog_record_audio").getDescendantOfName("blockAudioRecordIndication");

			indicator.setWidth(AR.startIndicatorWidth, true);
			indicator.setVisibility(jsx3.gui.Block.VISIBILITYHIDDEN, true);
			if (window['audio_rec_var']) {
				clearTimeout(window['audio_rec_var']);
			}

			var button = jsx3.GO("dialog_record_audio").getDescendantOfName("buttonAR");
			button.setBackgroundColor("#FFFFFF");
			button.setText(__("Push to talk"), true);
			//button.setEvent("mx.AR.startAudioRecord();", jsx3.gui.Interactive.EXECUTE);
		}
    };

    AR.getMixers = function(){
		var mixers = AR.audioRecorderApplet.getAllInputDevices();
		mixers = mixers.split("|");

		var isfirst = true;
		var first_mixer_id = 0;
		var strDocMixers = '<data jsxid="jsxroot">';
		for (var i = 0; i < mixers.length - 1; i++) {
			//if (mixers[i].indexOf("Java") != -1){ continue; }// ignore java mixers. they are incompatible with us
			strDocMixers += '<record jsxid="' + jsx3.xml.CDF.getKey() + '" jsxtext="' + mixers[i] + '" mixer_id="' + i + '"/>';
			AR.nomixers = false;
			if (isfirst) {
				first_mixer_id = i;
				isfirst = false;
			}
		}
		strDocMixers += '</data>';
		var strDocMixersXML = (new jsx3.xml.Document().loadXML(strDocMixers));
		var CDF_MIXERS = jsx3.xml.CDF.Document.wrap(strDocMixersXML);

		mx.MATRIX2.getServer().getCache().setDocument("CDF_MIXERS", CDF_MIXERS);

		if (!AR.nomixers) {
			AR.setMixer(CDF_MIXERS.selectSingleNode("//record[@mixer_id='" + first_mixer_id + "']").getAttribute("jsxid"));
		}
    };

    AR.setMixer = function(strId){
		AR.stopAudioRecord();
		var mixers_doc = mx.MATRIX2.getServer().getCache().getDocument("CDF_MIXERS");
		if (mixers_doc) {
			var mixer_id = mixers_doc.selectSingleNode("//record[@jsxid='" + strId + "']").getAttribute("mixer_id");
			if (mixer_id) {
				AR.audioRecorderApplet.setInputDevice(parseInt(mixer_id, 10));
			}
		}
    };
});
