// Do not clobber the list of params if they have already been defined.
// This is used in the Puppet tests.

if (typeof GEE_BASE_URL === 'undefined') {
  GEE_BASE_URL = window.location.protocol + '//' + window.location.host;
}

var params = params || {};
var experiments = [];
(function() {
  // Read cgi parameters from page url.
  var url = window.location.href;
  var paramsList = url.split('?');
  if (paramsList.length > 1) {
    var paramsString = paramsList[1];
    var terms = paramsString.split('&');
    for (var i = 0; i < terms.length; ++i) {
      var parts = terms[i].split('=');
      params[parts[0]] = unescape(parts[1]);
    }
  }

  if (params['expid']) experiments.push(params['expid']);
  if (!params['sensor']) params['sensor'] = 'false';

  // Load bootstrap.
  var bootstrap = GEE_BASE_URL + '/local/js/310/bootstrap.js';
  var params_list = [];
  for (var key in params) {
    params_list.push(key + '=' + params[key]);
  }
  bootstrap += '?' + params_list.join('&');
  if (!params['callback']) {
    document.write('<' + 'script src="' + bootstrap + '"' +
                   ' type="text/javascript"><' + '/script>');
  } else {
    var script = document.createElement('script');
    script.src = bootstrap;
    document.body.appendChild(script);
  }
})();
